/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app;

import de.ii.xtraplatform.base.domain.Jackson;
import de.ii.xtraplatform.store.app.EntityDeserialization;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.KeyPathAlias;
import de.ii.xtraplatform.store.domain.ValueDecoderMiddleware;
import de.ii.xtraplatform.store.domain.ValueEncoding;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.com.fasterxml.jackson.core.ObjectCodec;
import shadow.com.fasterxml.jackson.core.io.IOContext;
import shadow.com.fasterxml.jackson.core.type.TypeReference;
import shadow.com.fasterxml.jackson.databind.DeserializationFeature;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import shadow.com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.org.yaml.snakeyaml.DumperOptions;

public class ValueEncodingJackson<T>
implements ValueEncoding<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueEncodingJackson.class);
    public static final byte[] JSON_NULL = "null".getBytes();
    public static final byte[] YAML_NULL = "--- null\n".getBytes();
    private static final Pattern JSON_EMPTY = Pattern.compile("(\\s)*");
    private static final Pattern YAML_EMPTY = Pattern.compile("---(\\s)*");
    private static final ValueEncoding.FORMAT DEFAULT_FORMAT = ValueEncoding.FORMAT.YML;
    private static final ValueEncoding.FORMAT DESER_FORMAT_LEGACY = ValueEncoding.FORMAT.JSON;
    private final Map<ValueEncoding.FORMAT, ObjectMapper> mappers;
    private final List<ValueDecoderMiddleware<byte[]>> decoderPreProcessor;
    private final List<ValueDecoderMiddleware<T>> decoderMiddleware;

    public ValueEncodingJackson(Jackson jackson, boolean failOnUnknownProperties) {
        ObjectMapper jsonMapper = jackson.getDefaultObjectMapper().copy().registerModule(EntityDeserialization.DESERIALIZE_IMMUTABLE_BUILDER_NESTED).registerModule(EntityDeserialization.DESERIALIZE_MERGEABLE_MAP_BUILDER_WRAPPER).registerModule(EntityDeserialization.DESERIALIZE_API_BUILDINGBLOCK_MIGRATION).setDefaultMergeable(true);
        ObjectMapper yamlMapper = jackson.getNewObjectMapper(new EmptyStringFixYAMLFactory().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID).disable(YAMLGenerator.Feature.USE_NATIVE_OBJECT_ID).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS)).registerModule(EntityDeserialization.DESERIALIZE_IMMUTABLE_BUILDER_NESTED).registerModule(EntityDeserialization.DESERIALIZE_MERGEABLE_MAP_BUILDER_WRAPPER).registerModule(EntityDeserialization.DESERIALIZE_API_BUILDINGBLOCK_MIGRATION).setDefaultMergeable(true).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (failOnUnknownProperties) {
            jsonMapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            yamlMapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
        this.mappers = ImmutableMap.of(ValueEncoding.FORMAT.JSON, jsonMapper, ValueEncoding.FORMAT.YML, yamlMapper, ValueEncoding.FORMAT.YAML, yamlMapper);
        this.decoderMiddleware = new ArrayList<ValueDecoderMiddleware<T>>();
        this.decoderPreProcessor = new ArrayList<ValueDecoderMiddleware<byte[]>>();
    }

    public void addDecoderPreProcessor(ValueDecoderMiddleware<byte[]> preProcessor) {
        this.decoderPreProcessor.add(preProcessor);
    }

    public void addDecoderMiddleware(ValueDecoderMiddleware<T> middleware) {
        this.decoderMiddleware.add(middleware);
    }

    @Override
    public final ValueEncoding.FORMAT getDefaultFormat() {
        return DEFAULT_FORMAT;
    }

    @Override
    public final byte[] serialize(T data) {
        try {
            return this.getDefaultMapper().writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unexpected serialization error", e);
        }
    }

    @Override
    public byte[] serialize(Map<String, Object> data) {
        try {
            return this.getDefaultMapper().writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unexpected serialization error", e);
        }
    }

    @Override
    public final T deserialize(Identifier identifier, byte[] payload, ValueEncoding.FORMAT format, boolean ignoreCache) throws IOException {
        if (this.isNull(payload)) {
            return null;
        }
        byte[] rawData = payload;
        ValueEncoding.FORMAT payloadFormat = Objects.equals((Object)format, (Object)ValueEncoding.FORMAT.NONE) ? DESER_FORMAT_LEGACY : format;
        ObjectMapper objectMapper = this.getMapper(payloadFormat);
        Object data = null;
        for (ValueDecoderMiddleware<byte[]> valueDecoderMiddleware : this.decoderPreProcessor) {
            rawData = valueDecoderMiddleware.process(identifier, rawData, objectMapper, null, ignoreCache);
        }
        try {
            for (ValueDecoderMiddleware<Object> valueDecoderMiddleware : this.decoderMiddleware) {
                data = valueDecoderMiddleware.process(identifier, rawData, objectMapper, data, ignoreCache);
            }
        }
        catch (Throwable e) {
            Optional<ValueDecoderMiddleware> optional = this.decoderMiddleware.stream().filter(ValueDecoderMiddleware::canRecover).findFirst();
            if (optional.isPresent()) {
                try {
                    data = optional.get().recover(identifier, rawData, objectMapper);
                }
                catch (Throwable e2) {
                    throw e;
                }
            }
            throw e;
        }
        return data;
    }

    @Override
    public byte[] nestPayload(byte[] payload, String formatString, List<String> nestingPath, Optional<KeyPathAlias> keyPathAlias) throws IOException {
        ValueEncoding.FORMAT format;
        if (nestingPath.isEmpty()) {
            return payload;
        }
        try {
            format = ValueEncoding.FORMAT.fromString(formatString);
        }
        catch (Throwable e) {
            return payload;
        }
        ObjectMapper mapper = this.getMapper(format);
        Map<String, Object> data = (Map<String, Object>)mapper.readValue(payload, new TypeReference<LinkedHashMap<String, Object>>(){});
        for (int i = nestingPath.size() - 1; i >= 0; --i) {
            if (i == nestingPath.size() - 1 && keyPathAlias.isPresent()) {
                data = keyPathAlias.get().wrapMap(data);
                continue;
            }
            String key = nestingPath.get(i);
            data = ImmutableMap.of(key, data);
        }
        return mapper.writeValueAsBytes(data);
    }

    final ObjectMapper getDefaultMapper() {
        return this.getMapper(DEFAULT_FORMAT);
    }

    @Override
    public final ObjectMapper getMapper(ValueEncoding.FORMAT format) {
        return this.mappers.get((Object)format);
    }

    final boolean isNull(byte[] payload) {
        return Arrays.equals(payload, JSON_NULL) || Arrays.equals(payload, YAML_NULL);
    }

    public final boolean isEmpty(byte[] payload) {
        String payloadString = new String(payload, StandardCharsets.UTF_8);
        return JSON_EMPTY.matcher(payloadString).matches() || YAML_EMPTY.matcher(payloadString).matches();
    }

    @Deprecated
    static class EmptyStringFixYAMLFactory
    extends YAMLFactory {
        EmptyStringFixYAMLFactory() {
        }

        @Override
        protected YAMLGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
            return new EmptyStringFixYAMLGenerator(ctxt, this._generatorFeatures, this._yamlGeneratorFeatures, this._objectCodec, out, this._version);
        }
    }

    @Deprecated
    static class EmptyStringFixYAMLGenerator
    extends YAMLGenerator {
        private static final Character STYLE_QUOTED = Character.valueOf('\"');
        private static final Pattern PLAIN_NUMBER_P_FIXED = Pattern.compile("[+\\-]?[0-9]*(\\.[0-9]*)?");

        public EmptyStringFixYAMLGenerator(IOContext ctxt, int jsonFeatures, int yamlFeatures, ObjectCodec codec, Writer out, DumperOptions.Version version) throws IOException {
            super(ctxt, jsonFeatures, yamlFeatures, codec, out, version);
        }

        @Override
        protected void _writeScalar(String value, String type, DumperOptions.ScalarStyle style) throws IOException {
            if (type.equals("string") && value.isEmpty()) {
                super._writeScalar(value, type, DumperOptions.ScalarStyle.DOUBLE_QUOTED);
            } else if (type.equals("string") && DumperOptions.ScalarStyle.DOUBLE_QUOTED != style && YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS.enabledIn(this._formatFeatures) && PLAIN_NUMBER_P_FIXED.matcher(value).matches()) {
                super._writeScalar(value, type, DumperOptions.ScalarStyle.DOUBLE_QUOTED);
            } else {
                super._writeScalar(value, type, style);
            }
        }
    }
}

