/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app;

import de.ii.xtraplatform.store.domain.Builder;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.Value;
import de.ii.xtraplatform.store.domain.ValueCache;
import de.ii.xtraplatform.store.domain.ValueDecoderMiddleware;
import java.io.IOException;
import java.util.function.Function;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;

public class ValueDecoderWithBuilder<T extends Value>
implements ValueDecoderMiddleware<T> {
    private final Function<Identifier, Builder<T>> newBuilderSupplier;
    private final ValueCache<T> valueCache;

    public ValueDecoderWithBuilder(Function<Identifier, Builder<T>> newBuilderSupplier, ValueCache<T> valueCache) {
        this.newBuilderSupplier = newBuilderSupplier;
        this.valueCache = valueCache;
    }

    @Override
    public T process(Identifier identifier, byte[] payload, ObjectMapper objectMapper, T data, boolean ignoreCache) throws IOException {
        Builder<T> builder = this.newBuilderSupplier.apply(identifier);
        if (this.valueCache.isInCache(identifier) && !ignoreCache) {
            builder.from((Value)this.valueCache.getFromCache(identifier));
        }
        objectMapper.readerForUpdating(builder).readValue(payload);
        return builder.build();
    }
}

