/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app;

import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.store.app.EventSubscriptions;
import de.ii.xtraplatform.store.domain.EntityEvent;
import de.ii.xtraplatform.store.domain.EventStoreSubscriber;
import de.ii.xtraplatform.store.domain.ImmutableStateChangeEvent;
import de.ii.xtraplatform.store.domain.StateChangeEvent;
import de.ii.xtraplatform.store.domain.TypedEvent;
import de.ii.xtraplatform.streams.domain.Event;
import de.ii.xtraplatform.streams.domain.EventStream;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class EventSubscriptionsImpl
implements EventSubscriptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventSubscriptionsImpl.class);
    private final Map<String, EventStream<Event>> eventStreams = new ConcurrentHashMap<String, EventStream<Event>>();
    private final Reactive.Runner streamRunner;
    private final ScheduledExecutorService executorService;
    private boolean isStarted;

    protected EventSubscriptionsImpl(Reactive.Runner streamRunner) {
        this.streamRunner = streamRunner;
        this.executorService = new ScheduledThreadPoolExecutor(1);
    }

    @Override
    public void addSubscriber(EventStoreSubscriber subscriber) {
        this.executorService.submit(() -> {
            Thread.currentThread().setName("startup");
            if (LOGGER.isDebugEnabled(LogContext.MARKER.DI)) {
                LOGGER.debug((Marker)LogContext.MARKER.DI, "New event store subscriber: {} {}", (Object)subscriber.getEventTypes(), (Object)subscriber);
            }
            for (String eventType : subscriber.getEventTypes()) {
                EventStream<Event> eventStream = this.getEventStream(eventType);
                CompletableFuture cmp = new CompletableFuture();
                eventStream.foreach(event -> {
                    if (event instanceof StateChangeEvent && ((StateChangeEvent)event).state() == StateChangeEvent.STATE.LISTENING) {
                        subscriber.onEmit((Event)event);
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("{} STARTED LISTENER", (Object)eventType);
                        }
                        cmp.complete(null);
                        return;
                    }
                    Reactive.Runner runner = this.streamRunner;
                    synchronized (runner) {
                        if (LOGGER.isTraceEnabled() && event instanceof EntityEvent) {
                            LOGGER.trace("EMIT: {} {}", (Object)((EntityEvent)event).type(), (Object)((EntityEvent)event).identifier());
                        }
                        subscriber.onEmit((Event)event);
                        if (LOGGER.isTraceEnabled() && event instanceof EntityEvent) {
                            LOGGER.trace("EMITTED: {} {}", (Object)((EntityEvent)event).type(), (Object)((EntityEvent)event).identifier());
                        }
                    }
                });
                cmp.join();
            }
        });
    }

    @Override
    public synchronized void emitEvent(TypedEvent event) {
        if (LOGGER.isTraceEnabled() && event instanceof EntityEvent) {
            LOGGER.trace("Emitting event: {} {}", (Object)event.type(), (Object)((EntityEvent)event).identifier());
        }
        EventStream<Event> eventStream = this.getEventStream(event.type());
        eventStream.queue(event);
    }

    @Override
    public void startListening() {
        this.eventStreams.values().forEach(eventStream -> this.emitStateChange((EventStream<Event>)eventStream, StateChangeEvent.STATE.LISTENING, eventStream.getEventType()));
        this.isStarted = true;
    }

    private synchronized EventStream<Event> getEventStream(String eventType) {
        Objects.requireNonNull(eventType, "eventType may not be null");
        return this.eventStreams.computeIfAbsent(eventType, prefix -> this.createEventStream(eventType));
    }

    private EventStream<Event> createEventStream(String eventType) {
        EventStream<Event> eventStream = new EventStream<Event>(this.streamRunner, eventType);
        this.emitStateChange(eventStream, StateChangeEvent.STATE.REPLAYING, eventType);
        if (this.isStarted) {
            this.emitStateChange(eventStream, StateChangeEvent.STATE.LISTENING, eventType);
        }
        return eventStream;
    }

    private void emitStateChange(EventStream<Event> eventStream, StateChangeEvent.STATE state, String type) {
        eventStream.queue(ImmutableStateChangeEvent.builder().state(state).type(type).build());
    }
}

