/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app;

import de.ii.xtraplatform.base.domain.AppContext;
import de.ii.xtraplatform.base.domain.AppLifeCycle;
import de.ii.xtraplatform.base.domain.StoreConfiguration;
import de.ii.xtraplatform.store.app.EventSubscriptions;
import de.ii.xtraplatform.store.app.EventSubscriptionsImpl;
import de.ii.xtraplatform.store.app.ValueEncodingJackson;
import de.ii.xtraplatform.store.domain.EntityEvent;
import de.ii.xtraplatform.store.domain.EventFilter;
import de.ii.xtraplatform.store.domain.EventStore;
import de.ii.xtraplatform.store.domain.EventStoreDriver;
import de.ii.xtraplatform.store.domain.EventStoreSubscriber;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.ImmutableIdentifier;
import de.ii.xtraplatform.store.domain.ImmutableReloadEvent;
import de.ii.xtraplatform.store.domain.ImmutableReplayEvent;
import de.ii.xtraplatform.store.domain.TypedEvent;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;

@Singleton
@AutoBind
public class EventStoreDefault
implements EventStore,
AppLifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventStoreDefault.class);
    private final EventStoreDriver driver;
    private final EventSubscriptions subscriptions;
    private final StoreConfiguration storeConfiguration;
    private final boolean isReadOnly;

    @Inject
    EventStoreDefault(AppContext appContext, EventStoreDriver eventStoreDriver, Reactive reactive) {
        this.driver = eventStoreDriver;
        this.subscriptions = new EventSubscriptionsImpl(reactive.runner("events"));
        this.storeConfiguration = appContext.getConfiguration().store;
        this.isReadOnly = this.storeConfiguration.mode == StoreConfiguration.StoreMode.READ_ONLY;
    }

    public EventStoreDefault(StoreConfiguration storeConfiguration, EventStoreDriver eventStoreDriver, EventSubscriptions subscriptions) {
        this.driver = eventStoreDriver;
        this.subscriptions = subscriptions;
        this.storeConfiguration = storeConfiguration;
        this.isReadOnly = storeConfiguration.mode == StoreConfiguration.StoreMode.READ_ONLY;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void onStart() {
        LOGGER.info("Store mode: {}", (Object)this.storeConfiguration.mode);
        this.driver.start();
        this.driver.loadEventStream().forEach(this.subscriptions::emitEvent);
        this.subscriptions.startListening();
        if (this.storeConfiguration.watch && this.driver.supportsWatch()) {
            LOGGER.info("Watching store for changes");
            new Thread(() -> this.driver.startWatching(changedFiles -> {
                LOGGER.info("Store changes detected: {}", changedFiles);
                EventFilter filter = EventFilter.fromPaths(changedFiles);
                this.replay(filter);
            })).start();
        }
    }

    @Override
    public void subscribe(EventStoreSubscriber subscriber) {
        this.subscriptions.addSubscriber(subscriber);
    }

    @Override
    public void push(EntityEvent event) {
        if (this.isReadOnly) {
            throw new UnsupportedOperationException("Operating in read-only mode, writes are not allowed.");
        }
        try {
            if (Objects.equals(event.deleted(), true)) {
                this.driver.deleteAllEvents(event.type(), event.identifier(), event.format());
            } else {
                this.driver.saveEvent(event);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not save event", e);
        }
        this.subscriptions.emitEvent(event);
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void replay(EventFilter filter) {
        HashSet deleteEvents = new HashSet();
        List<EntityEvent> eventStream = this.driver.loadEventStream().filter(event -> {
            boolean matches = filter.matches((EntityEvent)event);
            if (matches) {
                if (Objects.equals(event.type(), "entities") || Objects.equals(event.type(), "overrides")) {
                    String id = event.identifier().path().size() > 1 ? event.identifier().path().get(1) : event.identifier().id();
                    boolean bl = deleteEvents.add(ImmutableReplayEvent.builder().type("entities").deleted(true).identifier(Identifier.from(id, event.identifier().path().get(0))).payload(ValueEncodingJackson.YAML_NULL).build());
                } else {
                    String id = "defaults";
                    boolean bl = deleteEvents.add(ImmutableReplayEvent.builder().type("defaults").deleted(true).identifier(ImmutableIdentifier.builder().id(id).path(event.identifier().path()).build()).payload(ValueEncodingJackson.YAML_NULL).build());
                }
                return true;
            }
            return false;
        }).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        deleteEvents.forEach(event -> {
            this.subscriptions.emitEvent((TypedEvent)event);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        eventStream.forEach(event -> {
            this.subscriptions.emitEvent((TypedEvent)event);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.subscriptions.emitEvent(ImmutableReloadEvent.builder().type("entities").filter(filter).build());
    }
}

