/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app;

import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.store.domain.EntityEvent;
import de.ii.xtraplatform.store.domain.EventFilter;
import de.ii.xtraplatform.store.domain.EventStore;
import de.ii.xtraplatform.store.domain.EventStoreSubscriber;
import de.ii.xtraplatform.store.domain.Identifier;
import de.ii.xtraplatform.store.domain.ImmutableMutationEvent;
import de.ii.xtraplatform.store.domain.MutationEvent;
import de.ii.xtraplatform.store.domain.ReloadEvent;
import de.ii.xtraplatform.store.domain.ReplayEvent;
import de.ii.xtraplatform.store.domain.StateChangeEvent;
import de.ii.xtraplatform.store.domain.ValueCache;
import de.ii.xtraplatform.store.domain.ValueEncoding;
import de.ii.xtraplatform.streams.domain.Event;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.util.concurrent.MoreExecutors;
import shadow.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class EventSourcing<T>
implements EventStoreSubscriber,
ValueCache<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventSourcing.class);
    private final Map<Identifier, T> cache;
    private final Map<Identifier, CompletableFuture<T>> queue;
    private final EventStore eventStore;
    private final List<String> eventTypes;
    private final ValueEncoding<T> valueEncoding;
    private final Supplier<CompletableFuture<Void>> onStart;
    private final Optional<Function<ReplayEvent, List<ReplayEvent>>> replayEventProcessor;
    private final Optional<Function<MutationEvent, List<MutationEvent>>> mutationEventProcessor;
    private final Optional<BiFunction<Identifier, T, CompletableFuture<Void>>> updateHook;
    private final Optional<BiConsumer<Identifier, T>> valueValidator;
    private final Set<String> started;
    private final ExecutorService executorService;

    public EventSourcing(EventStore eventStore, List<String> eventTypes, ValueEncoding<T> valueEncoding, Supplier<CompletableFuture<Void>> onStart, Optional<Function<ReplayEvent, List<ReplayEvent>>> replayEventProcessor, Optional<Function<MutationEvent, List<MutationEvent>>> mutationEventProcessor, Optional<BiFunction<Identifier, T, CompletableFuture<Void>>> updateHook) {
        this(eventStore, eventTypes, valueEncoding, onStart, replayEventProcessor, mutationEventProcessor, updateHook, Optional.empty());
    }

    public EventSourcing(EventStore eventStore, List<String> eventTypes, ValueEncoding<T> valueEncoding, Supplier<CompletableFuture<Void>> onStart, Optional<Function<ReplayEvent, List<ReplayEvent>>> replayEventProcessor, Optional<Function<MutationEvent, List<MutationEvent>>> mutationEventProcessor, Optional<BiFunction<Identifier, T, CompletableFuture<Void>>> updateHook, Optional<BiConsumer<Identifier, T>> valueValidator) {
        this.eventStore = eventStore;
        this.eventTypes = eventTypes;
        this.replayEventProcessor = replayEventProcessor;
        this.mutationEventProcessor = mutationEventProcessor;
        this.updateHook = updateHook;
        this.cache = new ConcurrentSkipListMap<Identifier, T>();
        this.queue = new ConcurrentHashMap<Identifier, CompletableFuture<T>>();
        this.valueEncoding = valueEncoding;
        this.onStart = onStart;
        this.valueValidator = valueValidator;
        this.started = new HashSet<String>();
        this.executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("stream.events-%d").build()));
    }

    public void start() {
        this.eventStore.subscribe(this);
    }

    @Override
    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public void onEmit(Event event) {
        block17: {
            if (event instanceof EntityEvent) {
                EntityEvent entityEvent = (EntityEvent)event;
                try {
                    if (this.replayEventProcessor.isPresent() && event instanceof ReplayEvent) {
                        for (ReplayEvent replayEvent : this.replayEventProcessor.get().apply((ReplayEvent)event)) {
                            this.onEmit(replayEvent);
                        }
                        break block17;
                    }
                    if (this.mutationEventProcessor.isPresent() && event instanceof MutationEvent) {
                        CompletableFuture<T> completableFuture2 = null;
                        if (this.queue.containsKey(entityEvent.identifier()) && entityEvent.type().equals("defaults") && entityEvent.identifier().id().equals("services.ogc_api")) {
                            completableFuture2 = this.queue.get(entityEvent.identifier());
                            this.queue.remove(entityEvent.identifier());
                        }
                        for (MutationEvent mutationEvent : this.mutationEventProcessor.get().apply((MutationEvent)event)) {
                            if (Objects.nonNull(completableFuture2)) {
                                this.queue.put(mutationEvent.identifier(), completableFuture2);
                            }
                            this.onEmit(mutationEvent);
                        }
                        break block17;
                    }
                    this.onEmit(entityEvent);
                }
                catch (Throwable e) {
                    LogContext.error(LOGGER, e, "Cannot load '{}'", entityEvent.asPath());
                }
            } else if (event instanceof StateChangeEvent) {
                switch (((StateChangeEvent)event).state()) {
                    case REPLAYING: {
                        LOGGER.debug("Replaying events for {}", (Object)((StateChangeEvent)event).type());
                        break;
                    }
                    case LISTENING: {
                        this.started.add(((StateChangeEvent)event).type());
                        if (!this.started.containsAll(this.getEventTypes())) break;
                        this.onStart.get().thenRun(() -> LOGGER.debug("Listening for events for {}", (Object)this.started));
                    }
                }
            } else if (event instanceof ReloadEvent && this.updateHook.isPresent()) {
                List<Identifier> identifiers = this.getIdentifiers(((ReloadEvent)event).filter());
                identifiers.stream().sorted(Comparator.comparing(identifier -> identifier.path().get(0))).reduce(CompletableFuture.completedFuture(null), (completableFuture, identifier) -> completableFuture.thenCompose(ignore2 -> this.updateHook.get().apply((Identifier)identifier, (Identifier)this.getFromCache((Identifier)identifier))), (first, second) -> first.thenCompose(ignore2 -> second)).join();
            }
        }
    }

    @Override
    public boolean isInCache(Identifier identifier) {
        return this.cache.containsKey(identifier);
    }

    @Override
    public T getFromCache(Identifier identifier) {
        return this.cache.get(identifier);
    }

    public List<Identifier> getIdentifiers(String ... path) {
        return this.cache.keySet().stream().filter(identifier -> path.length == 0 || Objects.equals(ImmutableList.copyOf(path), identifier.path())).collect(Collectors.toList());
    }

    public CompletableFuture<T> pushMutationEvent(Identifier identifier, T data) {
        byte[] payload = this.valueEncoding.serialize(data);
        return this.pushMutationEventRaw(identifier, payload, Objects.isNull(data));
    }

    public CompletableFuture<T> pushPartialMutationEvent(Identifier identifier, Map<String, Object> data) {
        byte[] payload = this.valueEncoding.serialize(data);
        return this.pushMutationEventRaw(identifier, payload, Objects.isNull(data));
    }

    public CompletableFuture<T> pushMutationEventRaw(Identifier identifier, byte[] payload) {
        return this.pushMutationEventRaw(identifier, payload, false);
    }

    private CompletableFuture<T> pushMutationEventRaw(Identifier identifier, byte[] payload, boolean isDelete) {
        CompletableFuture completableFuture = new CompletableFuture();
        try {
            ImmutableMutationEvent entityEvent = ImmutableMutationEvent.builder().type(this.eventTypes.get(0)).identifier(identifier).payload(payload).deleted(isDelete ? Boolean.valueOf(true) : null).format(this.valueEncoding.getDefaultFormat().toString()).build();
            this.queue.put(identifier, completableFuture);
            this.eventStore.push(entityEvent);
        }
        catch (Throwable e) {
            completableFuture.completeExceptionally(e);
            return completableFuture;
        }
        return completableFuture;
    }

    private void onEmit(EntityEvent event) throws Throwable {
        Object value;
        Identifier key = event.identifier();
        ValueEncoding.FORMAT payloadFormat = ValueEncoding.FORMAT.fromString(event.format());
        if (payloadFormat == ValueEncoding.FORMAT.UNKNOWN) {
            if (this.queue.containsKey(key)) {
                this.queue.remove(key).complete(null);
            }
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Adding event: {} {} {}", event.type(), event.identifier(), event.format());
        }
        Throwable error = null;
        try {
            value = this.valueEncoding.deserialize(event.identifier(), event.payload(), payloadFormat, event instanceof MutationEvent);
        }
        catch (Throwable e) {
            error = e;
            value = this.cache.getOrDefault(key, null);
        }
        if (Objects.isNull(error) && !Objects.isNull(value) && this.valueValidator.isPresent()) {
            try {
                this.valueValidator.get().accept(key, value);
            }
            catch (Throwable e) {
                error = e.getCause();
                value = this.cache.getOrDefault(key, null);
            }
        }
        if (Objects.isNull(value)) {
            this.cache.remove(key);
        } else {
            this.cache.put(key, value);
        }
        if (this.queue.containsKey(key)) {
            Object finalValue = value;
            this.queue.remove(key).completeAsync(() -> finalValue, this.executorService);
        }
        if (!Objects.isNull(error)) {
            throw error;
        }
    }

    private List<Identifier> getIdentifiers(EventFilter filter) {
        return this.getIdentifiers(new String[0]).stream().filter(identifier -> {
            if (filter.getEntityTypes().contains("*") || !identifier.path().isEmpty() && filter.getEntityTypes().contains(identifier.path().get(0))) {
                return filter.getIds().contains("*") || filter.getIds().contains(identifier.id());
            }
            return false;
        }).collect(Collectors.toList());
    }
}

