/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.store.app;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.core.JsonLocation;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.core.JsonToken;
import shadow.com.fasterxml.jackson.core.Version;
import shadow.com.fasterxml.jackson.databind.BeanDescription;
import shadow.com.fasterxml.jackson.databind.DeserializationConfig;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.JavaType;
import shadow.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.com.fasterxml.jackson.databind.Module;
import shadow.com.fasterxml.jackson.databind.cfg.MapperConfig;
import shadow.com.fasterxml.jackson.databind.deser.BeanDeserializer;
import shadow.com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import shadow.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import shadow.com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import shadow.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import shadow.com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import shadow.com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import shadow.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import shadow.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import shadow.com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import shadow.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import shadow.com.fasterxml.jackson.databind.module.SimpleModule;
import shadow.com.fasterxml.jackson.databind.util.NameTransformer;

public class EntityDeserialization {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityDeserialization.class);
    public static final Module DESERIALIZE_MERGEABLE_MAP_BUILDER_WRAPPER = new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

        @Override
        public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
            Optional<BeanPropertyDefinition> propertyDefinition;
            if (deserializer instanceof BeanDeserializer && (propertyDefinition = beanDesc.findProperties().stream().filter(beanPropertyDefinition -> beanPropertyDefinition.getRawPrimaryType().getName().endsWith("MapWrapper$Builder")).findFirst()).isPresent()) {
                return new ImmutableBuilderMapWrapperDeserializer((BeanDeserializer)deserializer, propertyDefinition.get().getName());
            }
            return super.modifyDeserializer(config, beanDesc, deserializer);
        }
    });
    public static final Module DESERIALIZE_IMMUTABLE_BUILDER_NESTED = new Module(){

        @Override
        public String getModuleName() {
            return "DESERIALIZE_MODIFIABLE_MODULE";
        }

        @Override
        public Version version() {
            return Version.unknownVersion();
        }

        @Override
        public void setupModule(Module.SetupContext context) {
            context.appendAnnotationIntrospector(new NopAnnotationIntrospector(){

                @Override
                public AnnotatedMethod resolveSetterConflict(MapperConfig<?> config, AnnotatedMethod setter1, AnnotatedMethod setter2) {
                    if (this.isImmutableBuilder(setter1.getDeclaringClass())) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("resolving setter conflict for Immutables Builder {} {}", (Object)setter1, (Object)setter2);
                        }
                        if (this.isImmutableBuilder(setter1.getRawParameterType(0))) {
                            return setter1;
                        }
                        if (this.isImmutableBuilder(setter2.getRawParameterType(0))) {
                            return setter2;
                        }
                    }
                    return super.resolveSetterConflict(config, setter1, setter2);
                }
            });
        }

        private boolean isImmutableBuilder(Class<?> clazz) {
            return clazz.getSimpleName().equals("Builder");
        }
    };
    public static final Module DESERIALIZE_API_BUILDINGBLOCK_MIGRATION = new Module(){

        @Override
        public String getModuleName() {
            return "DESERIALIZE_API_BUILDINGBLOCK_MIGRATION";
        }

        @Override
        public Version version() {
            return Version.unknownVersion();
        }

        @Override
        public void setupModule(Module.SetupContext context) {
            context.addDeserializationProblemHandler(new DeserializationProblemHandler(){

                @Override
                public JavaType handleMissingTypeId(DeserializationContext ctxt, JavaType baseType, TypeIdResolver idResolver, String failureMsg) throws IOException {
                    if (!failureMsg.contains("'buildingBlock'")) {
                        return super.handleMissingTypeId(ctxt, baseType, idResolver, failureMsg);
                    }
                    JsonParser p = ctxt.getParser();
                    JsonLocation currentLocation = p.getCurrentLocation();
                    byte[] sourceRef = (byte[])currentLocation.getSourceRef();
                    long line = currentLocation.getLineNr();
                    long column = currentLocation.getColumnNr();
                    JsonParser parser2 = p.getCodec().getFactory().createParser(sourceRef);
                    parser2.nextToken();
                    parser2.nextToken();
                    parser2.nextToken();
                    JsonToken currentToken = parser2.nextToken();
                    if (currentToken == JsonToken.START_OBJECT) {
                        currentToken = parser2.nextToken();
                    } else if (currentToken != JsonToken.FIELD_NAME) {
                        return super.handleMissingTypeId(ctxt, baseType, idResolver, failureMsg);
                    }
                    long currentLine = parser2.getCurrentLocation().getLineNr();
                    long currentColumn = parser2.getCurrentLocation().getColumnNr();
                    String lastExtensionType = null;
                    while (currentLine < line || currentColumn < column) {
                        while (currentToken != JsonToken.END_OBJECT) {
                            if (currentToken == JsonToken.FIELD_NAME && parser2.getCurrentName().equals("extensionType")) {
                                currentToken = parser2.nextToken();
                                lastExtensionType = parser2.getValueAsString();
                            }
                            currentToken = parser2.nextToken();
                        }
                        currentLine = parser2.getCurrentLocation().getLineNr();
                        currentColumn = parser2.getCurrentLocation().getColumnNr();
                        currentToken = parser2.nextToken();
                    }
                    if (currentLine == line && currentColumn == column && Objects.nonNull(lastExtensionType)) {
                        return idResolver.typeFromId(ctxt, lastExtensionType);
                    }
                    return super.handleMissingTypeId(ctxt, baseType, idResolver, failureMsg);
                }
            });
        }
    };

    public static class ImmutableBuilderMapWrapperDeserializer
    extends BeanDeserializer {
        private final String wrappedPropertyName;

        ImmutableBuilderMapWrapperDeserializer(BeanDeserializer defaultDeserializer, String wrappedPropertyName) {
            super(defaultDeserializer);
            this.wrappedPropertyName = wrappedPropertyName;
        }

        @Override
        public void resolve(DeserializationContext ctxt) throws JsonMappingException {
            super.resolve(ctxt);
            SettableBeanProperty prop = this.findProperty(this.wrappedPropertyName);
            if (prop != null) {
                JsonDeserializer<Object> orig;
                BeanDeserializerBase unwrapping;
                NameTransformer xform = NameTransformer.simpleTransformer("", "");
                if (this._unwrappedPropertyHandler == null) {
                    this._unwrappedPropertyHandler = new UnwrappedPropertyHandler();
                }
                if ((unwrapping = (orig = prop.getValueDeserializer()).unwrappingDeserializer(xform)) != orig && unwrapping != null && unwrapping instanceof BeanDeserializer) {
                    SettableBeanProperty mapProp = ((BeanDeserializer)unwrapping).findProperty("map");
                    if (mapProp != null) {
                        Iterable iterable = ((BeanDeserializer)unwrapping)::properties;
                        List<SettableBeanProperty> beanProperties = StreamSupport.stream(iterable.spliterator(), false).map(settableBeanProperty -> {
                            if (settableBeanProperty == mapProp) {
                                return mapProp.withSimpleName(this.wrappedPropertyName);
                            }
                            return settableBeanProperty;
                        }).collect(Collectors.toList());
                        BeanPropertyMap beanPropertyMap = new BeanPropertyMap(false, beanProperties, Collections.emptyMap());
                        unwrapping = ((BeanDeserializer)unwrapping).withBeanProperties(beanPropertyMap);
                    }
                    prop = prop.withValueDeserializer(unwrapping);
                    this._unwrappedPropertyHandler.addProperty(prop);
                    this._beanProperties.remove(prop);
                }
            }
        }
    }
}

