/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.services.domain;

import de.ii.xtraplatform.services.domain.ImmutableServiceDataCommon;
import de.ii.xtraplatform.services.domain.Notification;
import de.ii.xtraplatform.store.domain.entities.AutoEntity;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import java.util.List;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableServiceDataCommon.Builder.class)
public interface ServiceData
extends EntityData,
AutoEntity {
    @Override
    default public Optional<String> getEntitySubType() {
        return Optional.of(this.getServiceType());
    }

    public String getServiceType();

    @Value.Default
    default public String getLabel() {
        return this.getId();
    }

    public Optional<String> getDescription();

    @JsonProperty(value="enabled")
    @JsonAlias(value={"shouldStart"})
    @Value.Default
    default public boolean getEnabled() {
        return true;
    }

    public List<Notification> getNotifications();

    @JsonProperty(value="secured")
    @Value.Default
    default public boolean getSecured() {
        return true;
    }

    public Optional<Integer> getApiVersion();

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getAuto();

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getAutoPersist();

    @JsonIgnore
    default public boolean isLoading() {
        return false;
    }

    @JsonIgnore
    default public boolean hasError() {
        return false;
    }
}

