/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.services.domain;

import de.ii.xtraplatform.services.domain.ImmutableNotification;
import de.ii.xtraplatform.services.domain.Notification;
import de.ii.xtraplatform.services.domain.ServiceData;
import de.ii.xtraplatform.services.domain.ServiceDataCommon;
import de.ii.xtraplatform.store.domain.Value;
import de.ii.xtraplatform.store.domain.entities.AutoEntity;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.common.primitives.Longs;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ServiceDataCommon", generator="Immutables")
@Immutable
public final class ImmutableServiceDataCommon
implements ServiceDataCommon {
    private final long storageVersion;
    private final String id;
    private final long createdAt;
    private final long lastModified;
    private final long entityStorageVersion;
    private final transient long entitySchemaVersion;
    private final transient boolean isAuto;
    private final transient boolean isAutoPersist;
    private final String serviceType;
    private final String label;
    @Nullable
    private final String description;
    private final boolean enabled;
    private final ImmutableList<Notification> notifications;
    private final boolean secured;
    @Nullable
    private final Integer apiVersion;
    @Nullable
    private final Boolean auto;
    @Nullable
    private final Boolean autoPersist;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableServiceDataCommon(Builder builder) {
        this.id = builder.id;
        this.serviceType = builder.serviceType;
        this.description = builder.description;
        this.notifications = ImmutableList.copyOf(ImmutableServiceDataCommon.convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(builder.notifications.build()));
        this.apiVersion = builder.apiVersion;
        this.auto = builder.auto;
        this.autoPersist = builder.autoPersist;
        if (builder.storageVersionIsSet()) {
            this.initShim.storageVersion(builder.storageVersion);
        }
        if (builder.createdAtIsSet()) {
            this.initShim.createdAt(builder.createdAt);
        }
        if (builder.lastModifiedIsSet()) {
            this.initShim.lastModified(builder.lastModified);
        }
        if (builder.entityStorageVersionIsSet()) {
            this.initShim.entityStorageVersion(builder.entityStorageVersion);
        }
        if (builder.label != null) {
            this.initShim.label(builder.label);
        }
        if (builder.enabledIsSet()) {
            this.initShim.enabled(builder.enabled);
        }
        if (builder.securedIsSet()) {
            this.initShim.secured(builder.secured);
        }
        this.storageVersion = this.initShim.storageVersion();
        this.createdAt = this.initShim.getCreatedAt();
        this.lastModified = this.initShim.getLastModified();
        this.entityStorageVersion = this.initShim.getEntityStorageVersion();
        this.entitySchemaVersion = this.initShim.getEntitySchemaVersion();
        this.isAuto = this.initShim.isAuto();
        this.isAutoPersist = this.initShim.isAutoPersist();
        this.label = this.initShim.getLabel();
        this.enabled = this.initShim.getEnabled();
        this.secured = this.initShim.getSecured();
        this.initShim = null;
    }

    private ImmutableServiceDataCommon(long storageVersion, String id, long createdAt, long lastModified, long entityStorageVersion, String serviceType, String label, @Nullable String description, boolean enabled, ImmutableList<Notification> notifications, boolean secured, @Nullable Integer apiVersion, @Nullable Boolean auto, @Nullable Boolean autoPersist) {
        this.initShim.storageVersion(storageVersion);
        this.id = id;
        this.initShim.createdAt(createdAt);
        this.initShim.lastModified(lastModified);
        this.initShim.entityStorageVersion(entityStorageVersion);
        this.serviceType = serviceType;
        this.initShim.label(label);
        this.description = description;
        this.initShim.enabled(enabled);
        this.notifications = notifications;
        this.initShim.secured(secured);
        this.apiVersion = apiVersion;
        this.auto = auto;
        this.autoPersist = autoPersist;
        this.storageVersion = this.initShim.storageVersion();
        this.createdAt = this.initShim.getCreatedAt();
        this.lastModified = this.initShim.getLastModified();
        this.entityStorageVersion = this.initShim.getEntityStorageVersion();
        this.entitySchemaVersion = this.initShim.getEntitySchemaVersion();
        this.isAuto = this.initShim.isAuto();
        this.isAutoPersist = this.initShim.isAutoPersist();
        this.label = this.initShim.getLabel();
        this.enabled = this.initShim.getEnabled();
        this.secured = this.initShim.getSecured();
        this.initShim = null;
    }

    private long storageVersionInitialize() {
        return ServiceDataCommon.super.storageVersion();
    }

    private long getCreatedAtInitialize() {
        return ServiceDataCommon.super.getCreatedAt();
    }

    private long getLastModifiedInitialize() {
        return ServiceDataCommon.super.getLastModified();
    }

    private long getEntityStorageVersionInitialize() {
        return ServiceDataCommon.super.getEntityStorageVersion();
    }

    private long getEntitySchemaVersionInitialize() {
        return ServiceDataCommon.super.getEntitySchemaVersion();
    }

    private boolean isAutoInitialize() {
        return ServiceDataCommon.super.isAuto();
    }

    private boolean isAutoPersistInitialize() {
        return ServiceDataCommon.super.isAutoPersist();
    }

    private String getLabelInitialize() {
        return ServiceDataCommon.super.getLabel();
    }

    private boolean getEnabledInitialize() {
        return ServiceDataCommon.super.getEnabled();
    }

    private boolean getSecuredInitialize() {
        return ServiceDataCommon.super.getSecured();
    }

    @Override
    @JsonProperty(value="storageVersion")
    @JsonIgnore
    public long storageVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storageVersion() : this.storageVersion;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="createdAt")
    public long getCreatedAt() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreatedAt() : this.createdAt;
    }

    @Override
    @JsonProperty(value="lastModified")
    public long getLastModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLastModified() : this.lastModified;
    }

    @Override
    @JsonProperty(value="entityStorageVersion")
    public long getEntityStorageVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEntityStorageVersion() : this.entityStorageVersion;
    }

    @Override
    @JsonProperty(value="entitySchemaVersion")
    @JsonIgnore
    public long getEntitySchemaVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEntitySchemaVersion() : this.entitySchemaVersion;
    }

    @Override
    @JsonProperty(value="isAuto")
    @JsonIgnore
    public boolean isAuto() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAuto() : this.isAuto;
    }

    @Override
    @JsonProperty(value="isAutoPersist")
    @JsonIgnore
    public boolean isAutoPersist() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAutoPersist() : this.isAutoPersist;
    }

    @Override
    @JsonProperty(value="serviceType")
    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    @JsonProperty(value="label")
    public String getLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLabel() : this.label;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="enabled")
    @JsonAlias(value={"shouldStart"})
    public boolean getEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEnabled() : this.enabled;
    }

    @JsonProperty(value="notifications")
    public ImmutableList<Notification> getNotifications() {
        return this.notifications;
    }

    @Override
    @JsonProperty(value="secured")
    public boolean getSecured() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSecured() : this.secured;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public Optional<Integer> getApiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getAuto() {
        return Optional.ofNullable(this.auto);
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getAutoPersist() {
        return Optional.ofNullable(this.autoPersist);
    }

    public final ImmutableServiceDataCommon withStorageVersion(long value) {
        if (this.storageVersion == value) {
            return this;
        }
        return new ImmutableServiceDataCommon(value, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, newValue, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withCreatedAt(long value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, value, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withLastModified(long value) {
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, value, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withEntityStorageVersion(long value) {
        if (this.entityStorageVersion == value) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, value, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withServiceType(String value) {
        String newValue = Objects.requireNonNull(value, "serviceType");
        if (this.serviceType.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, newValue, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, newValue, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, newValue, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, value, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, value, this.notifications, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withNotifications(Notification ... elements) {
        ImmutableList<Notification> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, newValue, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withNotifications(Iterable<? extends Notification> elements) {
        if (this.notifications == elements) {
            return this;
        }
        ImmutableList<Notification> newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, newValue, this.secured, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withSecured(boolean value) {
        if (this.secured == value) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, value, this.apiVersion, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withApiVersion(int value) {
        Integer newValue = value;
        if (Objects.equals(this.apiVersion, newValue)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, newValue, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withApiVersion(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.apiVersion, value)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, value, this.auto, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withAuto(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.auto, newValue)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, newValue, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withAuto(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.auto, value)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, value, this.autoPersist);
    }

    public final ImmutableServiceDataCommon withAutoPersist(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.autoPersist, newValue)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, newValue);
    }

    public final ImmutableServiceDataCommon withAutoPersist(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.autoPersist, value)) {
            return this;
        }
        return new ImmutableServiceDataCommon(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.serviceType, this.label, this.description, this.enabled, this.notifications, this.secured, this.apiVersion, this.auto, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceDataCommon && this.equalTo((ImmutableServiceDataCommon)another);
    }

    private boolean equalTo(ImmutableServiceDataCommon another) {
        return this.storageVersion == another.storageVersion && this.id.equals(another.id) && this.createdAt == another.createdAt && this.lastModified == another.lastModified && this.entityStorageVersion == another.entityStorageVersion && this.entitySchemaVersion == another.entitySchemaVersion && this.serviceType.equals(another.serviceType) && this.label.equals(another.label) && Objects.equals(this.description, another.description) && this.enabled == another.enabled && this.notifications.equals(another.notifications) && this.secured == another.secured && Objects.equals(this.apiVersion, another.apiVersion) && Objects.equals(this.auto, another.auto) && Objects.equals(this.autoPersist, another.autoPersist);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode(this.storageVersion);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Longs.hashCode(this.createdAt);
        h += (h << 5) + Longs.hashCode(this.lastModified);
        h += (h << 5) + Longs.hashCode(this.entityStorageVersion);
        h += (h << 5) + Longs.hashCode(this.entitySchemaVersion);
        h += (h << 5) + this.serviceType.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Booleans.hashCode(this.enabled);
        h += (h << 5) + this.notifications.hashCode();
        h += (h << 5) + Booleans.hashCode(this.secured);
        h += (h << 5) + Objects.hashCode(this.apiVersion);
        h += (h << 5) + Objects.hashCode(this.auto);
        h += (h << 5) + Objects.hashCode(this.autoPersist);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ServiceDataCommon").omitNullValues().add("storageVersion", this.storageVersion).add("id", this.id).add("createdAt", this.createdAt).add("lastModified", this.lastModified).add("entityStorageVersion", this.entityStorageVersion).add("entitySchemaVersion", this.entitySchemaVersion).add("serviceType", this.serviceType).add("label", this.label).add("description", this.description).add("enabled", this.enabled).add("notifications", this.notifications).add("secured", this.secured).add("apiVersion", this.apiVersion).add("auto", this.auto).add("autoPersist", this.autoPersist).toString();
    }

    public static ImmutableServiceDataCommon copyOf(ServiceDataCommon instance) {
        if (instance instanceof ImmutableServiceDataCommon) {
            return (ImmutableServiceDataCommon)instance;
        }
        return new Builder().from(instance).build();
    }

    @Nullable
    private static ImmutableNotification convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable ImmutableNotification.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static Notification convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable Notification value) {
        if (value == null) {
            return null;
        }
        return new ImmutableNotification.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableNotification.Builder convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable Notification value) {
        if (value == null) {
            return null;
        }
        return new ImmutableNotification.Builder().from(value);
    }

    private static List<Notification> convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(Iterable<? extends ImmutableNotification.Builder> builderList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableNotification.Builder builder : builderList) {
            list.add(builder.build());
        }
        return list.build();
    }

    private static List<Notification> convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(ImmutableNotification.Builder ... builderArray) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableNotification.Builder element : builderArray) {
            list.add(element.build());
        }
        return list.build();
    }

    private static List<ImmutableNotification.Builder> convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(Iterable<? extends ImmutableNotification> valueList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableNotification immutableNotification : valueList) {
            list.add(new ImmutableNotification.Builder().from(immutableNotification));
        }
        return list.build();
    }

    private static List<ImmutableNotification.Builder> convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(ImmutableNotification ... valueArray) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableNotification element : valueArray) {
            list.add(new ImmutableNotification.Builder().from(element));
        }
        return list.build();
    }

    @Generated(from="ServiceDataCommon", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends ServiceDataCommon.Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_SERVICE_TYPE = 2L;
        private static final long OPT_BIT_STORAGE_VERSION = 1L;
        private static final long OPT_BIT_CREATED_AT = 2L;
        private static final long OPT_BIT_LAST_MODIFIED = 4L;
        private static final long OPT_BIT_ENTITY_STORAGE_VERSION = 8L;
        private static final long OPT_BIT_ENABLED = 16L;
        private static final long OPT_BIT_SECURED = 32L;
        private long initBits = 3L;
        private long optBits;
        private long storageVersion;
        @Nullable
        private String id;
        private long createdAt;
        private long lastModified;
        private long entityStorageVersion;
        @Nullable
        private String serviceType;
        @Nullable
        private String label;
        @Nullable
        private String description;
        private boolean enabled;
        private ImmutableList.Builder<ImmutableNotification.Builder> notifications = ImmutableList.builder();
        private boolean secured;
        @Nullable
        private Integer apiVersion;
        @Nullable
        private Boolean auto;
        @Nullable
        private Boolean autoPersist;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(Value instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AutoEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(EntityData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceDataCommon instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<Boolean> autoOptional;
            Optional<Boolean> autoPersistOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof Value) {
                instance = (Value)object;
                this.storageVersion(instance.storageVersion());
            }
            if (object instanceof AutoEntity) {
                instance = (AutoEntity)object;
                if ((bits & 1L) == 0L) {
                    autoPersistOptional = instance.getAutoPersist();
                    if (autoPersistOptional.isPresent()) {
                        this.autoPersist(autoPersistOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    autoOptional = instance.getAuto();
                    if (autoOptional.isPresent()) {
                        this.auto(autoOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof EntityData) {
                instance = (EntityData)object;
                this.createdAt(instance.getCreatedAt());
                this.entityStorageVersion(instance.getEntityStorageVersion());
                this.id(instance.getId());
                this.lastModified(instance.getLastModified());
            }
            if (object instanceof ServiceData) {
                Optional<String> descriptionOptional;
                Optional<Integer> apiVersionOptional;
                instance = (ServiceData)object;
                this.serviceType(instance.getServiceType());
                if ((bits & 1L) == 0L) {
                    autoPersistOptional = instance.getAutoPersist();
                    if (autoPersistOptional.isPresent()) {
                        this.autoPersist(autoPersistOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    autoOptional = instance.getAuto();
                    if (autoOptional.isPresent()) {
                        this.auto(autoOptional);
                    }
                    bits |= 2L;
                }
                if ((apiVersionOptional = instance.getApiVersion()).isPresent()) {
                    this.apiVersion(apiVersionOptional);
                }
                if ((descriptionOptional = instance.getDescription()).isPresent()) {
                    this.description(descriptionOptional);
                }
                this.label(instance.getLabel());
                this.secured(instance.getSecured());
                this.enabled(instance.getEnabled());
                this.addAllNotifications(instance.getNotifications());
            }
        }

        @JsonProperty(value="storageVersion")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder storageVersion(long storageVersion) {
            this.storageVersion = storageVersion;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(long createdAt) {
            this.createdAt = createdAt;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="lastModified")
        @CanIgnoreReturnValue
        public final Builder lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="entityStorageVersion")
        @CanIgnoreReturnValue
        public final Builder entityStorageVersion(long entityStorageVersion) {
            this.entityStorageVersion = entityStorageVersion;
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="serviceType")
        @CanIgnoreReturnValue
        public final Builder serviceType(String serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="label")
        @CanIgnoreReturnValue
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty(value="enabled")
        @JsonAlias(value={"shouldStart"})
        @CanIgnoreReturnValue
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNotifications(Notification element) {
            element = Builder.convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(element);
            this.notifications.add((Object)new ImmutableNotification.Builder().from(element));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNotifications(Notification ... elements) {
            for (Notification element : elements) {
                element = Builder.convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(element);
                this.notifications.add((Object)new ImmutableNotification.Builder().from(Objects.requireNonNull(element, "notifications element")));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final ImmutableNotification.Builder addNotificationsBuilder() {
            ImmutableNotification.Builder builder = new ImmutableNotification.Builder();
            this.notifications.add((Object)builder);
            return builder;
        }

        @CanIgnoreReturnValue
        public final Builder addAllNotificationsBuilders(ImmutableNotification.Builder ... elements) {
            for (ImmutableNotification.Builder element : elements) {
                this.notifications.add((Object)Objects.requireNonNull(element, "notifications element"));
            }
            return this;
        }

        public final List<ImmutableNotification.Builder> notificationsBuilders() {
            return this.notifications.build();
        }

        @JsonProperty(value="notifications")
        @CanIgnoreReturnValue
        public final Builder notifications(Iterable<? extends Notification> elements) {
            this.notifications = ImmutableList.builder();
            return this.addAllNotifications(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNotifications(Iterable<? extends Notification> elements) {
            for (Notification notification : elements) {
                Notification notification2 = Builder.convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(notification);
                this.notifications.add((Object)new ImmutableNotification.Builder().from(Objects.requireNonNull(notification2, "notifications element")));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllNotificationsBuilders(Iterable<ImmutableNotification.Builder> elements) {
            for (ImmutableNotification.Builder element : elements) {
                this.notifications.add((Object)Objects.requireNonNull(element, "notifications element"));
            }
            return this;
        }

        @JsonProperty(value="secured")
        @CanIgnoreReturnValue
        public final Builder secured(boolean secured) {
            this.secured = secured;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder apiVersion(int apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @JsonProperty(value="apiVersion")
        @CanIgnoreReturnValue
        public final Builder apiVersion(Optional<Integer> apiVersion) {
            this.apiVersion = apiVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auto(boolean auto) {
            this.auto = auto;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder auto(Optional<Boolean> auto) {
            this.auto = auto.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder autoPersist(boolean autoPersist) {
            this.autoPersist = autoPersist;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder autoPersist(Optional<Boolean> autoPersist) {
            this.autoPersist = autoPersist.orElse(null);
            return this;
        }

        @Override
        public ImmutableServiceDataCommon build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceDataCommon(this);
        }

        private boolean storageVersionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean createdAtIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean lastModifiedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean entityStorageVersionIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean enabledIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean securedIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceType");
            }
            return "Cannot build ServiceDataCommon, some of required attributes are not set " + attributes;
        }

        @Nullable
        private static ImmutableNotification convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable ImmutableNotification.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static Notification convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable Notification value) {
            if (value == null) {
                return null;
            }
            return new ImmutableNotification.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableNotification.Builder convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(@Nullable Notification value) {
            if (value == null) {
                return null;
            }
            return new ImmutableNotification.Builder().from(value);
        }

        private static List<Notification> convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(Iterable<? extends ImmutableNotification.Builder> builderList) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableNotification.Builder builder : builderList) {
                list.add(builder.build());
            }
            return list.build();
        }

        private static List<Notification> convertToValueTypede_ii_xtraplatform_services_domain_ImmutableNotification(ImmutableNotification.Builder ... builderArray) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableNotification.Builder element : builderArray) {
                list.add(element.build());
            }
            return list.build();
        }

        private static List<ImmutableNotification.Builder> convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(Iterable<? extends ImmutableNotification> valueList) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableNotification immutableNotification : valueList) {
                list.add(new ImmutableNotification.Builder().from(immutableNotification));
            }
            return list.build();
        }

        private static List<ImmutableNotification.Builder> convertToBuilderTypede_ii_xtraplatform_services_domain_ImmutableNotification(ImmutableNotification ... valueArray) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableNotification element : valueArray) {
                list.add(new ImmutableNotification.Builder().from(element));
            }
            return list.build();
        }
    }

    @Generated(from="ServiceDataCommon", generator="Immutables")
    private final class InitShim {
        private byte storageVersionBuildStage = 0;
        private long storageVersion;
        private byte createdAtBuildStage = 0;
        private long createdAt;
        private byte lastModifiedBuildStage = 0;
        private long lastModified;
        private byte entityStorageVersionBuildStage = 0;
        private long entityStorageVersion;
        private byte entitySchemaVersionBuildStage = 0;
        private long entitySchemaVersion;
        private byte isAutoBuildStage = 0;
        private boolean isAuto;
        private byte isAutoPersistBuildStage = 0;
        private boolean isAutoPersist;
        private byte labelBuildStage = 0;
        private String label;
        private byte enabledBuildStage = 0;
        private boolean enabled;
        private byte securedBuildStage = 0;
        private boolean secured;

        private InitShim() {
        }

        long storageVersion() {
            if (this.storageVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storageVersionBuildStage == 0) {
                this.storageVersionBuildStage = (byte)-1;
                this.storageVersion = ImmutableServiceDataCommon.this.storageVersionInitialize();
                this.storageVersionBuildStage = 1;
            }
            return this.storageVersion;
        }

        void storageVersion(long storageVersion) {
            this.storageVersion = storageVersion;
            this.storageVersionBuildStage = 1;
        }

        long getCreatedAt() {
            if (this.createdAtBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdAtBuildStage == 0) {
                this.createdAtBuildStage = (byte)-1;
                this.createdAt = ImmutableServiceDataCommon.this.getCreatedAtInitialize();
                this.createdAtBuildStage = 1;
            }
            return this.createdAt;
        }

        void createdAt(long createdAt) {
            this.createdAt = createdAt;
            this.createdAtBuildStage = 1;
        }

        long getLastModified() {
            if (this.lastModifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastModifiedBuildStage == 0) {
                this.lastModifiedBuildStage = (byte)-1;
                this.lastModified = ImmutableServiceDataCommon.this.getLastModifiedInitialize();
                this.lastModifiedBuildStage = 1;
            }
            return this.lastModified;
        }

        void lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.lastModifiedBuildStage = 1;
        }

        long getEntityStorageVersion() {
            if (this.entityStorageVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.entityStorageVersionBuildStage == 0) {
                this.entityStorageVersionBuildStage = (byte)-1;
                this.entityStorageVersion = ImmutableServiceDataCommon.this.getEntityStorageVersionInitialize();
                this.entityStorageVersionBuildStage = 1;
            }
            return this.entityStorageVersion;
        }

        void entityStorageVersion(long entityStorageVersion) {
            this.entityStorageVersion = entityStorageVersion;
            this.entityStorageVersionBuildStage = 1;
        }

        long getEntitySchemaVersion() {
            if (this.entitySchemaVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.entitySchemaVersionBuildStage == 0) {
                this.entitySchemaVersionBuildStage = (byte)-1;
                this.entitySchemaVersion = ImmutableServiceDataCommon.this.getEntitySchemaVersionInitialize();
                this.entitySchemaVersionBuildStage = 1;
            }
            return this.entitySchemaVersion;
        }

        boolean isAuto() {
            if (this.isAutoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAutoBuildStage == 0) {
                this.isAutoBuildStage = (byte)-1;
                this.isAuto = ImmutableServiceDataCommon.this.isAutoInitialize();
                this.isAutoBuildStage = 1;
            }
            return this.isAuto;
        }

        boolean isAutoPersist() {
            if (this.isAutoPersistBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAutoPersistBuildStage == 0) {
                this.isAutoPersistBuildStage = (byte)-1;
                this.isAutoPersist = ImmutableServiceDataCommon.this.isAutoPersistInitialize();
                this.isAutoPersistBuildStage = 1;
            }
            return this.isAutoPersist;
        }

        String getLabel() {
            if (this.labelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.labelBuildStage == 0) {
                this.labelBuildStage = (byte)-1;
                this.label = Objects.requireNonNull(ImmutableServiceDataCommon.this.getLabelInitialize(), "label");
                this.labelBuildStage = 1;
            }
            return this.label;
        }

        void label(String label) {
            this.label = label;
            this.labelBuildStage = 1;
        }

        boolean getEnabled() {
            if (this.enabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enabledBuildStage == 0) {
                this.enabledBuildStage = (byte)-1;
                this.enabled = ImmutableServiceDataCommon.this.getEnabledInitialize();
                this.enabledBuildStage = 1;
            }
            return this.enabled;
        }

        void enabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledBuildStage = 1;
        }

        boolean getSecured() {
            if (this.securedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.securedBuildStage == 0) {
                this.securedBuildStage = (byte)-1;
                this.secured = ImmutableServiceDataCommon.this.getSecuredInitialize();
                this.securedBuildStage = 1;
            }
            return this.secured;
        }

        void secured(boolean secured) {
            this.secured = secured;
            this.securedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.storageVersionBuildStage == -1) {
                attributes.add("storageVersion");
            }
            if (this.createdAtBuildStage == -1) {
                attributes.add("createdAt");
            }
            if (this.lastModifiedBuildStage == -1) {
                attributes.add("lastModified");
            }
            if (this.entityStorageVersionBuildStage == -1) {
                attributes.add("entityStorageVersion");
            }
            if (this.entitySchemaVersionBuildStage == -1) {
                attributes.add("entitySchemaVersion");
            }
            if (this.isAutoBuildStage == -1) {
                attributes.add("isAuto");
            }
            if (this.isAutoPersistBuildStage == -1) {
                attributes.add("isAutoPersist");
            }
            if (this.labelBuildStage == -1) {
                attributes.add("label");
            }
            if (this.enabledBuildStage == -1) {
                attributes.add("enabled");
            }
            if (this.securedBuildStage == -1) {
                attributes.add("secured");
            }
            return "Cannot build ServiceDataCommon, attribute initializers form cycle " + attributes;
        }
    }
}

