/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.services.domain;

import de.ii.xtraplatform.services.domain.Notification;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Notification", generator="Immutables")
@Immutable
public final class ImmutableNotification
extends Notification {
    private final Notification.LEVEL level;
    private final ImmutableMap<String, String> messages;
    private final transient String message;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNotification(Builder builder) {
        this.level = builder.level;
        if (builder.messagesIsSet()) {
            this.initShim.messages(builder.messages.build());
        }
        this.messages = this.initShim.getMessages();
        this.message = this.initShim.getMessage();
        this.initShim = null;
    }

    private ImmutableNotification(Notification.LEVEL level, ImmutableMap<String, String> messages) {
        this.level = level;
        this.initShim.messages(messages);
        this.messages = this.initShim.getMessages();
        this.message = this.initShim.getMessage();
        this.initShim = null;
    }

    @Override
    public Notification.LEVEL getLevel() {
        return this.level;
    }

    public ImmutableMap<String, String> getMessages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMessages() : this.messages;
    }

    @Override
    public String getMessage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMessage() : this.message;
    }

    public final ImmutableNotification withLevel(Notification.LEVEL value) {
        if (this.level == value) {
            return this;
        }
        Notification.LEVEL newValue = Objects.requireNonNull(value, "level");
        if (this.level.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(newValue, this.messages);
    }

    public final ImmutableNotification withMessages(Map<String, ? extends String> entries) {
        if (this.messages == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableNotification(this.level, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNotification && this.equalTo((ImmutableNotification)another);
    }

    private boolean equalTo(ImmutableNotification another) {
        return this.level.equals((Object)another.level) && this.messages.equals(another.messages) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.level.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Notification").omitNullValues().add("level", (Object)this.level).add("messages", this.messages).add("message", this.message).toString();
    }

    public static ImmutableNotification copyOf(Notification instance) {
        if (instance instanceof ImmutableNotification) {
            return (ImmutableNotification)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Notification", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LEVEL = 1L;
        private static final long OPT_BIT_MESSAGES = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private Notification.LEVEL level;
        private ImmutableMap.Builder<String, String> messages = ImmutableMap.builder();

        @CanIgnoreReturnValue
        public final Builder from(Notification instance) {
            Objects.requireNonNull(instance, "instance");
            this.level(instance.getLevel());
            this.putAllMessages(instance.getMessages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder level(Notification.LEVEL level) {
            this.level = Objects.requireNonNull(level, "level");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMessages(String key, String value) {
            this.messages.put(key, value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMessages(Map.Entry<String, ? extends String> entry) {
            this.messages.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messages(Map<String, ? extends String> entries) {
            this.messages = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllMessages(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMessages(Map<String, ? extends String> entries) {
            this.messages.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        public ImmutableNotification build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNotification(this);
        }

        private boolean messagesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("level");
            }
            return "Cannot build Notification, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Notification", generator="Immutables")
    private final class InitShim {
        private byte messagesBuildStage = 0;
        private ImmutableMap<String, String> messages;
        private byte messageBuildStage = 0;
        private String message;

        private InitShim() {
        }

        ImmutableMap<String, String> getMessages() {
            if (this.messagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messagesBuildStage == 0) {
                this.messagesBuildStage = (byte)-1;
                this.messages = ImmutableMap.copyOf(ImmutableNotification.super.getMessages());
                this.messagesBuildStage = 1;
            }
            return this.messages;
        }

        void messages(ImmutableMap<String, String> messages) {
            this.messages = messages;
            this.messagesBuildStage = 1;
        }

        String getMessage() {
            if (this.messageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messageBuildStage == 0) {
                this.messageBuildStage = (byte)-1;
                this.message = Objects.requireNonNull(ImmutableNotification.super.getMessage(), "message");
                this.messageBuildStage = 1;
            }
            return this.message;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.messagesBuildStage == -1) {
                attributes.add("messages");
            }
            if (this.messageBuildStage == -1) {
                attributes.add("message");
            }
            return "Cannot build Notification, attribute initializers form cycle " + attributes;
        }
    }
}

