/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.services.domain;

import de.ii.xtraplatform.base.domain.LogContext;
import de.ii.xtraplatform.services.domain.Service;
import de.ii.xtraplatform.services.domain.ServiceData;
import de.ii.xtraplatform.store.domain.entities.AbstractPersistentEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService<T extends ServiceData>
extends AbstractPersistentEntity<T>
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractService.class);

    public AbstractService(T data) {
        super(data);
    }

    @Override
    protected final boolean shouldRegister() {
        return this.getData() != null && ((ServiceData)this.getData()).getEnabled();
    }

    @Override
    protected void onStarted() {
        LOGGER.info("Service with id '{}' started successfully.", (Object)this.getId());
    }

    @Override
    protected void onReloaded() {
        LOGGER.info("Service with id '{}' reloaded successfully.", (Object)this.getId());
    }

    @Override
    protected void onStopped() {
        LOGGER.info("Service with id '{}' stopped.", (Object)this.getId());
    }

    @Override
    protected void onStartupFailure(Throwable throwable) {
        LogContext.error(LOGGER, throwable, "Service with id '{}' could not be started", this.getId());
    }
}

