/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.geometries.domain;

import de.ii.xtraplatform.geometries.domain.CoordinatesWriter;
import de.ii.xtraplatform.geometries.domain.DoubleArrayProcessor;
import java.io.IOException;
import shadow.org.immutables.value.Value;

@Value.Immutable
public abstract class ToDoubleArray
implements CoordinatesWriter<DoubleArrayProcessor> {
    protected static final int MAX_BUFFER_SIZE = 512;
    protected int bufferCursor = 0;

    protected ToDoubleArray() {
    }

    @Value.Derived
    protected int getBufferSize() {
        return 512 * this.getDimension();
    }

    @Value.Derived
    protected double[] getBuffer() {
        return new double[this.getBufferSize()];
    }

    @Override
    public void onStart() throws IOException {
        ((DoubleArrayProcessor)this.getDelegate()).onStart();
    }

    @Override
    public void onSeparator() throws IOException {
    }

    @Override
    public void onX(char[] chars, int offset, int length) throws IOException {
        this.addToBuffer(chars, offset, length);
    }

    @Override
    public void onY(char[] chars, int offset, int length) throws IOException {
        this.addToBuffer(chars, offset, length);
    }

    @Override
    public void onZ(char[] chars, int offset, int length) throws IOException {
        this.addToBuffer(chars, offset, length);
    }

    @Override
    public void onFlush() throws IOException {
        if (this.bufferCursor > 0) {
            ((DoubleArrayProcessor)this.getDelegate()).onCoordinates(this.getBuffer(), this.bufferCursor, this.getDimension());
            this.bufferCursor = 0;
        }
        ((DoubleArrayProcessor)this.getDelegate()).onFlush();
    }

    @Override
    public void onEnd() throws IOException {
        this.onFlush();
        ((DoubleArrayProcessor)this.getDelegate()).onEnd();
    }

    private void addToBuffer(char[] chars, int offset, int length) throws IOException {
        this.getBuffer()[this.bufferCursor] = Double.parseDouble(String.valueOf(chars, offset, length));
        ++this.bufferCursor;
        if (this.bufferCursor == this.getBufferSize()) {
            this.onFlush();
        }
    }
}

