/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.geometries.domain;

import de.ii.xtraplatform.geometries.domain.Axis;
import de.ii.xtraplatform.geometries.domain.DoubleArrayProcessor;
import de.ii.xtraplatform.geometries.domain.SeperateStringsProcessor;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import shadow.org.immutables.value.Value;

@Value.Immutable
public abstract class ToChars
implements DoubleArrayProcessor {
    private boolean isFirst = true;

    @Value.Parameter
    protected abstract SeperateStringsProcessor getCoordinatesProcessor();

    @Value.Parameter
    protected abstract List<Integer> getPrecision();

    @Override
    public void onStart() throws IOException {
        this.getCoordinatesProcessor().onStart();
    }

    @Override
    public void onCoordinates(double[] coordinates, int length, int dimension) throws IOException {
        Integer[] precision = this.getPrecision().toArray(this.getPrecision().toArray(new Integer[0]));
        block5: for (int i = 0; i < length; ++i) {
            int axisIndex = i % dimension;
            Axis axis = Axis.fromInt[axisIndex];
            String value = String.valueOf(coordinates[i]);
            if (precision[axisIndex] > 0) {
                BigDecimal bd = new BigDecimal(value).setScale((int)precision[axisIndex], RoundingMode.HALF_UP);
                value = bd.toPlainString();
            }
            switch (axis) {
                case X: {
                    if (this.isFirst) {
                        this.isFirst = false;
                    } else {
                        this.getCoordinatesProcessor().onSeparator();
                    }
                    this.getCoordinatesProcessor().onX(value.toCharArray(), 0, value.length());
                    continue block5;
                }
                case Y: {
                    this.getCoordinatesProcessor().onY(value.toCharArray(), 0, value.length());
                    continue block5;
                }
                case Z: {
                    this.getCoordinatesProcessor().onZ(value.toCharArray(), 0, value.length());
                }
            }
        }
    }

    @Override
    public void onFlush() throws IOException {
        this.getCoordinatesProcessor().onFlush();
    }

    @Override
    public void onEnd() throws IOException {
        this.getCoordinatesProcessor().onEnd();
    }
}

