/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.geometries.domain;

import de.ii.xtraplatform.geometries.domain.CoordinatesTransformation;
import java.io.IOException;
import java.util.Arrays;
import shadow.org.immutables.value.Value;

@Value.Immutable
public abstract class SimplifyLine
implements CoordinatesTransformation {
    @Value.Parameter
    protected abstract double getDistanceTolerance();

    @Value.Parameter
    protected abstract int getMinNumberOfPoints();

    @Override
    public void onCoordinates(double[] coordinates, int length, int dimension) throws IOException {
        double[] simplified = this.simplify(coordinates, length / dimension, dimension);
        this.getNext().onCoordinates(simplified, simplified.length, dimension);
    }

    private double[] simplify(double[] points, int numberOfPoints, int dimension) {
        int i;
        if (this.getMinNumberOfPoints() > 0 && numberOfPoints <= this.getMinNumberOfPoints()) {
            return Arrays.copyOf(points, numberOfPoints * dimension);
        }
        boolean[] keepPoints = new boolean[numberOfPoints];
        Arrays.fill(keepPoints, true);
        if (this.getMinNumberOfPoints() > 2) {
            int split = Math.max(this.getMinNumberOfPoints() - 1, numberOfPoints / this.getMinNumberOfPoints());
            for (i = 0; i < numberOfPoints; i += split) {
                this.simplifySection(points, dimension, i, Math.min(i + split - 1, numberOfPoints - 1), keepPoints);
            }
        } else {
            this.simplifySection(points, dimension, 0, numberOfPoints - 1, keepPoints);
        }
        int simplifiedLength = 0;
        for (i = 0; i < numberOfPoints; ++i) {
            if (!keepPoints[i]) continue;
            simplifiedLength += dimension;
        }
        double[] simplifiedPoints = new double[simplifiedLength];
        int cursor = 0;
        for (int i2 = 0; i2 < numberOfPoints; ++i2) {
            if (!keepPoints[i2]) continue;
            for (int j = i2 * dimension; j < i2 * dimension + dimension; ++j) {
                simplifiedPoints[cursor++] = points[j];
            }
        }
        return simplifiedPoints;
    }

    private void simplifySection(double[] points, int dimension, int start, int end, boolean[] keepPoints) {
        int i;
        if (start + 1 == end) {
            return;
        }
        double maxDistance = -1.0;
        int maxIndex = start;
        for (i = start + 1; i < end; ++i) {
            double distance = this.distance(points[start * dimension], points[start * dimension + 1], points[end * dimension], points[end * dimension + 1], points[i * dimension], points[i * dimension + 1]);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            maxIndex = i;
        }
        if (maxDistance <= this.getDistanceTolerance()) {
            for (i = start + 1; i < end; ++i) {
                keepPoints[i] = false;
            }
        } else {
            this.simplifySection(points, dimension, start, maxIndex, keepPoints);
            this.simplifySection(points, dimension, maxIndex, end, keepPoints);
        }
    }

    private double distance(double p1x, double p1y, double p2x, double p2y) {
        double dx = p1x - p2x;
        double dy = p1y - p2y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private double distance(double l1x, double l1y, double l2x, double l2y, double px, double py) {
        if (l1x == l2x && l1y == l2y) {
            return this.distance(l1x, l1y, px, py);
        }
        double len2 = (l2x - l1x) * (l2x - l1x) + (l2y - l1y) * (l2y - l1y);
        double r = ((px - l1x) * (l2x - l1x) + (py - l1y) * (l2y - l1y)) / len2;
        if (r <= 0.0) {
            return this.distance(px, py, l1x, l1y);
        }
        if (r >= 1.0) {
            return this.distance(px, py, l2x, l2y);
        }
        double s = ((l1y - py) * (l2x - l1x) - (l1x - px) * (l2y - l1y)) / len2;
        return Math.abs(s) * Math.sqrt(len2);
    }
}

