/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.geometries.domain;

import de.ii.xtraplatform.geometries.domain.DoubleArrayProcessor;
import de.ii.xtraplatform.geometries.domain.ToDoubleArray;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ToDoubleArray", generator="Immutables")
@Immutable
public final class ImmutableToDoubleArray
extends ToDoubleArray {
    private final DoubleArrayProcessor delegate;
    private final int dimension;
    private final transient int bufferSize;
    private final transient double[] buffer;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableToDoubleArray(DoubleArrayProcessor delegate, int dimension) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.dimension = dimension;
        this.bufferSize = this.initShim.getBufferSize();
        this.buffer = this.initShim.getBuffer();
        this.initShim = null;
    }

    private ImmutableToDoubleArray(ImmutableToDoubleArray original, DoubleArrayProcessor delegate, int dimension) {
        this.delegate = delegate;
        this.dimension = dimension;
        this.bufferSize = this.initShim.getBufferSize();
        this.buffer = this.initShim.getBuffer();
        this.initShim = null;
    }

    @Override
    public DoubleArrayProcessor getDelegate() {
        return this.delegate;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    protected int getBufferSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBufferSize() : this.bufferSize;
    }

    @Override
    protected double[] getBuffer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBuffer() : this.buffer;
    }

    public final ImmutableToDoubleArray withDelegate(DoubleArrayProcessor value) {
        if (this.delegate == value) {
            return this;
        }
        DoubleArrayProcessor newValue = Objects.requireNonNull(value, "delegate");
        return new ImmutableToDoubleArray(this, newValue, this.dimension);
    }

    public final ImmutableToDoubleArray withDimension(int value) {
        if (this.dimension == value) {
            return this;
        }
        return new ImmutableToDoubleArray(this, this.delegate, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToDoubleArray && this.equalTo((ImmutableToDoubleArray)another);
    }

    private boolean equalTo(ImmutableToDoubleArray another) {
        return this.delegate.equals(another.delegate) && this.dimension == another.dimension && this.bufferSize == another.bufferSize && this.buffer.equals(another.buffer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.delegate.hashCode();
        h += (h << 5) + this.dimension;
        h += (h << 5) + this.bufferSize;
        h += (h << 5) + this.buffer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ToDoubleArray").omitNullValues().add("delegate", this.delegate).add("dimension", this.dimension).add("bufferSize", this.bufferSize).add("buffer", this.buffer).toString();
    }

    public static ImmutableToDoubleArray of(DoubleArrayProcessor delegate, int dimension) {
        return new ImmutableToDoubleArray(delegate, dimension);
    }

    public static ImmutableToDoubleArray copyOf(ToDoubleArray instance) {
        if (instance instanceof ImmutableToDoubleArray) {
            return (ImmutableToDoubleArray)instance;
        }
        return ImmutableToDoubleArray.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ToDoubleArray", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DELEGATE = 1L;
        private static final long INIT_BIT_DIMENSION = 2L;
        private long initBits = 3L;
        @Nullable
        private DoubleArrayProcessor delegate;
        private int dimension;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ToDoubleArray instance) {
            Objects.requireNonNull(instance, "instance");
            this.delegate((DoubleArrayProcessor)instance.getDelegate());
            this.dimension(instance.getDimension());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder delegate(DoubleArrayProcessor delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dimension(int dimension) {
            this.dimension = dimension;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableToDoubleArray build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableToDoubleArray(null, this.delegate, this.dimension);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("delegate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dimension");
            }
            return "Cannot build ToDoubleArray, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ToDoubleArray", generator="Immutables")
    private final class InitShim {
        private byte bufferSizeBuildStage = 0;
        private int bufferSize;
        private byte bufferBuildStage = 0;
        private double[] buffer;

        private InitShim() {
        }

        int getBufferSize() {
            if (this.bufferSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bufferSizeBuildStage == 0) {
                this.bufferSizeBuildStage = (byte)-1;
                this.bufferSize = ImmutableToDoubleArray.super.getBufferSize();
                this.bufferSizeBuildStage = 1;
            }
            return this.bufferSize;
        }

        double[] getBuffer() {
            if (this.bufferBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bufferBuildStage == 0) {
                this.bufferBuildStage = (byte)-1;
                this.buffer = Objects.requireNonNull(ImmutableToDoubleArray.super.getBuffer(), "buffer");
                this.bufferBuildStage = 1;
            }
            return this.buffer;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.bufferSizeBuildStage == -1) {
                attributes.add("bufferSize");
            }
            if (this.bufferBuildStage == -1) {
                attributes.add("buffer");
            }
            return "Cannot build ToDoubleArray, attribute initializers form cycle " + attributes;
        }
    }
}

