/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.geometries.domain;

import de.ii.xtraplatform.geometries.domain.CoordinatesTransformation;
import de.ii.xtraplatform.geometries.domain.DoubleArrayProcessor;
import de.ii.xtraplatform.geometries.domain.SimplifyLine;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.primitives.Doubles;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SimplifyLine", generator="Immutables")
@Immutable
public final class ImmutableSimplifyLine
extends SimplifyLine {
    private final DoubleArrayProcessor next;
    private final double distanceTolerance;
    private final int minNumberOfPoints;

    private ImmutableSimplifyLine(DoubleArrayProcessor next, double distanceTolerance, int minNumberOfPoints) {
        this.next = Objects.requireNonNull(next, "next");
        this.distanceTolerance = distanceTolerance;
        this.minNumberOfPoints = minNumberOfPoints;
    }

    private ImmutableSimplifyLine(ImmutableSimplifyLine original, DoubleArrayProcessor next, double distanceTolerance, int minNumberOfPoints) {
        this.next = next;
        this.distanceTolerance = distanceTolerance;
        this.minNumberOfPoints = minNumberOfPoints;
    }

    @Override
    public DoubleArrayProcessor getNext() {
        return this.next;
    }

    @Override
    protected double getDistanceTolerance() {
        return this.distanceTolerance;
    }

    @Override
    protected int getMinNumberOfPoints() {
        return this.minNumberOfPoints;
    }

    public final ImmutableSimplifyLine withNext(DoubleArrayProcessor value) {
        if (this.next == value) {
            return this;
        }
        DoubleArrayProcessor newValue = Objects.requireNonNull(value, "next");
        return new ImmutableSimplifyLine(this, newValue, this.distanceTolerance, this.minNumberOfPoints);
    }

    public final ImmutableSimplifyLine withDistanceTolerance(double value) {
        if (Double.doubleToLongBits(this.distanceTolerance) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableSimplifyLine(this, this.next, value, this.minNumberOfPoints);
    }

    public final ImmutableSimplifyLine withMinNumberOfPoints(int value) {
        if (this.minNumberOfPoints == value) {
            return this;
        }
        return new ImmutableSimplifyLine(this, this.next, this.distanceTolerance, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSimplifyLine && this.equalTo((ImmutableSimplifyLine)another);
    }

    private boolean equalTo(ImmutableSimplifyLine another) {
        return this.next.equals(another.next) && Double.doubleToLongBits(this.distanceTolerance) == Double.doubleToLongBits(another.distanceTolerance) && this.minNumberOfPoints == another.minNumberOfPoints;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.next.hashCode();
        h += (h << 5) + Doubles.hashCode(this.distanceTolerance);
        h += (h << 5) + this.minNumberOfPoints;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SimplifyLine").omitNullValues().add("next", this.next).add("distanceTolerance", this.distanceTolerance).add("minNumberOfPoints", this.minNumberOfPoints).toString();
    }

    public static ImmutableSimplifyLine of(DoubleArrayProcessor next, double distanceTolerance, int minNumberOfPoints) {
        return new ImmutableSimplifyLine(next, distanceTolerance, minNumberOfPoints);
    }

    public static ImmutableSimplifyLine copyOf(SimplifyLine instance) {
        if (instance instanceof ImmutableSimplifyLine) {
            return (ImmutableSimplifyLine)instance;
        }
        return ImmutableSimplifyLine.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SimplifyLine", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NEXT = 1L;
        private static final long INIT_BIT_DISTANCE_TOLERANCE = 2L;
        private static final long INIT_BIT_MIN_NUMBER_OF_POINTS = 4L;
        private long initBits = 7L;
        @Nullable
        private DoubleArrayProcessor next;
        private double distanceTolerance;
        private int minNumberOfPoints;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CoordinatesTransformation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SimplifyLine instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CoordinatesTransformation instance;
            if (object instanceof CoordinatesTransformation) {
                instance = (CoordinatesTransformation)object;
                this.next(instance.getNext());
            }
            if (object instanceof SimplifyLine) {
                instance = (SimplifyLine)object;
                this.minNumberOfPoints(((SimplifyLine)instance).getMinNumberOfPoints());
                this.distanceTolerance(((SimplifyLine)instance).getDistanceTolerance());
            }
        }

        @CanIgnoreReturnValue
        public final Builder next(DoubleArrayProcessor next) {
            this.next = Objects.requireNonNull(next, "next");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder distanceTolerance(double distanceTolerance) {
            this.distanceTolerance = distanceTolerance;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minNumberOfPoints(int minNumberOfPoints) {
            this.minNumberOfPoints = minNumberOfPoints;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSimplifyLine build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSimplifyLine(null, this.next, this.distanceTolerance, this.minNumberOfPoints);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("next");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("distanceTolerance");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("minNumberOfPoints");
            }
            return "Cannot build SimplifyLine, some of required attributes are not set " + attributes;
        }
    }
}

