/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.geometries.domain;

import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.geometries.domain.CoordinatesParser;
import de.ii.xtraplatform.geometries.domain.CoordinatesTransformer;
import de.ii.xtraplatform.geometries.domain.CoordinatesWriter;
import de.ii.xtraplatform.geometries.domain.DoubleArrayProcessor;
import de.ii.xtraplatform.geometries.domain.SeperateStringsProcessor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.common.primitives.Doubles;
import shadow.com.google.common.primitives.Ints;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CoordinatesTransformer", generator="Immutables")
@Immutable
public final class ImmutableCoordinatesTransformer
extends CoordinatesTransformer {
    private final int sourceDimension;
    private final int targetDimension;
    private final CoordinatesWriter<?> coordinatesWriter;
    @Nullable
    private final CrsTransformer crsTransformer;
    private final boolean isSwapXY;
    private final boolean isReverseOrder;
    private final double maxAllowableOffset;
    private final int minNumberOfCoordinates;
    private final ImmutableList<Integer> precision;
    private final transient double normalizedMaxAllowableOffset;
    private final transient Optional<DoubleArrayProcessor> transformationPipeline;
    private final transient SeperateStringsProcessor coordinatesProcessor;
    private final transient CoordinatesParser coordinatesParser;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCoordinatesTransformer(Builder builder) {
        this.sourceDimension = builder.sourceDimension;
        this.targetDimension = builder.targetDimension;
        this.coordinatesWriter = builder.coordinatesWriter;
        this.crsTransformer = builder.crsTransformer;
        if (builder.isSwapXYIsSet()) {
            this.initShim.isSwapXY(builder.isSwapXY);
        }
        if (builder.isReverseOrderIsSet()) {
            this.initShim.isReverseOrder(builder.isReverseOrder);
        }
        if (builder.maxAllowableOffsetIsSet()) {
            this.initShim.maxAllowableOffset(builder.maxAllowableOffset);
        }
        if (builder.minNumberOfCoordinatesIsSet()) {
            this.initShim.minNumberOfCoordinates(builder.minNumberOfCoordinates);
        }
        if (builder.precisionIsSet()) {
            this.initShim.precision((ImmutableList<Integer>)builder.precision.build());
        }
        this.isSwapXY = this.initShim.isSwapXY();
        this.isReverseOrder = this.initShim.isReverseOrder();
        this.maxAllowableOffset = this.initShim.getMaxAllowableOffset();
        this.minNumberOfCoordinates = this.initShim.getMinNumberOfCoordinates();
        this.precision = this.initShim.getPrecision();
        this.normalizedMaxAllowableOffset = this.initShim.getNormalizedMaxAllowableOffset();
        this.transformationPipeline = this.initShim.getTransformationPipeline();
        this.coordinatesProcessor = this.initShim.getCoordinatesProcessor();
        this.coordinatesParser = this.initShim.getCoordinatesParser();
        this.initShim = null;
    }

    private ImmutableCoordinatesTransformer(int sourceDimension, int targetDimension, CoordinatesWriter<?> coordinatesWriter, @Nullable CrsTransformer crsTransformer, boolean isSwapXY, boolean isReverseOrder, double maxAllowableOffset, int minNumberOfCoordinates, ImmutableList<Integer> precision) {
        this.sourceDimension = sourceDimension;
        this.targetDimension = targetDimension;
        this.coordinatesWriter = coordinatesWriter;
        this.crsTransformer = crsTransformer;
        this.initShim.isSwapXY(isSwapXY);
        this.initShim.isReverseOrder(isReverseOrder);
        this.initShim.maxAllowableOffset(maxAllowableOffset);
        this.initShim.minNumberOfCoordinates(minNumberOfCoordinates);
        this.initShim.precision(precision);
        this.isSwapXY = this.initShim.isSwapXY();
        this.isReverseOrder = this.initShim.isReverseOrder();
        this.maxAllowableOffset = this.initShim.getMaxAllowableOffset();
        this.minNumberOfCoordinates = this.initShim.getMinNumberOfCoordinates();
        this.precision = this.initShim.getPrecision();
        this.normalizedMaxAllowableOffset = this.initShim.getNormalizedMaxAllowableOffset();
        this.transformationPipeline = this.initShim.getTransformationPipeline();
        this.coordinatesProcessor = this.initShim.getCoordinatesProcessor();
        this.coordinatesParser = this.initShim.getCoordinatesParser();
        this.initShim = null;
    }

    @Override
    protected int getSourceDimension() {
        return this.sourceDimension;
    }

    @Override
    protected int getTargetDimension() {
        return this.targetDimension;
    }

    @Override
    protected CoordinatesWriter<?> getCoordinatesWriter() {
        return this.coordinatesWriter;
    }

    @Override
    protected Optional<CrsTransformer> getCrsTransformer() {
        return Optional.ofNullable(this.crsTransformer);
    }

    @Override
    protected boolean isSwapXY() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSwapXY() : this.isSwapXY;
    }

    @Override
    protected boolean isReverseOrder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isReverseOrder() : this.isReverseOrder;
    }

    @Override
    protected double getMaxAllowableOffset() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMaxAllowableOffset() : this.maxAllowableOffset;
    }

    @Override
    protected int getMinNumberOfCoordinates() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinNumberOfCoordinates() : this.minNumberOfCoordinates;
    }

    protected ImmutableList<Integer> getPrecision() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPrecision() : this.precision;
    }

    @Override
    protected double getNormalizedMaxAllowableOffset() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getNormalizedMaxAllowableOffset() : this.normalizedMaxAllowableOffset;
    }

    @Override
    protected Optional<DoubleArrayProcessor> getTransformationPipeline() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTransformationPipeline() : this.transformationPipeline;
    }

    @Override
    protected SeperateStringsProcessor getCoordinatesProcessor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCoordinatesProcessor() : this.coordinatesProcessor;
    }

    @Override
    protected CoordinatesParser getCoordinatesParser() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCoordinatesParser() : this.coordinatesParser;
    }

    public final ImmutableCoordinatesTransformer withSourceDimension(int value) {
        if (this.sourceDimension == value) {
            return this;
        }
        return new ImmutableCoordinatesTransformer(value, this.targetDimension, this.coordinatesWriter, this.crsTransformer, this.isSwapXY, this.isReverseOrder, this.maxAllowableOffset, this.minNumberOfCoordinates, this.precision);
    }

    public final ImmutableCoordinatesTransformer withTargetDimension(int value) {
        if (this.targetDimension == value) {
            return this;
        }
        return new ImmutableCoordinatesTransformer(this.sourceDimension, value, this.coordinatesWriter, this.crsTransformer, this.isSwapXY, this.isReverseOrder, this.maxAllowableOffset, this.minNumberOfCoordinates, this.precision);
    }

    public final ImmutableCoordinatesTransformer withCoordinatesWriter(CoordinatesWriter<?> value) {
        if (this.coordinatesWriter == value) {
            return this;
        }
        CoordinatesWriter<?> newValue = Objects.requireNonNull(value, "coordinatesWriter");
        return new ImmutableCoordinatesTransformer(this.sourceDimension, this.targetDimension, newValue, this.crsTransformer, this.isSwapXY, this.isReverseOrder, this.maxAllowableOffset, this.minNumberOfCoordinates, this.precision);
    }

    public final ImmutableCoordinatesTransformer withCrsTransformer(CrsTransformer value) {
        CrsTransformer newValue = Objects.requireNonNull(value, "crsTransformer");
        if (this.crsTransformer == newValue) {
            return this;
        }
        return new ImmutableCoordinatesTransformer(this.sourceDimension, this.targetDimension, this.coordinatesWriter, newValue, this.isSwapXY, this.isReverseOrder, this.maxAllowableOffset, this.minNumberOfCoordinates, this.precision);
    }

    public final ImmutableCoordinatesTransformer withCrsTransformer(Optional<? extends CrsTransformer> optional) {
        CrsTransformer value = optional.orElse(null);
        if (this.crsTransformer == value) {
            return this;
        }
        return new ImmutableCoordinatesTransformer(this.sourceDimension, this.targetDimension, this.coordinatesWriter, value, this.isSwapXY, this.isReverseOrder, this.maxAllowableOffset, this.minNumberOfCoordinates, this.precision);
    }

    public final ImmutableCoordinatesTransformer withIsSwapXY(boolean value) {
        if (this.isSwapXY == value) {
            return this;
        }
        return new ImmutableCoordinatesTransformer(this.sourceDimension, this.targetDimension, this.coordinatesWriter, this.crsTransformer, value, this.isReverseOrder, this.maxAllowableOffset, this.minNumberOfCoordinates, this.precision);
    }

    public final ImmutableCoordinatesTransformer withIsReverseOrder(boolean value) {
        if (this.isReverseOrder == value) {
            return this;
        }
        return new ImmutableCoordinatesTransformer(this.sourceDimension, this.targetDimension, this.coordinatesWriter, this.crsTransformer, this.isSwapXY, value, this.maxAllowableOffset, this.minNumberOfCoordinates, this.precision);
    }

    public final ImmutableCoordinatesTransformer withMaxAllowableOffset(double value) {
        if (Double.doubleToLongBits(this.maxAllowableOffset) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableCoordinatesTransformer(this.sourceDimension, this.targetDimension, this.coordinatesWriter, this.crsTransformer, this.isSwapXY, this.isReverseOrder, value, this.minNumberOfCoordinates, this.precision);
    }

    public final ImmutableCoordinatesTransformer withMinNumberOfCoordinates(int value) {
        if (this.minNumberOfCoordinates == value) {
            return this;
        }
        return new ImmutableCoordinatesTransformer(this.sourceDimension, this.targetDimension, this.coordinatesWriter, this.crsTransformer, this.isSwapXY, this.isReverseOrder, this.maxAllowableOffset, value, this.precision);
    }

    public final ImmutableCoordinatesTransformer withPrecision(int ... elements) {
        ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
        return new ImmutableCoordinatesTransformer(this.sourceDimension, this.targetDimension, this.coordinatesWriter, this.crsTransformer, this.isSwapXY, this.isReverseOrder, this.maxAllowableOffset, this.minNumberOfCoordinates, newValue);
    }

    public final ImmutableCoordinatesTransformer withPrecision(Iterable<Integer> elements) {
        if (this.precision == elements) {
            return this;
        }
        ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableCoordinatesTransformer(this.sourceDimension, this.targetDimension, this.coordinatesWriter, this.crsTransformer, this.isSwapXY, this.isReverseOrder, this.maxAllowableOffset, this.minNumberOfCoordinates, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCoordinatesTransformer && this.equalTo((ImmutableCoordinatesTransformer)another);
    }

    private boolean equalTo(ImmutableCoordinatesTransformer another) {
        return this.sourceDimension == another.sourceDimension && this.targetDimension == another.targetDimension && this.coordinatesWriter.equals(another.coordinatesWriter) && Objects.equals(this.crsTransformer, another.crsTransformer) && this.isSwapXY == another.isSwapXY && this.isReverseOrder == another.isReverseOrder && Double.doubleToLongBits(this.maxAllowableOffset) == Double.doubleToLongBits(another.maxAllowableOffset) && this.minNumberOfCoordinates == another.minNumberOfCoordinates && this.precision.equals(another.precision) && Double.doubleToLongBits(this.normalizedMaxAllowableOffset) == Double.doubleToLongBits(another.normalizedMaxAllowableOffset) && this.transformationPipeline.equals(another.transformationPipeline) && this.coordinatesProcessor.equals(another.coordinatesProcessor) && this.coordinatesParser.equals(another.coordinatesParser);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sourceDimension;
        h += (h << 5) + this.targetDimension;
        h += (h << 5) + this.coordinatesWriter.hashCode();
        h += (h << 5) + Objects.hashCode(this.crsTransformer);
        h += (h << 5) + Booleans.hashCode(this.isSwapXY);
        h += (h << 5) + Booleans.hashCode(this.isReverseOrder);
        h += (h << 5) + Doubles.hashCode(this.maxAllowableOffset);
        h += (h << 5) + this.minNumberOfCoordinates;
        h += (h << 5) + this.precision.hashCode();
        h += (h << 5) + Doubles.hashCode(this.normalizedMaxAllowableOffset);
        h += (h << 5) + this.transformationPipeline.hashCode();
        h += (h << 5) + this.coordinatesProcessor.hashCode();
        h += (h << 5) + this.coordinatesParser.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CoordinatesTransformer").omitNullValues().add("sourceDimension", this.sourceDimension).add("targetDimension", this.targetDimension).add("coordinatesWriter", this.coordinatesWriter).add("crsTransformer", this.crsTransformer).add("isSwapXY", this.isSwapXY).add("isReverseOrder", this.isReverseOrder).add("maxAllowableOffset", this.maxAllowableOffset).add("minNumberOfCoordinates", this.minNumberOfCoordinates).add("precision", this.precision).add("normalizedMaxAllowableOffset", this.normalizedMaxAllowableOffset).add("transformationPipeline", this.transformationPipeline).add("coordinatesProcessor", this.coordinatesProcessor).add("coordinatesParser", this.coordinatesParser).toString();
    }

    public static ImmutableCoordinatesTransformer copyOf(CoordinatesTransformer instance) {
        if (instance instanceof ImmutableCoordinatesTransformer) {
            return (ImmutableCoordinatesTransformer)instance;
        }
        return ImmutableCoordinatesTransformer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CoordinatesTransformer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_DIMENSION = 1L;
        private static final long INIT_BIT_TARGET_DIMENSION = 2L;
        private static final long INIT_BIT_COORDINATES_WRITER = 4L;
        private static final long OPT_BIT_IS_SWAP_X_Y = 1L;
        private static final long OPT_BIT_IS_REVERSE_ORDER = 2L;
        private static final long OPT_BIT_MAX_ALLOWABLE_OFFSET = 4L;
        private static final long OPT_BIT_MIN_NUMBER_OF_COORDINATES = 8L;
        private static final long OPT_BIT_PRECISION = 16L;
        private long initBits = 7L;
        private long optBits;
        private int sourceDimension;
        private int targetDimension;
        @Nullable
        private CoordinatesWriter<?> coordinatesWriter;
        @Nullable
        private CrsTransformer crsTransformer;
        private boolean isSwapXY;
        private boolean isReverseOrder;
        private double maxAllowableOffset;
        private int minNumberOfCoordinates;
        private ImmutableList.Builder<Integer> precision = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CoordinatesTransformer instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceDimension(instance.getSourceDimension());
            this.targetDimension(instance.getTargetDimension());
            this.coordinatesWriter(instance.getCoordinatesWriter());
            Optional<CrsTransformer> crsTransformerOptional = instance.getCrsTransformer();
            if (crsTransformerOptional.isPresent()) {
                this.crsTransformer(crsTransformerOptional);
            }
            this.isSwapXY(instance.isSwapXY());
            this.isReverseOrder(instance.isReverseOrder());
            this.maxAllowableOffset(instance.getMaxAllowableOffset());
            this.minNumberOfCoordinates(instance.getMinNumberOfCoordinates());
            this.addAllPrecision(instance.getPrecision());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceDimension(int sourceDimension) {
            this.sourceDimension = sourceDimension;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetDimension(int targetDimension) {
            this.targetDimension = targetDimension;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder coordinatesWriter(CoordinatesWriter<?> coordinatesWriter) {
            this.coordinatesWriter = Objects.requireNonNull(coordinatesWriter, "coordinatesWriter");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crsTransformer(CrsTransformer crsTransformer) {
            this.crsTransformer = Objects.requireNonNull(crsTransformer, "crsTransformer");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crsTransformer(Optional<? extends CrsTransformer> crsTransformer) {
            this.crsTransformer = crsTransformer.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isSwapXY(boolean isSwapXY) {
            this.isSwapXY = isSwapXY;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isReverseOrder(boolean isReverseOrder) {
            this.isReverseOrder = isReverseOrder;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxAllowableOffset(double maxAllowableOffset) {
            this.maxAllowableOffset = maxAllowableOffset;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minNumberOfCoordinates(int minNumberOfCoordinates) {
            this.minNumberOfCoordinates = minNumberOfCoordinates;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPrecision(int element) {
            this.precision.add((Object)element);
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPrecision(int ... elements) {
            this.precision.addAll(Ints.asList(elements));
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder precision(Iterable<Integer> elements) {
            this.precision = ImmutableList.builder();
            return this.addAllPrecision(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPrecision(Iterable<Integer> elements) {
            this.precision.addAll((Iterable)elements);
            this.optBits |= 0x10L;
            return this;
        }

        public ImmutableCoordinatesTransformer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCoordinatesTransformer(this);
        }

        private boolean isSwapXYIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isReverseOrderIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean maxAllowableOffsetIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minNumberOfCoordinatesIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean precisionIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceDimension");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetDimension");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("coordinatesWriter");
            }
            return "Cannot build CoordinatesTransformer, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CoordinatesTransformer", generator="Immutables")
    private final class InitShim {
        private byte isSwapXYBuildStage = 0;
        private boolean isSwapXY;
        private byte isReverseOrderBuildStage = 0;
        private boolean isReverseOrder;
        private byte maxAllowableOffsetBuildStage = 0;
        private double maxAllowableOffset;
        private byte minNumberOfCoordinatesBuildStage = 0;
        private int minNumberOfCoordinates;
        private byte precisionBuildStage = 0;
        private ImmutableList<Integer> precision;
        private byte normalizedMaxAllowableOffsetBuildStage = 0;
        private double normalizedMaxAllowableOffset;
        private byte transformationPipelineBuildStage = 0;
        private Optional<DoubleArrayProcessor> transformationPipeline;
        private byte coordinatesProcessorBuildStage = 0;
        private SeperateStringsProcessor coordinatesProcessor;
        private byte coordinatesParserBuildStage = 0;
        private CoordinatesParser coordinatesParser;

        private InitShim() {
        }

        boolean isSwapXY() {
            if (this.isSwapXYBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSwapXYBuildStage == 0) {
                this.isSwapXYBuildStage = (byte)-1;
                this.isSwapXY = ImmutableCoordinatesTransformer.super.isSwapXY();
                this.isSwapXYBuildStage = 1;
            }
            return this.isSwapXY;
        }

        void isSwapXY(boolean isSwapXY) {
            this.isSwapXY = isSwapXY;
            this.isSwapXYBuildStage = 1;
        }

        boolean isReverseOrder() {
            if (this.isReverseOrderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isReverseOrderBuildStage == 0) {
                this.isReverseOrderBuildStage = (byte)-1;
                this.isReverseOrder = ImmutableCoordinatesTransformer.super.isReverseOrder();
                this.isReverseOrderBuildStage = 1;
            }
            return this.isReverseOrder;
        }

        void isReverseOrder(boolean isReverseOrder) {
            this.isReverseOrder = isReverseOrder;
            this.isReverseOrderBuildStage = 1;
        }

        double getMaxAllowableOffset() {
            if (this.maxAllowableOffsetBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxAllowableOffsetBuildStage == 0) {
                this.maxAllowableOffsetBuildStage = (byte)-1;
                this.maxAllowableOffset = ImmutableCoordinatesTransformer.super.getMaxAllowableOffset();
                this.maxAllowableOffsetBuildStage = 1;
            }
            return this.maxAllowableOffset;
        }

        void maxAllowableOffset(double maxAllowableOffset) {
            this.maxAllowableOffset = maxAllowableOffset;
            this.maxAllowableOffsetBuildStage = 1;
        }

        int getMinNumberOfCoordinates() {
            if (this.minNumberOfCoordinatesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minNumberOfCoordinatesBuildStage == 0) {
                this.minNumberOfCoordinatesBuildStage = (byte)-1;
                this.minNumberOfCoordinates = ImmutableCoordinatesTransformer.super.getMinNumberOfCoordinates();
                this.minNumberOfCoordinatesBuildStage = 1;
            }
            return this.minNumberOfCoordinates;
        }

        void minNumberOfCoordinates(int minNumberOfCoordinates) {
            this.minNumberOfCoordinates = minNumberOfCoordinates;
            this.minNumberOfCoordinatesBuildStage = 1;
        }

        ImmutableList<Integer> getPrecision() {
            if (this.precisionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.precisionBuildStage == 0) {
                this.precisionBuildStage = (byte)-1;
                this.precision = ImmutableList.copyOf(ImmutableCoordinatesTransformer.super.getPrecision());
                this.precisionBuildStage = 1;
            }
            return this.precision;
        }

        void precision(ImmutableList<Integer> precision) {
            this.precision = precision;
            this.precisionBuildStage = 1;
        }

        double getNormalizedMaxAllowableOffset() {
            if (this.normalizedMaxAllowableOffsetBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizedMaxAllowableOffsetBuildStage == 0) {
                this.normalizedMaxAllowableOffsetBuildStage = (byte)-1;
                this.normalizedMaxAllowableOffset = ImmutableCoordinatesTransformer.super.getNormalizedMaxAllowableOffset();
                this.normalizedMaxAllowableOffsetBuildStage = 1;
            }
            return this.normalizedMaxAllowableOffset;
        }

        Optional<DoubleArrayProcessor> getTransformationPipeline() {
            if (this.transformationPipelineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transformationPipelineBuildStage == 0) {
                this.transformationPipelineBuildStage = (byte)-1;
                this.transformationPipeline = Objects.requireNonNull(ImmutableCoordinatesTransformer.super.getTransformationPipeline(), "transformationPipeline");
                this.transformationPipelineBuildStage = 1;
            }
            return this.transformationPipeline;
        }

        SeperateStringsProcessor getCoordinatesProcessor() {
            if (this.coordinatesProcessorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.coordinatesProcessorBuildStage == 0) {
                this.coordinatesProcessorBuildStage = (byte)-1;
                this.coordinatesProcessor = Objects.requireNonNull(ImmutableCoordinatesTransformer.super.getCoordinatesProcessor(), "coordinatesProcessor");
                this.coordinatesProcessorBuildStage = 1;
            }
            return this.coordinatesProcessor;
        }

        CoordinatesParser getCoordinatesParser() {
            if (this.coordinatesParserBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.coordinatesParserBuildStage == 0) {
                this.coordinatesParserBuildStage = (byte)-1;
                this.coordinatesParser = Objects.requireNonNull(ImmutableCoordinatesTransformer.super.getCoordinatesParser(), "coordinatesParser");
                this.coordinatesParserBuildStage = 1;
            }
            return this.coordinatesParser;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isSwapXYBuildStage == -1) {
                attributes.add("isSwapXY");
            }
            if (this.isReverseOrderBuildStage == -1) {
                attributes.add("isReverseOrder");
            }
            if (this.maxAllowableOffsetBuildStage == -1) {
                attributes.add("maxAllowableOffset");
            }
            if (this.minNumberOfCoordinatesBuildStage == -1) {
                attributes.add("minNumberOfCoordinates");
            }
            if (this.precisionBuildStage == -1) {
                attributes.add("precision");
            }
            if (this.normalizedMaxAllowableOffsetBuildStage == -1) {
                attributes.add("normalizedMaxAllowableOffset");
            }
            if (this.transformationPipelineBuildStage == -1) {
                attributes.add("transformationPipeline");
            }
            if (this.coordinatesProcessorBuildStage == -1) {
                attributes.add("coordinatesProcessor");
            }
            if (this.coordinatesParserBuildStage == -1) {
                attributes.add("coordinatesParser");
            }
            return "Cannot build CoordinatesTransformer, attribute initializers form cycle " + attributes;
        }
    }
}

