/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.geometries.domain;

import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.geometries.domain.CoordinatesParser;
import de.ii.xtraplatform.geometries.domain.CoordinatesWriter;
import de.ii.xtraplatform.geometries.domain.DoubleArrayProcessor;
import de.ii.xtraplatform.geometries.domain.ImmutableCrsTransform;
import de.ii.xtraplatform.geometries.domain.ImmutableReverseLine;
import de.ii.xtraplatform.geometries.domain.ImmutableSimplifyLine;
import de.ii.xtraplatform.geometries.domain.ImmutableSwapXY;
import de.ii.xtraplatform.geometries.domain.ImmutableToChars;
import de.ii.xtraplatform.geometries.domain.ImmutableToDoubleArray;
import de.ii.xtraplatform.geometries.domain.SeperateStringsProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@Value.Immutable
public abstract class CoordinatesTransformer
extends Writer {
    protected abstract int getSourceDimension();

    protected abstract int getTargetDimension();

    protected abstract CoordinatesWriter<?> getCoordinatesWriter();

    protected abstract Optional<CrsTransformer> getCrsTransformer();

    @Value.Default
    protected boolean isSwapXY() {
        return false;
    }

    @Value.Default
    protected boolean isReverseOrder() {
        return false;
    }

    @Value.Default
    protected double getMaxAllowableOffset() {
        return 0.0;
    }

    @Value.Default
    protected int getMinNumberOfCoordinates() {
        return 0;
    }

    @Value.Default
    protected List<Integer> getPrecision() {
        return ImmutableList.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
    }

    @Value.Derived
    protected double getNormalizedMaxAllowableOffset() {
        if (!this.getCrsTransformer().isPresent()) {
            return this.getMaxAllowableOffset();
        }
        double requestFactor = this.getCrsTransformer().get().getTargetUnitEquivalentInMeters();
        double localFactor = this.getCrsTransformer().get().getSourceUnitEquivalentInMeters();
        if (requestFactor == 1.0 && localFactor != 1.0) {
            return this.getMaxAllowableOffset() / localFactor;
        }
        if (requestFactor != 1.0 && localFactor == 1.0) {
            return this.getMaxAllowableOffset() * requestFactor;
        }
        return this.getMaxAllowableOffset();
    }

    @Value.Derived
    protected Optional<DoubleArrayProcessor> getTransformationPipeline() {
        DoubleArrayProcessor lastTransformation = ImmutableToChars.of(this.getCoordinatesWriter(), this.getPrecision());
        boolean doTransform = this.getPrecision().stream().anyMatch(precision -> precision > 0);
        if (this.isSwapXY()) {
            lastTransformation = ImmutableSwapXY.of(lastTransformation);
            doTransform = true;
        }
        if (this.isReverseOrder()) {
            lastTransformation = ImmutableReverseLine.of(lastTransformation);
            doTransform = true;
        }
        if (this.getCrsTransformer().isPresent()) {
            lastTransformation = ImmutableCrsTransform.of(lastTransformation, this.getCrsTransformer().get());
            doTransform = true;
        }
        if (this.getNormalizedMaxAllowableOffset() > 0.0) {
            lastTransformation = ImmutableSimplifyLine.of(lastTransformation, this.getNormalizedMaxAllowableOffset(), this.getMinNumberOfCoordinates());
            doTransform = true;
        }
        return doTransform ? Optional.of(lastTransformation) : Optional.empty();
    }

    @Value.Derived
    protected SeperateStringsProcessor getCoordinatesProcessor() {
        Optional<DoubleArrayProcessor> transformationPipeline = this.getTransformationPipeline();
        if (transformationPipeline.isPresent()) {
            return ImmutableToDoubleArray.of(transformationPipeline.get(), this.getTargetDimension());
        }
        return this.getCoordinatesWriter();
    }

    @Value.Derived
    protected CoordinatesParser getCoordinatesParser() {
        return new CoordinatesParser(this.getCoordinatesProcessor(), this.getSourceDimension(), this.getTargetDimension());
    }

    @Override
    public void write(char[] chars, int i, int i1) throws IOException {
        this.getCoordinatesParser().parse(chars, i, i1);
    }

    @Override
    public void flush() throws IOException {
        this.getCoordinatesParser().flush();
    }

    @Override
    public void close() throws IOException {
        this.getCoordinatesParser().close();
    }
}

