/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.geometries.domain;

import de.ii.xtraplatform.geometries.domain.Axis;
import de.ii.xtraplatform.geometries.domain.SeperateStringsProcessor;
import java.io.IOException;
import java.util.Objects;
import shadow.org.apache.commons.lang3.ArrayUtils;

public class CoordinatesParser {
    private final SeperateStringsProcessor coordinatesProcessor;
    private final int sourceDimension;
    private final int targetDimension;
    private boolean started;
    private boolean lastCharWasSeparator;
    private char[] chunkBoundaryBuffer;
    private int counter;
    private Axis axis;

    public CoordinatesParser(SeperateStringsProcessor coordinatesProcessor, int sourceDimension, int targetDimension) {
        this.coordinatesProcessor = coordinatesProcessor;
        this.sourceDimension = sourceDimension;
        this.targetDimension = targetDimension;
        this.started = false;
        this.lastCharWasSeparator = true;
        this.chunkBoundaryBuffer = null;
        this.counter = 0;
        this.axis = Axis.X;
    }

    public final void parse(char[] chars, int offset, int length) throws IOException {
        boolean endOfChunk = false;
        int read = 0;
        for (int j = offset; j < offset + length; ++j) {
            boolean bl = endOfChunk = j == offset + length - 1;
            if (this.isSeparator(chars[j])) {
                if (!this.lastCharWasSeparator) {
                    this.lastCharWasSeparator = true;
                    this.onValue(chars, j - read, read);
                    read = -1;
                } else {
                    --read;
                }
            } else {
                this.lastCharWasSeparator = false;
            }
            if (endOfChunk) {
                this.onChunkEnd(chars, j - read, read + 1);
            }
            ++read;
        }
    }

    public void flush() throws IOException {
        if (!this.started) {
            this.onStart();
        }
        if (!this.lastCharWasSeparator && this.hasChunkBoundaryBuffer()) {
            this.onValue(new char[0], 0, 0);
        }
        this.started = false;
        this.lastCharWasSeparator = true;
        this.chunkBoundaryBuffer = null;
        this.counter = 0;
        this.axis = Axis.X;
        this.coordinatesProcessor.onFlush();
    }

    public void close() throws IOException {
        this.flush();
        this.coordinatesProcessor.onEnd();
    }

    private boolean isSeparator(char chr) {
        return chr == ' ' || chr == '\n' || chr == '\t' || chr == '\r' || chr == ',';
    }

    private void onStart() throws IOException {
        this.started = true;
        this.coordinatesProcessor.onStart();
    }

    private void onChunkEnd(char[] chars, int offset, int length) throws IOException {
        if (length > 0) {
            this.chunkBoundaryBuffer = this.hasChunkBoundaryBuffer() ? ArrayUtils.addAll(this.chunkBoundaryBuffer, ArrayUtils.subarray(chars, offset, offset + length)) : ArrayUtils.subarray(chars, offset, offset + length);
        }
    }

    private boolean hasChunkBoundaryBuffer() throws IOException {
        return Objects.nonNull(this.chunkBoundaryBuffer);
    }

    private void onValue(char[] chars, int offset, int length) throws IOException {
        this.axis = Axis.fromInt[this.counter % this.sourceDimension];
        ++this.counter;
        if (this.hasChunkBoundaryBuffer()) {
            char[] value = ArrayUtils.addAll(this.chunkBoundaryBuffer, ArrayUtils.subarray(chars, offset, offset + length));
            this.chunkBoundaryBuffer = null;
            this.formatValue(value, 0, value.length);
        } else {
            this.formatValue(chars, offset, length);
        }
    }

    private void formatValue(char[] chars, int offset, int length) throws IOException {
        boolean writeSeparator = true;
        if (!this.started) {
            this.onStart();
            writeSeparator = false;
        }
        switch (this.axis) {
            case X: {
                if (writeSeparator) {
                    this.coordinatesProcessor.onSeparator();
                }
                this.coordinatesProcessor.onX(chars, offset, length);
                break;
            }
            case Y: {
                this.coordinatesProcessor.onY(chars, offset, length);
                break;
            }
            case Z: {
                if (this.targetDimension != 3) break;
                this.coordinatesProcessor.onZ(chars, offset, length);
            }
        }
    }
}

