/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.infra.db;

import de.ii.xtraplatform.features.domain.ImmutableTuple;
import de.ii.xtraplatform.features.domain.Tuple;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.util.TablesNamesFinder;
import shadow.com.google.common.collect.ImmutableList;

public class ViewInfo {
    public static List<String> getOriginalTables(String viewDefinition) {
        try {
            PlainSelect select = ViewInfo.parse(viewDefinition);
            TablesNamesFinder tablesNamesFinder = new TablesNamesFinder(){

                @Override
                protected String extractTableName(Table table) {
                    return table.getName();
                }
            };
            return tablesNamesFinder.getTableList(statementVisitor -> select.accept(tablesNamesFinder));
        }
        catch (JSQLParserException | ParseException e) {
            boolean bl = true;
            return ImmutableList.of();
        }
    }

    public static Optional<Tuple<String, String>> getOriginalTableAndColumn(String viewDefinition, String columnName) {
        try {
            PlainSelect select = ViewInfo.parse(viewDefinition);
            return ViewInfo.getOriginalTableAndColumn(select, columnName).map(tableAndColumn -> ViewInfo.resolveTableAlias(select, tableAndColumn));
        }
        catch (JSQLParserException | ParseException e) {
            boolean bl = true;
            return Optional.empty();
        }
    }

    private static Optional<Tuple<String, String>> getOriginalTableAndColumn(PlainSelect select, final String columnName) {
        final ImmutableTuple.Builder builder = ImmutableTuple.builder().second(columnName);
        for (SelectItem selectItem : select.getSelectItems()) {
            selectItem.accept(new SelectItemVisitorAdapter(){

                @Override
                public void visit(SelectExpressionItem item) {
                    if (item.getExpression() instanceof Column) {
                        Column column = (Column)item.getExpression();
                        if (Objects.nonNull(item.getAlias()) && Objects.equals(item.getAlias().getName(), columnName)) {
                            builder.first(column.getTable().getName()).second(column.getColumnName());
                        } else if (Objects.equals(column.getColumnName(), columnName)) {
                            builder.first(column.getTable().getName());
                        }
                    }
                }
            });
        }
        try {
            return Optional.of(builder.build());
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    private static Tuple<String, String> resolveTableAlias(PlainSelect select, final Tuple<String, String> tableAndColumn) {
        final ImmutableTuple.Builder<String, String> builder = ImmutableTuple.builder().from(tableAndColumn);
        select.getFromItem().accept(new FromItemVisitorAdapter(){

            @Override
            public void visit(Table tableName) {
                if (Objects.nonNull(tableName.getAlias()) && Objects.equals(tableName.getAlias().getName(), tableAndColumn.first())) {
                    builder.first(tableName.getName());
                }
            }

            @Override
            public void visit(SubJoin subjoin) {
                subjoin.getLeft().accept(this);
                subjoin.getJoinList().forEach(join -> join.getRightItem().accept(this));
            }
        });
        return builder.build();
    }

    private static PlainSelect parse(String select) throws JSQLParserException, ParseException {
        Select statement = (Select)CCJSqlParserUtil.parse(select, ccjSqlParser -> ccjSqlParser.setErrorRecovery(true));
        PlainSelect selectBody = (PlainSelect)statement.getSelectBody();
        if (Objects.isNull(selectBody.getFromItem())) {
            CCJSqlParser from = new CCJSqlParser(new StringProvider(select.substring(select.lastIndexOf("FROM") + 5)));
            selectBody.setFromItem(from.FromItem());
        }
        return selectBody;
    }
}

