/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.infra.db;

import de.ii.xtraplatform.features.domain.FeatureStoreAttributesContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreRelatedContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreRelation;
import de.ii.xtraplatform.features.domain.TypeInfoValidator;
import de.ii.xtraplatform.features.sql.domain.SqlClient;
import de.ii.xtraplatform.features.sql.infra.db.SchemaInfo;
import de.ii.xtraplatform.features.sql.infra.db.SqlSchemaCrawler;
import de.ii.xtraplatform.store.domain.entities.ImmutableValidationResult;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.collect.ImmutableList;

public class SqlTypeInfoValidator
implements TypeInfoValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlTypeInfoValidator.class);
    public static final String TABLE_DOES_NOT_EXIST = "%s: table '%s' does not exist";
    public static final String COLUMN_DOES_NOT_EXIST = "%s: column '%s' in table '%s' does not exist";
    public static final String COLUMN_NOT_UNIQUE = "%s: column '%s' in table '%s' should not be used as %s, neither a primary key nor a unique constraint can be found";
    public static final String COLUMN_CANNOT_BE_USED_AS = "%s: column '%s' in table '%s' cannot be used as %s";
    private final List<String> schemas;
    private Supplier<SqlClient> sqlClient;

    public SqlTypeInfoValidator(List<String> schemas, Supplier<SqlClient> sqlClient) {
        this.schemas = schemas;
        this.sqlClient = sqlClient;
    }

    @Override
    public ValidationResult validate(String typeName, FeatureStoreAttributesContainer attributesContainer, ValidationResult.MODE mode) {
        ValidationResult validationResult;
        SqlSchemaCrawler schemaCrawler = new SqlSchemaCrawler(this.sqlClient.get().getConnection());
        try {
            Catalog catalog = schemaCrawler.getCatalog(this.schemas, this.getUsedTables(attributesContainer), ImmutableList.of());
            Collection<Table> tables = catalog.getTables();
            validationResult = this.validate(typeName, attributesContainer, mode, new SchemaInfo(tables));
        }
        catch (Throwable throwable) {
            try {
                try {
                    schemaCrawler.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SchemaCrawlerException e) {
                throw new IllegalStateException("could not parse schema");
            }
        }
        schemaCrawler.close();
        return validationResult;
    }

    private ValidationResult validate(String typeName, FeatureStoreAttributesContainer attributesContainer, ValidationResult.MODE mode, SchemaInfo schemaInfo) {
        ImmutableValidationResult intermediateResult;
        ImmutableValidationResult.Builder result = ImmutableValidationResult.builder().mode(mode);
        if (attributesContainer instanceof FeatureStoreRelatedContainer) {
            List<FeatureStoreRelation> relations = ((FeatureStoreRelatedContainer)attributesContainer).getInstanceConnection();
            for (int i = 0; i < relations.size(); ++i) {
                FeatureStoreRelation relation = relations.get(i);
                String context = String.format("Invalid sourcePath '%s' in type '%s'", Joiner.on('/').join(relation.asPath()), typeName);
                if (i > 0 && !schemaInfo.tableExists(relation.getSourceContainer())) {
                    result.addErrors(String.format(TABLE_DOES_NOT_EXIST, context, relation.getSourceContainer()));
                } else if (!schemaInfo.columnExists(relation.getSourceField(), relation.getSourceContainer())) {
                    result.addErrors(String.format(COLUMN_DOES_NOT_EXIST, context, relation.getSourceField(), relation.getSourceContainer()));
                }
                if (!schemaInfo.tableExists(relation.getTargetContainer())) {
                    result.addErrors(String.format(TABLE_DOES_NOT_EXIST, context, relation.getTargetContainer()));
                } else if (!schemaInfo.columnExists(relation.getTargetField(), relation.getTargetContainer())) {
                    result.addErrors(String.format(COLUMN_DOES_NOT_EXIST, context, relation.getTargetField(), relation.getTargetContainer()));
                }
                if (relation.getJunction().isPresent() && !schemaInfo.tableExists(relation.getJunction().get())) {
                    result.addErrors(String.format(TABLE_DOES_NOT_EXIST, context, relation.getJunction().get()));
                    continue;
                }
                if (relation.getJunctionSource().isPresent() && relation.getJunction().isPresent() && !schemaInfo.columnExists(relation.getJunctionSource().get(), relation.getJunction().get())) {
                    result.addErrors(String.format(COLUMN_DOES_NOT_EXIST, context, relation.getJunctionSource().get(), relation.getJunction().get()));
                }
                if (!relation.getJunctionTarget().isPresent() || !relation.getJunction().isPresent() || schemaInfo.columnExists(relation.getJunctionTarget().get(), relation.getJunction().get())) continue;
                result.addErrors(String.format(COLUMN_DOES_NOT_EXIST, context, relation.getJunctionTarget().get(), relation.getJunction().get()));
            }
        } else if (!schemaInfo.tableExists(attributesContainer.getName())) {
            String context = String.format("Invalid sourcePath in type '%s'", typeName);
            result.addErrors(String.format(TABLE_DOES_NOT_EXIST, context, attributesContainer.getName()));
        }
        if (!(intermediateResult = result.build()).isSuccess()) {
            return intermediateResult;
        }
        String context = String.format("Invalid sort key for type '%s'", typeName);
        if (!schemaInfo.columnExists(attributesContainer.getSortKey(), attributesContainer.getName())) {
            result.addErrors(String.format(COLUMN_DOES_NOT_EXIST, context, attributesContainer.getSortKey(), attributesContainer.getName()));
        } else if (!schemaInfo.isColumnUnique(attributesContainer.getSortKey(), attributesContainer.getName())) {
            result.addStrictErrors(String.format(COLUMN_NOT_UNIQUE, context, attributesContainer.getSortKey(), attributesContainer.getName(), "sort key"));
        }
        attributesContainer.getAttributes().forEach(attribute -> {
            if (!attribute.isConstant()) {
                String context2 = String.format("Invalid sourcePath for property '%s' in type '%s'", attribute.getQueryable(), typeName);
                if (!schemaInfo.columnExists(attribute.getName(), attributesContainer.getName())) {
                    result.addErrors(String.format(COLUMN_DOES_NOT_EXIST, context2, attribute.getName(), attributesContainer.getName()));
                } else {
                    if (attribute.isId() && !schemaInfo.isColumnUnique(attribute.getName(), attributesContainer.getName())) {
                        String context3 = String.format("Invalid role ID for property '%s' in type '%s'", attribute.getQueryable(), typeName);
                        result.addStrictErrors(String.format(COLUMN_NOT_UNIQUE, context3, attribute.getName(), attributesContainer.getName(), "feature id"));
                    }
                    if (attribute.isSpatial() && !schemaInfo.isColumnSpatial(attributesContainer.getName(), attribute.getName())) {
                        result.addErrors(String.format(COLUMN_CANNOT_BE_USED_AS, context2, attribute.getName(), attributesContainer.getName(), "geometry"));
                    }
                    if (attribute.isTemporal() && !schemaInfo.isColumnTemporal(attributesContainer.getName(), attribute.getName())) {
                        result.addErrors(String.format(COLUMN_CANNOT_BE_USED_AS, context2, attribute.getName(), attributesContainer.getName(), "datetime"));
                    }
                }
            }
        });
        return result.build();
    }

    private List<String> getUsedTables(FeatureStoreAttributesContainer attributesContainer) {
        ArrayList<String> usedTables = new ArrayList<String>();
        usedTables.add(attributesContainer.getName());
        if (attributesContainer instanceof FeatureStoreRelatedContainer) {
            List<FeatureStoreRelation> relations = ((FeatureStoreRelatedContainer)attributesContainer).getInstanceConnection();
            for (int i = 0; i < relations.size(); ++i) {
                FeatureStoreRelation relation = relations.get(i);
                usedTables.add(relation.getSourceContainer());
                usedTables.add(relation.getTargetContainer());
                if (!relation.getJunction().isPresent()) continue;
                usedTables.add(relation.getJunction().get());
            }
        }
        return usedTables;
    }
}

