/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.infra.db;

import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.Tuple;
import de.ii.xtraplatform.features.sql.domain.ValueTypeMapping;
import de.ii.xtraplatform.features.sql.infra.db.ViewInfo;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import schemacrawler.schema.Column;
import schemacrawler.schema.Index;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;

class SchemaInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaInfo.class);
    private static final String VIEW_COLUMN_NOT_ANALYZABLE = "Cannot analyze constraints and indices for column '{}' in view '{}', the column might be composed of multiple actual columns or the view might be composed of other views.";
    private final Collection<Table> tables;

    SchemaInfo(Collection<Table> tables) {
        this.tables = tables;
    }

    public boolean tableExists(String name) {
        return this.tables.stream().anyMatch(t -> t.getName().equals(name));
    }

    public boolean columnExists(String name, String table) {
        return this.tables.stream().filter(t -> t.getName().equals(table)).flatMap(t -> t.getColumns().stream()).anyMatch(c -> c.getName().equals(name));
    }

    public boolean isColumnUnique(String columnName, String tableName) {
        return this.isColumnUnique(columnName, tableName, true);
    }

    public boolean isColumnUnique(String columnName, String tableName, boolean warn) {
        Optional<Column> optionalColumn = this.getColumn(tableName, columnName, true, warn);
        if (optionalColumn.isPresent()) {
            Column column = optionalColumn.get();
            Table table = (Table)column.getParent();
            boolean isPrimaryKey = table.hasPrimaryKey() && table.getPrimaryKey().getColumns().size() == 1 && Objects.equals(table.getPrimaryKey().getColumns().get(0), column);
            boolean isUniqueIndex = table.getIndexes().stream().filter(Index::isUnique).anyMatch(index -> index.getColumns().size() == 1 && Objects.equals(index.getColumns().get(0), column));
            return isPrimaryKey || isUniqueIndex;
        }
        return false;
    }

    public boolean isColumnSpatial(String table, String name) {
        return this.getColumn(table, name).filter(c -> ValueTypeMapping.matches(c.getColumnDataType().getJavaSqlType(), c.getColumnDataType().getName(), SchemaBase.Type.GEOMETRY)).isPresent();
    }

    public boolean isColumnTemporal(String table, String name) {
        return this.getColumn(table, name).filter(c -> ValueTypeMapping.matches(c.getColumnDataType().getJavaSqlType(), c.getColumnDataType().getDatabaseSpecificTypeName(), SchemaBase.Type.DATETIME)).isPresent();
    }

    public Optional<Column> getColumn(String tableName, String columnName) {
        return this.getColumn(tableName, columnName, false, false);
    }

    public Optional<Column> getColumn(String tableName, String columnName, boolean resolveViews, boolean warn) {
        Table table;
        Optional<Column> optionalColumn = this.tables.stream().filter(t -> t.getName().equals(tableName)).flatMap(t -> t.getColumns().stream()).filter(c -> c.getName().equals(columnName)).findFirst();
        if (resolveViews && optionalColumn.isPresent() && (table = (Table)optionalColumn.get().getParent()) instanceof View) {
            Optional<Tuple<String, String>> originalColumn = ViewInfo.getOriginalTableAndColumn(table.getDefinition(), columnName);
            if (originalColumn.isPresent()) {
                return this.getColumn(originalColumn.get().first(), originalColumn.get().second());
            }
            if (warn) {
                LOGGER.warn(VIEW_COLUMN_NOT_ANALYZABLE, (Object)columnName, (Object)tableName);
            }
        }
        return optionalColumn;
    }
}

