/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.infra.db;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaGenerator;
import de.ii.xtraplatform.features.domain.Tuple;
import de.ii.xtraplatform.features.sql.app.SimpleFeatureGeometryFromToWkt;
import de.ii.xtraplatform.features.sql.domain.SqlClient;
import de.ii.xtraplatform.features.sql.domain.SqlDialect;
import de.ii.xtraplatform.features.sql.infra.db.SchemaInfo;
import de.ii.xtraplatform.features.sql.infra.db.SqlSchemaCrawler;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;

public class SchemaGeneratorSql
implements SchemaGenerator,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaGeneratorSql.class);
    private final SqlClient sqlClient;
    private final Connection connection;
    private final SqlSchemaCrawler schemaCrawler;
    private final List<String> schemas;
    private final List<String> includeTables;
    private final SqlDialect dialect;

    public SchemaGeneratorSql(SqlClient sqlClient, List<String> schemas, List<String> includeTables, SqlDialect dialect) {
        this.sqlClient = sqlClient;
        this.connection = sqlClient.getConnection();
        this.schemaCrawler = new SqlSchemaCrawler(sqlClient.getConnection());
        this.schemas = schemas;
        this.includeTables = includeTables;
        this.dialect = dialect;
    }

    @Override
    public List<FeatureSchema> generate() {
        try {
            LOGGER.debug("Crawling SQL schema");
            Tuple<Catalog, List<String>> catalogAndMatching = this.schemaCrawler.getCatalogAndMatching(this.schemas, this.includeTables, this.dialect.getSystemTables());
            LOGGER.debug("Finished crawling SQL schema");
            Map<String, List<String>> geometryInfos = this.getGeometryInfos();
            return this.getFeatureTypes(catalogAndMatching.first(), catalogAndMatching.second(), geometryInfos);
        }
        catch (Throwable e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stacktrace:", e);
            }
            throw new IllegalStateException("Could not crawl schema: " + e.getMessage());
        }
    }

    private List<FeatureSchema> getFeatureTypes(Catalog catalog, List<String> includeTables, Map<String, List<String>> geometryInfos) {
        ImmutableList.Builder featureTypes = new ImmutableList.Builder();
        for (Schema schema : catalog.getSchemas()) {
            SchemaInfo schemaInfo = new SchemaInfo(catalog.getTables(schema));
            for (Table table : catalog.getTables(schema)) {
                if (!includeTables.isEmpty() && !includeTables.contains(table.getName())) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Generating type '{}'", (Object)table.getName());
                }
                ImmutableFeatureSchema.Builder featureType = new ImmutableFeatureSchema.Builder().name(table.getName()).sourcePath("/" + table.getName().toLowerCase());
                boolean idFound = false;
                for (Column column : table.getColumns()) {
                    SchemaBase.Type featurePropertyType = this.getFeaturePropertyType(column.getColumnDataType());
                    if (featurePropertyType == SchemaBase.Type.UNKNOWN) continue;
                    ImmutableFeatureSchema.Builder featureProperty = new ImmutableFeatureSchema.Builder().name(column.getName()).sourcePath(column.getName()).type(featurePropertyType);
                    if (!idFound && schemaInfo.isColumnUnique(column.getName(), table.getName(), false)) {
                        featureProperty.role(SchemaBase.Role.ID);
                        idFound = true;
                    }
                    if (featurePropertyType == SchemaBase.Type.GEOMETRY) {
                        if (!geometryInfos.containsKey(table.getName())) continue;
                        List<String> geometryInfo = geometryInfos.get(table.getName());
                        try {
                            int srid = Integer.parseInt(geometryInfo.get(1));
                            if (srid > 0) {
                                featureProperty.additionalInfo(ImmutableMap.of("crs", String.valueOf(srid)));
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        featureProperty.geometryType(SimpleFeatureGeometryFromToWkt.fromString(geometryInfo.get(0)).toSimpleFeatureGeometry());
                    }
                    featureType.putPropertyMap(column.getName(), featureProperty.build());
                }
                ImmutableFeatureSchema featureSchema = featureType.build();
                if (featureSchema.getProperties().stream().noneMatch(SchemaBase::isId)) {
                    LOGGER.warn("No primary key or unique column found for table '{}', you have to adjust the type configuration manually.", (Object)table.getName());
                }
                featureTypes.add(featureSchema);
            }
        }
        return featureTypes.build();
    }

    private SchemaBase.Type getFeaturePropertyType(ColumnDataType columnDataType) {
        if (SimpleFeatureGeometryFromToWkt.fromString(columnDataType.getName()) != SimpleFeatureGeometryFromToWkt.NONE) {
            return SchemaBase.Type.GEOMETRY;
        }
        switch (columnDataType.getJavaSqlType().getJavaSqlTypeGroup()) {
            case bit: {
                return SchemaBase.Type.BOOLEAN;
            }
            case character: {
                return SchemaBase.Type.STRING;
            }
            case integer: {
                return SchemaBase.Type.INTEGER;
            }
            case real: {
                return SchemaBase.Type.FLOAT;
            }
            case temporal: {
                return SchemaBase.Type.DATETIME;
            }
        }
        return SchemaBase.Type.UNKNOWN;
    }

    private Map<String, List<String>> getGeometryInfos() {
        HashMap<String, List<String>> geometry = new HashMap<String, List<String>>();
        Map<String, String> dbInfo = this.sqlClient.getDbInfo();
        String query = this.dialect.geometryInfoQuery(dbInfo);
        try {
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                geometry.put(rs.getString("table"), ImmutableList.of(rs.getString("type"), rs.getString("srid")));
            }
        }
        catch (SQLException e) {
            LOGGER.debug("SQL QUERY EXCEPTION", e);
        }
        return geometry;
    }

    @Override
    public void close() throws IOException {
        try {
            this.schemaCrawler.close();
            this.connection.close();
        }
        catch (SQLException exception) {
            throw new IOException(exception);
        }
    }
}

