/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.features.domain.SchemaBase;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;

public class ValueTypeMapping {
    private static final List<SQLType> SQL_BOOLEANS = ImmutableList.of(JDBCType.BOOLEAN);
    private static final List<SQLType> SQL_INTEGERS = ImmutableList.of(JDBCType.BIGINT, JDBCType.INTEGER, JDBCType.SMALLINT, JDBCType.TINYINT);
    private static final List<SQLType> SQL_FLOATS = ImmutableList.of(JDBCType.DECIMAL, JDBCType.DOUBLE, JDBCType.FLOAT, JDBCType.NUMERIC, JDBCType.REAL);
    private static final List<SQLType> SQL_STRINGS = ImmutableList.of(JDBCType.CHAR, JDBCType.LONGNVARCHAR, JDBCType.LONGVARCHAR, JDBCType.NCHAR, JDBCType.NVARCHAR, JDBCType.VARCHAR);
    private static final List<SQLType> SQL_TIMESTAMPS = Stream.concat(Stream.of(JDBCType.TIMESTAMP, JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCType.DATE), SQL_STRINGS.stream()).collect(ImmutableList.toImmutableList());
    private static final List<SQLType> SQL_GEOMETRIES = ImmutableList.of(new SQLType(){

        @Override
        public String getName() {
            return "geometry";
        }

        @Override
        public String getVendor() {
            return JDBCType.OTHER.getVendor();
        }

        @Override
        public Integer getVendorTypeNumber() {
            return JDBCType.OTHER.getVendorTypeNumber();
        }
    });
    private static final Map<SchemaBase.Type, List<SQLType>> mappings = new ImmutableMap.Builder<SchemaBase.Type, List<SQLType>>().put(SchemaBase.Type.BOOLEAN, SQL_BOOLEANS).put(SchemaBase.Type.INTEGER, SQL_INTEGERS).put(SchemaBase.Type.FLOAT, SQL_FLOATS).put(SchemaBase.Type.STRING, SQL_STRINGS).put(SchemaBase.Type.DATETIME, SQL_TIMESTAMPS).put(SchemaBase.Type.GEOMETRY, SQL_GEOMETRIES).build();

    public static List<SQLType> getSourceTypes(SchemaBase.Type type) {
        return mappings.getOrDefault((Object)type, ImmutableList.of());
    }

    public static boolean matches(SQLType sqlType, String databaseSpecificTypeName, SchemaBase.Type type) {
        return ValueTypeMapping.getSourceTypes(type).stream().anyMatch(allowedType -> {
            boolean vendorTypeNumberMatches = Objects.equals(allowedType.getVendorTypeNumber(), sqlType.getVendorTypeNumber());
            if (vendorTypeNumberMatches && Objects.equals(JDBCType.OTHER.getVendorTypeNumber(), sqlType.getVendorTypeNumber())) {
                return allowedType.getName().equalsIgnoreCase(databaseSpecificTypeName);
            }
            return vendorTypeNumberMatches;
        });
    }
}

