/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.features.domain.FeatureProviderConnector;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SortKey;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlQueryOptions;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface SqlQueryOptions
extends FeatureProviderConnector.QueryOptions {
    public static SqlQueryOptions withColumnTypes(Class<?> ... columnTypes) {
        return SqlQueryOptions.withColumnTypes(Arrays.asList(columnTypes));
    }

    public static SqlQueryOptions ddl() {
        return SqlQueryOptions.withColumnTypes(new Class[0]);
    }

    public static SqlQueryOptions ignoreResults() {
        return SqlQueryOptions.withColumnTypes(new Class[0]);
    }

    public static SqlQueryOptions mutation() {
        return SqlQueryOptions.withColumnTypes(new Class[0]);
    }

    public static SqlQueryOptions withColumnTypes(List<Class<?>> columnTypes) {
        return new ImmutableSqlQueryOptions.Builder().customColumnTypes(columnTypes).build();
    }

    public Optional<SchemaSql> getTableSchema();

    public List<SortKey> getCustomSortKeys();

    public List<Class<?>> getCustomColumnTypes();

    @Value.Default
    default public int getContainerPriority() {
        return 0;
    }

    @Value.Default
    default public int getChunkSize() {
        return 1000;
    }

    @Value.Derived
    default public List<String> getSortKeys() {
        return Stream.concat(this.getCustomSortKeys().stream().map(SortKey::getField), this.getTableSchema().map(attributesContainer -> attributesContainer.getSortKeys().stream()).orElse(Stream.empty())).collect(Collectors.toList());
    }

    @Value.Derived
    default public List<SortKey.Direction> getSortDirections() {
        return Stream.concat(this.getCustomSortKeys().stream().map(SortKey::getDirection), this.getTableSchema().map(attributesContainer -> attributesContainer.getSortKeys().stream().map(s -> SortKey.Direction.ASCENDING)).orElse(Stream.empty())).collect(Collectors.toList());
    }

    @Value.Derived
    default public List<Class<?>> getColumnTypes() {
        ArrayList columnTypes = new ArrayList();
        this.getTableSchema().ifPresent(attributesContainer -> attributesContainer.getProperties().stream().filter(SchemaBase::isValue).forEach(attribute -> columnTypes.add(String.class)));
        columnTypes.addAll(this.getCustomColumnTypes());
        return columnTypes;
    }

    @Value.Derived
    default public boolean isPlain() {
        return !this.getTableSchema().isPresent();
    }
}

