/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.cql.domain.Cql;
import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.features.domain.ImmutableTuple;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlPath;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlRelation;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlPath;
import de.ii.xtraplatform.features.sql.domain.SqlPathDefaults;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableCollection;
import shadow.com.google.common.collect.ImmutableList;

public class SqlPathParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlPathParser.class);
    private static final Splitter PATH_SPLITTER = Splitter.on("/").omitEmptyStrings();
    private static final Joiner PATH_JOINER = Joiner.on("/").skipNulls();
    private static final Splitter MULTI_COLUMN_SPLITTER = Splitter.on(":").omitEmptyStrings();
    private final SqlPathDefaults defaults;
    private final Cql cql;
    private final Optional<Pattern> junctionTableMatcher;

    public SqlPathParser(SqlPathDefaults defaults, Cql cql) {
        this.defaults = defaults;
        this.cql = cql;
        this.junctionTableMatcher = defaults.getJunctionTablePattern().map(Pattern::compile);
    }

    public SqlPath parseColumnPath(String path) {
        String column;
        Matcher matcher = Patterns.COLUMN_PATH.matcher(path);
        if (matcher.find() && Objects.nonNull(column = matcher.group(MatcherGroups.COLUMNS.name()))) {
            List<String> columns = MULTI_COLUMN_SPLITTER.splitToList(column);
            ImmutableSqlPath.Builder builder = new ImmutableSqlPath.Builder().name(column).columns(columns);
            String tablePath = matcher.group(MatcherGroups.PATH.name());
            if (Objects.nonNull(tablePath)) {
                builder.parentTables(this.parseTables(tablePath));
            }
            builder.sortKey("").primaryKey("").junction(false);
            return builder.build();
        }
        throw new IllegalArgumentException("Invalid sourcePath in provider configuration: " + path);
    }

    public SqlPath parseTablePath(String path) {
        Matcher matcher = Patterns.ROOT_TABLE.matcher(path);
        if (matcher.find()) {
            return this.parseTable(matcher, false);
        }
        List<SqlPath> sqlPaths = this.parseTables(path);
        if (!sqlPaths.isEmpty()) {
            return new ImmutableSqlPath.Builder().from(sqlPaths.get(sqlPaths.size() - 1)).parentTables(sqlPaths.subList(0, sqlPaths.size() - 1)).build();
        }
        throw new IllegalArgumentException("Invalid sourcePath in provider configuration: " + path);
    }

    private List<SqlPath> parseTables(String tablePath) {
        ArrayList<SqlPath> tables = new ArrayList<SqlPath>();
        Matcher tableMatcher = Patterns.JOINED_TABLE.matcher(tablePath);
        while (tableMatcher.find()) {
            tables.add(this.parseTable(tableMatcher, true));
        }
        return tables;
    }

    private SqlPath parseTable(Matcher tableMatcher, boolean hasJoin) {
        String table = tableMatcher.group(MatcherGroups.TABLE.name());
        ImmutableSqlPath.Builder builder = new ImmutableSqlPath.Builder().name(table);
        if (hasJoin) {
            String sourceField = tableMatcher.group(MatcherGroups.SOURCEFIELD.name());
            String targetField = tableMatcher.group(MatcherGroups.TARGETFIELD.name());
            builder.name(table).join(ImmutableTuple.of(sourceField, targetField));
        }
        String flags = Optional.ofNullable(tableMatcher.group(MatcherGroups.FLAGS.name())).orElse("");
        builder.sortKey(this.getSortKey(flags)).primaryKey(this.getPrimaryKey(flags)).junction(this.isJunctionTable(table, flags)).filter(this.getFilterFlag(flags).map(filterText -> this.cql.read((String)filterText, Cql.Format.TEXT))).filterString(this.getFilterFlag(flags));
        return builder.build();
    }

    public List<String> asList(String path) {
        return PATH_SPLITTER.splitToList(path);
    }

    public String asString(List<String> pathElements) {
        StringBuilder path = new StringBuilder();
        if (!pathElements.isEmpty() && !pathElements.get(0).startsWith("/")) {
            path.append("/");
        }
        PATH_JOINER.appendTo(path, (Iterable<? extends Object>)pathElements);
        return path.toString();
    }

    public String asString(String ... pathAndPathElements) {
        return this.asString(Arrays.asList(pathAndPathElements));
    }

    public boolean isJunctionTable(String table, String flags) {
        return this.junctionTableMatcher.filter(pattern -> pattern.matcher(table).find()).isPresent() || Patterns.JUNCTION_TABLE_FLAG.matcher(flags).find();
    }

    public String getSortKey(String flags) {
        Matcher matcher = Patterns.SORT_KEY_FLAG.matcher(flags);
        if (matcher.find()) {
            return matcher.group(MatcherGroups.SORTKEY.name());
        }
        return this.defaults.getSortKey();
    }

    public String getPrimaryKey(String flags) {
        Matcher matcher = Patterns.PRIMARY_KEY_FLAG.matcher(flags);
        if (matcher.find()) {
            return matcher.group(MatcherGroups.PRIMARYKEY.name());
        }
        return this.defaults.getPrimaryKey();
    }

    public Optional<String> getFilterFlag(String flags) {
        Matcher matcher = Patterns.FILTER_FLAG.matcher(flags);
        if (matcher.find()) {
            return Optional.of(matcher.group(MatcherGroups.FILTER.name()));
        }
        return Optional.empty();
    }

    public List<SqlRelation> extractRelations(SqlPath parentPath, SqlPath path) {
        List<SqlPath> allTables = this.getAllTables(parentPath, path);
        return this.extractRelations(allTables);
    }

    public List<SqlRelation> extractRelations(SchemaSql parent, SqlPath path) {
        List<SqlPath> allTables = this.getAllTables(new ImmutableSqlPath.Builder().name(parent.getName()).sortKey(parent.getSortKey().orElse(this.defaults.getSortKey())).primaryKey(parent.getPrimaryKey().orElse(this.defaults.getPrimaryKey())).filter(parent.getFilter()).filterString(parent.getFilter().map(filterCql -> this.cql.write((CqlFilter)filterCql, Cql.Format.TEXT))).junction(false).build(), path);
        return this.extractRelations(allTables);
    }

    private List<SqlRelation> extractRelations(List<SqlPath> paths) {
        if (paths.size() < 2) {
            return ImmutableList.of();
        }
        if (paths.size() == 2) {
            return IntStream.range(1, paths.size()).mapToObj(i -> this.toRelation((SqlPath)paths.get(i - 1), (SqlPath)paths.get(i))).collect(Collectors.toList());
        }
        return IntStream.range(2, paths.size()).mapToObj(i -> this.toRelations((SqlPath)paths.get(i - 2), (SqlPath)paths.get(i - 1), (SqlPath)paths.get(i), i == paths.size() - 1)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    private List<SqlPath> getAllTables(SqlPath parentPath, SqlPath path) {
        ImmutableCollection.Builder pathsBuilder = ((ImmutableList.Builder)new ImmutableList.Builder().add(parentPath)).addAll(path.getParentTables());
        if (path.isBranch()) {
            ((ImmutableList.Builder)pathsBuilder).add(path);
        }
        return ((ImmutableList.Builder)pathsBuilder).build();
    }

    private Stream<SqlRelation> toRelations(SqlPath source, SqlPath link, SqlPath target, boolean isLast) {
        if (source.isJunction()) {
            if (isLast) {
                return Stream.of(this.toRelation(link, target));
            }
            return Stream.empty();
        }
        if (target.isJunction() && !isLast) {
            return Stream.of(this.toRelation(source, link));
        }
        if (link.isJunction()) {
            return Stream.of(this.toRelation(source, link, target));
        }
        return Stream.of(this.toRelation(source, link), this.toRelation(link, target));
    }

    private SqlRelation toRelation(SqlPath source, SqlPath target) {
        if (!target.getJoin().isPresent()) {
            throw new IllegalArgumentException();
        }
        String sourceField = target.getJoin().get().first();
        String targetField = target.getJoin().get().second();
        boolean isOne2One = Objects.equals(targetField, source.getPrimaryKey());
        return new ImmutableSqlRelation.Builder().cardinality(isOne2One ? SqlRelation.CARDINALITY.ONE_2_ONE : SqlRelation.CARDINALITY.ONE_2_N).sourceContainer(source.getName()).sourceField(sourceField).sourcePrimaryKey(source.getPrimaryKey()).sourceSortKey(source.getSortKey()).sourceFilter(source.getFilterString()).targetContainer(target.getName()).targetField(targetField).targetFilter(target.getFilterString()).build();
    }

    private SqlRelation toRelation(SqlPath source, SqlPath link, SqlPath target) {
        if (!link.getJoin().isPresent() || !target.getJoin().isPresent()) {
            throw new IllegalArgumentException();
        }
        String sourceField = link.getJoin().get().first();
        String junctionSourceField = link.getJoin().get().second();
        String junctionTargetField = target.getJoin().get().first();
        String targetField = target.getJoin().get().second();
        return new ImmutableSqlRelation.Builder().cardinality(SqlRelation.CARDINALITY.M_2_N).sourceContainer(source.getName()).sourceField(sourceField).sourcePrimaryKey(source.getPrimaryKey()).sourceSortKey(source.getSortKey()).sourceFilter(source.getFilterString()).junctionSource(junctionSourceField).junction(link.getName()).junctionTarget(junctionTargetField).junctionFilter(link.getFilterString()).targetContainer(target.getName()).targetField(targetField).targetFilter(target.getFilterString()).build();
    }

    private static interface Patterns {
        public static final Pattern ROOT_TABLE = Pattern.compile(PatternStrings.ROOT_TABLE);
        public static final Pattern JOINED_TABLE = Pattern.compile(PatternStrings.JOINED_TABLE);
        public static final Pattern COLUMN_PATH = Pattern.compile(PatternStrings.COLUMN_PATH);
        public static final Pattern JUNCTION_TABLE_FLAG = Pattern.compile("\\{junction\\}");
        public static final Pattern SORT_KEY_FLAG = Pattern.compile(PatternStrings.SORT_KEY_FLAG);
        public static final Pattern FILTER_FLAG = Pattern.compile(PatternStrings.FILTER_FLAG);
        public static final Pattern PRIMARY_KEY_FLAG = Pattern.compile(PatternStrings.PRIMARY_KEY_FLAG);
    }

    private static interface PatternStrings {
        public static final String IDENTIFIER = "[a-zA-Z_]{1}[a-zA-Z0-9_]*";
        public static final String FLAGS = "(?:\\{[a-z_]+.*?\\})*";
        public static final String SORT_KEY_FLAG = String.format("\\{sortKey=(?<%s>.+?)\\}", new Object[]{MatcherGroups.SORTKEY});
        public static final String PRIMARY_KEY_FLAG = String.format("\\{primaryKey=(?<%s>.+?)\\}", new Object[]{MatcherGroups.PRIMARYKEY});
        public static final String FILTER_FLAG = String.format("\\{filter=(?<%s>.+?)\\}", new Object[]{MatcherGroups.FILTER});
        public static final String JUNCTION_FLAG = "\\{junction\\}";
        public static final String COLUMN = String.format("%s(?:%s%s)*", "[a-zA-Z_]{1}[a-zA-Z0-9_]*", ":", "[a-zA-Z_]{1}[a-zA-Z0-9_]*");
        public static final String JOIN = String.format("%s(?<%s>%s)%s(?<%s>%s)%s", new Object[]{Pattern.quote("["), MatcherGroups.SOURCEFIELD, "[a-zA-Z_]{1}[a-zA-Z0-9_]*", Pattern.quote("="), MatcherGroups.TARGETFIELD, "[a-zA-Z_]{1}[a-zA-Z0-9_]*", Pattern.quote("]")});
        public static final String JOIN_PLAIN = String.format("%s(?:%s)%s(?:%s)%s", Pattern.quote("["), "[a-zA-Z_]{1}[a-zA-Z0-9_]*", Pattern.quote("="), "[a-zA-Z_]{1}[a-zA-Z0-9_]*", Pattern.quote("]"));
        public static final String ROOT_TABLE = String.format("(?:%s)(?<%s>%s)(?<%s>%s)?", new Object[]{"/", MatcherGroups.TABLE, "[a-zA-Z_]{1}[a-zA-Z0-9_]*", MatcherGroups.FLAGS, "(?:\\{[a-z_]+.*?\\})*"});
        public static final String JOINED_TABLE = String.format("%s(?<%s>%s)(?<%s>%s)?", new Object[]{JOIN, MatcherGroups.TABLE, "[a-zA-Z_]{1}[a-zA-Z0-9_]*", MatcherGroups.FLAGS, "(?:\\{[a-z_]+.*?\\})*"});
        public static final String JOINED_TABLE_PLAIN = String.format("(?:%s)(?:%s)(?:%s)?", JOIN_PLAIN, "[a-zA-Z_]{1}[a-zA-Z0-9_]*", "(?:\\{[a-z_]+.*?\\})*");
        public static final String COLUMN_PATH = String.format("(?<%s>(?:%s%s)*)(?<%s>%s)(?<%s>%s)?", new Object[]{MatcherGroups.PATH, JOINED_TABLE_PLAIN, "/", MatcherGroups.COLUMNS, COLUMN, MatcherGroups.FLAGS, "(?:\\{[a-z_]+.*?\\})*"});
    }

    private static interface Tokens {
        public static final String PATH_SEPARATOR = "/";
        public static final String MULTI_COLUMN_SEPARATOR = ":";
        public static final String JOIN_START = "[";
        public static final String JOIN_SEPARATOR = "=";
        public static final String JOIN_END = "]";
    }

    private static enum MatcherGroups {
        PATH,
        TABLE,
        COLUMNS,
        SOURCEFIELD,
        TARGETFIELD,
        FLAGS,
        SORTKEY,
        PRIMARYKEY,
        FILTER;

    }
}

