/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.features.domain.Tuple;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.org.immutables.value.Value;

@Value.Immutable
public interface SqlPath {
    public String getName();

    public List<SqlPath> getParentTables();

    public Optional<Tuple<String, String>> getJoin();

    public List<String> getColumns();

    public String getSortKey();

    public String getPrimaryKey();

    public Optional<CqlFilter> getFilter();

    public Optional<String> getFilterString();

    public boolean getJunction();

    @Value.Derived
    default public boolean isRoot() {
        return this.getColumns().isEmpty() && !this.getJoin().isPresent();
    }

    @Value.Derived
    default public boolean isBranch() {
        return !this.isRoot() && !this.isLeaf();
    }

    @Value.Derived
    default public boolean isLeaf() {
        return !this.getColumns().isEmpty();
    }

    @Value.Derived
    default public boolean isJunction() {
        return this.getJunction();
    }

    @Value.Derived
    default public String asPath() {
        return this.isBranch() ? String.format("[%s=%s]%s%s", this.getJoin().get().first(), this.getJoin().get().second(), this.getName(), this.getFilterString().map(filterString -> "{filter=" + filterString + "}").orElse("")) : this.getName() + this.getFilterString().map(filterString -> "{filter=" + filterString + "}").orElse("");
    }

    @Value.Derived
    default public List<String> getParentPath() {
        return this.getParentTables().stream().map(SqlPath::asPath).collect(Collectors.toList());
    }

    @Value.Derived
    default public List<String> getFullPath() {
        return Stream.concat(this.getParentPath().stream(), Stream.of(this.asPath())).collect(Collectors.toList());
    }
}

