/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.cql.domain.TemporalOperation;
import de.ii.xtraplatform.cql.domain.TemporalOperator;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.features.sql.domain.SqlDialect;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.org.threeten.extra.Interval;

public class SqlDialectPostGis
implements SqlDialect {
    private static final Splitter BBOX_SPLITTER = Splitter.onPattern("[(), ]").omitEmptyStrings().trimResults();
    public static final Map<TemporalOperator, String> TEMPORAL_OPERATORS = new ImmutableMap.Builder<TemporalOperator, String>().put(TemporalOperator.T_INTERSECTS, "OVERLAPS").build();

    @Override
    public String applyToWkt(String column, boolean forcePolygonCCW) {
        if (!forcePolygonCCW) {
            return String.format("ST_AsText(%s)", column);
        }
        return String.format("ST_AsText(ST_ForcePolygonCCW(%s))", column);
    }

    @Override
    public String applyToExtent(String column) {
        return String.format("ST_Extent(%s)", column);
    }

    @Override
    public Optional<BoundingBox> parseExtent(String extent, EpsgCrs crs) {
        List<String> bbox = BBOX_SPLITTER.splitToList(extent);
        if (bbox.size() > 4) {
            return Optional.of(BoundingBox.of(Double.parseDouble(bbox.get(1)), Double.parseDouble(bbox.get(2)), Double.parseDouble(bbox.get(3)), Double.parseDouble(bbox.get(4)), crs));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Interval> parseTemporalExtent(String start, String end) {
        if (Objects.isNull(start)) {
            return Optional.empty();
        }
        DateTimeFormatter parser = DateTimeFormatter.ofPattern("yyyy-MM-dd[['T'][' ']HH:mm:ss][.SSS][X]").withZone(ZoneOffset.UTC);
        Instant parsedStart = parser.parse((CharSequence)start, Instant::from);
        if (Objects.isNull(end)) {
            return Optional.of(Interval.of(parsedStart, Instant.MAX));
        }
        Instant parsedEnd = parser.parse((CharSequence)end, Instant::from);
        return Optional.of(Interval.of(parsedStart, parsedEnd));
    }

    @Override
    public String getTemporalOperator(TemporalOperation temporalOperation) {
        return TEMPORAL_OPERATORS.get(temporalOperation.getOperator());
    }

    @Override
    public Set<TemporalOperator> getTemporalOperators() {
        return TEMPORAL_OPERATORS.keySet();
    }

    @Override
    public String applyToDate(String column) {
        return String.format("%s::date", column);
    }

    @Override
    public String applyToDatetime(String column) {
        return String.format("%s::timestamp(0)", column);
    }

    @Override
    public String applyToDateLiteral(String date) {
        return String.format("DATE '%s'", date);
    }

    @Override
    public String applyToDatetimeLiteral(String datetime) {
        return String.format("TIMESTAMP '%s'", datetime);
    }

    @Override
    public String applyToInstantMin() {
        return "-infinity";
    }

    @Override
    public String applyToInstantMax() {
        return "infinity";
    }

    @Override
    public String escapeString(String value) {
        return value.replaceAll("'", "''");
    }

    @Override
    public String geometryInfoQuery(Map<String, String> dbInfo) {
        return String.format("SELECT f_table_schema AS \"%s\", f_table_name AS \"%s\", f_geometry_column AS \"%s\", coord_dimension AS \"%s\", srid AS \"%s\", type AS \"%s\" FROM geometry_columns;", "schema", "table", "column", "dimension", "srid", "type");
    }

    @Override
    public List<String> getSystemTables() {
        return ImmutableList.of("spatial_ref_sys", "geography_columns", "geometry_columns", "raster_columns", "raster_overviews");
    }
}

