/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.cql.domain.SpatialOperation;
import de.ii.xtraplatform.cql.domain.SpatialOperator;
import de.ii.xtraplatform.cql.domain.TemporalOperation;
import de.ii.xtraplatform.cql.domain.TemporalOperator;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.ImmutableSet;
import shadow.org.threeten.extra.Interval;

public interface SqlDialect {
    public static final Map<SpatialOperator, String> SPATIAL_OPERATORS = new ImmutableMap.Builder<SpatialOperator, String>().put(SpatialOperator.S_EQUALS, "ST_Equals").put(SpatialOperator.S_DISJOINT, "ST_Disjoint").put(SpatialOperator.S_TOUCHES, "ST_Touches").put(SpatialOperator.S_WITHIN, "ST_Within").put(SpatialOperator.S_OVERLAPS, "ST_Overlaps").put(SpatialOperator.S_CROSSES, "ST_Crosses").put(SpatialOperator.S_INTERSECTS, "ST_Intersects").put(SpatialOperator.S_CONTAINS, "ST_Contains").build();

    public String applyToWkt(String var1, boolean var2);

    public String applyToExtent(String var1);

    public String applyToDate(String var1);

    public String applyToDatetime(String var1);

    public String applyToDateLiteral(String var1);

    public String applyToDatetimeLiteral(String var1);

    public String applyToInstantMin();

    public String applyToInstantMax();

    public Optional<BoundingBox> parseExtent(String var1, EpsgCrs var2);

    public Optional<Interval> parseTemporalExtent(String var1, String var2);

    public String escapeString(String var1);

    public String geometryInfoQuery(Map<String, String> var1);

    public List<String> getSystemTables();

    default public String getSpatialOperator(SpatialOperation spatialOperation) {
        return SPATIAL_OPERATORS.get(spatialOperation.getOperator());
    }

    default public String getTemporalOperator(TemporalOperation temporalOperation) {
        return null;
    }

    default public Set<TemporalOperator> getTemporalOperators() {
        return ImmutableSet.of();
    }

    public static interface GeoInfo {
        public static final String SCHEMA = "schema";
        public static final String TABLE = "table";
        public static final String COLUMN = "column";
        public static final String DIMENSION = "dimension";
        public static final String SRID = "srid";
        public static final String TYPE = "type";
    }
}

