/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.features.domain.FeatureProviderConnector;
import de.ii.xtraplatform.features.domain.FeatureStoreAttributesContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreInstanceContainer;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlQueryOptions;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlRowMeta;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlClient;
import de.ii.xtraplatform.features.sql.domain.SqlQueries;
import de.ii.xtraplatform.features.sql.domain.SqlQueryOptions;
import de.ii.xtraplatform.features.sql.domain.SqlRow;
import de.ii.xtraplatform.features.sql.domain.SqlRowMeta;
import de.ii.xtraplatform.streams.domain.Reactive;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import shadow.org.postgresql.util.PSQLException;
import shadow.org.postgresql.util.PSQLState;

public interface SqlConnector
extends FeatureProviderConnector<SqlRow, SqlQueries, SqlQueryOptions> {
    public static final SqlQueryOptions NO_OPTIONS = SqlQueryOptions.withColumnTypes(String.class);
    public static final Function<Throwable, Throwable> PSQL_CONTEXT = throwable -> {
        if (throwable instanceof PSQLException) {
            PSQLException e = (PSQLException)throwable;
            String message = Optional.ofNullable(e.getServerErrorMessage()).map(serverErrorMessage -> {
                StringBuilder totalMessage = new StringBuilder("\n  ");
                String msg = serverErrorMessage.getSeverity();
                if (msg != null) {
                    totalMessage.append(msg).append(": ");
                }
                if ((msg = serverErrorMessage.getMessage()) != null) {
                    totalMessage.append(msg);
                }
                if ((msg = serverErrorMessage.getDetail()) != null) {
                    totalMessage.append("\n  ").append("Detail: ").append(msg);
                }
                if ((msg = serverErrorMessage.getHint()) != null) {
                    totalMessage.append("\n  ").append("Hint: ").append(msg);
                }
                if (!(msg = String.valueOf(serverErrorMessage.getPosition())).equals("0")) {
                    totalMessage.append("\n  ").append("Position: ").append(msg);
                }
                if ((msg = serverErrorMessage.getWhere()) != null) {
                    totalMessage.append("\n  ").append("Where: ").append(msg);
                }
                return totalMessage.toString();
            }).orElseGet(e::getMessage);
            return new PSQLException("Unexpected SQL query error: " + message, PSQLState.UNKNOWN_STATE);
        }
        return throwable;
    };

    public int getMaxConnections();

    public int getMinConnections();

    public int getQueueSize();

    public SqlClient getSqlClient();

    @Override
    default public Reactive.Source<SqlRow> getSourceStream(SqlQueries query) {
        return this.getSourceStream(query, NO_OPTIONS);
    }

    @Override
    default public Reactive.Source<SqlRow> getSourceStream(SqlQueries query, SqlQueryOptions options) {
        Optional<String> metaQuery = query.getMetaQuery();
        Reactive.Source<SqlRowMeta> metaResult1 = this.getMetaResult(metaQuery, options);
        FeatureStoreInstanceContainer mainTable = query.getInstanceContainers().get(0);
        List<FeatureStoreAttributesContainer> attributesContainers = mainTable.getAllAttributesContainers();
        List<SchemaSql> tableSchemas = query.getTableSchemas();
        Reactive.Source sqlRowSource = metaResult1.via(Reactive.Transformer.flatMap(metaResult -> {
            int[] i = new int[]{0};
            Reactive.Source[] sqlRows = (Reactive.Source[])query.getValueQueries().apply((SqlRowMeta)metaResult).map(valueQuery -> {
                int n = i[0];
                i[0] = n + 1;
                return this.getSqlClient().getSourceStream((String)valueQuery, new ImmutableSqlQueryOptions.Builder().from(options).tableSchema((SchemaSql)tableSchemas.get(i[0])).containerPriority(n).build());
            }).toArray(Reactive.Source[]::new);
            return SqlConnector.mergeAndSort(sqlRows).prepend(Reactive.Source.single(metaResult));
        }));
        return sqlRowSource.mapError(PSQL_CONTEXT);
    }

    default public Reactive.Source<SqlRowMeta> getMetaResult(Optional<String> metaQuery, SqlQueryOptions options) {
        if (!metaQuery.isPresent()) {
            return Reactive.Source.single(this.getMetaQueryResult(0L, 0L, 0L, 0L).build());
        }
        List<Class<?>> columnTypes = Stream.concat(IntStream.range(0, 2 + options.getCustomSortKeys().size() * 2).mapToObj(i -> Object.class), Stream.of(Long.class, Long.class)).collect(Collectors.toList());
        return this.getSqlClient().getSourceStream(metaQuery.get(), SqlQueryOptions.withColumnTypes(columnTypes)).via(Reactive.Transformer.map(sqlRow -> this.getMetaQueryResult(sqlRow.getValues())));
    }

    default public ImmutableSqlRowMeta.Builder getMetaQueryResult(Object minKey, Object maxKey, Long numberReturned, Long numberMatched) {
        return new ImmutableSqlRowMeta.Builder().minKey(minKey).maxKey(maxKey).numberReturned(Objects.nonNull(numberReturned) ? numberReturned : 0L).numberMatched(Objects.nonNull(numberMatched) && numberMatched > -1L ? OptionalLong.of(numberMatched) : OptionalLong.empty());
    }

    default public SqlRowMeta getMetaQueryResult(List<Object> values) {
        int size = values.size();
        ImmutableSqlRowMeta.Builder builder = this.getMetaQueryResult(values.get(size - 4), values.get(size - 3), (Long)values.get(size - 2), (Long)values.get(size - 1));
        for (int i = 0; i < size - 4; i += 2) {
            builder.addCustomMinKeys(values.get(i)).addCustomMaxKeys(values.get(i + 1));
        }
        return builder.build();
    }

    public static <T extends Comparable<T>> Reactive.Source<T> mergeAndSort(Reactive.Source<T> ... sources) {
        if (sources.length == 1) {
            return sources[0];
        }
        return SqlConnector.mergeAndSort(sources[0], sources[1], Arrays.asList(sources).subList(2, sources.length));
    }

    public static <T extends Comparable<T>> Reactive.Source<T> mergeAndSort(Reactive.Source<T> source1, Reactive.Source<T> source2, Iterable<Reactive.Source<T>> rest) {
        Comparator comparator = Comparator.naturalOrder();
        Reactive.Source<T> mergedAndSorted = source1.mergeSorted(source2, comparator);
        for (Reactive.Source<T> source3 : rest) {
            mergedAndSorted = mergedAndSorted.mergeSorted(source3, comparator);
        }
        return mergedAndSorted;
    }
}

