/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.sql.domain.ImmutableSchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.google.common.collect.ImmutableList;
import shadow.org.immutables.value.Value;

@Value.Immutable
@Value.Style(deepImmutablesDetection=true, builder="new", attributeBuilderDetection=true)
public interface SchemaSql
extends SchemaBase<SchemaSql> {
    public List<SqlRelation> getRelation();

    public Optional<String> getPrimaryKey();

    public Optional<String> getSortKey();

    public List<String> getParentSortKeys();

    public Optional<CqlFilter> getFilter();

    public Optional<String> getFilterString();

    public Optional<String> getConstantValue();

    @Value.Derived
    default public boolean isConstant() {
        return this.getConstantValue().isPresent();
    }

    @Override
    @Value.Auxiliary
    @Value.Derived
    default public List<String> getPath() {
        return this.getRelation().isEmpty() ? ImmutableList.of(this.getName() + this.getFilterString().map(filter -> "{filter=" + filter + "}").orElse("")) : this.getRelation().stream().flatMap(relation -> relation.asPath().stream()).collect(Collectors.toList());
    }

    @Value.Derived
    @Value.Auxiliary
    default public List<List<String>> getColumnPaths() {
        return this.getProperties().stream().filter(SchemaBase::isValue).map(SchemaBase::getFullPath).collect(ImmutableList.toImmutableList());
    }

    @Value.Derived
    @Value.Auxiliary
    default public List<String> getSortKeys() {
        ImmutableList.Builder keys = ImmutableList.builder();
        keys.addAll(this.getParentSortKeys());
        SqlRelation previousRelation = null;
        for (int i = 0; i < this.getRelation().size(); ++i) {
            SqlRelation relation = this.getRelation().get(i);
            if (relation.getSourceSortKey().isPresent() && i > 0 && (previousRelation.isM2N() || previousRelation.isOne2N())) {
                keys.add(String.format("%s.%s", relation.getSourceContainer(), relation.getSourceSortKey().get()));
            }
            previousRelation = relation;
        }
        if (this.getSortKey().isPresent()) {
            keys.add(String.format("%s.%s", this.getName(), this.getSortKey().get()));
        }
        return keys.build();
    }

    default public List<String> getSortKeys(ListIterator<String> aliasesIterator, boolean onlyRelations, int keyIndexStart) {
        ImmutableList.Builder keys = ImmutableList.builder();
        int keyIndex = keyIndexStart;
        SqlRelation previousRelation = null;
        for (int i = 0; i < this.getRelation().size(); ++i) {
            SqlRelation relation = this.getRelation().get(i);
            String alias = aliasesIterator.next();
            if (relation.isM2N()) {
                aliasesIterator.next();
            }
            if (relation.getSourceSortKey().isPresent() && (i == 0 || previousRelation.isM2N() || previousRelation.isOne2N())) {
                Object suffix = keyIndex > 0 ? "_" + keyIndex : "";
                keys.add(String.format("%s.%s AS SKEY%s", alias, relation.getSourceSortKey().get(), suffix));
                ++keyIndex;
            }
            previousRelation = relation;
        }
        if (!onlyRelations) {
            keys.add(String.format("%s.%s AS SKEY_%d", aliasesIterator.next(), this.getSortKey().get(), keyIndex));
        }
        return keys.build();
    }

    @Override
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public List<SchemaSql> getAllNestedProperties() {
        return this.getProperties().stream().flatMap(t -> {
            SchemaSql current = this.isObject() && t.isObject() ? new ImmutableSchemaSql.Builder().from((SchemaSql)t).relation(this.getRelation()).addAllRelation(t.getRelation()).build() : t;
            return Stream.concat(Stream.of(current), current.getAllNestedProperties().stream());
        }).collect(Collectors.toList());
    }
}

