/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.features.domain.ImmutableSortKey;
import de.ii.xtraplatform.features.domain.SortKey;
import de.ii.xtraplatform.features.sql.domain.ImmutableSchemaSql;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlQueryOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SqlQueryOptions", generator="Immutables")
@Immutable
public final class ImmutableSqlQueryOptions
implements SqlQueryOptions {
    @Nullable
    private final SchemaSql tableSchema;
    private final ImmutableList<SortKey> customSortKeys;
    private final ImmutableList<Class<?>> customColumnTypes;
    private final int containerPriority;
    private final int chunkSize;
    private final transient List<String> sortKeys;
    private final transient List<SortKey.Direction> sortDirections;
    private final transient List<Class<?>> columnTypes;
    private final transient boolean isPlain;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSqlQueryOptions(Builder builder) {
        this.tableSchema = ImmutableSqlQueryOptions.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSchemaSql(builder.tableSchema);
        this.customSortKeys = ImmutableList.copyOf(ImmutableSqlQueryOptions.convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(builder.customSortKeys.build()));
        this.customColumnTypes = builder.customColumnTypes.build();
        if (builder.containerPriorityIsSet()) {
            this.initShim.containerPriority(builder.containerPriority);
        }
        if (builder.chunkSizeIsSet()) {
            this.initShim.chunkSize(builder.chunkSize);
        }
        this.containerPriority = this.initShim.getContainerPriority();
        this.chunkSize = this.initShim.getChunkSize();
        this.sortKeys = this.initShim.getSortKeys();
        this.sortDirections = this.initShim.getSortDirections();
        this.columnTypes = this.initShim.getColumnTypes();
        this.isPlain = this.initShim.isPlain();
        this.initShim = null;
    }

    private ImmutableSqlQueryOptions(@Nullable SchemaSql tableSchema, ImmutableList<SortKey> customSortKeys, ImmutableList<Class<?>> customColumnTypes, int containerPriority, int chunkSize) {
        this.tableSchema = tableSchema;
        this.customSortKeys = customSortKeys;
        this.customColumnTypes = customColumnTypes;
        this.initShim.containerPriority(containerPriority);
        this.initShim.chunkSize(chunkSize);
        this.containerPriority = this.initShim.getContainerPriority();
        this.chunkSize = this.initShim.getChunkSize();
        this.sortKeys = this.initShim.getSortKeys();
        this.sortDirections = this.initShim.getSortDirections();
        this.columnTypes = this.initShim.getColumnTypes();
        this.isPlain = this.initShim.isPlain();
        this.initShim = null;
    }

    private int getContainerPriorityInitialize() {
        return SqlQueryOptions.super.getContainerPriority();
    }

    private int getChunkSizeInitialize() {
        return SqlQueryOptions.super.getChunkSize();
    }

    private List<String> getSortKeysInitialize() {
        return SqlQueryOptions.super.getSortKeys();
    }

    private List<SortKey.Direction> getSortDirectionsInitialize() {
        return SqlQueryOptions.super.getSortDirections();
    }

    private List<Class<?>> getColumnTypesInitialize() {
        return SqlQueryOptions.super.getColumnTypes();
    }

    private boolean isPlainInitialize() {
        return SqlQueryOptions.super.isPlain();
    }

    @Override
    public Optional<SchemaSql> getTableSchema() {
        return Optional.ofNullable(this.tableSchema);
    }

    public ImmutableList<SortKey> getCustomSortKeys() {
        return this.customSortKeys;
    }

    public ImmutableList<Class<?>> getCustomColumnTypes() {
        return this.customColumnTypes;
    }

    @Override
    public int getContainerPriority() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getContainerPriority() : this.containerPriority;
    }

    @Override
    public int getChunkSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getChunkSize() : this.chunkSize;
    }

    @Override
    public List<String> getSortKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSortKeys() : this.sortKeys;
    }

    @Override
    public List<SortKey.Direction> getSortDirections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSortDirections() : this.sortDirections;
    }

    @Override
    public List<Class<?>> getColumnTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getColumnTypes() : this.columnTypes;
    }

    @Override
    public boolean isPlain() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPlain() : this.isPlain;
    }

    public final ImmutableSqlQueryOptions withTableSchema(SchemaSql value) {
        SchemaSql newValue = Objects.requireNonNull(value, "tableSchema");
        if (this.tableSchema == newValue) {
            return this;
        }
        return new ImmutableSqlQueryOptions(newValue, this.customSortKeys, this.customColumnTypes, this.containerPriority, this.chunkSize);
    }

    public final ImmutableSqlQueryOptions withTableSchema(Optional<? extends SchemaSql> optional) {
        SchemaSql value = optional.orElse(null);
        if (this.tableSchema == value) {
            return this;
        }
        return new ImmutableSqlQueryOptions(value, this.customSortKeys, this.customColumnTypes, this.containerPriority, this.chunkSize);
    }

    public final ImmutableSqlQueryOptions withCustomSortKeys(SortKey ... elements) {
        ImmutableList<SortKey> newValue = ImmutableList.copyOf(elements);
        return new ImmutableSqlQueryOptions(this.tableSchema, newValue, this.customColumnTypes, this.containerPriority, this.chunkSize);
    }

    public final ImmutableSqlQueryOptions withCustomSortKeys(Iterable<? extends SortKey> elements) {
        if (this.customSortKeys == elements) {
            return this;
        }
        ImmutableList<SortKey> newValue = ImmutableList.copyOf(elements);
        return new ImmutableSqlQueryOptions(this.tableSchema, newValue, this.customColumnTypes, this.containerPriority, this.chunkSize);
    }

    @SafeVarargs
    public final ImmutableSqlQueryOptions withCustomColumnTypes(Class<?> ... elements) {
        ImmutableList<Class<?>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableSqlQueryOptions(this.tableSchema, this.customSortKeys, newValue, this.containerPriority, this.chunkSize);
    }

    public final ImmutableSqlQueryOptions withCustomColumnTypes(Iterable<? extends Class<?>> elements) {
        if (this.customColumnTypes == elements) {
            return this;
        }
        ImmutableList<Class<?>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableSqlQueryOptions(this.tableSchema, this.customSortKeys, newValue, this.containerPriority, this.chunkSize);
    }

    public final ImmutableSqlQueryOptions withContainerPriority(int value) {
        if (this.containerPriority == value) {
            return this;
        }
        return new ImmutableSqlQueryOptions(this.tableSchema, this.customSortKeys, this.customColumnTypes, value, this.chunkSize);
    }

    public final ImmutableSqlQueryOptions withChunkSize(int value) {
        if (this.chunkSize == value) {
            return this;
        }
        return new ImmutableSqlQueryOptions(this.tableSchema, this.customSortKeys, this.customColumnTypes, this.containerPriority, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlQueryOptions && this.equalTo((ImmutableSqlQueryOptions)another);
    }

    private boolean equalTo(ImmutableSqlQueryOptions another) {
        return Objects.equals(this.tableSchema, another.tableSchema) && this.customSortKeys.equals(another.customSortKeys) && this.customColumnTypes.equals(another.customColumnTypes) && this.containerPriority == another.containerPriority && this.chunkSize == another.chunkSize && this.sortKeys.equals(another.sortKeys) && this.sortDirections.equals(another.sortDirections) && this.columnTypes.equals(another.columnTypes) && this.isPlain == another.isPlain;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tableSchema);
        h += (h << 5) + this.customSortKeys.hashCode();
        h += (h << 5) + this.customColumnTypes.hashCode();
        h += (h << 5) + this.containerPriority;
        h += (h << 5) + this.chunkSize;
        h += (h << 5) + this.sortKeys.hashCode();
        h += (h << 5) + this.sortDirections.hashCode();
        h += (h << 5) + this.columnTypes.hashCode();
        h += (h << 5) + Booleans.hashCode(this.isPlain);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SqlQueryOptions").omitNullValues().add("tableSchema", this.tableSchema).add("customSortKeys", this.customSortKeys).add("customColumnTypes", this.customColumnTypes).add("containerPriority", this.containerPriority).add("chunkSize", this.chunkSize).add("sortKeys", this.sortKeys).add("sortDirections", this.sortDirections).add("columnTypes", this.columnTypes).add("isPlain", this.isPlain).toString();
    }

    public static ImmutableSqlQueryOptions copyOf(SqlQueryOptions instance) {
        if (instance instanceof ImmutableSqlQueryOptions) {
            return (ImmutableSqlQueryOptions)instance;
        }
        return new Builder().from(instance).build();
    }

    @Nullable
    private static ImmutableSchemaSql convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSchemaSql(@Nullable ImmutableSchemaSql.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static SchemaSql convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSchemaSql(@Nullable SchemaSql value) {
        if (value == null) {
            return null;
        }
        return new ImmutableSchemaSql.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableSchemaSql.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableSchemaSql(@Nullable SchemaSql value) {
        if (value == null) {
            return null;
        }
        return new ImmutableSchemaSql.Builder().from(value);
    }

    @Nullable
    private static ImmutableSortKey convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(@Nullable ImmutableSortKey.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static SortKey convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(@Nullable SortKey value) {
        if (value == null) {
            return null;
        }
        return ImmutableSortKey.builder().from(value).build();
    }

    @Nullable
    private static ImmutableSortKey.Builder convertToBuilderTypede_ii_xtraplatform_features_domain_ImmutableSortKey(@Nullable SortKey value) {
        if (value == null) {
            return null;
        }
        return ImmutableSortKey.builder().from(value);
    }

    private static List<SortKey> convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(Iterable<? extends ImmutableSortKey.Builder> builderList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableSortKey.Builder builder : builderList) {
            list.add(builder.build());
        }
        return list.build();
    }

    private static List<SortKey> convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(ImmutableSortKey.Builder ... builderArray) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableSortKey.Builder element : builderArray) {
            list.add(element.build());
        }
        return list.build();
    }

    private static List<ImmutableSortKey.Builder> convertToBuilderTypede_ii_xtraplatform_features_domain_ImmutableSortKey(Iterable<? extends ImmutableSortKey> valueList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableSortKey immutableSortKey : valueList) {
            list.add(ImmutableSortKey.builder().from(immutableSortKey));
        }
        return list.build();
    }

    private static List<ImmutableSortKey.Builder> convertToBuilderTypede_ii_xtraplatform_features_domain_ImmutableSortKey(ImmutableSortKey ... valueArray) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (ImmutableSortKey element : valueArray) {
            list.add(ImmutableSortKey.builder().from(element));
        }
        return list.build();
    }

    @Generated(from="SqlQueryOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_CONTAINER_PRIORITY = 1L;
        private static final long OPT_BIT_CHUNK_SIZE = 2L;
        private long optBits;
        @Nullable
        private ImmutableSchemaSql.Builder tableSchema;
        private ImmutableList.Builder<ImmutableSortKey.Builder> customSortKeys = ImmutableList.builder();
        private ImmutableList.Builder<Class<?>> customColumnTypes = ImmutableList.builder();
        private int containerPriority;
        private int chunkSize;

        @CanIgnoreReturnValue
        public final Builder from(SqlQueryOptions instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<SchemaSql> tableSchemaOptional = instance.getTableSchema();
            if (tableSchemaOptional.isPresent()) {
                this.tableSchema(tableSchemaOptional);
            }
            this.addAllCustomSortKeys(instance.getCustomSortKeys());
            this.addAllCustomColumnTypes(instance.getCustomColumnTypes());
            this.containerPriority(instance.getContainerPriority());
            this.chunkSize(instance.getChunkSize());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tableSchema(SchemaSql tableSchema) {
            this.tableSchema = new ImmutableSchemaSql.Builder().from(Objects.requireNonNull(tableSchema, "tableSchema"));
            return this;
        }

        public final ImmutableSchemaSql.Builder tableSchemaBuilder() {
            if (this.tableSchema == null) {
                this.tableSchema = new ImmutableSchemaSql.Builder();
            }
            return this.tableSchema;
        }

        @CanIgnoreReturnValue
        public final Builder tableSchemaBuilder(ImmutableSchemaSql.Builder tableSchema) {
            this.tableSchema = tableSchema;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tableSchema(Optional<? extends SchemaSql> tableSchema) {
            this.tableSchema = Builder.convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableSchemaSql(tableSchema.orElse(null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCustomSortKeys(SortKey element) {
            element = Builder.convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(element);
            this.customSortKeys.add((Object)ImmutableSortKey.builder().from(element));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCustomSortKeys(SortKey ... elements) {
            for (SortKey element : elements) {
                element = Builder.convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(element);
                this.customSortKeys.add((Object)ImmutableSortKey.builder().from(Objects.requireNonNull(element, "customSortKeys element")));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final ImmutableSortKey.Builder addCustomSortKeysBuilder() {
            ImmutableSortKey.Builder builder = ImmutableSortKey.builder();
            this.customSortKeys.add((Object)builder);
            return builder;
        }

        @CanIgnoreReturnValue
        public final Builder addAllCustomSortKeysBuilders(ImmutableSortKey.Builder ... elements) {
            for (ImmutableSortKey.Builder element : elements) {
                this.customSortKeys.add((Object)Objects.requireNonNull(element, "customSortKeys element"));
            }
            return this;
        }

        public final List<ImmutableSortKey.Builder> customSortKeysBuilders() {
            return this.customSortKeys.build();
        }

        @CanIgnoreReturnValue
        public final Builder customSortKeys(Iterable<? extends SortKey> elements) {
            this.customSortKeys = ImmutableList.builder();
            return this.addAllCustomSortKeys(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCustomSortKeys(Iterable<? extends SortKey> elements) {
            for (SortKey sortKey : elements) {
                SortKey sortKey2 = Builder.convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(sortKey);
                this.customSortKeys.add((Object)ImmutableSortKey.builder().from(Objects.requireNonNull(sortKey2, "customSortKeys element")));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllCustomSortKeysBuilders(Iterable<ImmutableSortKey.Builder> elements) {
            for (ImmutableSortKey.Builder element : elements) {
                this.customSortKeys.add((Object)Objects.requireNonNull(element, "customSortKeys element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCustomColumnTypes(Class<?> element) {
            this.customColumnTypes.add((Object)element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addCustomColumnTypes(Class<?> ... elements) {
            this.customColumnTypes.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customColumnTypes(Iterable<? extends Class<?>> elements) {
            this.customColumnTypes = ImmutableList.builder();
            return this.addAllCustomColumnTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCustomColumnTypes(Iterable<? extends Class<?>> elements) {
            this.customColumnTypes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder containerPriority(int containerPriority) {
            this.containerPriority = containerPriority;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableSqlQueryOptions build() {
            return new ImmutableSqlQueryOptions(this);
        }

        private boolean containerPriorityIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean chunkSizeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        @Nullable
        private static ImmutableSchemaSql convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSchemaSql(@Nullable ImmutableSchemaSql.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static SchemaSql convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSchemaSql(@Nullable SchemaSql value) {
            if (value == null) {
                return null;
            }
            return new ImmutableSchemaSql.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableSchemaSql.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableSchemaSql(@Nullable SchemaSql value) {
            if (value == null) {
                return null;
            }
            return new ImmutableSchemaSql.Builder().from(value);
        }

        @Nullable
        private static ImmutableSortKey convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(@Nullable ImmutableSortKey.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static SortKey convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(@Nullable SortKey value) {
            if (value == null) {
                return null;
            }
            return ImmutableSortKey.builder().from(value).build();
        }

        @Nullable
        private static ImmutableSortKey.Builder convertToBuilderTypede_ii_xtraplatform_features_domain_ImmutableSortKey(@Nullable SortKey value) {
            if (value == null) {
                return null;
            }
            return ImmutableSortKey.builder().from(value);
        }

        private static List<SortKey> convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(Iterable<? extends ImmutableSortKey.Builder> builderList) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableSortKey.Builder builder : builderList) {
                list.add(builder.build());
            }
            return list.build();
        }

        private static List<SortKey> convertToValueTypede_ii_xtraplatform_features_domain_ImmutableSortKey(ImmutableSortKey.Builder ... builderArray) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableSortKey.Builder element : builderArray) {
                list.add(element.build());
            }
            return list.build();
        }

        private static List<ImmutableSortKey.Builder> convertToBuilderTypede_ii_xtraplatform_features_domain_ImmutableSortKey(Iterable<? extends ImmutableSortKey> valueList) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableSortKey immutableSortKey : valueList) {
                list.add(ImmutableSortKey.builder().from(immutableSortKey));
            }
            return list.build();
        }

        private static List<ImmutableSortKey.Builder> convertToBuilderTypede_ii_xtraplatform_features_domain_ImmutableSortKey(ImmutableSortKey ... valueArray) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (ImmutableSortKey element : valueArray) {
                list.add(ImmutableSortKey.builder().from(element));
            }
            return list.build();
        }
    }

    @Generated(from="SqlQueryOptions", generator="Immutables")
    private final class InitShim {
        private byte containerPriorityBuildStage = 0;
        private int containerPriority;
        private byte chunkSizeBuildStage = 0;
        private int chunkSize;
        private byte sortKeysBuildStage = 0;
        private List<String> sortKeys;
        private byte sortDirectionsBuildStage = 0;
        private List<SortKey.Direction> sortDirections;
        private byte columnTypesBuildStage = 0;
        private List<Class<?>> columnTypes;
        private byte isPlainBuildStage = 0;
        private boolean isPlain;

        private InitShim() {
        }

        int getContainerPriority() {
            if (this.containerPriorityBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.containerPriorityBuildStage == 0) {
                this.containerPriorityBuildStage = (byte)-1;
                this.containerPriority = ImmutableSqlQueryOptions.this.getContainerPriorityInitialize();
                this.containerPriorityBuildStage = 1;
            }
            return this.containerPriority;
        }

        void containerPriority(int containerPriority) {
            this.containerPriority = containerPriority;
            this.containerPriorityBuildStage = 1;
        }

        int getChunkSize() {
            if (this.chunkSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.chunkSizeBuildStage == 0) {
                this.chunkSizeBuildStage = (byte)-1;
                this.chunkSize = ImmutableSqlQueryOptions.this.getChunkSizeInitialize();
                this.chunkSizeBuildStage = 1;
            }
            return this.chunkSize;
        }

        void chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            this.chunkSizeBuildStage = 1;
        }

        List<String> getSortKeys() {
            if (this.sortKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sortKeysBuildStage == 0) {
                this.sortKeysBuildStage = (byte)-1;
                this.sortKeys = Objects.requireNonNull(ImmutableSqlQueryOptions.this.getSortKeysInitialize(), "sortKeys");
                this.sortKeysBuildStage = 1;
            }
            return this.sortKeys;
        }

        List<SortKey.Direction> getSortDirections() {
            if (this.sortDirectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sortDirectionsBuildStage == 0) {
                this.sortDirectionsBuildStage = (byte)-1;
                this.sortDirections = Objects.requireNonNull(ImmutableSqlQueryOptions.this.getSortDirectionsInitialize(), "sortDirections");
                this.sortDirectionsBuildStage = 1;
            }
            return this.sortDirections;
        }

        List<Class<?>> getColumnTypes() {
            if (this.columnTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.columnTypesBuildStage == 0) {
                this.columnTypesBuildStage = (byte)-1;
                this.columnTypes = Objects.requireNonNull(ImmutableSqlQueryOptions.this.getColumnTypesInitialize(), "columnTypes");
                this.columnTypesBuildStage = 1;
            }
            return this.columnTypes;
        }

        boolean isPlain() {
            if (this.isPlainBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPlainBuildStage == 0) {
                this.isPlainBuildStage = (byte)-1;
                this.isPlain = ImmutableSqlQueryOptions.this.isPlainInitialize();
                this.isPlainBuildStage = 1;
            }
            return this.isPlain;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.containerPriorityBuildStage == -1) {
                attributes.add("containerPriority");
            }
            if (this.chunkSizeBuildStage == -1) {
                attributes.add("chunkSize");
            }
            if (this.sortKeysBuildStage == -1) {
                attributes.add("sortKeys");
            }
            if (this.sortDirectionsBuildStage == -1) {
                attributes.add("sortDirections");
            }
            if (this.columnTypesBuildStage == -1) {
                attributes.add("columnTypes");
            }
            if (this.isPlainBuildStage == -1) {
                attributes.add("isPlain");
            }
            return "Cannot build SqlQueryOptions, attribute initializers form cycle " + attributes;
        }
    }
}

