/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.features.sql.domain.ConnectionInfoSql;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConnectionInfoSql.PoolSettings", generator="Immutables")
@Immutable
public final class ImmutablePoolSettings
implements ConnectionInfoSql.PoolSettings {
    private final int maxConnections;
    private final int minConnections;
    private final boolean initFailFast;
    private final String initFailTimeout;
    private final String idleTimeout;
    private final boolean shared;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePoolSettings(Builder builder) {
        if (builder.maxConnectionsIsSet()) {
            this.initShim.maxConnections(builder.maxConnections);
        }
        if (builder.minConnectionsIsSet()) {
            this.initShim.minConnections(builder.minConnections);
        }
        if (builder.initFailFastIsSet()) {
            this.initShim.initFailFast(builder.initFailFast);
        }
        if (builder.initFailTimeout != null) {
            this.initShim.initFailTimeout(builder.initFailTimeout);
        }
        if (builder.idleTimeout != null) {
            this.initShim.idleTimeout(builder.idleTimeout);
        }
        if (builder.sharedIsSet()) {
            this.initShim.shared(builder.shared);
        }
        this.maxConnections = this.initShim.getMaxConnections();
        this.minConnections = this.initShim.getMinConnections();
        this.initFailFast = this.initShim.getInitFailFast();
        this.initFailTimeout = this.initShim.getInitFailTimeout();
        this.idleTimeout = this.initShim.getIdleTimeout();
        this.shared = this.initShim.getShared();
        this.initShim = null;
    }

    private ImmutablePoolSettings(int maxConnections, int minConnections, boolean initFailFast, String initFailTimeout, String idleTimeout, boolean shared) {
        this.maxConnections = maxConnections;
        this.minConnections = minConnections;
        this.initFailFast = initFailFast;
        this.initFailTimeout = initFailTimeout;
        this.idleTimeout = idleTimeout;
        this.shared = shared;
        this.initShim = null;
    }

    private int getMaxConnectionsInitialize() {
        return ConnectionInfoSql.PoolSettings.super.getMaxConnections();
    }

    private int getMinConnectionsInitialize() {
        return ConnectionInfoSql.PoolSettings.super.getMinConnections();
    }

    private boolean getInitFailFastInitialize() {
        return ConnectionInfoSql.PoolSettings.super.getInitFailFast();
    }

    private String getInitFailTimeoutInitialize() {
        return ConnectionInfoSql.PoolSettings.super.getInitFailTimeout();
    }

    private String getIdleTimeoutInitialize() {
        return ConnectionInfoSql.PoolSettings.super.getIdleTimeout();
    }

    private boolean getSharedInitialize() {
        return ConnectionInfoSql.PoolSettings.super.getShared();
    }

    @Override
    @JsonProperty(value="maxConnections")
    public int getMaxConnections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMaxConnections() : this.maxConnections;
    }

    @Override
    @JsonProperty(value="minConnections")
    public int getMinConnections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinConnections() : this.minConnections;
    }

    @Override
    @JsonProperty(value="initFailFast")
    @Deprecated
    public boolean getInitFailFast() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getInitFailFast() : this.initFailFast;
    }

    @Override
    @JsonProperty(value="initFailTimeout")
    public String getInitFailTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getInitFailTimeout() : this.initFailTimeout;
    }

    @Override
    @JsonProperty(value="idleTimeout")
    public String getIdleTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getIdleTimeout() : this.idleTimeout;
    }

    @Override
    @JsonProperty(value="shared")
    public boolean getShared() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getShared() : this.shared;
    }

    public final ImmutablePoolSettings withMaxConnections(int value) {
        if (this.maxConnections == value) {
            return this;
        }
        return new ImmutablePoolSettings(value, this.minConnections, this.initFailFast, this.initFailTimeout, this.idleTimeout, this.shared);
    }

    public final ImmutablePoolSettings withMinConnections(int value) {
        if (this.minConnections == value) {
            return this;
        }
        return new ImmutablePoolSettings(this.maxConnections, value, this.initFailFast, this.initFailTimeout, this.idleTimeout, this.shared);
    }

    @Deprecated
    public final ImmutablePoolSettings withInitFailFast(boolean value) {
        if (this.initFailFast == value) {
            return this;
        }
        return new ImmutablePoolSettings(this.maxConnections, this.minConnections, value, this.initFailTimeout, this.idleTimeout, this.shared);
    }

    public final ImmutablePoolSettings withInitFailTimeout(String value) {
        String newValue = Objects.requireNonNull(value, "initFailTimeout");
        if (this.initFailTimeout.equals(newValue)) {
            return this;
        }
        return new ImmutablePoolSettings(this.maxConnections, this.minConnections, this.initFailFast, newValue, this.idleTimeout, this.shared);
    }

    public final ImmutablePoolSettings withIdleTimeout(String value) {
        String newValue = Objects.requireNonNull(value, "idleTimeout");
        if (this.idleTimeout.equals(newValue)) {
            return this;
        }
        return new ImmutablePoolSettings(this.maxConnections, this.minConnections, this.initFailFast, this.initFailTimeout, newValue, this.shared);
    }

    public final ImmutablePoolSettings withShared(boolean value) {
        if (this.shared == value) {
            return this;
        }
        return new ImmutablePoolSettings(this.maxConnections, this.minConnections, this.initFailFast, this.initFailTimeout, this.idleTimeout, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePoolSettings && this.equalTo((ImmutablePoolSettings)another);
    }

    private boolean equalTo(ImmutablePoolSettings another) {
        return this.maxConnections == another.maxConnections && this.minConnections == another.minConnections && this.initFailFast == another.initFailFast && this.initFailTimeout.equals(another.initFailTimeout) && this.idleTimeout.equals(another.idleTimeout) && this.shared == another.shared;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.maxConnections;
        h += (h << 5) + this.minConnections;
        h += (h << 5) + Booleans.hashCode(this.initFailFast);
        h += (h << 5) + this.initFailTimeout.hashCode();
        h += (h << 5) + this.idleTimeout.hashCode();
        h += (h << 5) + Booleans.hashCode(this.shared);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PoolSettings").omitNullValues().add("maxConnections", this.maxConnections).add("minConnections", this.minConnections).add("initFailFast", this.initFailFast).add("initFailTimeout", this.initFailTimeout).add("idleTimeout", this.idleTimeout).add("shared", this.shared).toString();
    }

    public static ImmutablePoolSettings copyOf(ConnectionInfoSql.PoolSettings instance) {
        if (instance instanceof ImmutablePoolSettings) {
            return (ImmutablePoolSettings)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="ConnectionInfoSql.PoolSettings", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_MAX_CONNECTIONS = 1L;
        private static final long OPT_BIT_MIN_CONNECTIONS = 2L;
        private static final long OPT_BIT_INIT_FAIL_FAST = 4L;
        private static final long OPT_BIT_SHARED = 8L;
        private long optBits;
        private int maxConnections;
        private int minConnections;
        private boolean initFailFast;
        @Nullable
        private String initFailTimeout;
        @Nullable
        private String idleTimeout;
        private boolean shared;

        @CanIgnoreReturnValue
        public final Builder from(ConnectionInfoSql.PoolSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.maxConnections(instance.getMaxConnections());
            this.minConnections(instance.getMinConnections());
            this.initFailFast(instance.getInitFailFast());
            this.initFailTimeout(instance.getInitFailTimeout());
            this.idleTimeout(instance.getIdleTimeout());
            this.shared(instance.getShared());
            return this;
        }

        @JsonProperty(value="maxConnections")
        @CanIgnoreReturnValue
        public final Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="minConnections")
        @CanIgnoreReturnValue
        public final Builder minConnections(int minConnections) {
            this.minConnections = minConnections;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="initFailFast")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder initFailFast(boolean initFailFast) {
            this.initFailFast = initFailFast;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="initFailTimeout")
        @CanIgnoreReturnValue
        public final Builder initFailTimeout(String initFailTimeout) {
            this.initFailTimeout = Objects.requireNonNull(initFailTimeout, "initFailTimeout");
            return this;
        }

        @JsonProperty(value="idleTimeout")
        @CanIgnoreReturnValue
        public final Builder idleTimeout(String idleTimeout) {
            this.idleTimeout = Objects.requireNonNull(idleTimeout, "idleTimeout");
            return this;
        }

        @JsonProperty(value="shared")
        @CanIgnoreReturnValue
        public final Builder shared(boolean shared) {
            this.shared = shared;
            this.optBits |= 8L;
            return this;
        }

        public ImmutablePoolSettings build() {
            return new ImmutablePoolSettings(this);
        }

        private boolean maxConnectionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean minConnectionsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean initFailFastIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean sharedIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    @Generated(from="ConnectionInfoSql.PoolSettings", generator="Immutables")
    private final class InitShim {
        private byte maxConnectionsBuildStage = 0;
        private int maxConnections;
        private byte minConnectionsBuildStage = 0;
        private int minConnections;
        private byte initFailFastBuildStage = 0;
        private boolean initFailFast;
        private byte initFailTimeoutBuildStage = 0;
        private String initFailTimeout;
        private byte idleTimeoutBuildStage = 0;
        private String idleTimeout;
        private byte sharedBuildStage = 0;
        private boolean shared;

        private InitShim() {
        }

        int getMaxConnections() {
            if (this.maxConnectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxConnectionsBuildStage == 0) {
                this.maxConnectionsBuildStage = (byte)-1;
                this.maxConnections = ImmutablePoolSettings.this.getMaxConnectionsInitialize();
                this.maxConnectionsBuildStage = 1;
            }
            return this.maxConnections;
        }

        void maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            this.maxConnectionsBuildStage = 1;
        }

        int getMinConnections() {
            if (this.minConnectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minConnectionsBuildStage == 0) {
                this.minConnectionsBuildStage = (byte)-1;
                this.minConnections = ImmutablePoolSettings.this.getMinConnectionsInitialize();
                this.minConnectionsBuildStage = 1;
            }
            return this.minConnections;
        }

        void minConnections(int minConnections) {
            this.minConnections = minConnections;
            this.minConnectionsBuildStage = 1;
        }

        boolean getInitFailFast() {
            if (this.initFailFastBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initFailFastBuildStage == 0) {
                this.initFailFastBuildStage = (byte)-1;
                this.initFailFast = ImmutablePoolSettings.this.getInitFailFastInitialize();
                this.initFailFastBuildStage = 1;
            }
            return this.initFailFast;
        }

        void initFailFast(boolean initFailFast) {
            this.initFailFast = initFailFast;
            this.initFailFastBuildStage = 1;
        }

        String getInitFailTimeout() {
            if (this.initFailTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initFailTimeoutBuildStage == 0) {
                this.initFailTimeoutBuildStage = (byte)-1;
                this.initFailTimeout = Objects.requireNonNull(ImmutablePoolSettings.this.getInitFailTimeoutInitialize(), "initFailTimeout");
                this.initFailTimeoutBuildStage = 1;
            }
            return this.initFailTimeout;
        }

        void initFailTimeout(String initFailTimeout) {
            this.initFailTimeout = initFailTimeout;
            this.initFailTimeoutBuildStage = 1;
        }

        String getIdleTimeout() {
            if (this.idleTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idleTimeoutBuildStage == 0) {
                this.idleTimeoutBuildStage = (byte)-1;
                this.idleTimeout = Objects.requireNonNull(ImmutablePoolSettings.this.getIdleTimeoutInitialize(), "idleTimeout");
                this.idleTimeoutBuildStage = 1;
            }
            return this.idleTimeout;
        }

        void idleTimeout(String idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.idleTimeoutBuildStage = 1;
        }

        boolean getShared() {
            if (this.sharedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sharedBuildStage == 0) {
                this.sharedBuildStage = (byte)-1;
                this.shared = ImmutablePoolSettings.this.getSharedInitialize();
                this.sharedBuildStage = 1;
            }
            return this.shared;
        }

        void shared(boolean shared) {
            this.shared = shared;
            this.sharedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.maxConnectionsBuildStage == -1) {
                attributes.add("maxConnections");
            }
            if (this.minConnectionsBuildStage == -1) {
                attributes.add("minConnections");
            }
            if (this.initFailFastBuildStage == -1) {
                attributes.add("initFailFast");
            }
            if (this.initFailTimeoutBuildStage == -1) {
                attributes.add("initFailTimeout");
            }
            if (this.idleTimeoutBuildStage == -1) {
                attributes.add("idleTimeout");
            }
            if (this.sharedBuildStage == -1) {
                attributes.add("shared");
            }
            return "Cannot build PoolSettings, attribute initializers form cycle " + attributes;
        }
    }
}

