/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import de.ii.xtraplatform.features.domain.ExtendableConfiguration;
import de.ii.xtraplatform.features.domain.ExtensionConfiguration;
import de.ii.xtraplatform.features.domain.FeatureProviderDataV2;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.ZoneIdFromString;
import de.ii.xtraplatform.features.sql.domain.ConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.FeatureProviderSqlData;
import de.ii.xtraplatform.features.sql.domain.ImmutableConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.ImmutableQueryGeneratorSettings;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlPathDefaults;
import de.ii.xtraplatform.features.sql.domain.SqlPathDefaults;
import de.ii.xtraplatform.store.domain.Value;
import de.ii.xtraplatform.store.domain.entities.AutoEntity;
import de.ii.xtraplatform.store.domain.entities.EntityData;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.ImmutableBuildableMap;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.primitives.Longs;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeatureProviderSqlData", generator="Immutables")
@Immutable
public final class ImmutableFeatureProviderSqlData
implements FeatureProviderSqlData {
    private final long storageVersion;
    private final String id;
    private final long createdAt;
    private final long lastModified;
    private final long entityStorageVersion;
    @Nullable
    private final Boolean auto;
    @Nullable
    private final Boolean autoPersist;
    private final transient boolean isAuto;
    private final transient boolean isAutoPersist;
    private final transient List<ExtensionConfiguration> mergedExtensions;
    private final transient long entitySchemaVersion;
    private final String providerType;
    private final String featureProviderType;
    private final transient Optional<String> entitySubType;
    @Nullable
    private final EpsgCrs nativeCrs;
    @Nullable
    private final ZoneId nativeTimeZone;
    @Nullable
    private final String defaultLanguage;
    private final ValidationResult.MODE typeValidation;
    private final ImmutableList<ExtensionConfiguration> extensions;
    private final ImmutableMap<String, Map<String, String>> codelists;
    private final ImmutableList<String> autoTypes;
    @Nullable
    private final ImmutableConnectionInfoSql connectionInfo;
    @Nullable
    private final ImmutableSqlPathDefaults sourcePathDefaults;
    @Nullable
    private final ImmutableQueryGeneratorSettings queryGeneration;
    private final BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> types;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFeatureProviderSqlData(Builder builder) {
        this.id = builder.id;
        this.auto = builder.auto;
        this.autoPersist = builder.autoPersist;
        this.providerType = builder.providerType;
        this.featureProviderType = builder.featureProviderType;
        this.nativeCrs = ImmutableFeatureProviderSqlData.convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(builder.nativeCrs);
        this.nativeTimeZone = builder.nativeTimeZone;
        this.defaultLanguage = builder.defaultLanguage;
        this.extensions = builder.extensions.build();
        this.codelists = builder.codelists.build();
        this.autoTypes = builder.autoTypes.build();
        this.connectionInfo = builder.connectionInfo == null ? null : ImmutableFeatureProviderSqlData.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableConnectionInfoSql(builder.connectionInfo);
        this.sourcePathDefaults = builder.sourcePathDefaults == null ? null : ImmutableFeatureProviderSqlData.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(builder.sourcePathDefaults);
        this.queryGeneration = builder.queryGeneration == null ? null : ImmutableFeatureProviderSqlData.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableQueryGeneratorSettings(builder.queryGeneration);
        this.types = builder.types_build();
        if (builder.storageVersionIsSet()) {
            this.initShim.storageVersion(builder.storageVersion);
        }
        if (builder.createdAtIsSet()) {
            this.initShim.createdAt(builder.createdAt);
        }
        if (builder.lastModifiedIsSet()) {
            this.initShim.lastModified(builder.lastModified);
        }
        if (builder.entityStorageVersionIsSet()) {
            this.initShim.entityStorageVersion(builder.entityStorageVersion);
        }
        if (builder.typeValidation != null) {
            this.initShim.typeValidation(builder.typeValidation);
        }
        this.storageVersion = this.initShim.storageVersion();
        this.createdAt = this.initShim.getCreatedAt();
        this.lastModified = this.initShim.getLastModified();
        this.entityStorageVersion = this.initShim.getEntityStorageVersion();
        this.isAuto = this.initShim.isAuto();
        this.isAutoPersist = this.initShim.isAutoPersist();
        this.mergedExtensions = this.initShim.getMergedExtensions();
        this.entitySchemaVersion = this.initShim.getEntitySchemaVersion();
        this.entitySubType = this.initShim.getEntitySubType();
        this.typeValidation = this.initShim.getTypeValidation();
        this.initShim = null;
    }

    private ImmutableFeatureProviderSqlData(long storageVersion, String id, long createdAt, long lastModified, long entityStorageVersion, @Nullable Boolean auto, @Nullable Boolean autoPersist, String providerType, String featureProviderType, @Nullable EpsgCrs nativeCrs, @Nullable ZoneId nativeTimeZone, @Nullable String defaultLanguage, ValidationResult.MODE typeValidation, ImmutableList<ExtensionConfiguration> extensions, ImmutableMap<String, Map<String, String>> codelists, ImmutableList<String> autoTypes, @Nullable ImmutableConnectionInfoSql connectionInfo, @Nullable ImmutableSqlPathDefaults sourcePathDefaults, @Nullable ImmutableQueryGeneratorSettings queryGeneration, BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> types) {
        this.initShim.storageVersion(storageVersion);
        this.id = id;
        this.initShim.createdAt(createdAt);
        this.initShim.lastModified(lastModified);
        this.initShim.entityStorageVersion(entityStorageVersion);
        this.auto = auto;
        this.autoPersist = autoPersist;
        this.providerType = providerType;
        this.featureProviderType = featureProviderType;
        this.nativeCrs = nativeCrs;
        this.nativeTimeZone = nativeTimeZone;
        this.defaultLanguage = defaultLanguage;
        this.initShim.typeValidation(typeValidation);
        this.extensions = extensions;
        this.codelists = codelists;
        this.autoTypes = autoTypes;
        this.connectionInfo = connectionInfo;
        this.sourcePathDefaults = sourcePathDefaults;
        this.queryGeneration = queryGeneration;
        this.types = types;
        this.storageVersion = this.initShim.storageVersion();
        this.createdAt = this.initShim.getCreatedAt();
        this.lastModified = this.initShim.getLastModified();
        this.entityStorageVersion = this.initShim.getEntityStorageVersion();
        this.isAuto = this.initShim.isAuto();
        this.isAutoPersist = this.initShim.isAutoPersist();
        this.mergedExtensions = this.initShim.getMergedExtensions();
        this.entitySchemaVersion = this.initShim.getEntitySchemaVersion();
        this.entitySubType = this.initShim.getEntitySubType();
        this.typeValidation = this.initShim.getTypeValidation();
        this.initShim = null;
    }

    private long storageVersionInitialize() {
        return FeatureProviderSqlData.super.storageVersion();
    }

    private long getCreatedAtInitialize() {
        return FeatureProviderSqlData.super.getCreatedAt();
    }

    private long getLastModifiedInitialize() {
        return FeatureProviderSqlData.super.getLastModified();
    }

    private long getEntityStorageVersionInitialize() {
        return FeatureProviderSqlData.super.getEntityStorageVersion();
    }

    private boolean isAutoInitialize() {
        return FeatureProviderSqlData.super.isAuto();
    }

    private boolean isAutoPersistInitialize() {
        return FeatureProviderSqlData.super.isAutoPersist();
    }

    private List<ExtensionConfiguration> getMergedExtensionsInitialize() {
        return FeatureProviderSqlData.super.getMergedExtensions();
    }

    private long getEntitySchemaVersionInitialize() {
        return FeatureProviderSqlData.super.getEntitySchemaVersion();
    }

    private Optional<String> getEntitySubTypeInitialize() {
        return FeatureProviderSqlData.super.getEntitySubType();
    }

    private ValidationResult.MODE getTypeValidationInitialize() {
        return FeatureProviderSqlData.super.getTypeValidation();
    }

    @Override
    @JsonProperty(value="storageVersion")
    @JsonIgnore
    public long storageVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storageVersion() : this.storageVersion;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="createdAt")
    public long getCreatedAt() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreatedAt() : this.createdAt;
    }

    @Override
    @JsonProperty(value="lastModified")
    public long getLastModified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLastModified() : this.lastModified;
    }

    @Override
    @JsonProperty(value="entityStorageVersion")
    public long getEntityStorageVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEntityStorageVersion() : this.entityStorageVersion;
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getAuto() {
        return Optional.ofNullable(this.auto);
    }

    @Override
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getAutoPersist() {
        return Optional.ofNullable(this.autoPersist);
    }

    @Override
    @JsonProperty(value="isAuto")
    @JsonIgnore
    public boolean isAuto() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAuto() : this.isAuto;
    }

    @Override
    @JsonProperty(value="isAutoPersist")
    @JsonIgnore
    public boolean isAutoPersist() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAutoPersist() : this.isAutoPersist;
    }

    @Override
    @JsonProperty(value="mergedExtensions")
    @JsonIgnore
    public List<ExtensionConfiguration> getMergedExtensions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMergedExtensions() : this.mergedExtensions;
    }

    @Override
    @JsonProperty(value="entitySchemaVersion")
    public long getEntitySchemaVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEntitySchemaVersion() : this.entitySchemaVersion;
    }

    @Override
    @JsonProperty(value="providerType")
    public String getProviderType() {
        return this.providerType;
    }

    @Override
    @JsonProperty(value="featureProviderType")
    public String getFeatureProviderType() {
        return this.featureProviderType;
    }

    @Override
    @JsonProperty(value="entitySubType")
    public Optional<String> getEntitySubType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getEntitySubType() : this.entitySubType;
    }

    @Override
    @JsonProperty(value="nativeCrs")
    public Optional<EpsgCrs> getNativeCrs() {
        return Optional.ofNullable(this.nativeCrs);
    }

    @Override
    @JsonProperty(value="nativeTimeZone")
    @JsonDeserialize(converter=ZoneIdFromString.class)
    public Optional<ZoneId> getNativeTimeZone() {
        return Optional.ofNullable(this.nativeTimeZone);
    }

    @Override
    @JsonProperty(value="defaultLanguage")
    public Optional<String> getDefaultLanguage() {
        return Optional.ofNullable(this.defaultLanguage);
    }

    @Override
    @JsonProperty(value="typeValidation")
    public ValidationResult.MODE getTypeValidation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTypeValidation() : this.typeValidation;
    }

    @JsonProperty(value="extensions")
    public ImmutableList<ExtensionConfiguration> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="codelists")
    public ImmutableMap<String, Map<String, String>> getCodelists() {
        return this.codelists;
    }

    @JsonProperty(value="autoTypes")
    public ImmutableList<String> getAutoTypes() {
        return this.autoTypes;
    }

    @Override
    @JsonProperty(value="connectionInfo")
    @Nullable
    public ImmutableConnectionInfoSql getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    @JsonProperty(value="sourcePathDefaults")
    @Nullable
    public ImmutableSqlPathDefaults getSourcePathDefaults() {
        return this.sourcePathDefaults;
    }

    @Override
    @JsonProperty(value="queryGeneration", access=JsonProperty.Access.WRITE_ONLY)
    @Nullable
    public ImmutableQueryGeneratorSettings getQueryGeneration() {
        return this.queryGeneration;
    }

    @Override
    @JsonProperty(value="types")
    public BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> getTypes() {
        return this.types;
    }

    public final ImmutableFeatureProviderSqlData withStorageVersion(long value) {
        if (this.storageVersion == value) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(value, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, newValue, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withCreatedAt(long value) {
        if (this.createdAt == value) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, value, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withLastModified(long value) {
        if (this.lastModified == value) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, value, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withEntityStorageVersion(long value) {
        if (this.entityStorageVersion == value) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, value, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withAuto(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.auto, newValue)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, newValue, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withAuto(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.auto, value)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, value, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withAutoPersist(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.autoPersist, newValue)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, newValue, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withAutoPersist(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.autoPersist, value)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, value, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withProviderType(String value) {
        String newValue = Objects.requireNonNull(value, "providerType");
        if (this.providerType.equals(newValue)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, newValue, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withFeatureProviderType(String value) {
        String newValue = Objects.requireNonNull(value, "featureProviderType");
        if (this.featureProviderType.equals(newValue)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, newValue, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withNativeCrs(EpsgCrs value) {
        EpsgCrs newValue = Objects.requireNonNull(value, "nativeCrs");
        if (this.nativeCrs == newValue) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, newValue, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withNativeCrs(Optional<? extends EpsgCrs> optional) {
        EpsgCrs value = optional.orElse(null);
        if (this.nativeCrs == value) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, value, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withNativeTimeZone(ZoneId value) {
        ZoneId newValue = Objects.requireNonNull(value, "nativeTimeZone");
        if (this.nativeTimeZone == newValue) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, newValue, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withNativeTimeZone(Optional<? extends ZoneId> optional) {
        ZoneId value = optional.orElse(null);
        if (this.nativeTimeZone == value) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, value, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withDefaultLanguage(String value) {
        String newValue = Objects.requireNonNull(value, "defaultLanguage");
        if (Objects.equals(this.defaultLanguage, newValue)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, newValue, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withDefaultLanguage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.defaultLanguage, value)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, value, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withTypeValidation(ValidationResult.MODE value) {
        if (this.typeValidation == value) {
            return this;
        }
        ValidationResult.MODE newValue = Objects.requireNonNull(value, "typeValidation");
        if (this.typeValidation.equals((Object)newValue)) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, newValue, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withExtensions(ExtensionConfiguration ... elements) {
        ImmutableList<ExtensionConfiguration> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, newValue, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withExtensions(Iterable<? extends ExtensionConfiguration> elements) {
        if (this.extensions == elements) {
            return this;
        }
        ImmutableList<ExtensionConfiguration> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, newValue, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withCodelists(Map<String, ? extends Map<String, String>> entries) {
        if (this.codelists == entries) {
            return this;
        }
        ImmutableMap<String, Map<String, String>> newValue = ImmutableMap.copyOf(entries);
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, newValue, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withAutoTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, newValue, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withAutoTypes(Iterable<String> elements) {
        if (this.autoTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, newValue, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withConnectionInfo(@Nullable ConnectionInfoSql value) {
        if (this.connectionInfo == value) {
            return this;
        }
        ImmutableConnectionInfoSql newValue = new ImmutableConnectionInfoSql.Builder().from(value).build();
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, newValue, this.sourcePathDefaults, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withSourcePathDefaults(@Nullable SqlPathDefaults value) {
        if (this.sourcePathDefaults == value) {
            return this;
        }
        ImmutableSqlPathDefaults newValue = new ImmutableSqlPathDefaults.Builder().from(value).build();
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, newValue, this.queryGeneration, this.types));
    }

    public final ImmutableFeatureProviderSqlData withQueryGeneration(@Nullable FeatureProviderSqlData.QueryGeneratorSettings value) {
        if (this.queryGeneration == value) {
            return this;
        }
        ImmutableQueryGeneratorSettings newValue = new ImmutableQueryGeneratorSettings.Builder().from(value).build();
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, newValue, this.types));
    }

    public ImmutableFeatureProviderSqlData withTypes(BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> value) {
        BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> newValue = value;
        if (this.types == newValue) {
            return this;
        }
        return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this.storageVersion, this.id, this.createdAt, this.lastModified, this.entityStorageVersion, this.auto, this.autoPersist, this.providerType, this.featureProviderType, this.nativeCrs, this.nativeTimeZone, this.defaultLanguage, this.typeValidation, this.extensions, this.codelists, this.autoTypes, this.connectionInfo, this.sourcePathDefaults, this.queryGeneration, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureProviderSqlData && this.equalTo((ImmutableFeatureProviderSqlData)another);
    }

    private boolean equalTo(ImmutableFeatureProviderSqlData another) {
        return this.storageVersion == another.storageVersion && this.id.equals(another.id) && this.createdAt == another.createdAt && this.lastModified == another.lastModified && this.entityStorageVersion == another.entityStorageVersion && Objects.equals(this.auto, another.auto) && Objects.equals(this.autoPersist, another.autoPersist) && this.entitySchemaVersion == another.entitySchemaVersion && this.providerType.equals(another.providerType) && this.featureProviderType.equals(another.featureProviderType) && this.entitySubType.equals(another.entitySubType) && Objects.equals(this.nativeCrs, another.nativeCrs) && Objects.equals(this.nativeTimeZone, another.nativeTimeZone) && Objects.equals(this.defaultLanguage, another.defaultLanguage) && this.typeValidation.equals((Object)another.typeValidation) && this.extensions.equals(another.extensions) && this.codelists.equals(another.codelists) && this.autoTypes.equals(another.autoTypes) && Objects.equals(this.connectionInfo, another.connectionInfo) && Objects.equals(this.sourcePathDefaults, another.sourcePathDefaults) && Objects.equals(this.queryGeneration, another.queryGeneration) && this.getTypes().equals(another.getTypes());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode(this.storageVersion);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Longs.hashCode(this.createdAt);
        h += (h << 5) + Longs.hashCode(this.lastModified);
        h += (h << 5) + Longs.hashCode(this.entityStorageVersion);
        h += (h << 5) + Objects.hashCode(this.auto);
        h += (h << 5) + Objects.hashCode(this.autoPersist);
        h += (h << 5) + Longs.hashCode(this.entitySchemaVersion);
        h += (h << 5) + this.providerType.hashCode();
        h += (h << 5) + this.featureProviderType.hashCode();
        h += (h << 5) + this.entitySubType.hashCode();
        h += (h << 5) + Objects.hashCode(this.nativeCrs);
        h += (h << 5) + Objects.hashCode(this.nativeTimeZone);
        h += (h << 5) + Objects.hashCode(this.defaultLanguage);
        h += (h << 5) + this.typeValidation.hashCode();
        h += (h << 5) + this.extensions.hashCode();
        h += (h << 5) + this.codelists.hashCode();
        h += (h << 5) + this.autoTypes.hashCode();
        h += (h << 5) + Objects.hashCode(this.connectionInfo);
        h += (h << 5) + Objects.hashCode(this.sourcePathDefaults);
        h += (h << 5) + Objects.hashCode(this.queryGeneration);
        h += (h << 5) + this.getTypes().hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FeatureProviderSqlData").omitNullValues().add("storageVersion", this.storageVersion).add("id", this.id).add("createdAt", this.createdAt).add("lastModified", this.lastModified).add("entityStorageVersion", this.entityStorageVersion).add("auto", this.auto).add("autoPersist", this.autoPersist).add("entitySchemaVersion", this.entitySchemaVersion).add("providerType", this.providerType).add("featureProviderType", this.featureProviderType).add("entitySubType", this.entitySubType).add("nativeCrs", this.nativeCrs).add("nativeTimeZone", this.nativeTimeZone).add("defaultLanguage", this.defaultLanguage).add("typeValidation", (Object)this.typeValidation).add("extensions", this.extensions).add("codelists", this.codelists).add("autoTypes", this.autoTypes).add("connectionInfo", this.connectionInfo).add("sourcePathDefaults", this.sourcePathDefaults).add("queryGeneration", this.queryGeneration).add("types", this.getTypes().toString()).toString();
    }

    private static ImmutableFeatureProviderSqlData validate(ImmutableFeatureProviderSqlData instance) {
        instance = (ImmutableFeatureProviderSqlData)instance.mergeExtensions();
        instance = (ImmutableFeatureProviderSqlData)instance.initNestedDefault();
        return instance;
    }

    public static ImmutableFeatureProviderSqlData copyOf(FeatureProviderSqlData instance) {
        if (instance instanceof ImmutableFeatureProviderSqlData) {
            return (ImmutableFeatureProviderSqlData)instance;
        }
        return new Builder().from(instance).build();
    }

    @Nullable
    private static ImmutableEpsgCrs convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable ImmutableEpsgCrs.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static EpsgCrs convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable EpsgCrs value) {
        if (value == null) {
            return null;
        }
        return new ImmutableEpsgCrs.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableEpsgCrs.Builder convertToBuilderTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable EpsgCrs value) {
        if (value == null) {
            return null;
        }
        return new ImmutableEpsgCrs.Builder().from(value);
    }

    @Nullable
    private static ImmutableConnectionInfoSql convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableConnectionInfoSql(@Nullable ImmutableConnectionInfoSql.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static ConnectionInfoSql convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableConnectionInfoSql(@Nullable ConnectionInfoSql value) {
        if (value == null) {
            return null;
        }
        return new ImmutableConnectionInfoSql.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableConnectionInfoSql.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableConnectionInfoSql(@Nullable ConnectionInfoSql value) {
        if (value == null) {
            return null;
        }
        return new ImmutableConnectionInfoSql.Builder().from(value);
    }

    @Nullable
    private static ImmutableSqlPathDefaults convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable ImmutableSqlPathDefaults.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static SqlPathDefaults convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable SqlPathDefaults value) {
        if (value == null) {
            return null;
        }
        return new ImmutableSqlPathDefaults.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableSqlPathDefaults.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable SqlPathDefaults value) {
        if (value == null) {
            return null;
        }
        return new ImmutableSqlPathDefaults.Builder().from(value);
    }

    @Nullable
    private static ImmutableQueryGeneratorSettings convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableQueryGeneratorSettings(@Nullable ImmutableQueryGeneratorSettings.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static FeatureProviderSqlData.QueryGeneratorSettings convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableQueryGeneratorSettings(@Nullable FeatureProviderSqlData.QueryGeneratorSettings value) {
        if (value == null) {
            return null;
        }
        return new ImmutableQueryGeneratorSettings.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableQueryGeneratorSettings.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableQueryGeneratorSettings(@Nullable FeatureProviderSqlData.QueryGeneratorSettings value) {
        if (value == null) {
            return null;
        }
        return new ImmutableQueryGeneratorSettings.Builder().from(value);
    }

    @Generated(from="FeatureProviderSqlData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends FeatureProviderSqlData.Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PROVIDER_TYPE = 2L;
        private static final long INIT_BIT_FEATURE_PROVIDER_TYPE = 4L;
        private static final long OPT_BIT_STORAGE_VERSION = 1L;
        private static final long OPT_BIT_CREATED_AT = 2L;
        private static final long OPT_BIT_LAST_MODIFIED = 4L;
        private static final long OPT_BIT_ENTITY_STORAGE_VERSION = 8L;
        private long initBits = 7L;
        private long optBits;
        private Map<String, ImmutableFeatureSchema.Builder> types_builderMap = new LinkedHashMap<String, ImmutableFeatureSchema.Builder>();
        private long storageVersion;
        @Nullable
        private String id;
        private long createdAt;
        private long lastModified;
        private long entityStorageVersion;
        @Nullable
        private Boolean auto;
        @Nullable
        private Boolean autoPersist;
        @Nullable
        private String providerType;
        @Nullable
        private String featureProviderType;
        @Nullable
        private ImmutableEpsgCrs.Builder nativeCrs;
        @Nullable
        private ZoneId nativeTimeZone;
        @Nullable
        private String defaultLanguage;
        @Nullable
        private ValidationResult.MODE typeValidation;
        private ImmutableList.Builder<ExtensionConfiguration> extensions = ImmutableList.builder();
        private ImmutableMap.Builder<String, Map<String, String>> codelists = ImmutableMap.builder();
        private ImmutableList.Builder<String> autoTypes = ImmutableList.builder();
        @Nullable
        private ImmutableConnectionInfoSql.Builder connectionInfo;
        @Nullable
        private ImmutableSqlPathDefaults.Builder sourcePathDefaults;
        @Nullable
        private ImmutableQueryGeneratorSettings.Builder queryGeneration;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(Value instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AutoEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureProviderDataV2 instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FeatureProviderSqlData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(EntityData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExtendableConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof Value) {
                instance = (Value)object;
                this.storageVersion(instance.storageVersion());
            }
            if (object instanceof AutoEntity) {
                Optional<Boolean> autoOptional;
                instance = (AutoEntity)object;
                Optional<Boolean> autoPersistOptional = instance.getAutoPersist();
                if (autoPersistOptional.isPresent()) {
                    this.autoPersist(autoPersistOptional);
                }
                if ((autoOptional = instance.getAuto()).isPresent()) {
                    this.auto(autoOptional);
                }
            }
            if (object instanceof FeatureProviderDataV2) {
                Optional<String> defaultLanguageOptional;
                Optional<ZoneId> nativeTimeZoneOptional;
                instance = (FeatureProviderDataV2)object;
                if ((bits & 1L) == 0L) {
                    this.types(instance.getTypes());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllExtensions(instance.getExtensions());
                    bits |= 2L;
                }
                if ((nativeTimeZoneOptional = instance.getNativeTimeZone()).isPresent()) {
                    this.nativeTimeZone(nativeTimeZoneOptional);
                }
                if ((defaultLanguageOptional = instance.getDefaultLanguage()).isPresent()) {
                    this.defaultLanguage(defaultLanguageOptional);
                }
                this.featureProviderType(instance.getFeatureProviderType());
                this.addAllAutoTypes(instance.getAutoTypes());
                Optional<EpsgCrs> nativeCrsOptional = instance.getNativeCrs();
                if (nativeCrsOptional.isPresent()) {
                    this.nativeCrs(nativeCrsOptional);
                }
                this.typeValidation(instance.getTypeValidation());
                this.putAllCodelists(instance.getCodelists());
                this.providerType(instance.getProviderType());
            }
            if (object instanceof FeatureProviderSqlData) {
                FeatureProviderSqlData.QueryGeneratorSettings queryGenerationValue;
                SqlPathDefaults sourcePathDefaultsValue;
                ConnectionInfoSql connectionInfoValue;
                instance = (FeatureProviderSqlData)object;
                if ((bits & 1L) == 0L) {
                    this.types(instance.getTypes());
                    bits |= 1L;
                }
                if ((connectionInfoValue = instance.getConnectionInfo()) != null) {
                    this.connectionInfo(connectionInfoValue);
                }
                if ((sourcePathDefaultsValue = instance.getSourcePathDefaults()) != null) {
                    this.sourcePathDefaults(sourcePathDefaultsValue);
                }
                if ((queryGenerationValue = instance.getQueryGeneration()) != null) {
                    this.queryGeneration(queryGenerationValue);
                }
            }
            if (object instanceof EntityData) {
                instance = (EntityData)object;
                this.createdAt(instance.getCreatedAt());
                this.entityStorageVersion(instance.getEntityStorageVersion());
                this.id(instance.getId());
                this.lastModified(instance.getLastModified());
            }
            if (object instanceof ExtendableConfiguration) {
                instance = (ExtendableConfiguration)object;
                if ((bits & 2L) == 0L) {
                    this.addAllExtensions(instance.getExtensions());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="storageVersion")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder storageVersion(long storageVersion) {
            this.storageVersion = storageVersion;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="createdAt")
        @CanIgnoreReturnValue
        public final Builder createdAt(long createdAt) {
            this.createdAt = createdAt;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="lastModified")
        @CanIgnoreReturnValue
        public final Builder lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="entityStorageVersion")
        @CanIgnoreReturnValue
        public final Builder entityStorageVersion(long entityStorageVersion) {
            this.entityStorageVersion = entityStorageVersion;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auto(boolean auto) {
            this.auto = auto;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder auto(Optional<Boolean> auto) {
            this.auto = auto.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder autoPersist(boolean autoPersist) {
            this.autoPersist = autoPersist;
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder autoPersist(Optional<Boolean> autoPersist) {
            this.autoPersist = autoPersist.orElse(null);
            return this;
        }

        @Override
        @JsonProperty(value="providerType")
        @CanIgnoreReturnValue
        public final Builder providerType(String providerType) {
            this.providerType = Objects.requireNonNull(providerType, "providerType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty(value="featureProviderType")
        @CanIgnoreReturnValue
        public final Builder featureProviderType(String featureProviderType) {
            this.featureProviderType = Objects.requireNonNull(featureProviderType, "featureProviderType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nativeCrs(EpsgCrs nativeCrs) {
            this.nativeCrs = new ImmutableEpsgCrs.Builder().from(Objects.requireNonNull(nativeCrs, "nativeCrs"));
            return this;
        }

        @JsonProperty(value="nativeCrs")
        public final ImmutableEpsgCrs.Builder nativeCrsBuilder() {
            if (this.nativeCrs == null) {
                this.nativeCrs = new ImmutableEpsgCrs.Builder();
            }
            return this.nativeCrs;
        }

        @JsonProperty(value="nativeCrs")
        @CanIgnoreReturnValue
        public final Builder nativeCrsBuilder(ImmutableEpsgCrs.Builder nativeCrs) {
            this.nativeCrs = nativeCrs;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nativeCrs(int code) {
            return this.nativeCrs(ImmutableEpsgCrs.of(code));
        }

        @JsonProperty(value="nativeCrs")
        @CanIgnoreReturnValue
        public final Builder nativeCrs(Optional<? extends EpsgCrs> nativeCrs) {
            this.nativeCrs = Builder.convertToBuilderTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(nativeCrs.orElse(null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nativeTimeZone(ZoneId nativeTimeZone) {
            this.nativeTimeZone = Objects.requireNonNull(nativeTimeZone, "nativeTimeZone");
            return this;
        }

        @JsonProperty(value="nativeTimeZone")
        @JsonDeserialize(converter=ZoneIdFromString.class)
        @CanIgnoreReturnValue
        public final Builder nativeTimeZone(Optional<? extends ZoneId> nativeTimeZone) {
            this.nativeTimeZone = nativeTimeZone.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultLanguage(String defaultLanguage) {
            this.defaultLanguage = Objects.requireNonNull(defaultLanguage, "defaultLanguage");
            return this;
        }

        @JsonProperty(value="defaultLanguage")
        @CanIgnoreReturnValue
        public final Builder defaultLanguage(Optional<String> defaultLanguage) {
            this.defaultLanguage = defaultLanguage.orElse(null);
            return this;
        }

        @JsonProperty(value="typeValidation")
        @CanIgnoreReturnValue
        public final Builder typeValidation(ValidationResult.MODE typeValidation) {
            this.typeValidation = Objects.requireNonNull(typeValidation, "typeValidation");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(ExtensionConfiguration element) {
            this.extensions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(ExtensionConfiguration ... elements) {
            this.extensions.add(elements);
            return this;
        }

        @Override
        @JsonProperty(value="extensions")
        @CanIgnoreReturnValue
        public final Builder extensions(Iterable<? extends ExtensionConfiguration> elements) {
            this.extensions = ImmutableList.builder();
            return this.addAllExtensions((Iterable)elements);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllExtensions(Iterable<? extends ExtensionConfiguration> elements) {
            this.extensions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCodelists(String key, Map<String, String> value) {
            this.codelists.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCodelists(Map.Entry<String, ? extends Map<String, String>> entry) {
            this.codelists.put(entry);
            return this;
        }

        @JsonProperty(value="codelists")
        @CanIgnoreReturnValue
        public final Builder codelists(Map<String, ? extends Map<String, String>> entries) {
            this.codelists = ImmutableMap.builder();
            return this.putAllCodelists(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCodelists(Map<String, ? extends Map<String, String>> entries) {
            this.codelists.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAutoTypes(String element) {
            this.autoTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAutoTypes(String ... elements) {
            this.autoTypes.add(elements);
            return this;
        }

        @JsonProperty(value="autoTypes")
        @CanIgnoreReturnValue
        public final Builder autoTypes(Iterable<String> elements) {
            this.autoTypes = ImmutableList.builder();
            return this.addAllAutoTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAutoTypes(Iterable<String> elements) {
            this.autoTypes.addAll((Iterable)elements);
            return this;
        }

        @Override
        @JsonProperty(value="connectionInfo")
        @CanIgnoreReturnValue
        public final Builder connectionInfo(@Nullable ConnectionInfoSql connectionInfo) {
            this.connectionInfo = new ImmutableConnectionInfoSql.Builder().from(connectionInfo == null ? null : Builder.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableConnectionInfoSql(connectionInfo));
            return this;
        }

        @JsonProperty(value="connectionInfo")
        public final ImmutableConnectionInfoSql.Builder connectionInfoBuilder() {
            if (this.connectionInfo == null) {
                this.connectionInfo = new ImmutableConnectionInfoSql.Builder();
            }
            return this.connectionInfo;
        }

        @JsonProperty(value="connectionInfo")
        @CanIgnoreReturnValue
        public final Builder connectionInfoBuilder(@Nullable ImmutableConnectionInfoSql.Builder connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        @JsonProperty(value="sourcePathDefaults")
        @CanIgnoreReturnValue
        public final Builder sourcePathDefaults(@Nullable SqlPathDefaults sourcePathDefaults) {
            this.sourcePathDefaults = new ImmutableSqlPathDefaults.Builder().from(sourcePathDefaults == null ? null : Builder.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(sourcePathDefaults));
            return this;
        }

        @JsonProperty(value="sourcePathDefaults")
        public final ImmutableSqlPathDefaults.Builder sourcePathDefaultsBuilder() {
            if (this.sourcePathDefaults == null) {
                this.sourcePathDefaults = new ImmutableSqlPathDefaults.Builder();
            }
            return this.sourcePathDefaults;
        }

        @JsonProperty(value="sourcePathDefaults")
        @CanIgnoreReturnValue
        public final Builder sourcePathDefaultsBuilder(@Nullable ImmutableSqlPathDefaults.Builder sourcePathDefaults) {
            this.sourcePathDefaults = sourcePathDefaults;
            return this;
        }

        @JsonProperty(value="queryGeneration", access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder queryGeneration(@Nullable FeatureProviderSqlData.QueryGeneratorSettings queryGeneration) {
            this.queryGeneration = new ImmutableQueryGeneratorSettings.Builder().from(queryGeneration == null ? null : Builder.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableQueryGeneratorSettings(queryGeneration));
            return this;
        }

        @JsonProperty(value="queryGeneration", access=JsonProperty.Access.WRITE_ONLY)
        public final ImmutableQueryGeneratorSettings.Builder queryGenerationBuilder() {
            if (this.queryGeneration == null) {
                this.queryGeneration = new ImmutableQueryGeneratorSettings.Builder();
            }
            return this.queryGeneration;
        }

        @JsonProperty(value="queryGeneration", access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder queryGenerationBuilder(@Nullable ImmutableQueryGeneratorSettings.Builder queryGeneration) {
            this.queryGeneration = queryGeneration;
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="types")
        @CanIgnoreReturnValue
        public Builder types(Map<String, FeatureSchema> values) {
            this.types_builderMap = new LinkedHashMap<String, ImmutableFeatureSchema.Builder>();
            values.forEach(this::putTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putTypes(String key, FeatureSchema value) {
            this.types_builderMap.put(key, value.getBuilder());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder putTypes(String key, ImmutableFeatureSchema.Builder builder) {
            this.types_builderMap.put(key, builder);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putAllTypes(Map<String, FeatureSchema> values) {
            values.forEach(this::putTypes);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public Builder setTypes(Map<String, ImmutableFeatureSchema.Builder> builders) {
            this.types_builderMap.putAll(builders);
            return this;
        }

        @Override
        public ImmutableFeatureProviderSqlData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableFeatureProviderSqlData.validate(new ImmutableFeatureProviderSqlData(this));
        }

        private boolean storageVersionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean createdAtIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean lastModifiedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean entityStorageVersionIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("providerType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("featureProviderType");
            }
            return "Cannot build FeatureProviderSqlData, some of required attributes are not set " + attributes;
        }

        private BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> types_build() {
            return new ImmutableBuildableMap.Builder().builders(this.types_builderMap).build();
        }

        @Override
        @JsonProperty
        public Map<String, ImmutableFeatureSchema.Builder> getTypes() {
            return this.types_builderMap;
        }

        @Nullable
        private static ImmutableEpsgCrs convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable ImmutableEpsgCrs.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static EpsgCrs convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable EpsgCrs value) {
            if (value == null) {
                return null;
            }
            return new ImmutableEpsgCrs.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableEpsgCrs.Builder convertToBuilderTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable EpsgCrs value) {
            if (value == null) {
                return null;
            }
            return new ImmutableEpsgCrs.Builder().from(value);
        }

        @Nullable
        private static ImmutableConnectionInfoSql convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableConnectionInfoSql(@Nullable ImmutableConnectionInfoSql.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static ConnectionInfoSql convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableConnectionInfoSql(@Nullable ConnectionInfoSql value) {
            if (value == null) {
                return null;
            }
            return new ImmutableConnectionInfoSql.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableConnectionInfoSql.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableConnectionInfoSql(@Nullable ConnectionInfoSql value) {
            if (value == null) {
                return null;
            }
            return new ImmutableConnectionInfoSql.Builder().from(value);
        }

        @Nullable
        private static ImmutableSqlPathDefaults convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable ImmutableSqlPathDefaults.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static SqlPathDefaults convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable SqlPathDefaults value) {
            if (value == null) {
                return null;
            }
            return new ImmutableSqlPathDefaults.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableSqlPathDefaults.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable SqlPathDefaults value) {
            if (value == null) {
                return null;
            }
            return new ImmutableSqlPathDefaults.Builder().from(value);
        }

        @Nullable
        private static ImmutableQueryGeneratorSettings convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableQueryGeneratorSettings(@Nullable ImmutableQueryGeneratorSettings.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static FeatureProviderSqlData.QueryGeneratorSettings convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableQueryGeneratorSettings(@Nullable FeatureProviderSqlData.QueryGeneratorSettings value) {
            if (value == null) {
                return null;
            }
            return new ImmutableQueryGeneratorSettings.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableQueryGeneratorSettings.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableQueryGeneratorSettings(@Nullable FeatureProviderSqlData.QueryGeneratorSettings value) {
            if (value == null) {
                return null;
            }
            return new ImmutableQueryGeneratorSettings.Builder().from(value);
        }
    }

    @Generated(from="FeatureProviderSqlData", generator="Immutables")
    private final class InitShim {
        private byte storageVersionBuildStage = 0;
        private long storageVersion;
        private byte createdAtBuildStage = 0;
        private long createdAt;
        private byte lastModifiedBuildStage = 0;
        private long lastModified;
        private byte entityStorageVersionBuildStage = 0;
        private long entityStorageVersion;
        private byte isAutoBuildStage = 0;
        private boolean isAuto;
        private byte isAutoPersistBuildStage = 0;
        private boolean isAutoPersist;
        private byte mergedExtensionsBuildStage = 0;
        private List<ExtensionConfiguration> mergedExtensions;
        private byte entitySchemaVersionBuildStage = 0;
        private long entitySchemaVersion;
        private byte entitySubTypeBuildStage = 0;
        private Optional<String> entitySubType;
        private byte typeValidationBuildStage = 0;
        private ValidationResult.MODE typeValidation;

        private InitShim() {
        }

        long storageVersion() {
            if (this.storageVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storageVersionBuildStage == 0) {
                this.storageVersionBuildStage = (byte)-1;
                this.storageVersion = ImmutableFeatureProviderSqlData.this.storageVersionInitialize();
                this.storageVersionBuildStage = 1;
            }
            return this.storageVersion;
        }

        void storageVersion(long storageVersion) {
            this.storageVersion = storageVersion;
            this.storageVersionBuildStage = 1;
        }

        long getCreatedAt() {
            if (this.createdAtBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createdAtBuildStage == 0) {
                this.createdAtBuildStage = (byte)-1;
                this.createdAt = ImmutableFeatureProviderSqlData.this.getCreatedAtInitialize();
                this.createdAtBuildStage = 1;
            }
            return this.createdAt;
        }

        void createdAt(long createdAt) {
            this.createdAt = createdAt;
            this.createdAtBuildStage = 1;
        }

        long getLastModified() {
            if (this.lastModifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastModifiedBuildStage == 0) {
                this.lastModifiedBuildStage = (byte)-1;
                this.lastModified = ImmutableFeatureProviderSqlData.this.getLastModifiedInitialize();
                this.lastModifiedBuildStage = 1;
            }
            return this.lastModified;
        }

        void lastModified(long lastModified) {
            this.lastModified = lastModified;
            this.lastModifiedBuildStage = 1;
        }

        long getEntityStorageVersion() {
            if (this.entityStorageVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.entityStorageVersionBuildStage == 0) {
                this.entityStorageVersionBuildStage = (byte)-1;
                this.entityStorageVersion = ImmutableFeatureProviderSqlData.this.getEntityStorageVersionInitialize();
                this.entityStorageVersionBuildStage = 1;
            }
            return this.entityStorageVersion;
        }

        void entityStorageVersion(long entityStorageVersion) {
            this.entityStorageVersion = entityStorageVersion;
            this.entityStorageVersionBuildStage = 1;
        }

        boolean isAuto() {
            if (this.isAutoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAutoBuildStage == 0) {
                this.isAutoBuildStage = (byte)-1;
                this.isAuto = ImmutableFeatureProviderSqlData.this.isAutoInitialize();
                this.isAutoBuildStage = 1;
            }
            return this.isAuto;
        }

        boolean isAutoPersist() {
            if (this.isAutoPersistBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAutoPersistBuildStage == 0) {
                this.isAutoPersistBuildStage = (byte)-1;
                this.isAutoPersist = ImmutableFeatureProviderSqlData.this.isAutoPersistInitialize();
                this.isAutoPersistBuildStage = 1;
            }
            return this.isAutoPersist;
        }

        List<ExtensionConfiguration> getMergedExtensions() {
            if (this.mergedExtensionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mergedExtensionsBuildStage == 0) {
                this.mergedExtensionsBuildStage = (byte)-1;
                this.mergedExtensions = Objects.requireNonNull(ImmutableFeatureProviderSqlData.this.getMergedExtensionsInitialize(), "mergedExtensions");
                this.mergedExtensionsBuildStage = 1;
            }
            return this.mergedExtensions;
        }

        long getEntitySchemaVersion() {
            if (this.entitySchemaVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.entitySchemaVersionBuildStage == 0) {
                this.entitySchemaVersionBuildStage = (byte)-1;
                this.entitySchemaVersion = ImmutableFeatureProviderSqlData.this.getEntitySchemaVersionInitialize();
                this.entitySchemaVersionBuildStage = 1;
            }
            return this.entitySchemaVersion;
        }

        Optional<String> getEntitySubType() {
            if (this.entitySubTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.entitySubTypeBuildStage == 0) {
                this.entitySubTypeBuildStage = (byte)-1;
                this.entitySubType = Objects.requireNonNull(ImmutableFeatureProviderSqlData.this.getEntitySubTypeInitialize(), "entitySubType");
                this.entitySubTypeBuildStage = 1;
            }
            return this.entitySubType;
        }

        ValidationResult.MODE getTypeValidation() {
            if (this.typeValidationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeValidationBuildStage == 0) {
                this.typeValidationBuildStage = (byte)-1;
                this.typeValidation = Objects.requireNonNull(ImmutableFeatureProviderSqlData.this.getTypeValidationInitialize(), "typeValidation");
                this.typeValidationBuildStage = 1;
            }
            return this.typeValidation;
        }

        void typeValidation(ValidationResult.MODE typeValidation) {
            this.typeValidation = typeValidation;
            this.typeValidationBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.storageVersionBuildStage == -1) {
                attributes.add("storageVersion");
            }
            if (this.createdAtBuildStage == -1) {
                attributes.add("createdAt");
            }
            if (this.lastModifiedBuildStage == -1) {
                attributes.add("lastModified");
            }
            if (this.entityStorageVersionBuildStage == -1) {
                attributes.add("entityStorageVersion");
            }
            if (this.isAutoBuildStage == -1) {
                attributes.add("isAuto");
            }
            if (this.isAutoPersistBuildStage == -1) {
                attributes.add("isAutoPersist");
            }
            if (this.mergedExtensionsBuildStage == -1) {
                attributes.add("mergedExtensions");
            }
            if (this.entitySchemaVersionBuildStage == -1) {
                attributes.add("entitySchemaVersion");
            }
            if (this.entitySubTypeBuildStage == -1) {
                attributes.add("entitySubType");
            }
            if (this.typeValidationBuildStage == -1) {
                attributes.add("typeValidation");
            }
            return "Cannot build FeatureProviderSqlData, attribute initializers form cycle " + attributes;
        }
    }
}

