/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.features.domain.ConnectionInfo;
import de.ii.xtraplatform.features.sql.domain.ConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.FeatureActionTrigger;
import de.ii.xtraplatform.features.sql.domain.ImmutableFeatureActionTrigger;
import de.ii.xtraplatform.features.sql.domain.ImmutablePoolSettings;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlPathDefaults;
import de.ii.xtraplatform.features.sql.domain.SqlPathDefaults;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConnectionInfoSql", generator="Immutables")
@Immutable
public final class ImmutableConnectionInfoSql
implements ConnectionInfoSql {
    @Nullable
    private final String connectionUri;
    private final transient String connectorType;
    private final ConnectionInfoSql.Dialect dialect;
    private final String database;
    @Nullable
    private final String host;
    @Nullable
    private final String user;
    @Nullable
    private final String password;
    private final ImmutableList<String> schemas;
    @Nullable
    private final ImmutablePoolSettings pool;
    private final Map<String, Object> driverOptions;
    @Nullable
    private final FeatureActionTrigger triggers;
    @Nullable
    private final Integer maxConnections;
    @Nullable
    private final Integer minConnections;
    @Nullable
    private final Boolean initFailFast;
    @Nullable
    private final Boolean computeNumberMatched;
    @Nullable
    private final SqlPathDefaults pathSyntax;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long IS_SHARED_LAZY_INIT_BIT = 1L;
    private transient boolean isShared;

    private ImmutableConnectionInfoSql(Builder builder) {
        this.connectionUri = builder.connectionUri;
        this.database = builder.database;
        this.host = builder.host;
        this.user = builder.user;
        this.password = builder.password;
        this.schemas = builder.schemas.build();
        this.pool = builder.pool == null ? null : ImmutableConnectionInfoSql.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutablePoolSettings(builder.pool);
        this.driverOptions = builder.driverOptions_build();
        this.triggers = ImmutableConnectionInfoSql.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableFeatureActionTrigger(builder.triggers);
        this.maxConnections = builder.maxConnections;
        this.minConnections = builder.minConnections;
        this.initFailFast = builder.initFailFast;
        this.computeNumberMatched = builder.computeNumberMatched;
        this.pathSyntax = ImmutableConnectionInfoSql.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(builder.pathSyntax);
        if (builder.dialect != null) {
            this.initShim.dialect(builder.dialect);
        }
        this.connectorType = this.initShim.getConnectorType();
        this.dialect = this.initShim.getDialect();
        this.initShim = null;
    }

    private ImmutableConnectionInfoSql(@Nullable String connectionUri, ConnectionInfoSql.Dialect dialect, String database, @Nullable String host, @Nullable String user, @Nullable String password, ImmutableList<String> schemas, @Nullable ImmutablePoolSettings pool, Map<String, Object> driverOptions, @Nullable FeatureActionTrigger triggers, @Nullable Integer maxConnections, @Nullable Integer minConnections, @Nullable Boolean initFailFast, @Nullable Boolean computeNumberMatched, @Nullable SqlPathDefaults pathSyntax) {
        this.connectionUri = connectionUri;
        this.initShim.dialect(dialect);
        this.database = database;
        this.host = host;
        this.user = user;
        this.password = password;
        this.schemas = schemas;
        this.pool = pool;
        this.driverOptions = driverOptions;
        this.triggers = triggers;
        this.maxConnections = maxConnections;
        this.minConnections = minConnections;
        this.initFailFast = initFailFast;
        this.computeNumberMatched = computeNumberMatched;
        this.pathSyntax = pathSyntax;
        this.connectorType = this.initShim.getConnectorType();
        this.dialect = this.initShim.getDialect();
        this.initShim = null;
    }

    private String getConnectorTypeInitialize() {
        return ConnectionInfoSql.super.getConnectorType();
    }

    private ConnectionInfoSql.Dialect getDialectInitialize() {
        return ConnectionInfoSql.super.getDialect();
    }

    @Override
    @JsonProperty(value="connectionUri")
    public Optional<String> getConnectionUri() {
        return Optional.ofNullable(this.connectionUri);
    }

    @Override
    @JsonProperty(value="connectorType")
    public String getConnectorType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConnectorType() : this.connectorType;
    }

    @Override
    @JsonProperty(value="dialect")
    public ConnectionInfoSql.Dialect getDialect() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDialect() : this.dialect;
    }

    @Override
    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database;
    }

    @Override
    @JsonProperty(value="host")
    public Optional<String> getHost() {
        return Optional.ofNullable(this.host);
    }

    @Override
    @JsonProperty(value="user")
    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    @Override
    @JsonProperty(value="password")
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @JsonProperty(value="schemas")
    public ImmutableList<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty(value="pool", access=JsonProperty.Access.WRITE_ONLY)
    @Nullable
    public ImmutablePoolSettings getPool() {
        return this.pool;
    }

    @Override
    @JsonProperty(value="driverOptions")
    public Map<String, Object> getDriverOptions() {
        return this.driverOptions;
    }

    @Override
    @JsonProperty(value="triggers")
    public Optional<FeatureActionTrigger> getTriggers() {
        return Optional.ofNullable(this.triggers);
    }

    @Override
    @JsonAlias(value={"maxThreads"})
    @JsonProperty(value="maxConnections", access=JsonProperty.Access.WRITE_ONLY)
    @Deprecated
    public OptionalInt getMaxConnections() {
        return this.maxConnections != null ? OptionalInt.of(this.maxConnections) : OptionalInt.empty();
    }

    @Override
    @JsonProperty(value="minConnections", access=JsonProperty.Access.WRITE_ONLY)
    @Deprecated
    public OptionalInt getMinConnections() {
        return this.minConnections != null ? OptionalInt.of(this.minConnections) : OptionalInt.empty();
    }

    @Override
    @JsonProperty(value="initFailFast", access=JsonProperty.Access.WRITE_ONLY)
    @Deprecated
    public Optional<Boolean> getInitFailFast() {
        return Optional.ofNullable(this.initFailFast);
    }

    @Override
    @JsonProperty(value="shadow.computeNumberMatched", access=JsonProperty.Access.WRITE_ONLY)
    @Deprecated
    public Optional<Boolean> getComputeNumberMatched() {
        return Optional.ofNullable(this.computeNumberMatched);
    }

    @Override
    @JsonProperty(value="pathSyntax", access=JsonProperty.Access.WRITE_ONLY)
    @Deprecated
    public Optional<SqlPathDefaults> getPathSyntax() {
        return Optional.ofNullable(this.pathSyntax);
    }

    public final ImmutableConnectionInfoSql withConnectionUri(String value) {
        String newValue = Objects.requireNonNull(value, "connectionUri");
        if (Objects.equals(this.connectionUri, newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(newValue, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withConnectionUri(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.connectionUri, value)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(value, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withDialect(ConnectionInfoSql.Dialect value) {
        if (this.dialect == value) {
            return this;
        }
        ConnectionInfoSql.Dialect newValue = Objects.requireNonNull(value, "dialect");
        if (this.dialect.equals((Object)newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, newValue, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withDatabase(String value) {
        String newValue = Objects.requireNonNull(value, "database");
        if (this.database.equals(newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, newValue, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (Objects.equals(this.host, newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, newValue, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withHost(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.host, value)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, value, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withUser(String value) {
        String newValue = Objects.requireNonNull(value, "user");
        if (Objects.equals(this.user, newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, newValue, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withUser(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.user, value)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, value, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (Objects.equals(this.password, newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, newValue, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withPassword(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.password, value)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, value, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withSchemas(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, newValue, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withSchemas(Iterable<String> elements) {
        if (this.schemas == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, newValue, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withPool(@Nullable ConnectionInfoSql.PoolSettings value) {
        if (this.pool == value) {
            return this;
        }
        ImmutablePoolSettings newValue = new ImmutablePoolSettings.Builder().from(value).build();
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, newValue, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public ImmutableConnectionInfoSql withDriverOptions(Map<String, Object> value) {
        Map<String, Object> newValue = value;
        if (this.driverOptions == newValue) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, newValue, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withTriggers(FeatureActionTrigger value) {
        FeatureActionTrigger newValue = Objects.requireNonNull(value, "triggers");
        if (this.triggers == newValue) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, newValue, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    public final ImmutableConnectionInfoSql withTriggers(Optional<? extends FeatureActionTrigger> optional) {
        FeatureActionTrigger value = optional.orElse(null);
        if (this.triggers == value) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, value, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withMaxConnections(int value) {
        Integer newValue = value;
        if (Objects.equals(this.maxConnections, newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, newValue, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withMaxConnections(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.maxConnections, value)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, value, this.minConnections, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withMinConnections(int value) {
        Integer newValue = value;
        if (Objects.equals(this.minConnections, newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, newValue, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withMinConnections(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.minConnections, value)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, value, this.initFailFast, this.computeNumberMatched, this.pathSyntax));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withInitFailFast(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.initFailFast, newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, newValue, this.computeNumberMatched, this.pathSyntax));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withInitFailFast(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.initFailFast, value)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, value, this.computeNumberMatched, this.pathSyntax));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withComputeNumberMatched(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.computeNumberMatched, newValue)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, newValue, this.pathSyntax));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withComputeNumberMatched(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.computeNumberMatched, value)) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, value, this.pathSyntax));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withPathSyntax(SqlPathDefaults value) {
        SqlPathDefaults newValue = Objects.requireNonNull(value, "pathSyntax");
        if (this.pathSyntax == newValue) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, newValue));
    }

    @Deprecated
    public final ImmutableConnectionInfoSql withPathSyntax(Optional<? extends SqlPathDefaults> optional) {
        SqlPathDefaults value = optional.orElse(null);
        if (this.pathSyntax == value) {
            return this;
        }
        return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this.connectionUri, this.dialect, this.database, this.host, this.user, this.password, this.schemas, this.pool, this.driverOptions, this.triggers, this.maxConnections, this.minConnections, this.initFailFast, this.computeNumberMatched, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConnectionInfoSql && this.equalTo((ImmutableConnectionInfoSql)another);
    }

    private boolean equalTo(ImmutableConnectionInfoSql another) {
        return Objects.equals(this.connectionUri, another.connectionUri) && this.connectorType.equals(another.connectorType) && this.dialect.equals((Object)another.dialect) && this.database.equals(another.database) && Objects.equals(this.host, another.host) && Objects.equals(this.user, another.user) && Objects.equals(this.password, another.password) && this.schemas.equals(another.schemas) && Objects.equals(this.pool, another.pool) && this.getDriverOptions().equals(another.getDriverOptions()) && Objects.equals(this.triggers, another.triggers) && Objects.equals(this.maxConnections, another.maxConnections) && Objects.equals(this.minConnections, another.minConnections) && Objects.equals(this.initFailFast, another.initFailFast) && Objects.equals(this.computeNumberMatched, another.computeNumberMatched) && Objects.equals(this.pathSyntax, another.pathSyntax);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.connectionUri);
        h += (h << 5) + this.connectorType.hashCode();
        h += (h << 5) + this.dialect.hashCode();
        h += (h << 5) + this.database.hashCode();
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.password);
        h += (h << 5) + this.schemas.hashCode();
        h += (h << 5) + Objects.hashCode(this.pool);
        h += (h << 5) + this.getDriverOptions().hashCode();
        h += (h << 5) + Objects.hashCode(this.triggers);
        h += (h << 5) + Objects.hashCode(this.maxConnections);
        h += (h << 5) + Objects.hashCode(this.minConnections);
        h += (h << 5) + Objects.hashCode(this.initFailFast);
        h += (h << 5) + Objects.hashCode(this.computeNumberMatched);
        h += (h << 5) + Objects.hashCode(this.pathSyntax);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ConnectionInfoSql").omitNullValues().add("connectionUri", this.connectionUri).add("connectorType", this.connectorType).add("dialect", (Object)this.dialect).add("database", this.database).add("host", this.host).add("user", this.user).add("password", this.password).add("schemas", this.schemas).add("pool", this.pool).add("driverOptions", this.getDriverOptions().toString()).add("triggers", this.triggers).add("maxConnections", this.maxConnections).add("minConnections", this.minConnections).add("initFailFast", this.initFailFast).add("shadow.computeNumberMatched", this.computeNumberMatched).add("pathSyntax", this.pathSyntax).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShared() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableConnectionInfoSql immutableConnectionInfoSql = this;
            synchronized (immutableConnectionInfoSql) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.isShared = ConnectionInfoSql.super.isShared();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.isShared;
    }

    private static ImmutableConnectionInfoSql validate(ImmutableConnectionInfoSql instance) {
        instance = (ImmutableConnectionInfoSql)instance.initNestedDefault();
        return instance;
    }

    public static ImmutableConnectionInfoSql copyOf(ConnectionInfoSql instance) {
        if (instance instanceof ImmutableConnectionInfoSql) {
            return (ImmutableConnectionInfoSql)instance;
        }
        return new Builder().from(instance).build();
    }

    @Nullable
    private static ImmutablePoolSettings convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutablePoolSettings(@Nullable ImmutablePoolSettings.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static ConnectionInfoSql.PoolSettings convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutablePoolSettings(@Nullable ConnectionInfoSql.PoolSettings value) {
        if (value == null) {
            return null;
        }
        return new ImmutablePoolSettings.Builder().from(value).build();
    }

    @Nullable
    private static ImmutablePoolSettings.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutablePoolSettings(@Nullable ConnectionInfoSql.PoolSettings value) {
        if (value == null) {
            return null;
        }
        return new ImmutablePoolSettings.Builder().from(value);
    }

    @Nullable
    private static ImmutableFeatureActionTrigger convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableFeatureActionTrigger(@Nullable ImmutableFeatureActionTrigger.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static FeatureActionTrigger convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableFeatureActionTrigger(@Nullable FeatureActionTrigger value) {
        if (value == null) {
            return null;
        }
        return new ImmutableFeatureActionTrigger.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableFeatureActionTrigger.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableFeatureActionTrigger(@Nullable FeatureActionTrigger value) {
        if (value == null) {
            return null;
        }
        return new ImmutableFeatureActionTrigger.Builder().from(value);
    }

    @Nullable
    private static ImmutableSqlPathDefaults convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable ImmutableSqlPathDefaults.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static SqlPathDefaults convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable SqlPathDefaults value) {
        if (value == null) {
            return null;
        }
        return new ImmutableSqlPathDefaults.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableSqlPathDefaults.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable SqlPathDefaults value) {
        if (value == null) {
            return null;
        }
        return new ImmutableSqlPathDefaults.Builder().from(value);
    }

    @Generated(from="ConnectionInfoSql", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATABASE = 1L;
        private long initBits = 1L;
        private Map<String, Object> driverOptions_mergeableMap = new LinkedHashMap<String, Object>();
        @Nullable
        private String connectionUri;
        @Nullable
        private ConnectionInfoSql.Dialect dialect;
        @Nullable
        private String database;
        @Nullable
        private String host;
        @Nullable
        private String user;
        @Nullable
        private String password;
        private ImmutableList.Builder<String> schemas = ImmutableList.builder();
        @Nullable
        private ImmutablePoolSettings.Builder pool;
        @Nullable
        private ImmutableFeatureActionTrigger.Builder triggers;
        @Nullable
        private Integer maxConnections;
        @Nullable
        private Integer minConnections;
        @Nullable
        private Boolean initFailFast;
        @Nullable
        private Boolean computeNumberMatched;
        @Nullable
        private ImmutableSqlPathDefaults.Builder pathSyntax;

        @CanIgnoreReturnValue
        public final Builder from(ConnectionInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ConnectionInfoSql instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ConnectionInfo instance;
            Optional<String> connectionUriOptional;
            if (object instanceof ConnectionInfo && (connectionUriOptional = (instance = (ConnectionInfo)object).getConnectionUri()).isPresent()) {
                this.connectionUri(connectionUriOptional);
            }
            if (object instanceof ConnectionInfoSql) {
                OptionalInt maxConnectionsOptional;
                Optional<String> userOptional;
                Optional<Boolean> initFailFastOptional;
                Optional<String> hostOptional;
                Optional<Boolean> computeNumberMatchedOptional;
                OptionalInt minConnectionsOptional;
                Optional<FeatureActionTrigger> triggersOptional;
                instance = (ConnectionInfoSql)object;
                this.driverOptions(instance.getDriverOptions());
                this.dialect(instance.getDialect());
                ConnectionInfoSql.PoolSettings poolValue = instance.getPool();
                if (poolValue != null) {
                    this.pool(poolValue);
                }
                if ((triggersOptional = instance.getTriggers()).isPresent()) {
                    this.triggers(triggersOptional);
                }
                this.database(instance.getDatabase());
                Optional<String> passwordOptional = instance.getPassword();
                if (passwordOptional.isPresent()) {
                    this.password(passwordOptional);
                }
                if ((minConnectionsOptional = instance.getMinConnections()).isPresent()) {
                    this.minConnections(minConnectionsOptional);
                }
                if ((computeNumberMatchedOptional = instance.getComputeNumberMatched()).isPresent()) {
                    this.computeNumberMatched(computeNumberMatchedOptional);
                }
                this.addAllSchemas(instance.getSchemas());
                Optional<SqlPathDefaults> pathSyntaxOptional = instance.getPathSyntax();
                if (pathSyntaxOptional.isPresent()) {
                    this.pathSyntax(pathSyntaxOptional);
                }
                if ((hostOptional = instance.getHost()).isPresent()) {
                    this.host(hostOptional);
                }
                if ((initFailFastOptional = instance.getInitFailFast()).isPresent()) {
                    this.initFailFast(initFailFastOptional);
                }
                if ((userOptional = instance.getUser()).isPresent()) {
                    this.user(userOptional);
                }
                if ((maxConnectionsOptional = instance.getMaxConnections()).isPresent()) {
                    this.maxConnections(maxConnectionsOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder connectionUri(String connectionUri) {
            this.connectionUri = Objects.requireNonNull(connectionUri, "connectionUri");
            return this;
        }

        @JsonProperty(value="connectionUri")
        @CanIgnoreReturnValue
        public final Builder connectionUri(Optional<String> connectionUri) {
            this.connectionUri = connectionUri.orElse(null);
            return this;
        }

        @JsonProperty(value="dialect")
        @CanIgnoreReturnValue
        public final Builder dialect(ConnectionInfoSql.Dialect dialect) {
            this.dialect = Objects.requireNonNull(dialect, "dialect");
            return this;
        }

        @JsonProperty(value="database")
        @CanIgnoreReturnValue
        public final Builder database(String database) {
            this.database = Objects.requireNonNull(database, "database");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @JsonProperty(value="host")
        @CanIgnoreReturnValue
        public final Builder host(Optional<String> host) {
            this.host = host.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder user(String user) {
            this.user = Objects.requireNonNull(user, "user");
            return this;
        }

        @JsonProperty(value="user")
        @CanIgnoreReturnValue
        public final Builder user(Optional<String> user) {
            this.user = user.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            return this;
        }

        @JsonProperty(value="password")
        @CanIgnoreReturnValue
        public final Builder password(Optional<String> password) {
            this.password = password.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemas(String element) {
            this.schemas.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemas(String ... elements) {
            this.schemas.add(elements);
            return this;
        }

        @JsonProperty(value="schemas")
        @CanIgnoreReturnValue
        public final Builder schemas(Iterable<String> elements) {
            this.schemas = ImmutableList.builder();
            return this.addAllSchemas(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemas(Iterable<String> elements) {
            this.schemas.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="pool", access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder pool(@Nullable ConnectionInfoSql.PoolSettings pool) {
            this.pool = new ImmutablePoolSettings.Builder().from(pool == null ? null : Builder.convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutablePoolSettings(pool));
            return this;
        }

        @JsonProperty(value="pool", access=JsonProperty.Access.WRITE_ONLY)
        public final ImmutablePoolSettings.Builder poolBuilder() {
            if (this.pool == null) {
                this.pool = new ImmutablePoolSettings.Builder();
            }
            return this.pool;
        }

        @JsonProperty(value="pool", access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder poolBuilder(@Nullable ImmutablePoolSettings.Builder pool) {
            this.pool = pool;
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="driverOptions")
        @CanIgnoreReturnValue
        public Builder driverOptions(Map<String, Object> values) {
            this.driverOptions_mergeableMap = new LinkedHashMap<String, Object>();
            values.forEach(this::putDriverOptions);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putDriverOptions(String key, Object value) {
            this.driverOptions_mergeableMap.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder putAllDriverOptions(Map<String, Object> values) {
            values.forEach(this::putDriverOptions);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public Builder setDriverOptions(Map<String, Object> values) {
            values.forEach(this::putDriverOptions);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggers(FeatureActionTrigger triggers) {
            this.triggers = new ImmutableFeatureActionTrigger.Builder().from(Objects.requireNonNull(triggers, "triggers"));
            return this;
        }

        @JsonProperty(value="triggers")
        public final ImmutableFeatureActionTrigger.Builder triggersBuilder() {
            if (this.triggers == null) {
                this.triggers = new ImmutableFeatureActionTrigger.Builder();
            }
            return this.triggers;
        }

        @JsonProperty(value="triggers")
        @CanIgnoreReturnValue
        public final Builder triggersBuilder(ImmutableFeatureActionTrigger.Builder triggers) {
            this.triggers = triggers;
            return this;
        }

        @JsonProperty(value="triggers")
        @CanIgnoreReturnValue
        public final Builder triggers(Optional<? extends FeatureActionTrigger> triggers) {
            this.triggers = Builder.convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableFeatureActionTrigger(triggers.orElse(null));
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        @JsonAlias(value={"maxThreads"})
        @JsonProperty(value="maxConnections", access=JsonProperty.Access.WRITE_ONLY)
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxConnections(OptionalInt maxConnections) {
            this.maxConnections = maxConnections.isPresent() ? Integer.valueOf(maxConnections.getAsInt()) : null;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder minConnections(int minConnections) {
            this.minConnections = minConnections;
            return this;
        }

        @JsonProperty(value="minConnections", access=JsonProperty.Access.WRITE_ONLY)
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder minConnections(OptionalInt minConnections) {
            this.minConnections = minConnections.isPresent() ? Integer.valueOf(minConnections.getAsInt()) : null;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder initFailFast(boolean initFailFast) {
            this.initFailFast = initFailFast;
            return this;
        }

        @JsonProperty(value="initFailFast", access=JsonProperty.Access.WRITE_ONLY)
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder initFailFast(Optional<Boolean> initFailFast) {
            this.initFailFast = initFailFast.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder computeNumberMatched(boolean computeNumberMatched) {
            this.computeNumberMatched = computeNumberMatched;
            return this;
        }

        @JsonProperty(value="shadow.computeNumberMatched", access=JsonProperty.Access.WRITE_ONLY)
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder computeNumberMatched(Optional<Boolean> computeNumberMatched) {
            this.computeNumberMatched = computeNumberMatched.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder pathSyntax(SqlPathDefaults pathSyntax) {
            this.pathSyntax = new ImmutableSqlPathDefaults.Builder().from(Objects.requireNonNull(pathSyntax, "pathSyntax"));
            return this;
        }

        @JsonProperty(value="pathSyntax", access=JsonProperty.Access.WRITE_ONLY)
        @Deprecated
        public final ImmutableSqlPathDefaults.Builder pathSyntaxBuilder() {
            if (this.pathSyntax == null) {
                this.pathSyntax = new ImmutableSqlPathDefaults.Builder();
            }
            return this.pathSyntax;
        }

        @JsonProperty(value="pathSyntax", access=JsonProperty.Access.WRITE_ONLY)
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder pathSyntaxBuilder(ImmutableSqlPathDefaults.Builder pathSyntax) {
            this.pathSyntax = pathSyntax;
            return this;
        }

        @JsonProperty(value="pathSyntax", access=JsonProperty.Access.WRITE_ONLY)
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder pathSyntax(Optional<? extends SqlPathDefaults> pathSyntax) {
            this.pathSyntax = Builder.convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(pathSyntax.orElse(null));
            return this;
        }

        public ImmutableConnectionInfoSql build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableConnectionInfoSql.validate(new ImmutableConnectionInfoSql(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("database");
            }
            return "Cannot build ConnectionInfoSql, some of required attributes are not set " + attributes;
        }

        private Map<String, Object> driverOptions_build() {
            return ImmutableMap.copyOf(this.driverOptions_mergeableMap);
        }

        @JsonProperty
        public Map<String, Object> getDriverOptions() {
            return this.driverOptions_mergeableMap;
        }

        @Nullable
        private static ImmutablePoolSettings convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutablePoolSettings(@Nullable ImmutablePoolSettings.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static ConnectionInfoSql.PoolSettings convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutablePoolSettings(@Nullable ConnectionInfoSql.PoolSettings value) {
            if (value == null) {
                return null;
            }
            return new ImmutablePoolSettings.Builder().from(value).build();
        }

        @Nullable
        private static ImmutablePoolSettings.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutablePoolSettings(@Nullable ConnectionInfoSql.PoolSettings value) {
            if (value == null) {
                return null;
            }
            return new ImmutablePoolSettings.Builder().from(value);
        }

        @Nullable
        private static ImmutableFeatureActionTrigger convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableFeatureActionTrigger(@Nullable ImmutableFeatureActionTrigger.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static FeatureActionTrigger convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableFeatureActionTrigger(@Nullable FeatureActionTrigger value) {
            if (value == null) {
                return null;
            }
            return new ImmutableFeatureActionTrigger.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableFeatureActionTrigger.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableFeatureActionTrigger(@Nullable FeatureActionTrigger value) {
            if (value == null) {
                return null;
            }
            return new ImmutableFeatureActionTrigger.Builder().from(value);
        }

        @Nullable
        private static ImmutableSqlPathDefaults convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable ImmutableSqlPathDefaults.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static SqlPathDefaults convertToValueTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable SqlPathDefaults value) {
            if (value == null) {
                return null;
            }
            return new ImmutableSqlPathDefaults.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableSqlPathDefaults.Builder convertToBuilderTypede_ii_xtraplatform_features_sql_domain_ImmutableSqlPathDefaults(@Nullable SqlPathDefaults value) {
            if (value == null) {
                return null;
            }
            return new ImmutableSqlPathDefaults.Builder().from(value);
        }
    }

    @Generated(from="ConnectionInfoSql", generator="Immutables")
    private final class InitShim {
        private byte connectorTypeBuildStage = 0;
        private String connectorType;
        private byte dialectBuildStage = 0;
        private ConnectionInfoSql.Dialect dialect;

        private InitShim() {
        }

        String getConnectorType() {
            if (this.connectorTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.connectorTypeBuildStage == 0) {
                this.connectorTypeBuildStage = (byte)-1;
                this.connectorType = Objects.requireNonNull(ImmutableConnectionInfoSql.this.getConnectorTypeInitialize(), "connectorType");
                this.connectorTypeBuildStage = 1;
            }
            return this.connectorType;
        }

        ConnectionInfoSql.Dialect getDialect() {
            if (this.dialectBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dialectBuildStage == 0) {
                this.dialectBuildStage = (byte)-1;
                this.dialect = Objects.requireNonNull(ImmutableConnectionInfoSql.this.getDialectInitialize(), "dialect");
                this.dialectBuildStage = 1;
            }
            return this.dialect;
        }

        void dialect(ConnectionInfoSql.Dialect dialect) {
            this.dialect = dialect;
            this.dialectBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.connectorTypeBuildStage == -1) {
                attributes.add("connectorType");
            }
            if (this.dialectBuildStage == -1) {
                attributes.add("dialect");
            }
            return "Cannot build ConnectionInfoSql, attribute initializers form cycle " + attributes;
        }
    }
}

