/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.features.domain.ExtensionConfiguration;
import de.ii.xtraplatform.features.domain.FeatureProviderDataV2;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ImmutableFeatureSchema;
import de.ii.xtraplatform.features.domain.WithConnectionInfo;
import de.ii.xtraplatform.features.sql.domain.ConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.ImmutableConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.ImmutableFeatureProviderSqlData;
import de.ii.xtraplatform.features.sql.domain.ImmutableQueryGeneratorSettings;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlPathDefaults;
import de.ii.xtraplatform.features.sql.domain.SqlPathDefaults;
import de.ii.xtraplatform.store.domain.entities.EntityDataBuilder;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.BuildableMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableFeatureProviderSqlData.Builder.class)
@Value.Immutable
public interface FeatureProviderSqlData
extends FeatureProviderDataV2,
WithConnectionInfo<ConnectionInfoSql> {
    @Override
    @Nullable
    public ConnectionInfoSql getConnectionInfo();

    @Nullable
    public SqlPathDefaults getSourcePathDefaults();

    @JsonProperty(value="queryGeneration", access=JsonProperty.Access.WRITE_ONLY)
    @Nullable
    public QueryGeneratorSettings getQueryGeneration();

    @Override
    public BuildableMap<FeatureSchema, ImmutableFeatureSchema.Builder> getTypes();

    @Value.Check
    default public FeatureProviderSqlData initNestedDefault() {
        boolean sourcePathDefaultsDiffers;
        if (Objects.isNull(this.getConnectionInfo())) {
            ImmutableFeatureProviderSqlData.Builder builder = new ImmutableFeatureProviderSqlData.Builder().from(this);
            builder.connectionInfoBuilder().database("");
            return builder.build();
        }
        boolean queryGenerationIsNull = Objects.isNull(this.getQueryGeneration());
        boolean computeNumberMatchedDiffers = !queryGenerationIsNull && this.getConnectionInfo().getComputeNumberMatched().isPresent() && !Objects.equals(this.getConnectionInfo().getComputeNumberMatched().get(), this.getQueryGeneration().getComputeNumberMatched());
        boolean sourcePathDefaultsIsNull = Objects.isNull(this.getSourcePathDefaults());
        boolean bl = sourcePathDefaultsDiffers = !sourcePathDefaultsIsNull && this.getConnectionInfo().getPathSyntax().isPresent() && !Objects.equals(this.getConnectionInfo().getPathSyntax().get(), this.getSourcePathDefaults());
        if (queryGenerationIsNull || computeNumberMatchedDiffers || sourcePathDefaultsIsNull || sourcePathDefaultsDiffers) {
            ImmutableFeatureProviderSqlData.Builder builder = new ImmutableFeatureProviderSqlData.Builder().from(this);
            ImmutableConnectionInfoSql.Builder connectionInfoBuilder = builder.connectionInfoBuilder();
            if (queryGenerationIsNull || computeNumberMatchedDiffers) {
                ImmutableQueryGeneratorSettings.Builder queryGenerationBuilder = builder.queryGenerationBuilder();
                this.getConnectionInfo().getComputeNumberMatched().ifPresent(computeNumberMatched -> {
                    queryGenerationBuilder.computeNumberMatched((boolean)computeNumberMatched);
                    connectionInfoBuilder.computeNumberMatched(Optional.empty());
                });
            }
            if (sourcePathDefaultsIsNull || sourcePathDefaultsDiffers) {
                ImmutableSqlPathDefaults.Builder sourcePathDefaultsBuilder = builder.sourcePathDefaultsBuilder();
                this.getConnectionInfo().getPathSyntax().ifPresent(pathSyntax -> {
                    if (!Objects.equals(pathSyntax.getSortKey(), "id")) {
                        sourcePathDefaultsBuilder.sortKey(pathSyntax.getSortKey());
                    }
                    if (!Objects.equals(pathSyntax.getPrimaryKey(), "id")) {
                        sourcePathDefaultsBuilder.primaryKey(pathSyntax.getPrimaryKey());
                    }
                    if (pathSyntax.getJunctionTablePattern().isPresent()) {
                        sourcePathDefaultsBuilder.junctionTablePattern(pathSyntax.getJunctionTablePattern());
                    }
                    connectionInfoBuilder.pathSyntax(Optional.empty());
                });
            }
            return builder.build();
        }
        return this;
    }

    @Value.Check
    default public FeatureProviderSqlData mergeExtensions() {
        List<ExtensionConfiguration> distinctExtensions = this.getMergedExtensions();
        if (this.getExtensions().size() > distinctExtensions.size()) {
            return ((ImmutableFeatureProviderSqlData.Builder)new ImmutableFeatureProviderSqlData.Builder().from(this).extensions(distinctExtensions)).build();
        }
        return this;
    }

    @JsonDeserialize(builder=ImmutableQueryGeneratorSettings.Builder.class)
    @Value.Immutable
    public static interface QueryGeneratorSettings {
        @Value.Default
        default public boolean getComputeNumberMatched() {
            return true;
        }

        @Value.Default
        default public Optional<String> getAccentiCollation() {
            return Optional.empty();
        }
    }

    public static abstract class Builder
    extends FeatureProviderDataV2.Builder<ImmutableFeatureProviderSqlData.Builder>
    implements EntityDataBuilder<FeatureProviderDataV2> {
        public abstract ImmutableFeatureProviderSqlData.Builder connectionInfo(ConnectionInfoSql var1);

        public ImmutableFeatureProviderSqlData.Builder fillRequiredFieldsWithPlaceholders() {
            return ((ImmutableFeatureProviderSqlData.Builder)this.id("__DEFAULT__")).providerType("__DEFAULT__").featureProviderType("__DEFAULT__").connectionInfo(new ImmutableConnectionInfoSql.Builder().database("__DEFAULT__").build());
        }
    }
}

