/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.domain;

import de.ii.xtraplatform.features.domain.ConnectionInfo;
import de.ii.xtraplatform.features.sql.domain.FeatureActionTrigger;
import de.ii.xtraplatform.features.sql.domain.ImmutableConnectionInfoSql;
import de.ii.xtraplatform.features.sql.domain.ImmutablePoolSettings;
import de.ii.xtraplatform.features.sql.domain.SqlPathDefaults;
import de.ii.xtraplatform.store.domain.entities.maptobuilder.encoding.MergeableMapEncodingEnabled;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableConnectionInfoSql.Builder.class)
@Value.Immutable
@MergeableMapEncodingEnabled
public interface ConnectionInfoSql
extends ConnectionInfo {
    @Override
    @Value.Derived
    default public String getConnectorType() {
        return "SLICK";
    }

    @Value.Default
    default public Dialect getDialect() {
        return Dialect.PGIS;
    }

    public String getDatabase();

    public Optional<String> getHost();

    public Optional<String> getUser();

    public Optional<String> getPassword();

    public List<String> getSchemas();

    @JsonProperty(value="pool", access=JsonProperty.Access.WRITE_ONLY)
    @Nullable
    public PoolSettings getPool();

    public Map<String, Object> getDriverOptions();

    public Optional<FeatureActionTrigger> getTriggers();

    @Override
    @JsonIgnore
    @Value.Lazy
    default public boolean isShared() {
        return Objects.nonNull(this.getPool()) && this.getPool().getShared();
    }

    @Deprecated(forRemoval=true, since="ldproxy 3.0.0")
    @JsonAlias(value={"maxThreads"})
    @JsonProperty(value="maxConnections", access=JsonProperty.Access.WRITE_ONLY)
    public OptionalInt getMaxConnections();

    @Deprecated(forRemoval=true, since="ldproxy 3.0.0")
    @JsonProperty(value="minConnections", access=JsonProperty.Access.WRITE_ONLY)
    public OptionalInt getMinConnections();

    @Deprecated(forRemoval=true, since="ldproxy 3.0.0")
    @JsonProperty(value="initFailFast", access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getInitFailFast();

    @Deprecated(forRemoval=true, since="ldproxy 3.0.0")
    @JsonProperty(value="shadow.computeNumberMatched", access=JsonProperty.Access.WRITE_ONLY)
    public Optional<Boolean> getComputeNumberMatched();

    @Deprecated(forRemoval=true, since="ldproxy 3.0.0")
    @JsonProperty(value="pathSyntax", access=JsonProperty.Access.WRITE_ONLY)
    public Optional<SqlPathDefaults> getPathSyntax();

    @Value.Check
    default public ConnectionInfoSql initNestedDefault() {
        boolean initFailFastDiffers;
        boolean poolIsNull = Objects.isNull(this.getPool());
        boolean maxConnectionsDiffers = !poolIsNull && this.getMaxConnections().isPresent() && !Objects.equals(this.getMaxConnections().getAsInt(), this.getPool().getMaxConnections());
        boolean minConnectionsDiffers = !poolIsNull && this.getMinConnections().isPresent() && !Objects.equals(this.getMinConnections().getAsInt(), this.getPool().getMinConnections());
        boolean bl = initFailFastDiffers = !poolIsNull && this.getInitFailFast().isPresent() && !Objects.equals(this.getInitFailFast().get(), this.getPool().getInitFailFast());
        if (poolIsNull || maxConnectionsDiffers || minConnectionsDiffers || initFailFastDiffers) {
            ImmutableConnectionInfoSql.Builder builder = new ImmutableConnectionInfoSql.Builder().from(this);
            ImmutablePoolSettings.Builder poolBuilder = builder.poolBuilder();
            if (maxConnectionsDiffers) {
                this.getMaxConnections().ifPresent(poolBuilder::maxConnections);
            }
            if (minConnectionsDiffers) {
                this.getMinConnections().ifPresent(poolBuilder::minConnections);
            }
            if (initFailFastDiffers) {
                this.getInitFailFast().ifPresent(poolBuilder::initFailFast);
            }
            return builder.build();
        }
        return this;
    }

    @JsonDeserialize(builder=ImmutablePoolSettings.Builder.class)
    @Value.Immutable
    public static interface PoolSettings {
        @Value.Default
        default public int getMaxConnections() {
            return -1;
        }

        @Value.Default
        default public int getMinConnections() {
            return this.getMaxConnections();
        }

        @Deprecated
        @Value.Default
        default public boolean getInitFailFast() {
            return true;
        }

        @Value.Default
        default public String getInitFailTimeout() {
            return "1";
        }

        @Value.Default
        default public String getIdleTimeout() {
            return "10m";
        }

        @Value.Default
        default public boolean getShared() {
            return false;
        }
    }

    public static enum Dialect {
        PGIS,
        GPKG;

    }
}

