/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.cql.domain.And;
import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.cql.domain.ImmutableCqlPredicate;
import de.ii.xtraplatform.cql.domain.ScalarExpression;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaVisitorWithFinalizer;
import de.ii.xtraplatform.features.domain.SortKey;
import de.ii.xtraplatform.features.domain.Tuple;
import de.ii.xtraplatform.features.sql.app.AliasGenerator;
import de.ii.xtraplatform.features.sql.app.FilterEncoderSql;
import de.ii.xtraplatform.features.sql.app.ImmutableSqlQueryTemplates;
import de.ii.xtraplatform.features.sql.app.JoinGenerator;
import de.ii.xtraplatform.features.sql.app.SqlQueryTemplates;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlDialect;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SqlQueryTemplatesDeriver
implements SchemaVisitorWithFinalizer<SchemaSql, List<SqlQueryTemplates.ValueQueryTemplate>, SqlQueryTemplates> {
    private static final String SKEY = "SKEY";
    private static final String CSKEY = "CSKEY";
    private static final String TAB = "  ";
    private final SqlDialect sqlDialect;
    private final FilterEncoderSql filterEncoder;
    private final AliasGenerator aliasGenerator;
    private final JoinGenerator joinGenerator;
    private final boolean computeNumberMatched;

    public SqlQueryTemplatesDeriver(FilterEncoderSql filterEncoder, SqlDialect sqlDialect, boolean computeNumberMatched) {
        this.sqlDialect = sqlDialect;
        this.filterEncoder = filterEncoder;
        this.aliasGenerator = new AliasGenerator();
        this.joinGenerator = new JoinGenerator();
        this.computeNumberMatched = computeNumberMatched;
    }

    @Override
    public List<SqlQueryTemplates.ValueQueryTemplate> visit(SchemaSql schema, List<SchemaSql> parents, List<List<SqlQueryTemplates.ValueQueryTemplate>> visitedProperties) {
        Stream current = schema.isObject() && schema.getProperties().stream().anyMatch(SchemaBase::isValue) ? Stream.of(this.createValueQueryTemplate(schema, parents)) : Stream.empty();
        return Stream.concat(current, visitedProperties.stream().flatMap(Collection::stream)).collect(Collectors.toList());
    }

    @Override
    public SqlQueryTemplates finalize(SchemaSql schema, List<SqlQueryTemplates.ValueQueryTemplate> valueQueryTemplates) {
        return new ImmutableSqlQueryTemplates.Builder().metaQueryTemplate(this.createMetaQueryTemplate(schema)).valueQueryTemplates(valueQueryTemplates).addAllQuerySchemas(schema.getAllObjects()).build();
    }

    SqlQueryTemplates.MetaQueryTemplate createMetaQueryTemplate(SchemaSql schema) {
        return (limit, offset, additionalSortKeys, cqlFilter, virtualTables) -> {
            String limitSql = limit > 0L ? String.format(" LIMIT %d", limit) : "";
            String offsetSql = offset > 0L ? String.format(" OFFSET %d", offset) : "";
            Optional<String> filter = this.getFilter(schema, cqlFilter);
            String where = filter.isPresent() ? String.format(" WHERE %s", filter.get()) : "";
            String tableName = virtualTables.containsKey(schema.getName()) ? (String)virtualTables.get(schema.getName()) : schema.getName();
            String table = String.format("%s A", tableName);
            Object columns = "";
            for (int i = 0; i < additionalSortKeys.size(); ++i) {
                SortKey sortKey = (SortKey)additionalSortKeys.get(i);
                columns = (String)columns + "A." + sortKey.getField() + " AS CSKEY_" + i + ", ";
            }
            columns = (String)columns + String.format("A.%s AS SKEY", schema.getSortKey().get());
            String orderBy = this.getOrderBy(additionalSortKeys);
            String minMaxColumns = this.getMinMaxColumns(additionalSortKeys);
            String numberReturned = String.format("SELECT %7$s, count(*) AS numberReturned FROM (SELECT %2$s FROM %1$s%6$s ORDER BY %3$s%4$s%5$s) AS IDS", table, columns, orderBy, limitSql, offsetSql, where, minMaxColumns);
            if (this.computeNumberMatched) {
                String numberMatched = String.format("SELECT count(*) AS numberMatched FROM (SELECT A.%2$s AS %4$s FROM %1$s A%3$s ORDER BY 1) AS IDS", tableName, schema.getSortKey().get(), where, SKEY);
                return String.format("WITH\n%3$s%3$sNR AS (%s),\n%3$s%3$sNM AS (%s) \n%3$sSELECT * FROM NR, NM", numberReturned, numberMatched, TAB);
            }
            return String.format("WITH\n%2$s%2$sNR AS (%s)\n%2$sSELECT *, -1::bigint AS numberMatched FROM NR", numberReturned, TAB);
        };
    }

    SqlQueryTemplates.ValueQueryTemplate createValueQueryTemplate(SchemaSql schema, List<SchemaSql> parents) {
        return (limit, offset, additionalSortKeys, filter, minMaxKeys, virtualTables) -> {
            Optional<String> whereClause;
            boolean isIdFilter = filter.flatMap(ScalarExpression::getInOperator).isPresent();
            List<String> aliases = this.aliasGenerator.getAliases(schema);
            SchemaSql rootSchema = parents.isEmpty() ? schema : (SchemaSql)parents.get(0);
            Optional<String> sqlFilter = this.getFilter(rootSchema, filter);
            Optional<String> optional = whereClause = isIdFilter ? sqlFilter : this.toWhereClause(aliases.get(0), rootSchema.getSortKey().get(), additionalSortKeys, minMaxKeys, sqlFilter);
            Optional<String> pagingClause = additionalSortKeys.isEmpty() || limit == 0L && offset == 0L ? Optional.empty() : Optional.of((limit > 0L ? String.format(" LIMIT %d", limit) : "") + (offset > 0L ? String.format(" OFFSET %d", offset) : ""));
            return this.getTableQuery(schema, whereClause, pagingClause, additionalSortKeys, parents, virtualTables);
        };
    }

    private String getTableQuery(SchemaSql schema, Optional<String> whereClause, Optional<String> pagingClause, List<SortKey> additionalSortKeys, List<SchemaSql> parents, Map<String, String> virtualTables) {
        String mainTableName;
        List<String> aliases = this.aliasGenerator.getAliases(parents, schema);
        String attributeContainerAlias = aliases.get(aliases.size() - 1);
        String string = mainTableName = parents.isEmpty() ? schema.getName() : parents.get(0).getName();
        if (virtualTables.containsKey(mainTableName)) {
            mainTableName = virtualTables.get(mainTableName);
        }
        String mainTableSortKey = parents.isEmpty() ? schema.getSortKey().get() : parents.get(0).getSortKey().get();
        String mainTable = String.format("%s %s", mainTableName, aliases.get(0));
        List<String> sortFields = this.getSortFields(schema, parents, aliases, additionalSortKeys);
        String columns = Stream.concat(sortFields.stream(), schema.getProperties().stream().filter(SchemaBase::isValue).map(column -> {
            String name;
            String string = name = column.isConstant() ? "'" + column.getConstantValue().get() + "' AS " + column.getName() : this.getQualifiedColumn(attributeContainerAlias, column.getName());
            if (column.isSpatial()) {
                return this.sqlDialect.applyToWkt(name, column.isForcePolygonCCW());
            }
            if (column.isTemporal()) {
                if (column.getType() == SchemaBase.Type.DATE) {
                    return this.sqlDialect.applyToDate(name);
                }
                return this.sqlDialect.applyToDatetime(name);
            }
            return name;
        })).collect(Collectors.joining(", "));
        Optional<String> instanceFilter = parents.isEmpty() ? Optional.empty() : parents.get(0).getFilter().map(filter -> this.filterEncoder.encode((CqlFilter)filter, (SchemaSql)parents.get(0)));
        List<Optional<String>> relationFilters = Stream.concat(parents.stream().flatMap(parent -> parent.getRelation().stream()), schema.getRelation().stream()).map(sqlRelation -> sqlRelation.getTargetFilter().flatMap(filter -> this.filterEncoder.encodeRelationFilter(Optional.of(schema), Optional.empty()))).collect(Collectors.toList());
        String join = this.joinGenerator.getJoins(schema, parents, aliases, relationFilters, Optional.empty(), Optional.empty(), instanceFilter);
        Object where = whereClause.map(w -> " WHERE " + w).orElse("");
        String paging = pagingClause.filter(p -> join.isEmpty()).orElse("");
        if (!join.isEmpty() && pagingClause.isPresent()) {
            Object where2 = " WHERE ";
            List<String> aliasesNested = this.aliasGenerator.getAliases(schema, ((String)where).isEmpty() ? 1 : 2);
            String orderBy = IntStream.range(0, sortFields.size()).boxed().map(index -> {
                if (index < additionalSortKeys.size() && ((SortKey)additionalSortKeys.get((int)index)).getDirection() == SortKey.Direction.DESCENDING) {
                    return (String)sortFields.get((int)index) + " DESC";
                }
                return (String)sortFields.get((int)index);
            }).filter(sortField -> sortField.startsWith("A.")).map(sortField -> sortField.replace("A.", (String)aliasesNested.get(0) + ".")).map(sortField -> sortField.replaceAll(" AS \\w+", "")).collect(Collectors.joining(","));
            where = where2 = (String)where2 + String.format("(A.%3$s IN (SELECT %2$s.%3$s FROM %1$s %2$s%4$s ORDER BY %5$s%6$s))", mainTableName, aliasesNested.get(0), mainTableSortKey, ((String)where).replace("(A.", "(" + aliasesNested.get(0) + "."), orderBy, pagingClause.get());
        }
        String orderBy = IntStream.rangeClosed(1, sortFields.size()).boxed().map(index -> {
            if (index <= additionalSortKeys.size() && ((SortKey)additionalSortKeys.get(index - 1)).getDirection() == SortKey.Direction.DESCENDING) {
                return index + " DESC";
            }
            return String.valueOf(index);
        }).collect(Collectors.joining(","));
        return String.format("SELECT %s FROM %s%s%s%s ORDER BY %s%s", columns, mainTable, join.isEmpty() ? "" : " ", join, where, orderBy, paging);
    }

    private Optional<String> toWhereClause(String alias, String keyField, List<SortKey> additionalSortKeys, Optional<Tuple<Object, Object>> minMaxKeys, Optional<String> additionalFilter) {
        StringBuilder filter = new StringBuilder();
        if (minMaxKeys.isPresent() && additionalSortKeys.isEmpty()) {
            filter.append("(");
            this.addMinMaxFilter(filter, alias, keyField, minMaxKeys.get().first(), minMaxKeys.get().second());
            filter.append(")");
        }
        if (additionalFilter.isPresent()) {
            if (minMaxKeys.isPresent() && additionalSortKeys.isEmpty()) {
                filter.append(" AND ");
            }
            filter.append("(").append(additionalFilter.get()).append(")");
        }
        if (filter.length() == 0) {
            return Optional.empty();
        }
        return Optional.of(filter.toString());
    }

    private StringBuilder addMinMaxFilter(StringBuilder whereClause, String alias, String keyField, Object minKey, Object maxKey) {
        return whereClause.append(alias).append(".").append(keyField).append(" >= ").append(this.formatLiteral(minKey)).append(" AND ").append(alias).append(".").append(keyField).append(" <= ").append(this.formatLiteral(maxKey));
    }

    private String formatLiteral(Object literal) {
        if (Objects.isNull(literal)) {
            return "NULL";
        }
        if (literal instanceof Number) {
            return String.valueOf(literal);
        }
        String literalString = literal instanceof Timestamp ? String.valueOf(((Timestamp)literal).toInstant()) : String.valueOf(literal);
        return String.format("'%s'", this.sqlDialect.escapeString(literalString));
    }

    private List<String> getSortFields(SchemaSql schema, List<SchemaSql> parents, List<String> aliases, List<SortKey> additionalSortKeys) {
        int[] i = new int[]{0};
        Stream<String> customSortKeys = additionalSortKeys.stream().map(sortKey -> {
            Object[] objectArray = new Object[3];
            objectArray[0] = aliases.get(0);
            objectArray[1] = sortKey.getField();
            int n = i[0];
            i[0] = n + 1;
            objectArray[2] = n;
            return String.format("%s.%s AS CSKEY_%s", objectArray);
        });
        if (!schema.getRelation().isEmpty() || !parents.isEmpty()) {
            ListIterator<String> aliasesIterator = aliases.listIterator();
            List parentSortKeys = parents.stream().flatMap(parent -> parent.getSortKeys(aliasesIterator, true, 0).stream()).collect(Collectors.toList());
            return Stream.of(customSortKeys, parentSortKeys.stream(), schema.getSortKeys(aliasesIterator, false, parentSortKeys.size()).stream()).flatMap(s -> s).collect(Collectors.toList());
        }
        return Stream.concat(customSortKeys, Stream.of(String.format("%s.%s AS SKEY", aliases.get(0), schema.getSortKey().get()))).collect(Collectors.toList());
    }

    private String getQualifiedColumn(String table, String column) {
        return column.contains("(") ? column.replaceAll("((?:\\w+\\()+)(\\w+)((?:\\))+)", "$1" + table + ".$2$3 AS $2") : String.format("%s.%s", table, column);
    }

    private Optional<String> getFilter(SchemaSql schema, Optional<CqlFilter> userFilter) {
        if (schema.getFilter().isEmpty() && userFilter.isEmpty()) {
            return Optional.empty();
        }
        if (schema.getFilter().isPresent() && schema.getRelation().isEmpty() && userFilter.isEmpty()) {
            return Optional.of(this.filterEncoder.encode(schema.getFilter().get(), schema));
        }
        if (schema.getFilter().isEmpty() && schema.getRelation().isEmpty() && userFilter.isPresent()) {
            return Optional.of(this.filterEncoder.encode(userFilter.get(), schema));
        }
        if (schema.getFilter().isPresent() && schema.getRelation().isEmpty() && userFilter.isPresent()) {
            CqlFilter mergedFilter = CqlFilter.of(And.of(ImmutableCqlPredicate.copyOf(schema.getFilter().get()), ImmutableCqlPredicate.copyOf(userFilter.get())));
            return Optional.of(this.filterEncoder.encode(mergedFilter, schema));
        }
        return Optional.empty();
    }

    private String getOrderBy(List<SortKey> sortKeys) {
        Object orderBy = "";
        for (int i = 0; i < sortKeys.size(); ++i) {
            SortKey sortKey = sortKeys.get(i);
            orderBy = (String)orderBy + "CSKEY_" + i + (sortKey.getDirection() == SortKey.Direction.DESCENDING ? " DESC" : "") + ", ";
        }
        orderBy = (String)orderBy + SKEY;
        return orderBy;
    }

    private String getMinMaxColumns(List<SortKey> sortKeys) {
        Object minMaxKeys = "";
        if (!sortKeys.isEmpty()) {
            minMaxKeys = (String)minMaxKeys + "NULL AS minKey, ";
            minMaxKeys = (String)minMaxKeys + "NULL AS maxKey";
        } else {
            minMaxKeys = (String)minMaxKeys + "MIN(SKEY) AS minKey, ";
            minMaxKeys = (String)minMaxKeys + "MAX(SKEY) AS maxKey";
        }
        return minMaxKeys;
    }
}

