/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.features.domain.FeatureStoreMultiplicityTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlMultiplicityTracker
implements FeatureStoreMultiplicityTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlMultiplicityTracker.class);
    private final Map<List<String>, Object> currentIds = new HashMap<List<String>, Object>();
    private final Map<List<String>, Integer> currentMultiplicities = new HashMap<List<String>, Integer>();
    private final Map<List<String>, Set<List<String>>> children = new LinkedHashMap<List<String>, Set<List<String>>>();

    public SqlMultiplicityTracker(List<List<String>> multiTables) {
        multiTables.forEach(table -> {
            List subPath = table.subList(0, 1);
            this.currentIds.put(subPath, null);
            this.currentIds.put((List<String>)table, null);
        });
    }

    @Override
    public void reset() {
        this.currentMultiplicities.clear();
        this.children.clear();
        this.currentIds.keySet().forEach(table -> this.currentIds.put((List<String>)table, null));
    }

    @Override
    public void track(List<String> path, List<Comparable<?>> ids) {
        int multiplicityIndex = 0;
        boolean increased = false;
        List<String> increasedMultiplicityKey = null;
        ArrayList<List<String>> parentTables = new ArrayList<List<String>>();
        for (int i = 0; i < path.size(); ++i) {
            List<String> table = path.subList(0, i + 1);
            if (!this.currentIds.containsKey(table)) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("TRACKER {} {} {}", table, multiplicityIndex, ids);
            }
            Comparable<?> id = ids.get(multiplicityIndex);
            if (increased) {
                this.currentIds.put(table, id);
                this.currentMultiplicities.put(table, 1);
            } else if (this.currentIds.containsKey(table) && !Objects.equals(id, this.currentIds.get(table))) {
                this.currentIds.put(table, id);
                this.currentMultiplicities.put(table, this.currentMultiplicities.getOrDefault(table, 0) + 1);
                increased = true;
                increasedMultiplicityKey = table;
            } else {
                this.currentMultiplicities.putIfAbsent(table, 1);
            }
            this.children.putIfAbsent(table, new HashSet());
            if (multiplicityIndex > 0) {
                parentTables.forEach(parent -> this.children.get(parent).add(table));
            }
            parentTables.add(table);
            ++multiplicityIndex;
        }
        if (increased) {
            this.children.get(increasedMultiplicityKey).forEach(child -> {
                if (!parentTables.contains(child)) {
                    this.currentMultiplicities.remove(child);
                }
            });
        }
    }

    @Override
    public List<Integer> getMultiplicitiesForPath(List<String> path) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < path.size(); ++i) {
            List<String> subPath = path.subList(0, i + 1);
            if (!this.currentIds.containsKey(subPath)) continue;
            indexes.add(this.currentMultiplicities.getOrDefault(subPath, 1));
        }
        return indexes;
    }
}

