/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.Tuple;
import de.ii.xtraplatform.features.sql.app.FeatureSql;
import de.ii.xtraplatform.features.sql.app.FeatureStoreInsertGenerator;
import de.ii.xtraplatform.features.sql.app.ObjectSql;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlPathDefaults;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.collect.ImmutableSet;

class SqlInsertGenerator2
implements FeatureStoreInsertGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlInsertGenerator2.class);
    private final EpsgCrs nativeCrs;
    private final CrsTransformerFactory crsTransformerFactory;
    private final SqlPathDefaults sqlOptions;

    public SqlInsertGenerator2(EpsgCrs nativeCrs, CrsTransformerFactory crsTransformerFactory, SqlPathDefaults sqlOptions) {
        this.nativeCrs = nativeCrs;
        this.crsTransformerFactory = crsTransformerFactory;
        this.sqlOptions = sqlOptions;
    }

    SqlPathDefaults getSqlOptions() {
        return this.sqlOptions;
    }

    @Override
    public Function<FeatureSql, Tuple<String, Consumer<String>>> createInsert(SchemaSql schema, List<Integer> parentRows, Optional<String> id) {
        Optional parentRelation = schema.getRelation().stream().findFirst();
        Optional idProperty = schema.getIdProperty();
        LinkedHashMap<String, String> valueOverrides = new LinkedHashMap<String, String>();
        if (idProperty.isPresent() && id.isPresent()) {
            valueOverrides.put(((SchemaSql)idProperty.get()).getName(), ((SchemaSql)idProperty.get()).getType() == SchemaBase.Type.STRING ? String.format("'%s'", id.get()) : id.get());
        }
        String primaryKey = schema.getPrimaryKey().orElse(this.sqlOptions.getPrimaryKey());
        Set columns0 = schema.getProperties().stream().filter(property -> !Objects.equals(property.getName(), primaryKey)).map(SchemaBase::getName).collect(ImmutableSet.toImmutableSet());
        Set columns = idProperty.isPresent() && id.isPresent() ? ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(((SchemaSql)idProperty.get()).getName())).addAll((Iterable)columns0)).build() : columns0;
        List columns2 = columns.stream().map(col -> col.startsWith("ST_AsText(ST_ForcePolygonCCW(") ? col.substring("ST_AsText(ST_ForcePolygonCCW(".length(), col.length() - 2) : col).collect(Collectors.toList());
        ArrayList<String> sortKeys = new ArrayList<String>();
        if (parentRelation.isPresent()) {
            if (((SqlRelation)parentRelation.get()).isOne2One() && Objects.equals(((SqlRelation)parentRelation.get()).getSourceSortKey().orElse("id"), ((SqlRelation)parentRelation.get()).getSourceField())) {
                sortKeys.add(0, String.format("%s.%s", ((SqlRelation)parentRelation.get()).getSourceContainer(), ((SqlRelation)parentRelation.get()).getSourceSortKey().orElse("id")));
                if (!columns2.contains(primaryKey)) {
                    columns2.add(0, primaryKey);
                }
            } else if (((SqlRelation)parentRelation.get()).isOne2N()) {
                sortKeys.add(0, String.format("%s.%s", ((SqlRelation)parentRelation.get()).getSourceContainer(), ((SqlRelation)parentRelation.get()).getSourceSortKey().get()));
                columns2.add(0, ((SqlRelation)parentRelation.get()).getTargetField());
            }
        }
        String tableName = schema.getName();
        Object columnNames = Joiner.on(',').skipNulls().join(columns2);
        if (!((String)columnNames).isEmpty()) {
            columnNames = "(" + (String)columnNames + ")";
        }
        String finalColumnNames = columnNames;
        String returningValue = " RETURNING " + (parentRelation.isPresent() && ((SqlRelation)parentRelation.get()).isOne2N() ? " null" : (idProperty.isPresent() ? ((SchemaSql)idProperty.get()).getName() : primaryKey));
        Optional<Object> returningName = parentRelation.isPresent() && ((SqlRelation)parentRelation.get()).isOne2N() ? Optional.empty() : (idProperty.isPresent() ? Optional.of(tableName + "." + ((SchemaSql)idProperty.get()).getName()) : Optional.of(tableName + "." + primaryKey));
        return feature -> {
            Optional<FeatureSql> currentRow;
            Optional<ObjectSql> optional = currentRow = schema.isFeature() ? Optional.of(feature) : feature.getNestedObject(schema.getFullPath(), parentRows);
            if (!currentRow.isPresent()) {
                return Tuple.of(null, null);
            }
            Object values = this.getColumnValues(sortKeys, columns, ((ObjectSql)currentRow.get()).getValues(this.nativeCrs, this.crsTransformerFactory), ((ObjectSql)currentRow.get()).getIds(), valueOverrides);
            values = !((String)values).isEmpty() ? "VALUES (" + (String)values + ")" : "DEFAULT VALUES";
            String query = String.format("INSERT INTO %s %s %s%s;", tableName, finalColumnNames, values, returningValue);
            Consumer<String> idConsumer = returningName.map(name -> returned -> feature.putChildrenIds((String)name, (String)returned)).orElse(returned -> {});
            return Tuple.of(query, idConsumer);
        };
    }

    @Override
    public Function<FeatureSql, Tuple<String, Consumer<String>>> createJunctionInsert(SchemaSql schema, List<Integer> parentRows) {
        if (schema.getRelation().isEmpty() || !schema.getRelation().get(0).isM2N()) {
            throw new IllegalArgumentException();
        }
        SqlRelation relation = schema.getRelation().get(0);
        String table = relation.getJunction().get();
        String columnNames = String.format("%s,%s", relation.getJunctionSource().get(), relation.getJunctionTarget().get());
        String sourceIdColumn = String.format("%s.%s", relation.getSourceContainer(), relation.getSourceField());
        String targetIdColumn = String.format("%s.%s", relation.getTargetContainer(), relation.getTargetField());
        return feature -> {
            Optional<ObjectSql> currentRow = feature.getNestedObject(schema.getFullPath(), parentRows);
            if (!currentRow.isPresent()) {
                return Tuple.of(null, null);
            }
            Map<String, String> ids = currentRow.get().getIds();
            String columnValues = String.format("%s,%s", ids.get(sourceIdColumn), ids.get(targetIdColumn));
            return Tuple.of(String.format("INSERT INTO %s (%s) VALUES (%s) RETURNING null;", table, columnNames, columnValues), id -> {});
        };
    }

    @Override
    public Function<FeatureSql, Tuple<String, Consumer<String>>> createForeignKeyUpdate(SchemaSql schema, List<Integer> parentRows) {
        if (schema.getRelation().isEmpty() || !schema.getRelation().get(0).isOne2One() && !schema.getRelation().get(0).isOne2N()) {
            throw new IllegalArgumentException();
        }
        SqlRelation relation = schema.getRelation().get(0);
        String table = relation.getSourceContainer();
        String refKey = String.format("%s.%s", table, relation.getSourceSortKey().get());
        String column = relation.getSourceField();
        String columnKey = String.format("%s.%s", relation.getTargetContainer(), relation.getTargetField());
        return feature -> {
            Optional<ObjectSql> currentRow = feature.getNestedObject(schema.getFullPath(), parentRows);
            if (!currentRow.isPresent()) {
                return Tuple.of(null, null);
            }
            Map<String, String> ids = currentRow.get().getIds();
            return Tuple.of(String.format("UPDATE %s SET %s=%s WHERE id=%s RETURNING null;", table, column, ids.get(columnKey), ids.get(refKey)), id -> {});
        };
    }

    String getColumnValues(List<String> idKeys, Set<String> columnNames, Map<String, String> values, Map<String, String> ids, Map<String, String> valueOverrides) {
        return Stream.concat(idKeys.stream().map(ids::get), columnNames.stream().map(name -> {
            if (name.startsWith("ST_AsText(ST_ForcePolygonCCW(")) {
                return String.format("ST_ForcePolygonCW(ST_GeomFromText(%s,25832))", values.get(name));
            }
            if (valueOverrides.containsKey(name)) {
                return (String)valueOverrides.get(name);
            }
            return (String)values.get(name);
        })).collect(Collectors.joining(","));
    }
}

