/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.feature.transformer.api.SimpleFeatureGeometryFrom;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;

public enum SimpleFeatureGeometryFromToWkt implements SimpleFeatureGeometryFrom
{
    POINT,
    MULTIPOINT,
    LINESTRING,
    MULTILINESTRING,
    POLYGON,
    MULTIPOLYGON,
    GEOMETRYCOLLECTION,
    ANY,
    NONE;


    public static SimpleFeatureGeometryFromToWkt fromString(String type) {
        for (SimpleFeatureGeometryFromToWkt v : SimpleFeatureGeometryFromToWkt.values()) {
            if (!v.toString().equals(type.toUpperCase())) continue;
            return v;
        }
        if ("GEOMETRY".equalsIgnoreCase(type)) {
            return ANY;
        }
        return NONE;
    }

    public static SimpleFeatureGeometryFromToWkt fromSimpleFeatureGeometry(SimpleFeatureGeometry type) {
        switch (type) {
            case POINT: {
                return POINT;
            }
            case MULTI_POINT: {
                return MULTIPOINT;
            }
            case LINE_STRING: {
                return LINESTRING;
            }
            case MULTI_LINE_STRING: {
                return MULTILINESTRING;
            }
            case POLYGON: {
                return POLYGON;
            }
            case MULTI_POLYGON: {
                return MULTIPOLYGON;
            }
            case GEOMETRY_COLLECTION: {
                return GEOMETRYCOLLECTION;
            }
            case ANY: {
                return ANY;
            }
        }
        return NONE;
    }

    @Override
    public SimpleFeatureGeometry toSimpleFeatureGeometry() {
        SimpleFeatureGeometry simpleFeatureGeometry = SimpleFeatureGeometry.NONE;
        switch (this) {
            case POINT: {
                simpleFeatureGeometry = SimpleFeatureGeometry.POINT;
                break;
            }
            case MULTIPOINT: {
                simpleFeatureGeometry = SimpleFeatureGeometry.MULTI_POINT;
                break;
            }
            case LINESTRING: {
                simpleFeatureGeometry = SimpleFeatureGeometry.LINE_STRING;
                break;
            }
            case MULTILINESTRING: {
                simpleFeatureGeometry = SimpleFeatureGeometry.MULTI_LINE_STRING;
                break;
            }
            case POLYGON: {
                simpleFeatureGeometry = SimpleFeatureGeometry.POLYGON;
                break;
            }
            case MULTIPOLYGON: {
                simpleFeatureGeometry = SimpleFeatureGeometry.MULTI_POLYGON;
                break;
            }
            case GEOMETRYCOLLECTION: {
                simpleFeatureGeometry = SimpleFeatureGeometry.GEOMETRY_COLLECTION;
                break;
            }
            case ANY: {
                simpleFeatureGeometry = SimpleFeatureGeometry.ANY;
            }
        }
        return simpleFeatureGeometry;
    }

    @Override
    public boolean isValid() {
        return this != NONE;
    }
}

