/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.MappedSchemaDeriver;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.sql.domain.ImmutableSchemaSql;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlRelation;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlPath;
import de.ii.xtraplatform.features.sql.domain.SqlPathParser;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableList;

public class QuerySchemaDeriver
implements MappedSchemaDeriver<SchemaSql, SqlPath> {
    private final SqlPathParser pathParser;

    public QuerySchemaDeriver(SqlPathParser pathParser) {
        this.pathParser = pathParser;
    }

    @Override
    public List<SqlPath> parseSourcePaths(FeatureSchema sourceSchema) {
        return sourceSchema.getEffectiveSourcePaths().stream().map(sourcePath -> sourceSchema.isValue() ? this.pathParser.parseColumnPath((String)sourcePath) : this.pathParser.parseTablePath((String)sourcePath)).collect(Collectors.toList());
    }

    @Override
    public SchemaSql create(FeatureSchema targetSchema, SqlPath path, List<SchemaSql> visitedProperties, List<SqlPath> parentPaths) {
        ImmutableList<String> fullParentPath = targetSchema.isObject() ? (parentPaths.isEmpty() ? ImmutableList.of() : parentPaths.get(0).getFullPath()) : parentPaths.stream().flatMap(sqlPath -> sqlPath.getFullPath().stream()).collect(Collectors.toList());
        ImmutableList relations = parentPaths.isEmpty() ? ImmutableList.of() : this.pathParser.extractRelations(parentPaths.get(parentPaths.size() - 1), path);
        List sortKeys = Stream.concat(relations.stream().filter(relation -> relation.getSourceSortKey().isPresent()).map(relation -> String.format("%s.%s", relation.getSourceContainer(), relation.getSourceSortKey().get())), targetSchema.isObject() && targetSchema.getProperties().stream().anyMatch(prop -> prop.isValue() || prop.getEffectiveSourcePaths().isEmpty()) ? Stream.of(String.format("%s.%s", path.getName(), path.getSortKey())) : Stream.empty()).collect(Collectors.toList());
        List parentSortKeys = path.getParentTables().stream().map(SqlPath::getSortKey).collect(Collectors.toList());
        Map propertiesGroupedByRelation = visitedProperties.stream().collect(Collectors.groupingBy(SchemaSql::getRelation, LinkedHashMap::new, Collectors.toList()));
        List newVisitedProperties = propertiesGroupedByRelation.entrySet().stream().flatMap(entry -> {
            if (((List)entry.getKey()).isEmpty()) {
                return ((List)entry.getValue()).stream().map(prop -> targetSchema.isFeature() ? prop : new ImmutableSchemaSql.Builder().from((SchemaSql)prop).sourcePath(prop.getSourcePath().map(sourcePath -> targetSchema.getName() + "." + sourcePath)).sourcePaths(prop.getSourcePaths().stream().map(sourcePath -> targetSchema.getName() + "." + sourcePath).collect(Collectors.toList())).build());
            }
            if (((List)entry.getValue()).stream().noneMatch(SchemaBase::isValue)) {
                boolean hasValueSiblings;
                boolean bl = hasValueSiblings = visitedProperties.stream().anyMatch(SchemaBase::isValue) && ((List)entry.getKey()).size() == 1;
                List childRelations = hasValueSiblings ? (List)entry.getKey() : (!relations.isEmpty() ? ((List)entry.getKey()).stream().map(rel -> new ImmutableSqlRelation.Builder().from((SqlRelation)rel).sourceSortKey(Optional.empty()).sourcePrimaryKey(Optional.empty()).build()).collect(Collectors.toList()) : (((List)entry.getKey()).size() > 1 ? Stream.concat(Stream.of((SqlRelation)((List)entry.getKey()).get(0)), ((List)entry.getKey()).subList(1, ((List)entry.getKey()).size()).stream().map(rel -> new ImmutableSqlRelation.Builder().from((SqlRelation)rel).sourceSortKey(Optional.empty()).sourcePrimaryKey(Optional.empty()).build())).collect(Collectors.toList()) : (List)entry.getKey()));
                List childSortKeys = Stream.concat(sortKeys.stream(), childRelations.stream().filter(relation -> relation.getSourceSortKey().isPresent()).map(relation -> String.format("%s.%s", relation.getSourceContainer(), relation.getSourceSortKey().get()))).distinct().collect(Collectors.toList());
                return ((List)entry.getValue()).stream().map(prop -> new ImmutableSchemaSql.Builder().from((SchemaSql)prop).relation(ImmutableList.of()).addAllRelation(childRelations).parentSortKeys(sortKeys).sourcePath(targetSchema.isFeature() ? prop.getSourcePath() : prop.getSourcePath().map(sourcePath -> targetSchema.getName() + "." + sourcePath)).sourcePaths(targetSchema.isFeature() ? prop.getSourcePaths() : (Iterable)prop.getSourcePaths().stream().map(sourcePath -> targetSchema.getName() + "." + sourcePath).collect(Collectors.toList())).properties(this.adjustParentSortKeys(targetSchema.isFeature() ? prop.getProperties() : this.prefixSourcePath(prop.getProperties(), targetSchema.getName() + "."), childSortKeys)).build());
            }
            List newParentPath = ((List)entry.getKey()).stream().flatMap(rel -> rel.asPath().stream()).collect(Collectors.toList());
            List newProperties = ((List)entry.getValue()).stream().map(prop -> new ImmutableSchemaSql.Builder().from((SchemaSql)prop).type(prop.getValueType().orElse(prop.getType())).valueType(Optional.empty()).addAllParentPath(newParentPath).relation(ImmutableList.of()).sourcePath(prop.getSourcePath().map(sourcePath -> !targetSchema.isFeature() ? targetSchema.getName() + "." + sourcePath : sourcePath)).sourcePaths(prop.getSourcePaths().stream().map(sourcePath -> !targetSchema.isFeature() ? targetSchema.getName() + "." + sourcePath : sourcePath).collect(Collectors.toList())).build()).collect(Collectors.toList());
            boolean isArray = ((List)entry.getValue()).stream().anyMatch(SchemaBase::isArray);
            SqlPath tablePath = ((SchemaSql)((List)entry.getValue()).get(0)).getSortKey().isPresent() ? this.pathParser.parseTablePath((String)newParentPath.get(newParentPath.size() - 1) + "{sortKey=" + ((SchemaSql)((List)entry.getValue()).get(0)).getSortKey().get() + "}") : this.pathParser.parseTablePath((String)newParentPath.get(newParentPath.size() - 1));
            return Stream.of(new ImmutableSchemaSql.Builder().name(((SqlRelation)((List)entry.getKey()).get(((List)entry.getKey()).size() - 1)).getTargetContainer()).type(isArray ? SchemaBase.Type.OBJECT_ARRAY : SchemaBase.Type.OBJECT).parentPath(((SchemaSql)((List)entry.getValue()).get(0)).getParentPath()).parentSortKeys(sortKeys).addAllRelation((Iterable)entry.getKey()).properties(newProperties).sortKey(tablePath.getSortKey()).primaryKey(tablePath.getPrimaryKey()).sourcePath(!targetSchema.isFeature() ? Optional.of(targetSchema.getName()) : Optional.empty()).build());
        }).collect(Collectors.toList());
        ImmutableSchemaSql.Builder builder = new ImmutableSchemaSql.Builder().name(path.getName()).parentPath(fullParentPath).sortKey(parentSortKeys.isEmpty() || !targetSchema.isValue() ? Optional.empty() : Optional.of((String)parentSortKeys.get(parentSortKeys.size() - 1))).type(targetSchema.getType()).valueType(targetSchema.getValueType()).geometryType(targetSchema.getGeometryType()).role(targetSchema.getRole()).sourcePath(targetSchema.getName()).relation(relations).properties(newVisitedProperties).constantValue(targetSchema.getConstantValue()).forcePolygonCCW(targetSchema.isForcePolygonCCW() ? Optional.empty() : Optional.of(false));
        if (targetSchema.isObject()) {
            if (targetSchema.getProperties().stream().anyMatch(prop -> prop.isValue() || prop.getEffectiveSourcePaths().isEmpty())) {
                builder.sortKey(path.getSortKey()).primaryKey(path.getPrimaryKey());
            }
            builder.filter(path.getFilter()).filterString(path.getFilterString());
        }
        return builder.build();
    }

    @Override
    public List<SchemaSql> merge(FeatureSchema targetSchema, SqlPath parentPath, List<SchemaSql> visitedProperties) {
        return visitedProperties.stream().map(property -> new ImmutableSchemaSql.Builder().from((SchemaSql)property).sourcePath(property.getSourcePath().map(sourcePath -> targetSchema.getName() + "." + sourcePath)).sourcePaths(property.getSourcePaths().stream().map(sourcePath -> targetSchema.getName() + "." + sourcePath).collect(Collectors.toList())).build()).collect(Collectors.toList());
    }

    private List<SchemaSql> prefixSourcePath(List<SchemaSql> schemas, String prefix) {
        return schemas.stream().map(schema -> new ImmutableSchemaSql.Builder().from((SchemaSql)schema).sourcePath(schema.getSourcePath().map(sourcePath -> prefix + sourcePath)).sourcePaths(schema.getSourcePaths().stream().map(sourcePath -> prefix + sourcePath).collect(Collectors.toList())).build()).collect(Collectors.toList());
    }

    private List<SchemaSql> adjustParentSortKeys(List<SchemaSql> schemas, List<String> parentSortKeys) {
        ArrayList<String> keys = new ArrayList<String>(parentSortKeys);
        return schemas.stream().map(schema -> schema.isObject() ? new ImmutableSchemaSql.Builder().from((SchemaSql)schema).parentSortKeys(keys).build() : schema).collect(Collectors.toList());
    }
}

