/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.cql.domain.Cql;
import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.features.domain.FeatureStoreRelation;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreRelation;
import de.ii.xtraplatform.features.sql.ImmutableSqlPath;
import de.ii.xtraplatform.features.sql.SqlPath;
import de.ii.xtraplatform.features.sql.SqlPathSyntax;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableList;

public class PathParserSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathParserSql.class);
    private final SqlPathSyntax syntax;
    private final Cql cql;

    public PathParserSql(SqlPathSyntax syntax, Cql cql) {
        this.syntax = syntax;
        this.cql = cql;
    }

    public Optional<SqlPath> parse(String path, boolean isColumn) {
        Matcher matcher;
        Matcher matcher2 = matcher = isColumn ? this.syntax.getPartialColumnPathPattern().matcher(path) : this.syntax.getPathPattern().matcher(path);
        if (matcher.find()) {
            String tablePath = matcher.group("path");
            LinkedHashMap<String, String> tableFlags = new LinkedHashMap<String, String>();
            Matcher tableMatcher = this.syntax.getTablePattern().matcher(tablePath);
            while (tableMatcher.find()) {
                String flags = tableMatcher.group("tableFlags");
                tablePath = tablePath.replace(flags, "");
                String pathWithoutFlags = tableMatcher.group(0).replace(flags, "");
                tableFlags.putIfAbsent(pathWithoutFlags, flags);
            }
            String column = isColumn ? matcher.group("columns") : null;
            ImmutableList<String> columns = Objects.nonNull(column) ? this.syntax.getMultiColumnSplitter().splitToList(column) : ImmutableList.of();
            String flags = isColumn ? matcher.group("pathFlags") : "";
            OptionalInt priority = this.syntax.getPriorityFlag(flags);
            boolean hasOid = this.syntax.getOidFlag(flags);
            List<String> tablePathAsList = this.syntax.asList(tablePath);
            boolean isRoot = tablePathAsList.size() == 1;
            boolean isJunction = this.syntax.isJunctionTable(tablePathAsList.get(tablePathAsList.size() - 1));
            Optional<String> queryable = this.syntax.getQueryableFlag(flags).map(q -> q.replaceAll("\\[", "").replaceAll("]", ""));
            boolean isSpatial = this.syntax.getSpatialFlag(flags);
            try {
                return Optional.of(new ImmutableSqlPath.Builder().tablePath(tablePath).tableFlags(tableFlags).columns(columns).hasOid(hasOid).sortPriority(priority).isRoot(isRoot).isJunction(isJunction).queryable("").isSpatial(isSpatial).build());
            }
            catch (Throwable e) {
                boolean bl = true;
            }
        }
        LOGGER.warn("Invalid sourcePath in provider configuration: {}", (Object)path);
        return Optional.empty();
    }

    public List<FeatureStoreRelation> toRelations(List<String> path, Map<String, CqlFilter> filters) {
        if (path.size() < 2) {
            throw new IllegalArgumentException(String.format("not a valid relation path: %s", path));
        }
        if (path.size() > 2) {
            return IntStream.range(2, path.size()).mapToObj(i -> this.toRelations((String)path.get(i - 2), (String)path.get(i - 1), (String)path.get(i), i == path.size() - 1, filters)).flatMap(Function.identity()).collect(Collectors.toList());
        }
        return IntStream.range(1, path.size()).mapToObj(i -> this.toRelation((String)path.get(i - 1), (String)path.get(i), filters)).collect(Collectors.toList());
    }

    private Stream<FeatureStoreRelation> toRelations(String source, String link, String target, boolean isLast, Map<String, CqlFilter> filters) {
        if (this.syntax.isJunctionTable(source)) {
            if (isLast) {
                return Stream.of(this.toRelation(link, target, filters));
            }
            return Stream.empty();
        }
        if (this.syntax.isJunctionTable(target) && !isLast) {
            return Stream.of(this.toRelation(source, link, filters));
        }
        if (this.syntax.isJunctionTable(link)) {
            return Stream.of(this.toRelation(source, link, target));
        }
        return Stream.of(this.toRelation(source, link, filters), this.toRelation(link, target, filters));
    }

    private FeatureStoreRelation toRelation(String source, String target, Map<String, CqlFilter> filters) {
        Matcher sourceMatcher = this.syntax.getTablePattern().matcher(source);
        Matcher targetMatcher = this.syntax.getJoinedTablePattern().matcher(target);
        if (sourceMatcher.find() && targetMatcher.find()) {
            String sourceField = targetMatcher.group("sourceField");
            String targetField = targetMatcher.group("targetField");
            boolean isOne2One = Objects.equals(targetField, this.syntax.getOptions().getPrimaryKey());
            Optional<CqlFilter> filter = Optional.ofNullable(filters.get(target));
            return ImmutableFeatureStoreRelation.builder().cardinality(isOne2One ? FeatureStoreRelation.CARDINALITY.ONE_2_ONE : FeatureStoreRelation.CARDINALITY.ONE_2_N).sourceContainer(sourceMatcher.group("table")).sourceField(sourceField).sourceSortKey(this.syntax.getOptions().getPrimaryKey()).targetContainer(targetMatcher.group("table")).targetField(targetField).filter(filter).build();
        }
        throw new IllegalArgumentException(String.format("not a valid relation path: %s/%s", source, target));
    }

    private FeatureStoreRelation toRelation(String source, String link, String target) {
        Matcher sourceMatcher = this.syntax.getTablePattern().matcher(source);
        Matcher junctionMatcher = this.syntax.getJoinedTablePattern().matcher(link);
        Matcher targetMatcher = this.syntax.getJoinedTablePattern().matcher(target);
        if (sourceMatcher.find() && junctionMatcher.find() && targetMatcher.find()) {
            return ImmutableFeatureStoreRelation.builder().cardinality(FeatureStoreRelation.CARDINALITY.M_2_N).sourceContainer(sourceMatcher.group("table")).sourceField(junctionMatcher.group("sourceField")).sourceSortKey(this.syntax.getOptions().getPrimaryKey()).junctionSource(junctionMatcher.group("targetField")).junction(junctionMatcher.group("table")).junctionTarget(targetMatcher.group("sourceField")).targetContainer(targetMatcher.group("table")).targetField(targetMatcher.group("targetField")).build();
        }
        throw new IllegalArgumentException(String.format("not a valid relation path: %s/%s/%s", source, link, target));
    }
}

