/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import de.ii.xtraplatform.features.domain.FeatureStoreRelation;
import de.ii.xtraplatform.features.domain.PropertyBase;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.sql.app.FeatureSql;
import de.ii.xtraplatform.features.sql.app.PropertySql;
import de.ii.xtraplatform.features.sql.app.SimpleFeatureGeometryFromToWkt;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.geometries.domain.ImmutableCoordinatesTransformer;
import de.ii.xtraplatform.geometries.domain.ImmutableCoordinatesWriterWkt;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableListMultimap;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.Iterables;
import shadow.com.google.common.collect.ListMultimap;
import shadow.org.immutables.value.Value;

public interface ObjectSql {
    public List<FeatureStoreRelation> getPath();

    @Value.Derived
    default public Optional<String> getPath2() {
        return this instanceof FeatureSql ? ((FeatureSql)this).getSchema().map(SchemaBase::getName) : (this instanceof PropertySql ? ((PropertySql)this).getSchema().map(SchemaBase::getName) : Optional.empty());
    }

    public Map<String, String> getIds();

    @Value.Derived
    default public Map<List<String>, List<Integer>> getRowCounts() {
        return this.getRowCounts(ImmutableList.of(), 0);
    }

    default public Map<List<String>, List<Integer>> getRowCounts(List<String> parentPath, int parentRow) {
        LinkedHashMap<List<String>, List<Integer>> rows = new LinkedHashMap<List<String>, List<Integer>>();
        Map<List<String>, PropertySql> allChildren2 = this.getAllChildren2();
        allChildren2.forEach((path, property) -> {
            List parentRows = ImmutableList.of();
            for (int i = path.size() - 1; i > 0; --i) {
                if (!rows.containsKey(path.subList(0, i))) continue;
                parentRows = (List)rows.get(path.subList(0, i));
                break;
            }
            if (property.getType() == PropertyBase.Type.OBJECT) {
                rows.put((List<String>)path, (List<Integer>)ImmutableList.copyOf(Iterables.concat(parentRows, ImmutableList.of(Integer.valueOf(1)))));
            } else if (property.getType() == PropertyBase.Type.ARRAY) {
                rows.put((List<String>)path, (List<Integer>)ImmutableList.copyOf(Iterables.concat(parentRows, ImmutableList.of(Integer.valueOf(property.getChildren().size())))));
            }
        });
        return rows;
    }

    public ObjectSql path(Iterable<? extends FeatureStoreRelation> var1);

    public ObjectSql putIds(String var1, String var2);

    default public void putChildrenIds(String name, String id) {
        this.getAllChildren3().forEach(propertySql -> propertySql.putIds(name, id));
    }

    @Value.Derived
    default public Map<String, String> getValues(EpsgCrs nativeCrs, CrsTransformerFactory crsTransformerFactory) {
        return this.getChildren().stream().filter(propertySql -> propertySql.getType() == PropertyBase.Type.VALUE && Objects.nonNull(propertySql.getValue()) || propertySql.getType() == PropertyBase.Type.OBJECT && propertySql.getSchema().map(schemaSql -> schemaSql.getType() == SchemaBase.Type.GEOMETRY).orElse(false) != false).map(propertySql -> {
            boolean isGeometry;
            boolean bl = isGeometry = propertySql.getType() == PropertyBase.Type.OBJECT && propertySql.getSchema().map(schemaSql -> schemaSql.getType() == SchemaBase.Type.GEOMETRY).orElse(false) != false;
            if (isGeometry) {
                return this.toWkt((PropertySql)propertySql, nativeCrs, crsTransformerFactory);
            }
            boolean needsQuotes = propertySql.getSchema().map(schemaSql -> schemaSql.getType() == SchemaBase.Type.STRING || schemaSql.getType() == SchemaBase.Type.DATETIME).orElse(false);
            String value = needsQuotes ? String.format("'%s'", propertySql.getValue().replaceAll("'", "''")) : propertySql.getValue();
            return new AbstractMap.SimpleImmutableEntry<String, String>(propertySql.getName(), value);
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public Map.Entry<String, String> toWkt(PropertySql propertySql, EpsgCrs nativeCrs, CrsTransformerFactory crsTransformerFactory) {
        SimpleFeatureGeometry geometryType = propertySql.getSchema().flatMap(SchemaBase::getGeometryType).orElse(SimpleFeatureGeometry.POINT);
        SimpleFeatureGeometryFromToWkt wktType = SimpleFeatureGeometryFromToWkt.fromSimpleFeatureGeometry(geometryType);
        Integer dimension = 2;
        StringWriter geometryWriter = new StringWriter();
        ImmutableCoordinatesTransformer.Builder coordinatesTransformerBuilder = ImmutableCoordinatesTransformer.builder();
        coordinatesTransformerBuilder.coordinatesWriter(ImmutableCoordinatesWriterWkt.of(geometryWriter, Optional.ofNullable(dimension).orElse(2)));
        EpsgCrs sourceCrs = OgcCrs.CRS84;
        Optional<CrsTransformer> crsTransformer = crsTransformerFactory.getTransformer(sourceCrs, nativeCrs);
        coordinatesTransformerBuilder.crsTransformer(crsTransformer);
        if (dimension != null) {
            coordinatesTransformerBuilder.sourceDimension(dimension);
            coordinatesTransformerBuilder.targetDimension(dimension);
        }
        ImmutableCoordinatesTransformer coordinatesWriter = coordinatesTransformerBuilder.build();
        geometryWriter.append(wktType.toString());
        try {
            this.toWktArray(propertySql, geometryWriter, coordinatesWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(propertySql.getName(), String.format("ST_ForcePolygonCW(ST_GeomFromText('%s',%s))", geometryWriter, nativeCrs.getCode()));
    }

    default public void toWktArray(PropertySql propertySql, Writer structureWriter, Writer coordinatesWriter) throws IOException {
        if (propertySql.getType() == PropertyBase.Type.ARRAY) {
            structureWriter.append("(");
        }
        for (int i = 0; i < propertySql.getNestedProperties().size(); ++i) {
            PropertySql propertySql1 = (PropertySql)propertySql.getNestedProperties().get(i);
            if (propertySql1.getType() == PropertyBase.Type.ARRAY) {
                this.toWktArray(propertySql1, structureWriter, coordinatesWriter);
                if (i >= propertySql.getNestedProperties().size() - 1) continue;
                structureWriter.append(",");
                continue;
            }
            coordinatesWriter.append(propertySql1.getValue());
            if (i >= propertySql.getNestedProperties().size() - 1) continue;
            coordinatesWriter.append(",");
        }
        coordinatesWriter.flush();
        if (propertySql.getType() == PropertyBase.Type.ARRAY) {
            structureWriter.append(")");
        }
    }

    default public Optional<PropertySql> findChild(List<String> path) {
        if (path.size() < 2) {
            return Optional.empty();
        }
        Map<List<String>, PropertySql> properties = this.getAllChildren();
        for (int i = 2; i <= path.size(); ++i) {
            List<String> subPath = path.subList(0, i);
            if (!properties.containsKey(subPath)) continue;
            return Optional.of(properties.get(subPath));
        }
        return Optional.empty();
    }

    default public Optional<ObjectSql> getNestedObject(List<String> path, List<Integer> parentRows) {
        Optional<PropertySql> child = this.findChild(path);
        if (!child.isPresent()) {
            return Optional.empty();
        }
        PropertySql property = child.get();
        if (property.getType() == PropertyBase.Type.ARRAY) {
            int row;
            int n = row = parentRows.isEmpty() ? 0 : parentRows.get(0);
            if (row > property.getNestedProperties().size() - 1) {
                throw new IllegalStateException(String.format("No values found for row %s of %s", row, path));
            }
            property = (PropertySql)property.getNestedProperties().get(row);
        }
        if (property.getSchema().isPresent() && ((SchemaSql)property.getSchema().get()).getFullPath().size() < path.size()) {
            return property.getNestedObject(path, parentRows.subList(1, parentRows.size()));
        }
        return Optional.of(property);
    }

    @Value.Derived
    default public List<PropertySql> getChildren() {
        return this instanceof FeatureSql ? ((FeatureSql)this).getProperties() : (this instanceof PropertySql ? ((PropertySql)this).getNestedProperties() : ImmutableList.of());
    }

    @Value.Derived
    default public Map<List<String>, PropertySql> getAllChildren() {
        return this.getChildren().stream().filter(propertySql -> propertySql.getType() == PropertyBase.Type.OBJECT || propertySql.getType() == PropertyBase.Type.ARRAY).map(propertySql -> new AbstractMap.SimpleImmutableEntry<List, PropertySql>(propertySql.getSchema().map(SchemaBase::getFullPath).orElse(ImmutableList.of()), (PropertySql)propertySql)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Value.Derived
    default public Map<List<String>, PropertySql> getAllChildren2() {
        return this.getChildren().stream().filter(propertySql -> propertySql.getType() == PropertyBase.Type.OBJECT || propertySql.getType() == PropertyBase.Type.ARRAY).filter(propertySql -> propertySql.getSchema().map(schemaSql -> schemaSql.getType() != SchemaBase.Type.GEOMETRY).orElse(true)).flatMap(propertySql -> {
            List path = propertySql.getSchema().map(SchemaBase::getFullPath).orElse(ImmutableList.of());
            return Stream.concat(Stream.of(new AbstractMap.SimpleImmutableEntry<List, PropertySql>(path, (PropertySql)propertySql)), propertySql.getAllChildren2().entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), path)));
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Value.Derived
    default public List<PropertySql> getAllChildren3() {
        return this.getChildren().stream().filter(propertySql -> propertySql.getType() == PropertyBase.Type.OBJECT || propertySql.getType() == PropertyBase.Type.ARRAY).flatMap(propertySql -> Stream.concat(Stream.of(propertySql), propertySql.getAllChildren3().stream())).collect(ImmutableList.toImmutableList());
    }

    @Value.Derived
    default public ListMultimap<List<String>, PropertySql> getNested() {
        return this.getChildren().stream().map(propertySql -> new AbstractMap.SimpleImmutableEntry<List, PropertySql>(propertySql.getSchema().map(SchemaBase::getFullPath).orElse(ImmutableList.of()), (PropertySql)propertySql)).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

