/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.ReverseSchemaDeriver;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.sql.SqlPath;
import de.ii.xtraplatform.features.sql.app.PathParserSql;
import de.ii.xtraplatform.features.sql.domain.ImmutableSchemaSql;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlPathParser;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.base.Joiner;
import shadow.com.google.common.collect.ImmutableList;

public class MutationSchemaDeriver
implements ReverseSchemaDeriver<SchemaSql> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutationSchemaDeriver.class);
    private static final Joiner JOINER = Joiner.on('/').skipNulls();
    private static final String IGNORE = "__IGNORE__";
    private final PathParserSql pathParser;
    private final SqlPathParser pathParser3;
    private int ignoreCounter;

    public MutationSchemaDeriver(PathParserSql pathParser, SqlPathParser pathParser3) {
        this.pathParser = pathParser;
        this.pathParser3 = pathParser3;
        this.ignoreCounter = 0;
    }

    @Override
    public SchemaSql create(List<String> path, FeatureSchema targetSchema) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("OLD {} {}", (Object)(targetSchema.isObject() ? "OBJECT" : "VALUE"), (Object)path);
        }
        return new ImmutableSchemaSql.Builder().name(path.get(path.size() - 1)).parentPath(path.subList(0, path.size() - 1)).type(targetSchema.getType()).valueType(targetSchema.getValueType()).geometryType(targetSchema.getGeometryType()).role(targetSchema.getRole()).sourcePath(targetSchema.getName()).build();
    }

    @Override
    public SchemaSql create(String path, FeatureSchema targetSchema) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("NEW {} {}", (Object)(targetSchema.isObject() ? "OBJECT" : "VALUE"), (Object)path);
        }
        if (targetSchema.isValue()) {
            de.ii.xtraplatform.features.sql.domain.SqlPath sqlPath = this.pathParser3.parseColumnPath(path);
        }
        return null;
    }

    @Override
    public List<SchemaSql> createParents(String parentParentPath, SchemaSql child, Map<List<String>, SchemaSql> objectCache) {
        Object path = JOINER.join(child.getFullPath());
        if (!this.shouldIgnore(parentParentPath)) {
            path = parentParentPath + "/" + (String)path;
        } else {
            boolean bl = true;
        }
        Optional<SqlPath> sqlPath = this.pathParser.parse((String)path, child.isValue());
        if (!sqlPath.isPresent()) {
            throw new IllegalArgumentException("Parse error for SQL path: " + (String)path);
        }
        List<String> tablePathAsList = ReverseSchemaDeriver.SPLITTER.splitToList(sqlPath.get().getTablePath());
        boolean hasRelation = tablePathAsList.size() > 1;
        ImmutableList relations = ImmutableList.of();
        SchemaSql currentChild = child;
        ArrayList<SchemaSql> parents = new ArrayList<SchemaSql>();
        for (int i = relations.size() - 1; i >= 0; --i) {
            SqlRelation relation = (SqlRelation)relations.get(i);
            SchemaBase.Type type = relation.isOne2One() ? SchemaBase.Type.OBJECT : SchemaBase.Type.OBJECT_ARRAY;
            boolean replace = currentChild.isObject() && parents.isEmpty();
            SchemaSql parent = objectCache.computeIfAbsent(relation.asPath(), ignore -> this.createParent(relation, type, child, replace));
            currentChild = replace ? parent : this.addChild(parent, currentChild);
            parents.add(0, currentChild);
        }
        return parents;
    }

    private SchemaSql createParent(SqlRelation relation, SchemaBase.Type type, SchemaSql child, boolean replace) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("OBJECT {}", (Object)relation);
        }
        ImmutableSchemaSql.Builder builder = new ImmutableSchemaSql.Builder().name(relation.getTargetContainer()).type(type).addRelation(relation).parentPath(child.getParentPath().subList(0, child.getParentPath().size() - 1));
        if (replace) {
            builder.parentPath(child.getParentPath().subList(0, child.getParentPath().size() - 1)).properties(child.getProperties()).sourcePath(child.getSourcePath());
        }
        return builder.build();
    }

    private SchemaSql addChild(SchemaSql parent, SchemaSql child) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("CHILD {} {}", (Object)parent.getName(), (Object)child.getName());
        }
        SchemaSql toAdd = child;
        if (child.getValueType().isPresent()) {
            toAdd = new ImmutableSchemaSql.Builder().from(child).type(child.getValueType().get()).valueType(Optional.empty()).build();
        }
        return new ImmutableSchemaSql.Builder().from(parent).addProperties(toAdd).build();
    }

    @Override
    public SchemaSql addChildren(SchemaSql parent, List<SchemaSql> children) {
        return new ImmutableSchemaSql.Builder().from(parent).addAllProperties(children).build();
    }

    @Override
    public SchemaSql prependToParentPath(List<String> path, SchemaSql schema) {
        if (this.shouldIgnore(path)) {
            return schema;
        }
        return new ImmutableSchemaSql.Builder().from(schema).parentPath(path).addAllParentPath(schema.getParentPath()).properties(schema.getProperties().stream().map(prop -> this.prependToParentPath(path, (SchemaSql)prop)).collect(Collectors.toList())).build();
    }

    @Override
    public SchemaSql prependToSourcePath(String parentSourcePath, SchemaSql schema) {
        return new ImmutableSchemaSql.Builder().from(schema).sourcePath(JOINER.join(parentSourcePath, schema.getSourcePath().orElse(null), new Object[0])).build();
    }

    @Override
    public String ignore() {
        return IGNORE + this.ignoreCounter++;
    }

    private boolean shouldIgnore(String path) {
        return path.startsWith(IGNORE);
    }

    @Override
    public boolean shouldIgnore(List<String> path) {
        return path.isEmpty() || this.shouldIgnore(path.get(0));
    }
}

