/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaVisitor;
import de.ii.xtraplatform.features.sql.domain.ImmutableSchemaSql;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlRelation;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.Iterables;
import shadow.com.google.common.collect.Lists;

public class MutationSchemaBuilderSql
implements SchemaVisitor<SchemaSql, SchemaSql> {
    @Override
    public SchemaSql visit(SchemaSql schema, List<SchemaSql> visitedProperties) {
        SchemaSql current = schema;
        SchemaSql newParent = null;
        List<SchemaSql> currentChildren = visitedProperties;
        Optional<SchemaSql> mainTable = visitedProperties.stream().filter(this::isMerge).filter(this::isMain).findFirst();
        if (mainTable.isPresent()) {
            newParent = this.switchRelation(current, mainTable.get(), currentChildren);
            current = (SchemaSql)newParent.getProperties().get(newParent.getProperties().size() - 1);
            currentChildren = current.getProperties();
        }
        while (currentChildren.stream().anyMatch(this::isMerge)) {
            SchemaSql child = currentChildren.stream().filter(this::isMerge).findFirst().get();
            SchemaSql switched = this.switchRelation(current, child, currentChildren);
            newParent = Objects.isNull(newParent) ? switched : this.replaceChild(newParent, current, switched);
            current = (SchemaSql)switched.getProperties().get(switched.getProperties().size() - 1);
            currentChildren = current.getProperties();
        }
        return Optional.ofNullable(newParent).orElse(schema);
    }

    private SchemaSql replaceChild(SchemaSql parent, SchemaSql child, SchemaSql newChild) {
        List newChildren = parent.getProperties().stream().map(schemaSql -> {
            if (Objects.equals(schemaSql, child)) {
                return newChild;
            }
            return schemaSql;
        }).collect(Collectors.toList());
        return new ImmutableSchemaSql.Builder().from(parent).properties(newChildren).build();
    }

    private SchemaSql switchRelation(SchemaSql parent, SchemaSql child, List<SchemaSql> allChildren) {
        SqlRelation childRelation = child.getRelation().get(0);
        ImmutableSqlRelation newChildRelation = new ImmutableSqlRelation.Builder().from(childRelation).sourceContainer(childRelation.getTargetContainer()).sourceField(childRelation.getTargetField()).targetContainer(childRelation.getSourceContainer()).targetField(childRelation.getSourceField()).build();
        List newProperties = allChildren.stream().filter(property -> !Objects.equals(property, child)).map(property -> this.replaceInParentPath(1, newChildRelation.asPath(), (SchemaSql)property)).collect(Collectors.toList());
        SchemaSql newChild = new ImmutableSchemaSql.Builder().from(parent).properties(newProperties).addRelation((SqlRelation)newChildRelation).sourcePath(child.getSourcePath()).build();
        ImmutableList<String> newChildPath = !parent.getRelation().isEmpty() ? Lists.newArrayList(Iterables.concat(parent.getParentPath(), childRelation.asPath())) : ImmutableList.of(child.getName());
        newChild = this.replaceInParentPath(!parent.getRelation().isEmpty() ? 1 : 0, newChildPath, newChild);
        Optional newParentRelation = !parent.getRelation().isEmpty() ? Optional.of(new ImmutableSqlRelation.Builder().from(parent.getRelation().get(0)).sourceContainer(parent.getRelation().get(0).getSourceContainer()).sourceField(parent.getRelation().get(0).getSourceField()).targetContainer(childRelation.getTargetContainer()).targetField(childRelation.getTargetField()).build()) : Optional.empty();
        List<String> newParentPath = newParentRelation.isPresent() ? parent.getParentPath() : ImmutableList.of(child.getName());
        SchemaSql newParent = this.replaceInParentPath(2, newParentPath, child);
        newParent = new ImmutableSchemaSql.Builder().from(newParent).addProperties(newChild).parentPath(newParentRelation.isPresent() ? newParentPath : ImmutableList.of()).relation(newParentRelation.isPresent() ? ImmutableList.of((SqlRelation)newParentRelation.get()) : ImmutableList.of()).sourcePath(parent.getSourcePath()).build();
        return newParent;
    }

    private boolean isMain(SchemaSql schemaSql) {
        return schemaSql.getProperties().stream().anyMatch(property -> property.getRole().isPresent() && property.getRole().get() == SchemaBase.Role.ID);
    }

    private boolean isMerge(SchemaSql schemaSql) {
        return !schemaSql.getRelation().isEmpty() && schemaSql.getRelation().get(0).isOne2One() && Objects.equals(schemaSql.getRelation().get(0).getSourceSortKey().get(), schemaSql.getRelation().get(0).getSourceField());
    }

    public SchemaSql prependToParentPath(List<String> path, SchemaSql schema) {
        return new ImmutableSchemaSql.Builder().from(schema).parentPath(path).addAllParentPath(schema.getParentPath()).properties(schema.getProperties().stream().map(prop -> this.prependToParentPath(path, (SchemaSql)prop)).collect(Collectors.toList())).build();
    }

    public SchemaSql replaceInParentPath(int numElemsFromStart, List<String> to, SchemaSql schema) {
        List<String> newParentPath = numElemsFromStart > schema.getParentPath().size() ? schema.getParentPath() : ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(to)).addAll(schema.getParentPath().subList(numElemsFromStart, schema.getParentPath().size()))).build();
        return new ImmutableSchemaSql.Builder().from(schema).parentPath(newParentPath).properties(schema.getProperties().stream().map(prop -> this.replaceInParentPath(numElemsFromStart, to, (SchemaSql)prop)).collect(Collectors.toList())).build();
    }
}

