/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.base.domain.util.LambdaWithException;
import de.ii.xtraplatform.features.domain.FeatureEventHandler;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.domain.SchemaMapping;
import de.ii.xtraplatform.features.sql.app.SimpleFeatureGeometryFromToWkt;
import de.ii.xtraplatform.geometries.domain.SimpleFeatureGeometry;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Objects;
import shadow.com.google.common.base.Splitter;

public class GeometryDecoderWkt {
    private final FeatureEventHandler<FeatureSchema, SchemaMapping, FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping>> handler;
    private final FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context;
    private static final Splitter COMMA_SPLITTER = Splitter.on(',').omitEmptyStrings().trimResults();
    private static final Splitter BLANK_SPLITTER = Splitter.on(' ').omitEmptyStrings().trimResults();
    private static final String EMPTY = "EMPTY";
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";

    public GeometryDecoderWkt(FeatureEventHandler<FeatureSchema, SchemaMapping, FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping>> handler, FeatureEventHandler.ModifiableContext<FeatureSchema, SchemaMapping> context) {
        this.handler = handler;
        this.context = context;
    }

    public void decode(String text) throws IOException {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(text));
        int char128 = 128;
        int skip32 = 32;
        int char255 = 255;
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(160, 255);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(43, 43);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(44, 44);
        tokenizer.wordChars(32, 32);
        String type = this.getNextWord(tokenizer);
        int dimension = type.contains(" Z ") ? 3 : 2;
        type = type.replace(" Z ", "");
        SimpleFeatureGeometry geometryType = SimpleFeatureGeometryFromToWkt.fromString(type).toSimpleFeatureGeometry();
        if (!geometryType.isValid()) {
            return;
        }
        this.context.setGeometryType(geometryType);
        this.context.setGeometryDimension(dimension);
        this.handler.onObjectStart(this.context);
        this.context.setInGeometry(true);
        switch (geometryType) {
            case POINT: {
                this.readCoordinates(tokenizer);
                break;
            }
            case MULTI_POINT: {
                this.readMultiPointText(tokenizer);
                break;
            }
            case LINE_STRING: {
                this.readCoordinates(tokenizer);
                break;
            }
            case MULTI_LINE_STRING: {
                this.readPolygonText(tokenizer);
                break;
            }
            case POLYGON: {
                this.readPolygonText(tokenizer);
                break;
            }
            case MULTI_POLYGON: {
                this.readMultiPolygonText(tokenizer);
                break;
            }
        }
        this.handler.onObjectEnd(this.context);
        this.context.setInGeometry(false);
    }

    private String getNextWord(StreamTokenizer tokenizer) throws IOException {
        String value;
        int type = tokenizer.nextToken();
        switch (type) {
            case 40: {
                value = L_PAREN;
                break;
            }
            case 41: {
                value = R_PAREN;
                break;
            }
            case 44: {
                value = COMMA;
                break;
            }
            case -3: {
                String word = tokenizer.sval;
                if (word.equalsIgnoreCase(EMPTY)) {
                    value = EMPTY;
                    break;
                }
                value = word;
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private void readMultiPointText(StreamTokenizer tokenizer) throws IOException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (!Objects.equals(nextToken, EMPTY)) {
            nextToken = this.getNextWord(tokenizer);
            this.handler.onArrayStart(this.context);
            COMMA_SPLITTER.splitToList(nextToken).forEach(LambdaWithException.consumerMayThrow(point -> {
                this.context.setValueType(SchemaBase.Type.STRING);
                this.context.setValue((String)point);
                this.handler.onValue(this.context);
            }));
            this.handler.onArrayEnd(this.context);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
    }

    private void readMultiPolygonText(StreamTokenizer tokenizer) throws IOException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (Objects.equals(nextToken, EMPTY)) {
            return;
        }
        this.handler.onArrayStart(this.context);
        this.readPolygonText(tokenizer);
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (Objects.equals(nextToken, COMMA)) {
            this.readPolygonText(tokenizer);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        this.handler.onArrayEnd(this.context);
    }

    private void readPolygonText(StreamTokenizer tokenizer) throws IOException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (Objects.equals(nextToken, EMPTY)) {
            return;
        }
        this.handler.onArrayStart(this.context);
        this.readCoordinates(tokenizer);
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (Objects.equals(nextToken, COMMA)) {
            this.readCoordinates(tokenizer);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        this.handler.onArrayEnd(this.context);
    }

    private void readCoordinates(StreamTokenizer tokenizer) throws IOException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (!Objects.equals(nextToken, EMPTY)) {
            nextToken = this.getNextWord(tokenizer);
            this.context.setValueType(SchemaBase.Type.STRING);
            this.context.setValue(nextToken);
            this.handler.onValue(this.context);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
    }

    private String getNextEmptyOrOpener(StreamTokenizer tokenizer) throws IOException {
        String nextWord = this.getNextWord(tokenizer);
        if (EMPTY.equals(nextWord) || L_PAREN.equals(nextWord)) {
            return nextWord;
        }
        return null;
    }

    private String getNextCloserOrComma(StreamTokenizer tokenizer) throws IOException {
        String nextWord = this.getNextWord(tokenizer);
        if (COMMA.equals(nextWord) || R_PAREN.equals(nextWord)) {
            return nextWord;
        }
        return null;
    }
}

