/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.cql.domain.And;
import de.ii.xtraplatform.cql.domain.ArrayLiteral;
import de.ii.xtraplatform.cql.domain.ArrayOperation;
import de.ii.xtraplatform.cql.domain.ArrayOperator;
import de.ii.xtraplatform.cql.domain.Between;
import de.ii.xtraplatform.cql.domain.BinaryScalarOperation;
import de.ii.xtraplatform.cql.domain.Cql;
import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.cql.domain.CqlNode;
import de.ii.xtraplatform.cql.domain.CqlToText;
import de.ii.xtraplatform.cql.domain.Function;
import de.ii.xtraplatform.cql.domain.Geometry;
import de.ii.xtraplatform.cql.domain.ImmutableCqlPredicate;
import de.ii.xtraplatform.cql.domain.ImmutableMultiPolygon;
import de.ii.xtraplatform.cql.domain.ImmutablePolygon;
import de.ii.xtraplatform.cql.domain.In;
import de.ii.xtraplatform.cql.domain.IsNull;
import de.ii.xtraplatform.cql.domain.Like;
import de.ii.xtraplatform.cql.domain.LogicalOperation;
import de.ii.xtraplatform.cql.domain.Not;
import de.ii.xtraplatform.cql.domain.Operand;
import de.ii.xtraplatform.cql.domain.Property;
import de.ii.xtraplatform.cql.domain.Scalar;
import de.ii.xtraplatform.cql.domain.ScalarLiteral;
import de.ii.xtraplatform.cql.domain.SpatialOperation;
import de.ii.xtraplatform.cql.domain.Temporal;
import de.ii.xtraplatform.cql.domain.TemporalLiteral;
import de.ii.xtraplatform.cql.domain.TemporalOperation;
import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.sql.app.AliasGenerator;
import de.ii.xtraplatform.features.sql.app.JoinGenerator;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlDialect;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.base.Splitter;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Doubles;
import shadow.org.threeten.extra.Interval;

public class FilterEncoderSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterEncoderSql.class);
    static final String ROW_NUMBER = "row_number";
    static final Splitter ARRAY_SPLITTER = Splitter.on(",").trimResults().omitEmptyStrings();
    private final AliasGenerator aliasGenerator = new AliasGenerator();
    private final JoinGenerator joinGenerator = new JoinGenerator();
    private final EpsgCrs nativeCrs;
    private final SqlDialect sqlDialect;
    private final CrsTransformerFactory crsTransformerFactory;
    private final Cql cql;
    private final String accentiCollation;
    BiFunction<List<Double>, Optional<EpsgCrs>, List<Double>> coordinatesTransformer;

    public FilterEncoderSql(EpsgCrs nativeCrs, SqlDialect sqlDialect, CrsTransformerFactory crsTransformerFactory, Cql cql, String accentiCollation) {
        this.nativeCrs = nativeCrs;
        this.sqlDialect = sqlDialect;
        this.crsTransformerFactory = crsTransformerFactory;
        this.cql = cql;
        this.accentiCollation = accentiCollation;
        this.coordinatesTransformer = this::transformCoordinatesIfNecessary;
    }

    public String encode(CqlFilter cqlFilter, SchemaSql schema) {
        return this.cql.mapTemporalOperators(cqlFilter, this.sqlDialect.getTemporalOperators()).accept(new CqlToSql(schema));
    }

    public String encode(String cqlFilter, SchemaSql schema) {
        return this.cql.mapTemporalOperators(this.cql.read(cqlFilter, Cql.Format.TEXT), this.sqlDialect.getTemporalOperators()).accept(new CqlToSql(schema));
    }

    private String encodeNested(CqlFilter cqlFilter, SchemaSql schema, boolean isUserFilter) {
        return this.cql.mapTemporalOperators(cqlFilter, this.sqlDialect.getTemporalOperators()).accept(new CqlToSqlNested(schema, isUserFilter));
    }

    private List<Double> transformCoordinatesIfNecessary(List<Double> coordinates, Optional<EpsgCrs> sourceCrs) {
        Optional<CrsTransformer> transformer;
        if (sourceCrs.isPresent() && !Objects.equals(sourceCrs.get(), this.nativeCrs) && (transformer = this.crsTransformerFactory.getTransformer(sourceCrs.get(), this.nativeCrs, true)).isPresent()) {
            double[] transformed = transformer.get().transform(Doubles.toArray(coordinates), coordinates.size() / 2, 2);
            if (Objects.isNull(transformed)) {
                throw new IllegalArgumentException(String.format("Filter is invalid. Coordinates cannot be transformed: %s", coordinates));
            }
            return Doubles.asList(transformed);
        }
        return coordinates;
    }

    public Optional<String> encodeRelationFilter(Optional<SchemaSql> table, Optional<CqlFilter> cqlFilter) {
        if (!table.isPresent() || table.get().getRelation().isEmpty()) {
            return Optional.empty();
        }
        SqlRelation relation = table.get().getRelation().get(table.get().getRelation().size() - 1);
        if (!relation.getTargetFilter().isPresent() && !cqlFilter.isPresent()) {
            return Optional.empty();
        }
        if (relation.getTargetFilter().isPresent() && !cqlFilter.isPresent()) {
            return Optional.of(this.encodeNested(relation.getTargetFilter().map(filter -> this.cql.read((String)filter, Cql.Format.TEXT)).get(), table.get(), false));
        }
        if (!relation.getTargetFilter().isPresent() && cqlFilter.isPresent()) {
            return Optional.of(this.encodeNested(cqlFilter.get(), table.get(), true));
        }
        CqlFilter mergedFilter = CqlFilter.of(And.of(ImmutableCqlPredicate.copyOf(relation.getTargetFilter().map(filter -> this.cql.read((String)filter, Cql.Format.TEXT)).get()), ImmutableCqlPredicate.copyOf(cqlFilter.get())));
        return Optional.of(this.encodeNested(mergedFilter, table.get(), true));
    }

    private static Predicate<SchemaSql> getPropertyNameMatcher(String propertyName, boolean includeObjects) {
        return property -> property.isId() && Objects.equals(propertyName, "_ID_") || (property.isValue() || includeObjects) && property.getSourcePath().isPresent() && Objects.equals(propertyName, property.getSourcePath().get());
    }

    private class CqlToSqlNested
    extends CqlToSql {
        private final SchemaSql schema;
        private final boolean isUserFilter;
        private final List<String> allowedColumnPrefixes;

        private CqlToSqlNested(SchemaSql schema, boolean isUserFilter) {
            super(null);
            this.schema = schema;
            this.isUserFilter = isUserFilter;
            List parentTables = schema.getParentPath().stream().map(element -> element.replaceAll("\\{.*?\\}", "").replaceAll("\\[.*?\\]", "")).collect(Collectors.toList());
            this.allowedColumnPrefixes = new ArrayList<String>();
            Object current = "";
            for (int i = 0; i < parentTables.size(); ++i) {
                current = (String)current + (String)parentTables.get(i) + ".";
                this.allowedColumnPrefixes.add((String)current);
            }
        }

        @Override
        public String visit(Property property, List<String> children) {
            String propertyName = property.getName().replaceAll("^\"|\"$", "");
            boolean hasPrefix = propertyName.contains(".");
            String prefix = hasPrefix ? propertyName.substring(0, propertyName.lastIndexOf(".") + 1) : "";
            boolean hasAllowedPrefix = hasPrefix && this.allowedColumnPrefixes.contains(prefix);
            boolean allowColumnFallback = !hasPrefix || hasAllowedPrefix;
            List<String> aliases = FilterEncoderSql.this.aliasGenerator.getAliases(this.schema, this.isUserFilter ? 1 : 0);
            String alias = hasAllowedPrefix ? aliases.get(this.allowedColumnPrefixes.indexOf(prefix)) : aliases.get(aliases.size() - 1);
            Object qualifiedColumn = this.getQualifiedColumn(this.schema, propertyName, alias, !this.isUserFilter && allowColumnFallback);
            if (((String)qualifiedColumn).startsWith("_route_")) {
                qualifiedColumn = "A." + ((String)qualifiedColumn).replace("_route_", "");
            }
            return String.format("%%1$s%1$s%%2$s", qualifiedColumn);
        }
    }

    private class CqlToSql
    extends CqlToText {
        private final SchemaSql rootSchema;

        private CqlToSql(SchemaSql rootSchema) {
            super(FilterEncoderSql.this.coordinatesTransformer);
            this.rootSchema = rootSchema;
        }

        protected SchemaSql getTable(String propertyName, boolean isObject) {
            if (isObject) {
                return this.rootSchema.getAllObjects().stream().filter(FilterEncoderSql.getPropertyNameMatcher(propertyName, true)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Filter is invalid. Unknown property: %s", propertyName)));
            }
            return this.rootSchema.getAllObjects().stream().filter(obj -> obj.getProperties().stream().anyMatch(FilterEncoderSql.getPropertyNameMatcher(propertyName, false))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Filter is invalid. Unknown property: %s", propertyName)));
        }

        protected String getQualifiedColumn(SchemaSql table, String propertyName, String alias, boolean allowColumnFallback) {
            if (Objects.equals(table.getParentPath(), ImmutableList.of("_route_")) && propertyName.equals("node")) {
                return "_route_" + propertyName;
            }
            if (Objects.equals(table.getParentPath(), ImmutableList.of("_route_")) && propertyName.equals("source")) {
                return String.format("%s.%s", alias, propertyName);
            }
            return table.getProperties().stream().filter(FilterEncoderSql.getPropertyNameMatcher(propertyName, false)).findFirst().map(column -> {
                String qualifiedColumn = String.format("%s.%s", alias, column.getName());
                if (column.isTemporal()) {
                    if (column.getType() == SchemaBase.Type.DATE) {
                        return FilterEncoderSql.this.sqlDialect.applyToDate(qualifiedColumn);
                    }
                    return FilterEncoderSql.this.sqlDialect.applyToDatetime(qualifiedColumn);
                }
                return qualifiedColumn;
            }).or(() -> allowColumnFallback ? Optional.of(String.format("%s.%s", alias, propertyName.substring(propertyName.lastIndexOf(".") + 1))) : Optional.empty()).orElseThrow(() -> new IllegalArgumentException(String.format("Filter is invalid. Unknown property: %s", propertyName)));
        }

        @Override
        public String visit(Property property, List<String> children) {
            Optional<Object> userFilter;
            String propertyName = property.getName().replaceAll("^\"|\"$", "");
            SchemaSql table = this.getTable(propertyName, false);
            ImmutableList<SchemaSql> parents = ImmutableList.of(this.rootSchema);
            List<String> aliases = FilterEncoderSql.this.aliasGenerator.getAliases(parents, table, 1);
            String qualifiedColumn = this.getQualifiedColumn(table, propertyName, aliases.get(aliases.size() - 1), false);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("PROP {} {}", (Object)table.getName(), (Object)qualifiedColumn);
            }
            Optional<SchemaSql> userFilterTable = Optional.empty();
            Optional<String> instanceFilter = Optional.empty();
            if (!property.getNestedFilters().isEmpty()) {
                Optional nestedFilter = property.getNestedFilters().entrySet().stream().findFirst();
                userFilter = nestedFilter.map(Map.Entry::getValue);
                String userFilterPropertyName = this.getUserFilterPropertyName((CqlFilter)userFilter.get());
                if (userFilterPropertyName.contains(FilterEncoderSql.ROW_NUMBER)) {
                    userFilterTable = Optional.of(this.getTable((String)((Map.Entry)nestedFilter.get()).getKey(), true));
                    instanceFilter = this.rootSchema.getFilter().map(cql -> FilterEncoderSql.this.encode((CqlFilter)cql, this.rootSchema));
                } else {
                    userFilterTable = Optional.ofNullable(this.getTable(userFilterPropertyName, false));
                }
            } else {
                userFilter = Optional.empty();
            }
            List<Optional<String>> relationFilters = Stream.concat(parents.stream().flatMap(parent -> parent.getRelation().stream()), table.getRelation().stream()).map(sqlRelation -> Optional.empty()).collect(Collectors.toList());
            Object join = FilterEncoderSql.this.joinGenerator.getJoins(table, parents, aliases, relationFilters, userFilterTable, FilterEncoderSql.this.encodeRelationFilter(userFilterTable, userFilter), instanceFilter);
            if (!((String)join).isEmpty()) {
                join = (String)join + " ";
            }
            return String.format("A.%3$s IN (SELECT %2$s.%3$s FROM %1$s %2$s %4$sWHERE %%1$s%5$s%%2$s)", this.rootSchema.getName(), aliases.get(0), this.rootSchema.getSortKey().get(), join, qualifiedColumn);
        }

        private String getUserFilterPropertyName(CqlFilter userFilter) {
            CqlNode nestedFilter = userFilter.getExpressions().get(0);
            Operand operand = null;
            if (nestedFilter instanceof BinaryScalarOperation) {
                operand = ((BinaryScalarOperation)nestedFilter).getOperands().get(0);
            } else if (nestedFilter instanceof TemporalOperation) {
                operand = ((TemporalOperation)nestedFilter).getOperands().get(0);
            } else if (nestedFilter instanceof SpatialOperation) {
                operand = ((SpatialOperation)nestedFilter).getOperands().get(0);
            } else if (nestedFilter instanceof Like) {
                operand = ((Like)nestedFilter).getOperands().get(0);
            } else if (nestedFilter instanceof In) {
                operand = ((In)nestedFilter).getValue().get();
            } else if (nestedFilter instanceof Between) {
                operand = ((Between)nestedFilter).getValue().get();
            }
            if (operand instanceof Property) {
                return ((Property)operand).getName();
            }
            if (operand instanceof Function) {
                return operand.accept(this);
            }
            throw new IllegalArgumentException("unsupported nested filter");
        }

        @Override
        public String visit(Function function, List<String> children) {
            if (function.isInterval()) {
                String start = children.get(0);
                String end = children.get(1);
                if (start.equals("'..'")) {
                    start = FilterEncoderSql.this.sqlDialect.applyToDatetimeLiteral(FilterEncoderSql.this.sqlDialect.applyToInstantMin());
                }
                if (end.equals("'..'")) {
                    end = FilterEncoderSql.this.sqlDialect.applyToDatetimeLiteral(FilterEncoderSql.this.sqlDialect.applyToInstantMax());
                }
                Operand arg1 = function.getArguments().get(0);
                Operand arg2 = function.getArguments().get(1);
                if (arg1 instanceof Property && arg2 instanceof Property) {
                    String endColumn = end.substring(end.indexOf("%1$s") + 4, end.indexOf("%2$s"));
                    return String.format(start, "%1$s(", ", " + endColumn + ")%2$s");
                }
                if (arg1 instanceof Property && arg2 instanceof TemporalLiteral) {
                    return String.format(start, "%1$s(", ", " + end + ")%2$s");
                }
                if (arg1 instanceof TemporalLiteral && arg2 instanceof Property) {
                    return String.format(end, "%1$s(" + start + ", ", ")%2$s");
                }
                throw new IllegalStateException("unsupported interval function: " + function);
            }
            if (function.isPosition()) {
                return "%1$srow_number%2$s";
            }
            if (function.isUpper()) {
                if (function.getArguments().get(0) instanceof ScalarLiteral) {
                    return children.get(0).toLowerCase();
                }
                if (function.getArguments().get(0) instanceof Property || function.getArguments().get(0) instanceof Function) {
                    return String.format(children.get(0), "%1$sUPPER(", ")%2$s");
                }
                if (function.getArguments().get(0) instanceof Function) {
                    if (children.get(0).contains("%1$s") && children.get(0).contains("%2$s")) {
                        return String.format(children.get(0), "%1$sUPPER(", ")%2$s");
                    }
                    return String.format("UPPER(%s)", children.get(0));
                }
            } else if (function.isCasei() || function.isLower()) {
                if (function.getArguments().get(0) instanceof ScalarLiteral) {
                    return children.get(0).toLowerCase();
                }
                if (function.getArguments().get(0) instanceof Property) {
                    return String.format(children.get(0), "%1$sLOWER(", ")%2$s");
                }
                if (function.getArguments().get(0) instanceof Function) {
                    if (children.get(0).contains("%1$s") && children.get(0).contains("%2$s")) {
                        return String.format(children.get(0), "%1$sLOWER(", ")%2$s");
                    }
                    return String.format("LOWER(%s)", children.get(0));
                }
            } else if (function.isAccenti()) {
                if (function.getArguments().get(0) instanceof ScalarLiteral) {
                    if (Objects.nonNull(FilterEncoderSql.this.accentiCollation)) {
                        return String.format("%s COLLATE \"%s\"", children.get(0), FilterEncoderSql.this.accentiCollation);
                    }
                    throw new IllegalArgumentException("ACCENTI() is not supported by this API.");
                }
                if (function.getArguments().get(0) instanceof Property) {
                    if (Objects.nonNull(FilterEncoderSql.this.accentiCollation)) {
                        return children.get(0).replace("%2$s", " COLLATE \"" + FilterEncoderSql.this.accentiCollation + "\"%2$s");
                    }
                    throw new IllegalArgumentException("ACCENTI() is not supported by this API.");
                }
                return children.get(0);
            }
            return super.visit(function, (List)children);
        }

        private String reduceSelectToColumn(String expression) {
            if (expression.contains("%1$s") && expression.contains("%2$s")) {
                return String.format(expression.contains(" WHERE ") ? expression.substring(expression.indexOf(" WHERE ") + 7, expression.length() - 1) : expression, "", "");
            }
            return expression;
        }

        private String replaceColumnWithLiteral(String expression, String column, String literal) {
            return expression.replace(String.format("%%1$s%1$s%%2$s", column), String.format("%%1$s%1$s%%2$s", literal));
        }

        private String replaceColumnWithInterval(String expression, String column) {
            return expression.replace(String.format("%%1$s%1$s%%2$s", column), String.format("%%1$s(%1$s,%1$s)%%2$s", column));
        }

        private boolean operandIsOfType(Operand operand, Class ... classes) {
            return Arrays.stream(classes).anyMatch(clazz -> clazz.isInstance(operand));
        }

        private List<String> processBinary(List<Operand> operands, List<String> children) {
            String mainExpression = children.get(0);
            String secondExpression = children.get(1);
            boolean op1hasSelect = this.operandIsOfType(operands.get(0), Property.class, Function.class);
            boolean op2hasSelect = this.operandIsOfType(operands.get(1), Property.class, Function.class);
            if (op1hasSelect) {
                if (op2hasSelect) {
                    secondExpression = this.reduceSelectToColumn(children.get(1));
                }
            } else if (op2hasSelect) {
                secondExpression = this.reduceSelectToColumn(children.get(1));
                mainExpression = this.replaceColumnWithLiteral(children.get(1), secondExpression, children.get(0));
            } else {
                mainExpression = String.format("%%1$s%1$s%%2$s", children.get(0));
            }
            return ImmutableList.of(mainExpression, secondExpression);
        }

        private List<String> processTernary(List<Operand> operands, List<String> children) {
            String mainExpression = children.get(0);
            String secondExpression = children.get(1);
            String thirdExpression = children.get(2);
            boolean op1hasSelect = this.operandIsOfType(operands.get(0), Property.class, Function.class);
            boolean op2hasSelect = this.operandIsOfType(operands.get(1), Property.class, Function.class);
            boolean op3hasSelect = this.operandIsOfType(operands.get(2), Property.class, Function.class);
            if (op1hasSelect) {
                if (op2hasSelect) {
                    secondExpression = this.reduceSelectToColumn(children.get(1));
                }
                if (op3hasSelect) {
                    thirdExpression = this.reduceSelectToColumn(children.get(2));
                }
            } else if (op2hasSelect && !op3hasSelect) {
                secondExpression = this.reduceSelectToColumn(children.get(1));
                mainExpression = this.replaceColumnWithLiteral(children.get(1), secondExpression, children.get(0));
            } else if (!op2hasSelect && op3hasSelect) {
                thirdExpression = this.reduceSelectToColumn(children.get(2));
                mainExpression = this.replaceColumnWithLiteral(children.get(2), thirdExpression, children.get(0));
            } else if (op2hasSelect && op3hasSelect) {
                secondExpression = this.reduceSelectToColumn(children.get(1));
                mainExpression = this.replaceColumnWithLiteral(children.get(1), secondExpression, children.get(0));
                thirdExpression = this.reduceSelectToColumn(children.get(2));
            } else if (!op2hasSelect && !op3hasSelect) {
                mainExpression = String.format("%%1$s%1$s%%2$s", children.get(0));
            }
            return ImmutableList.of(mainExpression, secondExpression, thirdExpression);
        }

        @Override
        public String visit(BinaryScalarOperation scalarOperation, List<String> children) {
            String operator = (String)SCALAR_OPERATORS.get(scalarOperation.getClass());
            List<String> expressions = this.processBinary(scalarOperation.getOperands(), children);
            String operation = String.format(" %s %s", operator, expressions.get(1));
            return String.format(expressions.get(0), "", operation);
        }

        @Override
        public String visit(Like like, List<String> children) {
            String operator = (String)SCALAR_OPERATORS.get(like.getClass());
            List<String> expressions = this.processBinary(like.getOperands(), children);
            String secondExpression = expressions.get(1);
            String functionStart = "";
            String functionEnd = "";
            String operation = String.format("::varchar%s %s %s", functionEnd, operator, secondExpression);
            return String.format(expressions.get(0), functionStart, operation);
        }

        @Override
        public String visit(In in, List<String> children) {
            String operator = (String)SCALAR_OPERATORS.get(in.getClass());
            String mainExpression = "";
            Scalar op1 = in.getValue().get();
            if (op1 instanceof Property) {
                mainExpression = children.get(0);
            } else if (op1 instanceof Function) {
                mainExpression = children.get(0);
            } else if (op1 instanceof ScalarLiteral) {
                mainExpression = String.format("%%1$s%1$s%%2$s", children.get(0));
            } else {
                throw new IllegalArgumentException(String.format("In: Cannot process operand of type %s with value %s.", op1.getClass().getSimpleName(), mainExpression));
            }
            String operation = String.format(" %s (%s)", operator, String.join((CharSequence)", ", children.subList(1, children.size())));
            return String.format(mainExpression, "", operation);
        }

        @Override
        public String visit(IsNull isNull, List<String> children) {
            String operator = (String)SCALAR_OPERATORS.get(isNull.getClass());
            String mainExpression = "";
            Operand op1 = isNull.getOperand().get();
            if (op1 instanceof Property) {
                mainExpression = children.get(0);
            } else if (op1 instanceof ScalarLiteral) {
                mainExpression = String.format("%%1$s%1$s%%2$s", children.get(0));
            } else {
                throw new IllegalArgumentException(String.format("IsNull: Cannot process operand of type %s with value %s.", op1.getClass().getSimpleName(), mainExpression));
            }
            String operation = String.format(" %s", operator);
            return String.format(mainExpression, "", operation);
        }

        @Override
        public String visit(Between between, List<String> children) {
            String operator = (String)SCALAR_OPERATORS.get(between.getClass());
            Scalar op1 = between.getValue().get();
            Scalar op2 = between.getLower().get();
            Scalar op3 = between.getUpper().get();
            List<String> expressions = this.processTernary(ImmutableList.of(op1, op2, op3), children);
            String operation = String.format(" %s %s AND %s", operator, expressions.get(1), expressions.get(2));
            return String.format(expressions.get(0), "", operation);
        }

        @Override
        public String visit(TemporalOperation temporalOperation, List<String> children) {
            String operator = FilterEncoderSql.this.sqlDialect.getTemporalOperator(temporalOperation);
            if (Objects.isNull(operator)) {
                throw new IllegalStateException(String.format("unexpected temporal operator: %s", temporalOperation.getClass()));
            }
            Temporal op1 = (Temporal)temporalOperation.getOperands().get(0);
            Temporal op2 = (Temporal)temporalOperation.getOperands().get(1);
            if (op1 instanceof Property) {
                children = ImmutableList.of(this.replaceColumnWithInterval(children.get(0), this.reduceSelectToColumn(children.get(0))), children.get(1));
            } else if (op1 instanceof TemporalLiteral) {
                children = ImmutableList.of(String.format("(%s, %s)", this.getStartAsString((TemporalLiteral)op1), this.getEndExclusiveAsString((TemporalLiteral)op1)), children.get(1));
            } else if (op1 instanceof Function) {
                // empty if block
            }
            if (op2 instanceof Property) {
                children = ImmutableList.of(children.get(0), this.replaceColumnWithInterval(children.get(1), this.reduceSelectToColumn(children.get(1))));
            } else if (op2 instanceof TemporalLiteral) {
                if (((TemporalLiteral)op2).getType() != Function.class) {
                    children = ImmutableList.of(children.get(0), this.getInterval((TemporalLiteral)op2));
                }
            } else if (op2 instanceof Function) {
                // empty if block
            }
            List<String> expressions = this.processBinary(ImmutableList.of(op1, op2), children);
            return String.format(expressions.get(0), "", String.format(" %s %s", operator, expressions.get(1)));
        }

        private String getInterval(TemporalLiteral literal) {
            return String.format("(%s,%s)", this.getStartAsString(literal), this.getEndExclusiveAsString(literal));
        }

        private Instant getStart(TemporalLiteral literal) {
            if (literal.getType() == Interval.class) {
                return ((Interval)literal.getValue()).getStart();
            }
            if (literal.getType() == Instant.class) {
                return (Instant)literal.getValue();
            }
            if (literal.getType() == TemporalLiteral.OPEN.class) {
                return Instant.MIN;
            }
            if (literal.getType() == Function.class) {
                Function function = (Function)literal.getValue();
                assert (function.isInterval());
                assert (function.getArguments().get(0) instanceof TemporalLiteral);
                return this.getStart((TemporalLiteral)function.getArguments().get(0));
            }
            return ((LocalDate)literal.getValue()).atStartOfDay(ZoneOffset.UTC).toInstant();
        }

        private String getStartAsString(TemporalLiteral literal) {
            Instant instant = this.getStart(literal);
            if (instant == Instant.MIN) {
                return FilterEncoderSql.this.sqlDialect.applyToDatetimeLiteral(FilterEncoderSql.this.sqlDialect.applyToInstantMin());
            }
            return FilterEncoderSql.this.sqlDialect.applyToDatetimeLiteral(instant.toString());
        }

        private Instant getEndExclusive(TemporalLiteral literal) {
            if (literal.getType() == Interval.class) {
                return ((Interval)literal.getValue()).getEnd();
            }
            if (literal.getType() == Instant.class) {
                return (Instant)literal.getValue();
            }
            if (literal.getType() == TemporalLiteral.OPEN.class) {
                return Instant.MAX;
            }
            if (literal.getType() == Function.class) {
                Function function = (Function)literal.getValue();
                assert (function.isInterval());
                assert (function.getArguments().get(1) instanceof TemporalLiteral);
                return this.getEndExclusive((TemporalLiteral)function.getArguments().get(1));
            }
            return ((LocalDate)literal.getValue()).plusDays(1L).atStartOfDay(ZoneOffset.UTC).toInstant();
        }

        private String getEndExclusiveAsString(TemporalLiteral literal) {
            Instant instant = this.getEndExclusive(literal);
            if (instant == Instant.MAX) {
                return FilterEncoderSql.this.sqlDialect.applyToDatetimeLiteral(FilterEncoderSql.this.sqlDialect.applyToInstantMax());
            }
            return FilterEncoderSql.this.sqlDialect.applyToDatetimeLiteral(instant.toString());
        }

        @Override
        public String visit(SpatialOperation spatialOperation, List<String> children) {
            String operator = FilterEncoderSql.this.sqlDialect.getSpatialOperator(spatialOperation);
            List<String> expressions = this.processBinary(spatialOperation.getOperands(), children);
            return String.format(expressions.get(0), String.format("%s(", operator), String.format(", %s)", expressions.get(1)));
        }

        @Override
        public String visit(TemporalLiteral temporalLiteral, List<String> children) {
            if (temporalLiteral.getType() == Instant.class) {
                Instant instant = (Instant)temporalLiteral.getValue();
                String literal = instant == Instant.MIN ? FilterEncoderSql.this.sqlDialect.applyToInstantMin() : (instant == Instant.MAX ? FilterEncoderSql.this.sqlDialect.applyToInstantMax() : ((Instant)temporalLiteral.getValue()).toString());
                return FilterEncoderSql.this.sqlDialect.applyToDatetimeLiteral(literal);
            }
            if (temporalLiteral.getType() == Interval.class) {
                return this.getInterval(temporalLiteral);
            }
            if (temporalLiteral.getType() == Function.class) {
                Function function = (Function)temporalLiteral.getValue();
                assert (function.isInterval());
                Operand arg1 = function.getArguments().get(0);
                assert (arg1 instanceof TemporalLiteral);
                Operand arg2 = function.getArguments().get(1);
                assert (arg2 instanceof TemporalLiteral);
                return String.format("(%s,%s)", this.getStartAsString((TemporalLiteral)arg1), this.getEndExclusiveAsString((TemporalLiteral)arg2));
            }
            if (temporalLiteral.getType() == LocalDate.class) {
                return FilterEncoderSql.this.sqlDialect.applyToDateLiteral(((LocalDate)temporalLiteral.getValue()).toString());
            }
            if (temporalLiteral.getType() == TemporalLiteral.OPEN.class) {
                return "'..'";
            }
            throw new IllegalStateException("unsupported temporal SQL literal: " + temporalLiteral);
        }

        @Override
        public String visit(Geometry.Point point, List<String> children) {
            return String.format("ST_GeomFromText('%s',%s)", super.visit(point, (List)children), FilterEncoderSql.this.nativeCrs.getCode());
        }

        @Override
        public String visit(Geometry.LineString lineString, List<String> children) {
            return String.format("ST_GeomFromText('%s',%s)", super.visit(lineString, (List)children), FilterEncoderSql.this.nativeCrs.getCode());
        }

        @Override
        public String visit(Geometry.Polygon polygon, List<String> children) {
            return String.format("ST_GeomFromText('%s',%s)", super.visit(polygon, (List)children), FilterEncoderSql.this.nativeCrs.getCode());
        }

        @Override
        public String visit(Geometry.MultiPoint multiPoint, List<String> children) {
            return String.format("ST_GeomFromText('%s',%s)", super.visit(multiPoint, (List)children), FilterEncoderSql.this.nativeCrs.getCode());
        }

        @Override
        public String visit(Geometry.MultiLineString multiLineString, List<String> children) {
            return String.format("ST_GeomFromText('%s',%s)", super.visit(multiLineString, (List)children), FilterEncoderSql.this.nativeCrs.getCode());
        }

        @Override
        public String visit(Geometry.MultiPolygon multiPolygon, List<String> children) {
            return String.format("ST_GeomFromText('%s',%s)", super.visit(multiPolygon, (List)children), FilterEncoderSql.this.nativeCrs.getCode());
        }

        @Override
        public String visit(Geometry.Envelope envelope, List<String> children) {
            List<Double> c = envelope.getCoordinates();
            EpsgCrs crs = envelope.getCrs().orElse(OgcCrs.CRS84);
            int epsgCode = crs.getCode();
            boolean hasDiscontinuityAt180DegreeLongitude = ImmutableList.of(Integer.valueOf(4326), Integer.valueOf(4979), Integer.valueOf(4259), Integer.valueOf(4269)).contains(epsgCode);
            if (c.get(0) > c.get(2) && hasDiscontinuityAt180DegreeLongitude) {
                ImmutableList<Geometry.Coordinate> coordinates1 = ImmutableList.of(Geometry.Coordinate.of(c.get(0), c.get(1)), Geometry.Coordinate.of(180.0, c.get(1)), Geometry.Coordinate.of(180.0, c.get(3)), Geometry.Coordinate.of(c.get(0), c.get(3)), Geometry.Coordinate.of(c.get(0), c.get(1)));
                ImmutableList<Geometry.Coordinate> coordinates2 = ImmutableList.of(Geometry.Coordinate.of(-180.0, c.get(1)), Geometry.Coordinate.of(c.get(2), c.get(1)), Geometry.Coordinate.of(c.get(2), c.get(3)), Geometry.Coordinate.of(-180.0, c.get(3)), Geometry.Coordinate.of(-180.0, c.get(1)));
                ImmutablePolygon polygon1 = new ImmutablePolygon.Builder().addCoordinates((List<Geometry.Coordinate>)coordinates1).crs(crs).build();
                ImmutablePolygon polygon2 = new ImmutablePolygon.Builder().addCoordinates((List<Geometry.Coordinate>)coordinates2).crs(crs).build();
                ImmutableMultiPolygon twoEnvelopes = new ImmutableMultiPolygon.Builder().addCoordinates(polygon1, polygon2).crs(crs).build();
                return this.visit((Geometry.MultiPolygon)twoEnvelopes, (List)ImmutableList.of());
            }
            ImmutableList<Geometry.Coordinate> coordinates = ImmutableList.of(Geometry.Coordinate.of(c.get(0), c.get(1)), Geometry.Coordinate.of(c.get(2), c.get(1)), Geometry.Coordinate.of(c.get(2), c.get(3)), Geometry.Coordinate.of(c.get(0), c.get(3)), Geometry.Coordinate.of(c.get(0), c.get(1)));
            ImmutablePolygon polygon = new ImmutablePolygon.Builder().addCoordinates((List<Geometry.Coordinate>)coordinates).crs(crs).build();
            return this.visit((Geometry.Polygon)polygon, (List)ImmutableList.of());
        }

        @Override
        public String visit(ArrayOperation arrayOperation, List<String> children) {
            String mainExpression = children.get(0);
            String secondExpression = children.get(1);
            boolean op1hasSelect = this.operandIsOfType(arrayOperation.getOperands().get(0), Property.class, Function.class);
            boolean op2hasSelect = this.operandIsOfType(arrayOperation.getOperands().get(1), Property.class, Function.class);
            boolean notInverse = true;
            if (op1hasSelect) {
                if (op2hasSelect) {
                    throw new IllegalArgumentException("Array predicates with property references on both sides are not supported.");
                }
            } else if (op2hasSelect) {
                mainExpression = children.get(1);
                secondExpression = children.get(0);
                notInverse = false;
                op1hasSelect = true;
                op2hasSelect = false;
            } else {
                List<String> firstOp = ARRAY_SPLITTER.splitToList(mainExpression.replaceAll("\\[|\\]", ""));
                List<String> secondOp = ARRAY_SPLITTER.splitToList(secondExpression.replaceAll("\\[|\\]", ""));
                switch (arrayOperation.getOperator()) {
                    case A_CONTAINS: {
                        return secondOp.stream().allMatch(item -> firstOp.stream().anyMatch(item2 -> item.equals(item2))) ? "1=1" : "1=0";
                    }
                    case A_EQUALS: {
                        if (firstOp.size() != secondOp.size()) {
                            return "1=0";
                        }
                        return secondOp.stream().allMatch(item -> firstOp.stream().anyMatch(item2 -> item.equals(item2))) ? "1=1" : "1=0";
                    }
                    case A_OVERLAPS: {
                        return secondOp.stream().anyMatch(item -> firstOp.stream().anyMatch(item2 -> item.equals(item2))) ? "1=1" : "1=0";
                    }
                    case A_CONTAINEDBY: {
                        return firstOp.stream().allMatch(item -> secondOp.stream().anyMatch(item2 -> item.equals(item2))) ? "1=1" : "1=0";
                    }
                }
                throw new IllegalArgumentException("unsupported array operator: " + arrayOperation.getOperator());
            }
            if (op1hasSelect && op2hasSelect) {
                throw new IllegalArgumentException("Array predicates with property references on both sides are not supported.");
            }
            int elementCount = secondExpression.split(",").length;
            String propertyName = ((Property)arrayOperation.getOperands().get(notInverse ? 0 : 1)).getName();
            SchemaSql table = this.getTable(propertyName, false);
            List<String> aliases = FilterEncoderSql.this.aliasGenerator.getAliases(table, 1);
            String qualifiedColumn = this.getQualifiedColumn(table, propertyName, aliases.get(aliases.size() - 1), false);
            if (notInverse ? arrayOperation.getOperator() == ArrayOperator.A_CONTAINS : arrayOperation.getOperator() == ArrayOperator.A_CONTAINEDBY) {
                String arrayQuery = String.format(" IN %1$s GROUP BY %2$s.%3$s HAVING count(distinct %4$s) = %5$s", secondExpression, aliases.get(0), this.rootSchema.getSortKey().get(), qualifiedColumn, elementCount);
                return String.format(mainExpression, "", arrayQuery);
            }
            if (arrayOperation.getOperator() == ArrayOperator.A_EQUALS) {
                String arrayQuery = String.format(" IS NOT NULL GROUP BY %2$s.%3$s HAVING count(distinct %4$s) = %5$s AND count(case when %4$s not in %1$s then %4$s else null end) = 0", secondExpression, aliases.get(0), this.rootSchema.getSortKey().get(), qualifiedColumn, elementCount);
                return String.format(mainExpression, "", arrayQuery);
            }
            if (arrayOperation.getOperator() == ArrayOperator.A_OVERLAPS) {
                String arrayQuery = String.format(" IN %1$s GROUP BY %2$s.%3$s", secondExpression, aliases.get(0), this.rootSchema.getSortKey().get());
                return String.format(mainExpression, "", arrayQuery);
            }
            if (notInverse ? arrayOperation.getOperator() == ArrayOperator.A_CONTAINEDBY : arrayOperation.getOperator() == ArrayOperator.A_CONTAINS) {
                String arrayQuery = String.format(" IS NOT NULL GROUP BY %2$s.%3$s HAVING count(case when %4$s not in %1$s then %4$s else null end) = 0", secondExpression, aliases.get(0), this.rootSchema.getSortKey().get(), qualifiedColumn);
                return String.format(mainExpression, "", arrayQuery);
            }
            throw new IllegalStateException("unexpected array operator: " + arrayOperation);
        }

        @Override
        public String visit(ArrayLiteral arrayLiteral, List<String> children) {
            if (arrayLiteral.getValue() instanceof String) {
                return (String)arrayLiteral.getValue();
            }
            List elements = ((List)arrayLiteral.getValue()).stream().map(e -> e.accept(this)).map(e -> String.format("%s", e)).collect(Collectors.toList());
            return String.format("(%s)", String.join((CharSequence)",", elements));
        }

        @Override
        public String visit(LogicalOperation logicalOperation, List<String> children) {
            String operator = (String)LOGICAL_OPERATORS.get(logicalOperation.getClass());
            return super.visit(logicalOperation, (List)children);
        }

        @Override
        public String visit(Not not, List<String> children) {
            String operator = (String)LOGICAL_OPERATORS.get(not.getClass());
            String operation = children.get(0);
            if (not.getPredicate().get().getInOperator().isPresent()) {
                int pos = operation.lastIndexOf(" IN ");
                int length = operation.length();
                return String.format("%s %s %s", operation.substring(0, pos), operator, operation.substring(pos + 1, length));
            }
            return super.visit(not, (List)children);
        }
    }
}

