/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.cql.domain.Cql;
import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureStoreInstanceContainer;
import de.ii.xtraplatform.features.domain.FeatureStorePathParser;
import de.ii.xtraplatform.features.domain.FeatureStoreRelatedContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreRelation;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreAttribute;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreInstanceContainer;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreRelatedContainer;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreRelation;
import de.ii.xtraplatform.features.sql.ImmutableSqlPath;
import de.ii.xtraplatform.features.sql.SqlFeatureTypeParser;
import de.ii.xtraplatform.features.sql.SqlPath;
import de.ii.xtraplatform.features.sql.SqlPathSyntax;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;

public class FeatureStorePathParserSql
implements FeatureStorePathParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureStorePathParserSql.class);
    private final SqlPathSyntax syntax;
    private final SqlFeatureTypeParser mappingParser;
    private final Cql cql;

    public FeatureStorePathParserSql(SqlPathSyntax syntax, Cql cql) {
        this.syntax = syntax;
        this.mappingParser = new SqlFeatureTypeParser(syntax);
        this.cql = cql;
    }

    @Override
    public List<FeatureStoreInstanceContainer> parse(FeatureSchema schema) {
        List<String> paths = this.mappingParser.parse(schema);
        List<SqlPath> sortedPaths = paths.stream().sorted(this::sortByPriority).map(this::toSqlPath).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List<FeatureStoreInstanceContainer> mergedPaths = this.toInstanceContainers(sortedPaths);
        return mergedPaths;
    }

    private int sortByPriority(String path1, String path2) {
        OptionalInt priority1 = this.syntax.getPriorityFlag(path1);
        OptionalInt priority2 = this.syntax.getPriorityFlag(path2);
        if (path1.indexOf(47, 1) < path1.lastIndexOf(47) && path2.indexOf(47, 1) < path2.lastIndexOf(47)) {
            String table1 = path1.substring(0, path1.lastIndexOf(47));
            String table2 = path2.substring(0, path2.lastIndexOf(47));
            if (table2.indexOf(47, 1) < table2.lastIndexOf(47) && !Objects.equals(table2, table1) && table2.startsWith(table1)) {
                return -1;
            }
        }
        return priority1.isEmpty() ? 1 : (priority2.isEmpty() ? -1 : priority1.getAsInt() - priority2.getAsInt());
    }

    private Optional<SqlPath> toSqlPath(String path) {
        Matcher matcher = this.syntax.getColumnPathPattern().matcher(path);
        if (matcher.find()) {
            String tablePath = matcher.group("path");
            LinkedHashMap<String, String> tableFlags = new LinkedHashMap<String, String>();
            Matcher tableMatcher = this.syntax.getTablePattern().matcher(tablePath);
            while (tableMatcher.find()) {
                String flags = tableMatcher.group("tableFlags");
                String tableName = tableMatcher.group("table");
                tablePath = tablePath.replace(flags, "");
                tableFlags.putIfAbsent(tableName, flags);
            }
            String columnString = matcher.group("columns");
            ImmutableList<String> columns = Objects.nonNull(columnString) ? this.syntax.getMultiColumnSplitter().splitToList(columnString) : ImmutableList.of();
            String flags = matcher.group("pathFlags");
            OptionalInt priority = this.syntax.getPriorityFlag(flags);
            boolean hasOid = this.syntax.getOidFlag(flags);
            List<String> tablePathAsList = this.syntax.asList(tablePath);
            boolean isRoot = tablePathAsList.size() == 1;
            boolean isJunction = this.syntax.isJunctionTable(tablePathAsList.get(tablePathAsList.size() - 1));
            Optional<String> queryable = this.syntax.getQueryableFlag(flags).map(q -> q.replaceAll("\\[", "").replaceAll("]", ""));
            boolean isSpatial = this.syntax.getSpatialFlag(flags);
            boolean isTemporal = this.syntax.getTemporalFlag(flags);
            String sortKey = tableFlags.values().stream().findFirst().flatMap(this.syntax::getSortKeyFlag).orElse(this.syntax.getOptions().getSortKey());
            Optional<String> constant = this.syntax.getConstantFlag(flags);
            return Optional.of(new ImmutableSqlPath.Builder().tablePath(tablePath).tableFlags(tableFlags).columns(columns).hasOid(hasOid).sortPriority(priority).isRoot(isRoot).isJunction(isJunction).queryable(queryable.get()).isSpatial(isSpatial).isTemporal(isTemporal).constantValue(constant).build());
        }
        LOGGER.warn("Invalid path in provider configuration: {}", (Object)path);
        return Optional.empty();
    }

    private List<FeatureStoreInstanceContainer> toInstanceContainers(List<SqlPath> sqlPaths) {
        LinkedHashMap groupedPaths = sqlPaths.stream().collect(Collectors.groupingBy(SqlPath::getTablePathWithFlags, LinkedHashMap::new, Collectors.toList()));
        LinkedHashMap instanceContainerBuilders = new LinkedHashMap();
        int[] instancePos = new int[]{0};
        groupedPaths.entrySet().stream().forEach(entry -> {
            String tablePath = (String)entry.getKey();
            List<String> tablePathAsList = this.syntax.asList(tablePath);
            List columnPaths = (List)entry.getValue();
            List columns = columnPaths.stream().flatMap(sqlPath -> sqlPath.getColumns().stream()).collect(Collectors.toList());
            List attributes = columnPaths.stream().flatMap(sqlPath -> sqlPath.getColumns().stream().map(name -> ImmutableFeatureStoreAttribute.builder().name((String)name).path(tablePathAsList).addPath((String)name).queryable(sqlPath.getQueryable()).isId(sqlPath.hasOid()).isSpatial(sqlPath.isSpatial()).isTemporal(sqlPath.isTemporal()).constantValue(sqlPath.getConstantValue()).build())).collect(Collectors.toList());
            boolean hasOid = columnPaths.stream().anyMatch(SqlPath::hasOid);
            OptionalInt priority = columnPaths.stream().flatMapToInt(columnPath -> {
                OptionalInt sortPriority = columnPath.getSortPriority();
                return sortPriority.isPresent() ? IntStream.of(sortPriority.getAsInt()) : IntStream.empty();
            }).findFirst();
            boolean isRoot = columnPaths.stream().anyMatch(SqlPath::isRoot);
            Matcher instanceContainerNameMatcher = this.syntax.getTablePattern().matcher(tablePathAsList.get(0));
            if (!instanceContainerNameMatcher.find()) {
                throw new IllegalStateException("Unexpected error parsing the provider schema");
            }
            String instanceContainerName = instanceContainerNameMatcher.group("table");
            Matcher attributesContainerNameMatcher = this.syntax.getTablePattern().matcher(tablePathAsList.get(tablePathAsList.size() - 1));
            if (!attributesContainerNameMatcher.find()) {
                throw new IllegalStateException("Unexpected error parsing the provider schema");
            }
            String attributesContainerName = attributesContainerNameMatcher.group("table");
            if (!instanceContainerBuilders.containsKey(instanceContainerName)) {
                instanceContainerBuilders.put(instanceContainerName, ImmutableFeatureStoreInstanceContainer.builder());
            }
            Map stringFilters = columnPaths.stream().flatMap(sqlPath -> sqlPath.getTableFlags().entrySet().stream()).filter(entry2 -> this.syntax.getFilterFlag((String)entry2.getValue()).isPresent()).map(entry2 -> new AbstractMap.SimpleImmutableEntry<String, String>((String)entry2.getKey(), this.syntax.getFilterFlag((String)entry2.getValue()).get())).distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            ImmutableMap<String, CqlFilter> filters = Objects.isNull(this.cql) ? ImmutableMap.of() : (Map)stringFilters.entrySet().stream().map(entry2 -> new AbstractMap.SimpleImmutableEntry<String, CqlFilter>((String)entry2.getKey(), this.cql.read((String)entry2.getValue(), Cql.Format.TEXT))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            Map sortKeys = columnPaths.stream().flatMap(sqlPath -> sqlPath.getTableFlags().entrySet().stream()).filter(entry2 -> this.syntax.getSortKeyFlag((String)entry2.getValue()).isPresent()).map(entry2 -> new AbstractMap.SimpleImmutableEntry<String, String>((String)entry2.getKey(), this.syntax.getSortKeyFlag((String)entry2.getValue()).get())).distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            if (isRoot) {
                ImmutableFeatureStoreInstanceContainer.Builder instanceContainerBuilder = (ImmutableFeatureStoreInstanceContainer.Builder)instanceContainerBuilders.get(instanceContainerName);
                Optional<CqlFilter> filter = Optional.ofNullable((CqlFilter)filters.get(instanceContainerName));
                String sortKey = sortKeys.getOrDefault(instanceContainerName, this.syntax.getOptions().getSortKey());
                instanceContainerBuilder.name(instanceContainerName).sortKey(sortKey).attributes(attributes).attributesPosition(instancePos[0]).filter(filter);
                instancePos[0] = 0;
            } else {
                List<FeatureStoreRelation> instanceConnection = this.toRelations(tablePathAsList, filters, stringFilters, sortKeys);
                String defaultSortKey = this.syntax.isJunctionTable(attributesContainerName) ? instanceConnection.get(instanceConnection.size() - 1).getTargetField() : this.syntax.getOptions().getSortKey();
                String sortKey = sortKeys.getOrDefault(attributesContainerName, defaultSortKey);
                ImmutableFeatureStoreRelatedContainer attributesContainer = ImmutableFeatureStoreRelatedContainer.builder().name(attributesContainerName).sortKey(sortKey).instanceConnection(instanceConnection).attributes(attributes).build();
                ((ImmutableFeatureStoreInstanceContainer.Builder)instanceContainerBuilders.get(instanceContainerName)).addRelatedContainers((FeatureStoreRelatedContainer)attributesContainer);
                instancePos[0] = instancePos[0] + 1;
            }
        });
        return instanceContainerBuilders.values().stream().map(ImmutableFeatureStoreInstanceContainer.Builder::build).collect(Collectors.toList());
    }

    private List<FeatureStoreRelation> toRelations(List<String> path, Map<String, CqlFilter> filters, Map<String, String> stringFilters, Map<String, String> sortKeys) {
        if (path.size() < 2) {
            throw new IllegalArgumentException(String.format("not a valid relation path: %s", path));
        }
        if (path.size() > 2) {
            return IntStream.range(2, path.size()).mapToObj(i -> this.toRelations((String)path.get(i - 2), (String)path.get(i - 1), (String)path.get(i), i == path.size() - 1, filters, stringFilters, sortKeys)).flatMap(Function.identity()).collect(Collectors.toList());
        }
        return IntStream.range(1, path.size()).mapToObj(i -> this.toRelation((String)path.get(i - 1), (String)path.get(i), filters, stringFilters, sortKeys)).collect(Collectors.toList());
    }

    private Stream<FeatureStoreRelation> toRelations(String source, String link, String target, boolean isLast, Map<String, CqlFilter> filters, Map<String, String> stringFilters, Map<String, String> sortKeys) {
        if (this.syntax.isJunctionTable(source)) {
            if (isLast) {
                return Stream.of(this.toRelation(link, target, filters, stringFilters, sortKeys));
            }
            return Stream.empty();
        }
        if (this.syntax.isJunctionTable(target) && !isLast) {
            return Stream.of(this.toRelation(source, link, filters, stringFilters, sortKeys));
        }
        if (this.syntax.isJunctionTable(link)) {
            return Stream.of(this.toRelation(source, link, target, sortKeys));
        }
        return Stream.of(this.toRelation(source, link, filters, stringFilters, sortKeys), this.toRelation(link, target, filters, stringFilters, sortKeys));
    }

    private FeatureStoreRelation toRelation(String source, String target, Map<String, CqlFilter> filters, Map<String, String> stringFilters, Map<String, String> sortKeys) {
        Matcher sourceMatcher = this.syntax.getTablePattern().matcher(source);
        Matcher targetMatcher = this.syntax.getJoinedTablePattern().matcher(target);
        if (sourceMatcher.find() && targetMatcher.find()) {
            String sourceContainer = sourceMatcher.group("table");
            String sourceField = targetMatcher.group("sourceField");
            String targetContainer = targetMatcher.group("table");
            String targetField = targetMatcher.group("targetField");
            boolean isOne2One = Objects.equals(targetField, this.syntax.getOptions().getPrimaryKey());
            Optional<String> sourceFilter = Optional.ofNullable(stringFilters.get(sourceContainer)).map(f -> String.format("{filter=%s}", f));
            Optional<String> targetFilter = Optional.ofNullable(stringFilters.get(targetContainer)).map(f -> String.format("{filter=%s}", f));
            Optional<CqlFilter> targetFilter2 = Optional.ofNullable(filters.get(targetContainer));
            String sortKey = sortKeys.getOrDefault(sourceContainer, this.syntax.getOptions().getSortKey());
            return ImmutableFeatureStoreRelation.builder().cardinality(isOne2One ? FeatureStoreRelation.CARDINALITY.ONE_2_ONE : FeatureStoreRelation.CARDINALITY.ONE_2_N).sourceContainer(sourceContainer).sourceField(sourceField).sourceSortKey(sortKey).sourceFilter(sourceFilter).targetContainer(targetContainer).targetField(targetField).targetFilter(targetFilter).filter(targetFilter2).build();
        }
        throw new IllegalArgumentException(String.format("not a valid relation path: %s/%s", source, target));
    }

    private FeatureStoreRelation toRelation(String source, String link, String target, Map<String, String> sortKeys) {
        Matcher sourceMatcher = this.syntax.getTablePattern().matcher(source);
        Matcher junctionMatcher = this.syntax.getJoinedTablePattern().matcher(link);
        Matcher targetMatcher = this.syntax.getJoinedTablePattern().matcher(target);
        if (sourceMatcher.find() && junctionMatcher.find() && targetMatcher.find()) {
            String sourceContainer = sourceMatcher.group("table");
            Optional<String> sourceFilter = Optional.ofNullable(sourceMatcher.group("tableFlags")).flatMap(this.syntax::getFilterFlagExpression);
            String sortKey = sortKeys.getOrDefault(sourceContainer, this.syntax.getOptions().getSortKey());
            return ImmutableFeatureStoreRelation.builder().cardinality(FeatureStoreRelation.CARDINALITY.M_2_N).sourceContainer(sourceMatcher.group("table")).sourceField(junctionMatcher.group("sourceField")).sourceFilter(sourceFilter).sourceSortKey(sortKey).junctionSource(junctionMatcher.group("targetField")).junction(junctionMatcher.group("table")).junctionTarget(targetMatcher.group("sourceField")).targetContainer(targetMatcher.group("table")).targetField(targetMatcher.group("targetField")).build();
        }
        throw new IllegalArgumentException(String.format("not a valid relation path: %s/%s/%s", source, link, target));
    }
}

