/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.cql.domain.Cql;
import de.ii.xtraplatform.cql.domain.CqlFilter;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.features.domain.FeatureStoreInstanceContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreRelatedContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreRelation;
import de.ii.xtraplatform.features.domain.FeatureTypeV2;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreAttribute;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreInstanceContainer;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreRelatedContainer;
import de.ii.xtraplatform.features.domain.ImmutableFeatureStoreRelation;
import de.ii.xtraplatform.features.domain.SchemaBase;
import de.ii.xtraplatform.features.sql.ImmutableSqlPath;
import de.ii.xtraplatform.features.sql.SqlFeatureTypeParser2;
import de.ii.xtraplatform.features.sql.SqlPath;
import de.ii.xtraplatform.features.sql.SqlPathSyntax;
import de.ii.xtraplatform.features.sql.domain.ImmutableSchemaSql;
import de.ii.xtraplatform.features.sql.domain.SchemaSql;
import de.ii.xtraplatform.features.sql.domain.SqlRelation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableCollection;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;

public class FeatureSchemaSwapperSql {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureSchemaSwapperSql.class);
    private final SqlPathSyntax syntax;
    private final SqlFeatureTypeParser2 mappingParser;
    private final Cql cql;

    public FeatureSchemaSwapperSql(SqlPathSyntax syntax, Cql cql) {
        this.syntax = syntax;
        this.mappingParser = new SqlFeatureTypeParser2(syntax);
        this.cql = cql;
    }

    public SchemaSql swap(FeatureSchema featureType) {
        List<ImmutableSchemaSql.Builder> builders = this.swapProperties(featureType.getProperties(), featureType.getSourcePath().orElse(""));
        return new ImmutableSchemaSql.Builder().name(featureType.getName()).type(SchemaBase.Type.OBJECT).addAllPropertiesBuilders(builders).build();
    }

    private List<ImmutableSchemaSql.Builder> swapProperties(List<FeatureSchema> properties, String parentPath) {
        LinkedHashMap objectPropertiesCache = new LinkedHashMap();
        return properties.stream().flatMap(originalProperty -> this.createPropertyTree(objectPropertiesCache, (FeatureSchema)originalProperty, parentPath, (List<String>)ImmutableList.of(parentPath)).stream()).collect(Collectors.toList());
    }

    private List<ImmutableSchemaSql.Builder> createPropertyTree(Map<String, ImmutableSchemaSql.Builder> objectPropertiesCache, FeatureSchema originalProperty, String parentPath, List<String> parentFullPath) {
        boolean isRoot = parentPath.startsWith("/");
        boolean isColumn = originalProperty.getType() != SchemaBase.Type.OBJECT && originalProperty.getType() != SchemaBase.Type.OBJECT_ARRAY;
        Optional<SqlPath> sqlPath = this.toSqlPath(parentPath + "/" + originalProperty.getSourcePath().orElse(""), isColumn);
        if (!sqlPath.isPresent()) {
            throw new IllegalArgumentException("Parse error for SQL path: " + parentPath + "/" + originalProperty.getSourcePath().orElse(""));
        }
        List<String> tablePathAsList = this.syntax.asList(sqlPath.get().getTablePath());
        boolean hasRelation = tablePathAsList.size() > 1;
        ImmutableList<SqlRelation> featureStoreRelations = ImmutableList.of();
        return this.createPropertyTree(objectPropertiesCache, sqlPath.get(), featureStoreRelations, originalProperty, parentFullPath);
    }

    private List<ImmutableSchemaSql.Builder> createPropertyTree(Map<String, ImmutableSchemaSql.Builder> objectPropertiesCache, SqlPath sqlPath, List<SqlRelation> relations, FeatureSchema originalProperty, List<String> parentFullPath) {
        ArrayList<ImmutableSchemaSql.Builder> swapped = new ArrayList<ImmutableSchemaSql.Builder>();
        if (!relations.isEmpty()) {
            SqlRelation relation = relations.get(0);
            String name = relation.getTargetContainer();
            SchemaBase.Type type = relation.isOne2One() ? SchemaBase.Type.OBJECT : (sqlPath.getColumns().isEmpty() ? SchemaBase.Type.OBJECT_ARRAY : SchemaBase.Type.VALUE_ARRAY);
            ImmutableSchemaSql.Builder objectProperty = objectPropertiesCache.computeIfAbsent(name, cleanName -> {
                LOGGER.debug("OBJ {}", (Object)relation);
                ImmutableSchemaSql.Builder objectProperty1 = new ImmutableSchemaSql.Builder().name(relation.getTargetContainer()).addAllParentPath(parentFullPath).type(type).addRelation(relation).valueType(originalProperty.getValueType()).geometryType(originalProperty.getGeometryType());
                swapped.add(objectProperty1);
                return objectProperty1;
            });
            ImmutableCollection fullPath = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(parentFullPath)).addAll(relation.asPath())).build();
            if (relations.size() > 1) {
                LOGGER.debug("REL");
                List<ImmutableSchemaSql.Builder> childTrees = this.createPropertyTree(objectPropertiesCache, sqlPath, relations.subList(1, relations.size()), originalProperty, (List<String>)((Object)fullPath));
                objectProperty.addAllPropertiesBuilders(childTrees);
                return swapped;
            }
            originalProperty.getProperties().stream().flatMap(arg_0 -> this.lambda$createPropertyTree$2(objectPropertiesCache, (List)((Object)fullPath), arg_0)).forEach(xva$0 -> objectProperty.addAllPropertiesBuilders((ImmutableSchemaSql.Builder)xva$0));
            if (!sqlPath.getColumns().isEmpty()) {
                LOGGER.debug("COL {}", (Object)sqlPath);
                ImmutableSchemaSql.Builder property = new ImmutableSchemaSql.Builder().name(sqlPath.getColumns().get(0)).addAllParentPath(fullPath).type(originalProperty.getValueType().orElse(originalProperty.getType()));
                objectProperty.addAllPropertiesBuilders(property);
            }
            return swapped;
        }
        if (!sqlPath.getColumns().isEmpty()) {
            LOGGER.debug("COL {}", (Object)sqlPath);
            ImmutableSchemaSql.Builder property = new ImmutableSchemaSql.Builder().name(sqlPath.getColumns().get(0)).addAllParentPath(parentFullPath).type(originalProperty.getValueType().orElse(originalProperty.getType()));
            swapped.add(property);
        }
        return swapped;
    }

    public List<FeatureStoreInstanceContainer> parse(FeatureTypeV2 featureType) {
        List<String> paths = this.mappingParser.parse(featureType);
        List<SqlPath> sortedPaths = paths.stream().sorted(this::sortByPriority).map(this::toSqlPath).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List<FeatureStoreInstanceContainer> mergedPaths = this.toInstanceContainers(sortedPaths);
        return mergedPaths;
    }

    private int sortByPriority(String path1, String path2) {
        OptionalInt priority1 = this.syntax.getPriorityFlag(path1);
        OptionalInt priority2 = this.syntax.getPriorityFlag(path2);
        return !priority1.isPresent() ? 1 : (!priority2.isPresent() ? -1 : priority1.getAsInt() - priority2.getAsInt());
    }

    private Optional<SqlPath> toSqlPath(String path) {
        return this.toSqlPath(path, true);
    }

    private Optional<SqlPath> toSqlPath(String path, boolean isColumn) {
        Matcher matcher;
        Matcher matcher2 = matcher = isColumn ? this.syntax.getPartialColumnPathPattern().matcher(path) : this.syntax.getPathPattern().matcher(path);
        if (matcher.find()) {
            String tablePath = matcher.group("path");
            LinkedHashMap<String, String> tableFlags = new LinkedHashMap<String, String>();
            Matcher tableMatcher = this.syntax.getTablePattern().matcher(tablePath);
            while (tableMatcher.find()) {
                String flags = tableMatcher.group("tableFlags");
                tablePath = tablePath.replace(flags, "");
                String pathWithoutFlags = tableMatcher.group(0).replace(flags, "");
                tableFlags.putIfAbsent(pathWithoutFlags, flags);
            }
            String column = isColumn ? matcher.group("columns") : null;
            ImmutableList<String> columns = Objects.nonNull(column) ? this.syntax.getMultiColumnSplitter().splitToList(column) : ImmutableList.of();
            String flags = isColumn ? matcher.group("pathFlags") : "";
            OptionalInt priority = this.syntax.getPriorityFlag(flags);
            boolean hasOid = this.syntax.getOidFlag(flags);
            List<String> tablePathAsList = this.syntax.asList(tablePath);
            boolean isRoot = tablePathAsList.size() == 1;
            boolean isJunction = this.syntax.isJunctionTable(tablePathAsList.get(tablePathAsList.size() - 1));
            Optional<String> queryable = this.syntax.getQueryableFlag(flags).map(q -> q.replaceAll("\\[", "").replaceAll("]", ""));
            boolean isSpatial = this.syntax.getSpatialFlag(flags);
            return Optional.of(new ImmutableSqlPath.Builder().tablePath(tablePath).tableFlags(tableFlags).columns(columns).hasOid(hasOid).sortPriority(priority).isRoot(isRoot).isJunction(isJunction).queryable("").isSpatial(isSpatial).build());
        }
        LOGGER.warn("Invalid path in provider configuration: {}", (Object)path);
        return Optional.empty();
    }

    private List<FeatureStoreInstanceContainer> toInstanceContainers(List<SqlPath> sqlPaths) {
        LinkedHashMap groupedPaths = sqlPaths.stream().collect(Collectors.groupingBy(SqlPath::getTablePath, LinkedHashMap::new, Collectors.toList()));
        LinkedHashMap instanceContainerBuilders = new LinkedHashMap();
        int[] instancePos = new int[]{0};
        groupedPaths.entrySet().stream().forEach(entry -> {
            String tablePath = (String)entry.getKey();
            List<String> tablePathAsList = this.syntax.asList(tablePath);
            List columnPaths = (List)entry.getValue();
            List columns = columnPaths.stream().flatMap(sqlPath -> sqlPath.getColumns().stream()).collect(Collectors.toList());
            List attributes = columnPaths.stream().flatMap(sqlPath -> sqlPath.getColumns().stream().map(name -> ImmutableFeatureStoreAttribute.builder().name((String)name).path(tablePathAsList).addPath((String)name).queryable(sqlPath.getQueryable()).isId(sqlPath.hasOid()).isSpatial(sqlPath.isSpatial()).build())).collect(Collectors.toList());
            boolean hasOid = columnPaths.stream().anyMatch(SqlPath::hasOid);
            OptionalInt priority = columnPaths.stream().flatMapToInt(columnPath -> {
                OptionalInt sortPriority = columnPath.getSortPriority();
                return sortPriority.isPresent() ? IntStream.of(sortPriority.getAsInt()) : IntStream.empty();
            }).findFirst();
            boolean isRoot = columnPaths.stream().anyMatch(SqlPath::isRoot);
            Matcher instanceContainerNameMatcher = this.syntax.getTablePattern().matcher(tablePathAsList.get(0));
            if (!instanceContainerNameMatcher.find()) {
                throw new IllegalStateException("Unexpected error generating the provider transactions mapping");
            }
            String instanceContainerName = instanceContainerNameMatcher.group("table");
            Matcher attributesContainerNameMatcher = this.syntax.getTablePattern().matcher(tablePathAsList.get(tablePathAsList.size() - 1));
            if (!attributesContainerNameMatcher.find()) {
                throw new IllegalStateException("Unexpected error generating the provider transactions mapping");
            }
            String attributesContainerName = attributesContainerNameMatcher.group("table");
            if (!instanceContainerBuilders.containsKey(instanceContainerName)) {
                instanceContainerBuilders.put(instanceContainerName, ImmutableFeatureStoreInstanceContainer.builder());
            }
            Map filters = columnPaths.stream().flatMap(sqlPath -> sqlPath.getTableFlags().entrySet().stream()).filter(entry2 -> this.syntax.getFilterFlag((String)entry2.getValue()).isPresent()).map(entry2 -> new AbstractMap.SimpleImmutableEntry<String, String>((String)entry2.getKey(), this.syntax.getFilterFlag((String)entry2.getValue()).get())).distinct().map(entry2 -> new AbstractMap.SimpleImmutableEntry<String, CqlFilter>((String)entry2.getKey(), this.cql.read((String)entry2.getValue(), Cql.Format.TEXT))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            if (isRoot) {
                ImmutableFeatureStoreInstanceContainer.Builder instanceContainerBuilder = (ImmutableFeatureStoreInstanceContainer.Builder)instanceContainerBuilders.get(instanceContainerName);
                Optional<CqlFilter> filter = columnPaths.stream().flatMap(sqlPath -> sqlPath.getTableFlags().values().stream()).map(this.syntax::getFilterFlag).filter(Optional::isPresent).map(Optional::get).distinct().map(filterText -> this.cql.read((String)filterText, Cql.Format.TEXT)).findFirst();
                instanceContainerBuilder.name(instanceContainerName).sortKey(this.syntax.getOptions().getSortKey()).attributes(attributes).attributesPosition(instancePos[0]).filter(filter);
                instancePos[0] = 0;
            } else {
                List<FeatureStoreRelation> instanceConnection = this.toRelations(tablePathAsList, filters);
                String sortKey = this.syntax.isJunctionTable(attributesContainerName) ? instanceConnection.get(instanceConnection.size() - 1).getTargetField() : this.syntax.getOptions().getSortKey();
                ImmutableFeatureStoreRelatedContainer attributesContainer = ImmutableFeatureStoreRelatedContainer.builder().name(attributesContainerName).sortKey(sortKey).instanceConnection(instanceConnection).attributes(attributes).build();
                ((ImmutableFeatureStoreInstanceContainer.Builder)instanceContainerBuilders.get(instanceContainerName)).addRelatedContainers((FeatureStoreRelatedContainer)attributesContainer);
                instancePos[0] = instancePos[0] + 1;
            }
        });
        return instanceContainerBuilders.values().stream().map(ImmutableFeatureStoreInstanceContainer.Builder::build).collect(Collectors.toList());
    }

    private List<FeatureStoreRelation> toRelations(List<String> path, Map<String, CqlFilter> filters) {
        if (path.size() < 2) {
            throw new IllegalArgumentException(String.format("not a valid relation path: %s", path));
        }
        if (path.size() > 2) {
            return IntStream.range(2, path.size()).mapToObj(i -> this.toRelations((String)path.get(i - 2), (String)path.get(i - 1), (String)path.get(i), i == path.size() - 1, filters)).flatMap(Function.identity()).collect(Collectors.toList());
        }
        return IntStream.range(1, path.size()).mapToObj(i -> this.toRelation((String)path.get(i - 1), (String)path.get(i), filters)).collect(Collectors.toList());
    }

    private Stream<FeatureStoreRelation> toRelations(String source, String link, String target, boolean isLast, Map<String, CqlFilter> filters) {
        if (this.syntax.isJunctionTable(source)) {
            if (isLast) {
                return Stream.of(this.toRelation(link, target, filters));
            }
            return Stream.empty();
        }
        if (this.syntax.isJunctionTable(target) && !isLast) {
            return Stream.of(this.toRelation(source, link, filters));
        }
        if (this.syntax.isJunctionTable(link)) {
            return Stream.of(this.toRelation(source, link, target));
        }
        return Stream.of(this.toRelation(source, link, filters), this.toRelation(link, target, filters));
    }

    private FeatureStoreRelation toRelation(String source, String target, Map<String, CqlFilter> filters) {
        Matcher sourceMatcher = this.syntax.getTablePattern().matcher(source);
        Matcher targetMatcher = this.syntax.getJoinedTablePattern().matcher(target);
        if (sourceMatcher.find() && targetMatcher.find()) {
            String sourceField = targetMatcher.group("sourceField");
            String targetField = targetMatcher.group("targetField");
            boolean isOne2One = Objects.equals(targetField, this.syntax.getOptions().getPrimaryKey());
            Optional<CqlFilter> filter = Optional.ofNullable(filters.get(target));
            return ImmutableFeatureStoreRelation.builder().cardinality(isOne2One ? FeatureStoreRelation.CARDINALITY.ONE_2_ONE : FeatureStoreRelation.CARDINALITY.ONE_2_N).sourceContainer(sourceMatcher.group("table")).sourceField(sourceField).sourceSortKey(this.syntax.getOptions().getPrimaryKey()).targetContainer(targetMatcher.group("table")).targetField(targetField).filter(filter).build();
        }
        throw new IllegalArgumentException(String.format("not a valid relation path: %s/%s", source, target));
    }

    private FeatureStoreRelation toRelation(String source, String link, String target) {
        Matcher sourceMatcher = this.syntax.getTablePattern().matcher(source);
        Matcher junctionMatcher = this.syntax.getJoinedTablePattern().matcher(link);
        Matcher targetMatcher = this.syntax.getJoinedTablePattern().matcher(target);
        if (sourceMatcher.find() && junctionMatcher.find() && targetMatcher.find()) {
            return ImmutableFeatureStoreRelation.builder().cardinality(FeatureStoreRelation.CARDINALITY.M_2_N).sourceContainer(sourceMatcher.group("table")).sourceField(junctionMatcher.group("sourceField")).sourceSortKey(this.syntax.getOptions().getPrimaryKey()).junctionSource(junctionMatcher.group("targetField")).junction(junctionMatcher.group("table")).junctionTarget(targetMatcher.group("sourceField")).targetContainer(targetMatcher.group("table")).targetField(targetMatcher.group("targetField")).build();
        }
        throw new IllegalArgumentException(String.format("not a valid relation path: %s/%s/%s", source, link, target));
    }

    private /* synthetic */ Stream lambda$createPropertyTree$2(Map objectPropertiesCache, List fullPath, FeatureSchema childProperty) {
        LOGGER.debug("NES");
        return this.createPropertyTree(objectPropertiesCache, childProperty, (String)fullPath.get(fullPath.size() - 1), fullPath).stream();
    }
}

