/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.features.sql.app;

import de.ii.xtraplatform.features.domain.FeatureQuery;
import de.ii.xtraplatform.features.domain.FeatureQueryTransformer;
import de.ii.xtraplatform.features.domain.FeatureStoreAttribute;
import de.ii.xtraplatform.features.domain.FeatureStoreInstanceContainer;
import de.ii.xtraplatform.features.domain.FeatureStoreTypeInfo;
import de.ii.xtraplatform.features.domain.ImmutableSortKey;
import de.ii.xtraplatform.features.domain.SortKey;
import de.ii.xtraplatform.features.domain.Tuple;
import de.ii.xtraplatform.features.sql.app.SqlQueryTemplates;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlQueries;
import de.ii.xtraplatform.features.sql.domain.ImmutableSqlQueryOptions;
import de.ii.xtraplatform.features.sql.domain.SqlQueries;
import de.ii.xtraplatform.features.sql.domain.SqlQueryOptions;
import de.ii.xtraplatform.features.sql.domain.SqlRowMeta;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.google.common.collect.ImmutableList;

class FeatureQueryTransformerSql
implements FeatureQueryTransformer<SqlQueries, SqlQueryOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureQueryTransformerSql.class);
    private final Map<String, List<SqlQueryTemplates>> allQueryTemplates;
    private final Map<String, FeatureStoreTypeInfo> typeInfos;

    FeatureQueryTransformerSql(Map<String, List<SqlQueryTemplates>> allQueryTemplates, Map<String, FeatureStoreTypeInfo> typeInfos) {
        this.allQueryTemplates = allQueryTemplates;
        this.typeInfos = typeInfos;
    }

    @Override
    public SqlQueries transformQuery(FeatureQuery featureQuery, Map<String, String> additionalQueryParameters) {
        FeatureStoreTypeInfo typeInfo = this.typeInfos.get(featureQuery.getType());
        List<SqlQueryTemplates> queryTemplates = this.allQueryTemplates.get(featureQuery.getType());
        FeatureStoreInstanceContainer mainTable = typeInfo.getInstanceContainers().get(0);
        SqlQueryTemplates queries = queryTemplates.get(0);
        List<SortKey> sortKeys = this.transformSortKeys(featureQuery.getSortKeys(), mainTable);
        Optional<String> metaQuery = featureQuery.returnsSingleFeature() ? Optional.empty() : Optional.of(queries.getMetaQueryTemplate().generateMetaQuery(featureQuery.getLimit(), featureQuery.getOffset(), sortKeys, featureQuery.getFilter(), additionalQueryParameters));
        Function<SqlRowMeta, Stream<String>> valueQueries = metaResult -> queries.getValueQueryTemplates().stream().map(valueQueryTemplate -> valueQueryTemplate.generateValueQuery(featureQuery.getLimit(), featureQuery.getOffset(), sortKeys, featureQuery.getFilter(), Objects.nonNull(metaResult.getMinKey()) && Objects.nonNull(metaResult.getMaxKey()) || metaResult.getNumberReturned() == 0L ? Optional.of(Tuple.of(metaResult.getMinKey(), metaResult.getMaxKey())) : Optional.empty(), additionalQueryParameters));
        return new ImmutableSqlQueries.Builder().metaQuery(metaQuery).valueQueries(valueQueries).instanceContainers(typeInfo.getInstanceContainers()).tableSchemas(queries.getQuerySchemas()).build();
    }

    @Override
    public SqlQueryOptions getOptions(FeatureQuery featureQuery) {
        FeatureStoreTypeInfo typeInfo = this.typeInfos.get(featureQuery.getType());
        FeatureStoreInstanceContainer mainTable = typeInfo.getInstanceContainers().get(0);
        List<SortKey> sortKeys = this.transformSortKeys(featureQuery.getSortKeys(), mainTable);
        return new ImmutableSqlQueryOptions.Builder().customSortKeys(sortKeys).build();
    }

    private List<SortKey> transformSortKeys(List<SortKey> sortKeys, FeatureStoreInstanceContainer instanceContainer) {
        return sortKeys.stream().map(sortKey -> {
            Predicate<FeatureStoreAttribute> propertyMatches = attribute -> Objects.equals(sortKey.getField(), attribute.getQueryable()) || Objects.equals(sortKey.getField(), "_ID_") && attribute.isId();
            Optional<String> column = instanceContainer.getAttributes().stream().filter(propertyMatches).filter(attribute -> !attribute.isSpatial() && !attribute.isConstant()).findFirst().map(FeatureStoreAttribute::getName);
            if (!column.isPresent()) {
                throw new IllegalArgumentException(String.format("Sort key is invalid, property '%s' is either unknown or inapplicable.", sortKey.getField(), instanceContainer.getName()));
            }
            return ImmutableSortKey.builder().from((SortKey)sortKey).field(column.get()).build();
        }).collect(ImmutableList.toImmutableList());
    }
}

